/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.recipe.CrystalRecipeInput;
import net.povstalec.sgjourney.common.recipe.CrystallizingIngredient;

public class CrystallizerRecipe
implements Recipe<CrystalRecipeInput> {
    protected final CrystallizingIngredient crystalBase;
    protected final CrystallizingIngredient primaryIngredient;
    protected final CrystallizingIngredient secondaryIngredient;
    private final ItemStack output;

    public CrystallizerRecipe(ItemStack output, CrystallizingIngredient crystalBase, CrystallizingIngredient primaryIngredient, CrystallizingIngredient secondaryIngredient) {
        this.crystalBase = crystalBase;
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredient = secondaryIngredient;
        this.output = output;
    }

    public int getAmountInSlot(int slot) {
        return switch (slot) {
            case 0 -> this.crystalBase.amount();
            case 1 -> this.primaryIngredient.amount();
            case 2 -> this.secondaryIngredient.amount();
            default -> 0;
        };
    }

    public boolean depletePrimary() {
        return this.primaryIngredient.deplete();
    }

    public boolean depleteSecondary() {
        return this.secondaryIngredient.deplete();
    }

    @Nullable
    private Ingredient getIngredient(int slot) {
        return switch (slot) {
            case 0 -> this.crystalBase.ingredient();
            case 1 -> this.primaryIngredient.ingredient();
            case 2 -> this.secondaryIngredient.ingredient();
            default -> null;
        };
    }

    public boolean itemStackMatches(RecipeInput craftingInput, int slot) {
        ItemStack stack = craftingInput.getItem(slot);
        Ingredient ingredient = this.getIngredient(slot);
        if (ingredient != null) {
            return ingredient.test(stack) && this.getAmountInSlot(slot) <= stack.getCount();
        }
        return false;
    }

    public boolean matches(CrystalRecipeInput craftingInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.itemStackMatches(craftingInput, 0) && this.itemStackMatches(craftingInput, 1) && this.itemStackMatches(craftingInput, 2);
    }

    public ItemStack assemble(CrystalRecipeInput craftingInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.CRYSTALLIZING;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.crystalBase.ingredient());
        nonnulllist.add((Object)this.primaryIngredient.ingredient());
        nonnulllist.add((Object)this.secondaryIngredient.ingredient());
        return nonnulllist;
    }

    public static class Serializer
    implements RecipeSerializer<CrystallizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = StargateJourney.sgjourneyLocation("crystallizing");
        public static final MapCodec<CrystallizerRecipe> CODEC = RecordCodecBuilder.mapCodec(recipeBuilder -> recipeBuilder.group((App)ItemStack.STRICT_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)CrystallizingIngredient.CODEC.fieldOf("crystal_base").forGetter(recipe -> recipe.crystalBase), (App)CrystallizingIngredient.DEPLETABLE_CODEC.fieldOf("primary_ingredient").forGetter(recipe -> recipe.primaryIngredient), (App)CrystallizingIngredient.DEPLETABLE_CODEC.fieldOf("secondary_ingredient").forGetter(recipe -> recipe.secondaryIngredient)).apply((Applicative)recipeBuilder, CrystallizerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrystallizerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static CrystallizerRecipe fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
            int amount1 = friendlyByteBuf.readInt();
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
            int amount2 = friendlyByteBuf.readInt();
            boolean depletePrimary = friendlyByteBuf.readBoolean();
            Ingredient ingredient3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
            int amount3 = friendlyByteBuf.readInt();
            boolean depleteSecondary = friendlyByteBuf.readBoolean();
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            return new CrystallizerRecipe(output, new CrystallizingIngredient(ingredient1, amount1), new CrystallizingIngredient(ingredient2, amount2, depletePrimary), new CrystallizingIngredient(ingredient3, amount3, depleteSecondary));
        }

        private static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, CrystallizerRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.crystalBase.ingredient());
            friendlyByteBuf.writeInt(recipe.crystalBase.amount());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.primaryIngredient.ingredient());
            friendlyByteBuf.writeInt(recipe.primaryIngredient.amount());
            friendlyByteBuf.writeBoolean(recipe.primaryIngredient.deplete());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.secondaryIngredient.ingredient());
            friendlyByteBuf.writeInt(recipe.secondaryIngredient.amount());
            friendlyByteBuf.writeBoolean(recipe.secondaryIngredient.deplete());
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.getResultItem(null));
        }

        public MapCodec<CrystallizerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrystallizerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<CrystallizerRecipe> {
        public static final Type CRYSTALLIZING = new Type();
    }
}

