/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.CommonStargateNetworkConfig;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class Dialing {
    public static final int[] DIALED_7_CHEVRON_CONFIGURATION = new int[]{1, 2, 3, 6, 7, 8, 4, 5};
    public static final int[] DIALED_8_CHEVRON_CONFIGURATION = new int[]{1, 2, 3, 4, 6, 7, 8, 5};
    public static final int[] DIALED_9_CHEVRON_CONFIGURATION = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] DEFAULT_CHEVRON_CONFIGURATION = DIALED_7_CHEVRON_CONFIGURATION;

    public static int[] getChevronConfiguration(int addressLength) {
        return switch (addressLength) {
            case 6 -> DIALED_7_CHEVRON_CONFIGURATION;
            case 7 -> DIALED_8_CHEVRON_CONFIGURATION;
            case 8 -> DIALED_9_CHEVRON_CONFIGURATION;
            default -> DEFAULT_CHEVRON_CONFIGURATION;
        };
    }

    public static StargateInfo.Feedback dialStargate(MinecraftServer server, Stargate dialingStargate, Address.Immutable address, boolean doKawoosh, boolean mustBeLoaded) {
        if (SGJourneyEvents.onStargateDial(server, dialingStargate, address, doKawoosh)) {
            return StargateInfo.Feedback.NONE;
        }
        return switch (address.getLength()) {
            case 6 -> Dialing.get7ChevronStargate(server, dialingStargate, address, doKawoosh, mustBeLoaded);
            case 7 -> Dialing.get8ChevronStargate(server, dialingStargate, address, doKawoosh, mustBeLoaded);
            case 8 -> Dialing.get9ChevronStargate(server, dialingStargate, address, doKawoosh, mustBeLoaded);
            default -> dialingStargate.resetStargate(server, StargateInfo.Feedback.INVALID_ADDRESS, true);
        };
    }

    public static StargateInfo.Feedback dialStargate(MinecraftServer server, Stargate dialingStargate, Address.Immutable address, boolean doKawoosh) {
        return Dialing.dialStargate(server, dialingStargate, address, doKawoosh, false);
    }

    private static StargateInfo.Feedback get7ChevronStargate(MinecraftServer server, Stargate dialingStargate, Address.Immutable dialedAddress, boolean doKawoosh, boolean mustBeLoaded) {
        SolarSystem.Serializable solarSystem = Universe.get(server).getSolarSystemFromAddress(dialingStargate.getSolarSystem(server), dialedAddress);
        if (solarSystem == null) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.INVALID_ADDRESS, true);
        }
        return Dialing.getStargate(server, dialingStargate, solarSystem, Address.Type.ADDRESS_7_CHEVRON, doKawoosh, mustBeLoaded);
    }

    private static StargateInfo.Feedback get8ChevronStargate(MinecraftServer server, Stargate dialingStargate, Address.Immutable extragalacticAddress, boolean doKawoosh, boolean mustBeLoaded) {
        SolarSystem.Serializable solarSystem = Universe.get(server).getSolarSystemFromExtragalacticAddress(extragalacticAddress);
        if (solarSystem == null) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.INVALID_ADDRESS, true);
        }
        return Dialing.getStargate(server, dialingStargate, solarSystem, Address.Type.ADDRESS_8_CHEVRON, doKawoosh, mustBeLoaded);
    }

    private static StargateInfo.Feedback getStargate(MinecraftServer server, Stargate dialingStargate, SolarSystem.Serializable dialedSystem, Address.Type addressType, boolean doKawoosh, boolean mustBeLoaded) {
        SolarSystem.Serializable currentSystem = dialingStargate.getSolarSystem(server);
        if (dialedSystem.equals(currentSystem)) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.SAME_SYSTEM_DIAL, true);
        }
        if (!mustBeLoaded && dialedSystem.getStargates().isEmpty()) {
            List<ResourceKey<Level>> dimensionList = dialedSystem.getDimensions();
            int dimensions = 0;
            for (int i = 0; i < dimensionList.size(); ++i) {
                ResourceKey<Level> levelKey = dimensionList.get(i);
                if (!server.levelKeys().contains(levelKey)) continue;
                ServerLevel targetLevel = server.getLevel(levelKey);
                StargateNetwork.findStargates(targetLevel);
                ++dimensions;
            }
            if (dimensions == 0) {
                return dialingStargate.resetStargate(server, StargateInfo.Feedback.NO_DIMENSIONS, true);
            }
        }
        return Dialing.getPreferredStargate(server, dialingStargate, dialedSystem, addressType, doKawoosh, mustBeLoaded);
    }

    private static StargateInfo.Feedback attemptConnection(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate, Address.Type addressType, boolean doKawoosh, boolean mustBeLoaded) {
        if (mustBeLoaded && !dialedStargate.isLoaded(server)) {
            return StargateInfo.Feedback.TARGET_NOT_LOADED;
        }
        return dialedStargate.tryConnect(server, dialingStargate, addressType, doKawoosh);
    }

    private static StargateInfo.Feedback getStargateFromAddress(MinecraftServer server, Stargate dialingStargate, Address.Immutable address, boolean doKawoosh, boolean mustBeLoaded) {
        Stargate stargate = StargateNetwork.get(server).getStargate(address);
        if (stargate == null) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.INVALID_ADDRESS, true);
        }
        StargateInfo.Feedback feedback = Dialing.attemptConnection(server, dialingStargate, stargate, Address.Type.ADDRESS_9_CHEVRON, doKawoosh, mustBeLoaded);
        if (!feedback.isSkippable()) {
            return feedback;
        }
        return dialingStargate.resetStargate(server, feedback, true);
    }

    private static StargateInfo.Feedback get9ChevronStargate(MinecraftServer server, Stargate dialingStargate, Address.Immutable address, boolean doKawoosh, boolean mustBeLoaded) {
        return Dialing.getStargateFromAddress(server, dialingStargate, address, doKawoosh, mustBeLoaded);
    }

    private static StargateInfo.Feedback getPreferredStargate(MinecraftServer server, Stargate dialingStargate, SolarSystem.Serializable solarSystem, Address.Type addressType, boolean doKawoosh, boolean mustBeLoaded) {
        StargateInfo.Feedback feedback;
        List<Stargate> stargates = solarSystem.getStargates();
        if (stargates.isEmpty()) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.NO_STARGATES, true);
        }
        if (CommonStargateNetworkConfig.primary_stargate.get() && solarSystem.primaryStargate() != null && !(feedback = Dialing.attemptConnection(server, dialingStargate, solarSystem.primaryStargate(), addressType, doKawoosh, mustBeLoaded)).isSkippable()) {
            return feedback;
        }
        feedback = StargateInfo.Feedback.UNKNOWN_ERROR;
        for (Stargate targetStargate : stargates) {
            feedback = Dialing.attemptConnection(server, dialingStargate, targetStargate, addressType, doKawoosh, mustBeLoaded);
            if (feedback.isSkippable()) continue;
            return feedback;
        }
        if (feedback == StargateInfo.Feedback.UNKNOWN_ERROR) {
            StargateJourney.LOGGER.error("Solar System has Stargates, but somehow none can be accessed");
        }
        return dialingStargate.resetStargate(server, feedback, true);
    }

    public static StargateInfo.Feedback connectStargates(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate, Address.Type addressType, boolean doKawoosh) {
        return StargateNetwork.get(server).createConnection(server, dialingStargate, dialedStargate, addressType, doKawoosh);
    }
}

