/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.TransporterConnection;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class Transporting {
    public static void startTransport(MinecraftServer server, Transporter initialTransporter, UUID targetUUID) {
        Transporter targetTransporter = TransporterNetwork.get(server).getTransporter(targetUUID);
        TransporterNetwork.get(server).createConnection(server, initialTransporter, targetTransporter);
    }

    public static boolean transportTraveler(MinecraftServer server, TransporterConnection connection, Transporter initialTransporter, Transporter receivingTransporter, Entity traveler) {
        Vec3 relativePosition = initialTransporter.toTransporterCoords(server, traveler.position().subtract(initialTransporter.transportPos(server)), true);
        Vec3 relativeMomentum = initialTransporter.toTransporterCoords(server, traveler.getDeltaMovement(), false);
        Vec3 relativeLookAngle = initialTransporter.toTransporterCoords(server, traveler.getLookAngle(), false);
        return relativePosition.lengthSqr() <= initialTransporter.getInnerRadius() * initialTransporter.getInnerRadius() && receivingTransporter.receiveTraveler(server, connection, initialTransporter, traveler, relativePosition, relativeMomentum, relativeLookAngle);
    }

    public static boolean transportTravelers(MinecraftServer server, TransporterConnection connection, Transporter initialTransporter, Transporter receivingTransporter, List<Entity> travelers) {
        boolean used = false;
        for (Entity traveler : travelers) {
            if (!Transporting.transportTraveler(server, connection, initialTransporter, receivingTransporter, traveler)) continue;
            used = true;
        }
        return used;
    }

    public static Entity transportEntity(ServerLevel destinationLevel, Transporter receivingTransporter, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        if (traveler.level() != destinationLevel) {
            traveler = traveler.changeDimension(new DimensionTransition(destinationLevel, destinationPosition, destinationMomentum, CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.getXRot(), false, DimensionTransition.DO_NOTHING));
        } else {
            traveler.moveTo(destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.getXRot());
            traveler.setDeltaMovement(destinationMomentum);
        }
        return traveler;
    }

    public static Entity transportPlayer(ServerLevel destinationLevel, Transporter receivingTransporter, ServerPlayer player, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        player.teleportTo(destinationLevel, destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), player.getXRot());
        player.setDeltaMovement(destinationMomentum);
        player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
        return player;
    }

    public static Entity recursivePassengerTeleport(ServerLevel destinationLevel, Transporter receivingTransporter, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Level initialLevel = traveler.level();
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        if (initialLevel != destinationLevel) {
            for (Entity passenger : traveler.getPassengers()) {
                passengers.add(Transporting.recursivePassengerTeleport(destinationLevel, receivingTransporter, passenger, destinationPosition, destinationMomentum, destinationLookAngle));
            }
        }
        if (traveler instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)traveler;
            traveler = Transporting.transportPlayer(destinationLevel, receivingTransporter, player, destinationPosition, destinationMomentum, destinationLookAngle);
        } else {
            traveler = Transporting.transportEntity(destinationLevel, receivingTransporter, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        }
        if (initialLevel != destinationLevel) {
            for (Entity passenger : passengers) {
                passenger.startRiding(traveler, true);
            }
        }
        return traveler;
    }

    public static boolean receiveTraveler(ServerLevel level, Transporter receivingTransporter, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Transporting.recursivePassengerTeleport(level, receivingTransporter, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        return true;
    }
}

