/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.init.AdvancementInit;
import net.povstalec.sgjourney.common.init.DamageSourceInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class Wormhole {
    public static final String EVENT_DECONSTRUCTING_ENTITY = "stargate_deconstructing_entity";
    public static final String EVENT_RECONSTRUCTING_ENTITY = "stargate_reconstructing_entity";
    public static final String EVENT_IRIS_THUD = "iris_thud";
    public static final double INNER_RADIUS = 2.5;
    public static final double INNER_RADIUS_SQR = 6.25;
    protected Map<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();

    protected boolean shouldWormhole(Vec3 center, Entity traveler, double oldTravelerX, double travelerX, double momentumX) {
        if (traveler.isPassenger()) {
            return false;
        }
        Vec3 travelerPos = traveler.getBoundingBox().getCenter();
        if (center.distanceToSqr(travelerPos) > 6.25) {
            return false;
        }
        return oldTravelerX > 0.0 && travelerX < 0.0 && momentumX < 0.0;
    }

    protected boolean wormholeEntity(MinecraftServer server, StargateConnection connection, Stargate initialStargate, Stargate destinationStargate, StargateInfo.WormholeTravel twoWayWormhole, Map<Integer, Vec3> entityLocations, Entity traveler) {
        Vec3 relativePosition = initialStargate.toStargateCoords(server, traveler.position().subtract(initialStargate.getPosition(server)), true);
        Vec3 oldRelativePos = this.entityLocations.get(traveler.getId());
        if (oldRelativePos != null) {
            Vec3 relativeMomentum = relativePosition.subtract(oldRelativePos);
            if (this.shouldWormhole(initialStargate.getPosition(server), traveler, oldRelativePos.x(), relativePosition.x(), relativeMomentum.x())) {
                Player player;
                Wormhole.playWormholeSound(traveler.level(), traveler);
                if (twoWayWormhole == StargateInfo.WormholeTravel.ENABLED || twoWayWormhole == StargateInfo.WormholeTravel.CREATIVE_ONLY && traveler instanceof Player && ((player = (Player)traveler).isCreative() || player.isSpectator())) {
                    Vec3 relativeLookAngle = initialStargate.toStargateCoords(server, traveler.getLookAngle(), false);
                    if (!SGJourneyEvents.onWormholeTravel(server, initialStargate, destinationStargate, traveler, twoWayWormhole) && destinationStargate.receiveTraveler(server, connection, initialStargate, traveler, relativePosition, relativeMomentum, relativeLookAngle)) {
                        this.deconstructEvent(server, initialStargate, traveler, false);
                        return true;
                    }
                } else {
                    this.handleReverseWormhole(server, initialStargate, traveler);
                }
            }
        }
        entityLocations.put(traveler.getId(), relativePosition);
        return false;
    }

    public boolean wormholeEntities(MinecraftServer server, StargateConnection connection, Stargate initialStargate, Stargate destinationStargate, StargateInfo.WormholeTravel twoWayWormhole, List<Entity> wormholeCandidates) {
        boolean used = false;
        HashMap<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();
        for (Entity traveler : wormholeCandidates) {
            if (!this.wormholeEntity(server, connection, initialStargate, destinationStargate, twoWayWormhole, entityLocations, traveler)) continue;
            used = true;
        }
        this.entityLocations = entityLocations;
        return used;
    }

    public void handleReverseWormhole(MinecraftServer server, Stargate initialStargate, Entity traveler) {
        Wormhole.recursiveExecute(traveler, entity -> {
            if (((Boolean)CommonStargateConfig.reverse_wormhole_kills.get()).booleanValue()) {
                if (entity.isAlive()) {
                    ServerPlayer player;
                    if (entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).isCreative() || player.isSpectator())) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.stargate.error.one_way_wormhole").withStyle(ChatFormatting.DARK_RED), true);
                    } else if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer player2 = (ServerPlayer)entity;
                            player2.awardStat((ResourceLocation)StatisticsInit.TIMES_KILLED_BY_WORMHOLE.get());
                        }
                        livingEntity.hurt(DamageSourceInit.damageSource(server, DamageSourceInit.REVERSE_WORMHOLE), Float.POSITIVE_INFINITY);
                    } else {
                        entity.kill();
                    }
                }
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.stargate.error.one_way_wormhole").withStyle(ChatFormatting.DARK_RED), true);
            }
            this.deconstructEvent(server, initialStargate, entity, true);
        });
    }

    protected Entity transportEntity(ServerLevel destinationLevel, Stargate destinationStargate, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        if (traveler.level() != destinationLevel) {
            traveler = traveler.changeDimension(new DimensionTransition(destinationLevel, destinationPosition, destinationMomentum, CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.getXRot(), false, DimensionTransition.DO_NOTHING));
        } else {
            traveler.moveTo(destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.getXRot());
            traveler.setDeltaMovement(destinationMomentum);
        }
        if (traveler != null) {
            this.reconstructEvent(destinationLevel.getServer(), destinationStargate, traveler);
        }
        return traveler;
    }

    protected Entity transportPlayer(ServerLevel destinationLevel, Stargate destinationStargate, ServerPlayer player, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Level initialLevel = player.level();
        Vec3 initialPos = player.position();
        player.teleportTo(destinationLevel, destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), player.getXRot());
        player.setDeltaMovement(destinationMomentum);
        player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
        this.reconstructEvent(destinationLevel.getServer(), destinationStargate, (Entity)player);
        ResourceLocation initialDimension = initialLevel.dimension().location();
        ResourceLocation targetDimension = destinationLevel.dimension().location();
        long distanceTraveled = Math.round(DimensionType.getTeleportationScale((DimensionType)initialLevel.dimensionType(), (DimensionType)destinationLevel.dimensionType()) * Math.sqrt(initialPos.distanceTo(player.position())));
        player.awardStat((ResourceLocation)StatisticsInit.TIMES_USED_WORMHOLE.get());
        player.awardStat((ResourceLocation)StatisticsInit.DISTANCE_TRAVELED_BY_STARGATE.get(), (int)distanceTraveled * 100);
        AdvancementInit.WORMHOLE_CRITERION_TRIGGER.get().trigger(player, initialDimension, targetDimension, distanceTraveled);
        return player;
    }

    protected Entity recursivePassengerTeleport(ServerLevel destinationLevel, Stargate destinationStargate, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Level initialLevel = traveler.level();
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        if (initialLevel != destinationLevel) {
            for (Entity passenger : traveler.getPassengers()) {
                passengers.add(this.recursivePassengerTeleport(destinationLevel, destinationStargate, passenger, destinationPosition, destinationMomentum, destinationLookAngle));
            }
        }
        if (traveler instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)traveler;
            traveler = this.transportPlayer(destinationLevel, destinationStargate, player, destinationPosition, destinationMomentum, destinationLookAngle);
        } else {
            traveler = this.transportEntity(destinationLevel, destinationStargate, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        }
        if (initialLevel != destinationLevel) {
            for (Entity passenger : passengers) {
                passenger.startRiding(traveler, true);
            }
        }
        return traveler;
    }

    public boolean receiveTraveler(ServerLevel destinationLevel, Stargate destinationStargate, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        traveler = this.recursivePassengerTeleport(destinationLevel, destinationStargate, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        Wormhole.playWormholeSound((Level)destinationLevel, traveler);
        return true;
    }

    public boolean checkShielding(IrisStargateEntity targetStargate, Vec3 destinationPos, Vec3 motionVec, Entity traveler) {
        if (targetStargate.irisInfo().isIrisClosed()) {
            return false;
        }
        EntityDimensions dimension = traveler.getDimensions(traveler.getPose());
        Vec3 travelerCenter = dimension.makeBoundingBox(destinationPos).getCenter();
        Vec3 fromVec = travelerCenter.subtract(motionVec);
        Vec3 toVec = travelerCenter.add(motionVec);
        Level targetLevel = targetStargate.getLevel();
        BlockPos pos = targetStargate.getBlockPos();
        BlockState state = targetLevel.getBlockState(targetStargate.getBlockPos());
        Block block = state.getBlock();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            for (ShieldingPart part : stargateBlock.getShieldingParts()) {
                BlockPos shieldingPos = part.getShieldingPos(pos, (Direction)state.getValue((Property)AbstractStargateBlock.FACING), (Orientation)((Object)state.getValue(AbstractStargateBlock.ORIENTATION)));
                BlockState shieldingState = targetLevel.getBlockState(shieldingPos);
                if (!(shieldingState.getBlock() instanceof AbstractShieldingBlock) || shieldingState.getCollisionShape((BlockGetter)targetLevel, shieldingPos).clip(fromVec, toVec, shieldingPos) == null) continue;
                return false;
            }
        }
        return true;
    }

    public void handleShielding(MinecraftServer server, IrisStargateEntity irisStargate, Entity traveler) {
        Wormhole.recursiveExecute(traveler, entity -> {
            ServerPlayer player;
            if (entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).isCreative() || player.isSpectator())) {
                if (!((Boolean)CommonIrisConfig.creative_ignores_iris.get()).booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.stargate.error.iris").withStyle(ChatFormatting.DARK_RED), true);
                }
            } else {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player2 = (ServerPlayer)entity;
                        player2.awardStat((ResourceLocation)StatisticsInit.TIMES_SMASHED_AGAINST_IRIS.get());
                    }
                    livingEntity.hurt(DamageSourceInit.damageSource(server, DamageSourceInit.IRIS), Float.POSITIVE_INFINITY);
                } else {
                    entity.kill();
                }
                this.irisThudEvent(irisStargate, entity);
                irisStargate.irisInfo().decreaseIrisDurability();
            }
        });
        irisStargate.irisInfo().playIrisThudSound();
    }

    protected void irisThudEvent(AbstractStargateEntity targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.getKey((EntityType)traveler.getType()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.getGameProfile().getName();
        } else {
            string = traveler.getName().getString();
        }
        String displayName = string;
        String uuid = traveler.getUUID().toString();
        targetStargate.updateInterfaceBlocks(EVENT_IRIS_THUD, travelerType, displayName, uuid);
    }

    protected void deconstructEvent(MinecraftServer server, Stargate initialStargate, Entity traveler, boolean disintegrated) {
        String string;
        String travelerType = EntityType.getKey((EntityType)traveler.getType()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.getGameProfile().getName();
        } else {
            string = traveler.getName().getString();
        }
        String displayName = string;
        String uuid = traveler.getUUID().toString();
        initialStargate.updateInterfaceBlocks(server, null, EVENT_DECONSTRUCTING_ENTITY, travelerType, displayName, uuid, disintegrated);
    }

    protected void reconstructEvent(MinecraftServer server, Stargate targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.getKey((EntityType)traveler.getType()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.getGameProfile().getName();
        } else {
            string = traveler.getName().getString();
        }
        String displayName = string;
        String uuid = traveler.getUUID().toString();
        targetStargate.updateInterfaceBlocks(server, null, EVENT_RECONSTRUCTING_ENTITY, travelerType, displayName, uuid);
    }

    public static void recursiveExecute(Entity traveler, WormholeFunction func) {
        for (Entity passenger : traveler.getPassengers()) {
            Wormhole.recursiveExecute(passenger, func);
        }
        func.run(traveler);
    }

    public static void playWormholeSound(Level level, Entity traveler) {
        level.playSound(null, traveler.blockPosition(), (SoundEvent)SoundInit.WORMHOLE_ENTER.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public static interface WormholeFunction {
        public void run(Entity var1);
    }
}

