/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.info;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public class DHDInfo {
    public static final int DHD_INFO_DISTANCE = 5;
    protected AbstractStargateEntity stargate;
    @Nullable
    protected AbstractDHDEntity dhd;
    @Nullable
    protected Vec3i dhdRelativePos;
    protected int autoclose;

    public DHDInfo(AbstractStargateEntity stargate) {
        this.stargate = stargate;
        this.dhd = null;
        this.dhdRelativePos = null;
        this.autoclose = 0;
    }

    public void setDHD(AbstractDHDEntity dhd, int autoclose) {
        Direction direction = this.stargate.getDirection();
        if (dhd != null && direction != null) {
            if (!this.hasDHD() || this.dhd == dhd) {
                Vec3i relativeOffset;
                this.dhdRelativePos = relativeOffset = CoordinateHelper.Relative.getRelativeOffset(direction, this.stargate.getBlockPos(), dhd.getBlockPos());
                this.dhd = dhd;
                this.updateDHD();
            }
            this.autoclose = autoclose;
        }
        this.stargate.updateStargate(this.stargate.getLevel(), false);
        this.stargate.setChanged();
    }

    public void unsetDHD(boolean notifyDHD) {
        if (notifyDHD && this.hasDHD()) {
            this.dhd.unsetStargate();
        }
        this.dhd = null;
        this.dhdRelativePos = null;
        this.autoclose = 0;
        this.stargate.updateStargate(this.stargate.getLevel(), false);
        this.updateDHD();
        this.stargate.setChanged();
    }

    @Nullable
    public BlockPos getDHDPos() {
        if (this.dhdRelativePos == null) {
            return null;
        }
        BlockPos dhdPos = CoordinateHelper.Relative.getOffsetPos(this.stargate.getDirection(), this.stargate.getBlockPos(), this.dhdRelativePos);
        if (dhdPos != null) {
            return dhdPos;
        }
        return null;
    }

    public void loadDHD() {
        BlockPos dhdPos = this.getDHDPos();
        if (dhdPos == null) {
            return;
        }
        BlockEntity blockEntity = this.stargate.getLevel().getBlockEntity(dhdPos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd;
            this.dhd = dhd = (AbstractDHDEntity)blockEntity;
        }
        this.updateDHD();
        this.stargate.setChanged();
    }

    public void updateDHD() {
        if (this.hasDHD()) {
            this.dhd.updateDHD(!this.stargate.isConnected() || this.stargate.isConnected() && this.stargate.isDialingOut() ? this.stargate.getAddress() : new Address(), this.stargate.isConnected());
        }
    }

    public void sendDHDFeedback(StargateInfo.Feedback feedback) {
        if (this.hasDHD() && feedback.isError()) {
            this.dhd.sendMessageToNearbyPlayers(feedback.getFeedbackMessage(), 5);
        }
    }

    public boolean shouldCallForward() {
        return this.hasDHD() && this.dhd.callForwardingEnabled();
    }

    public void revalidateDHD() {
        BlockPos dhdPos = this.getDHDPos();
        if (dhdPos == null) {
            return;
        }
        BlockEntity blockEntity = this.stargate.getLevel().getBlockEntity(dhdPos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            if (this.dhd != dhd) {
                if (this.dhd != null) {
                    this.unsetDHD(true);
                }
                this.dhd = dhd;
            }
        } else if (this.dhd != null) {
            this.unsetDHD(true);
        }
    }

    public boolean hasDHD() {
        return this.dhd != null;
    }

    public void setRelativePos(Vec3i dhdRelativePos) {
        this.dhdRelativePos = dhdRelativePos;
    }

    @Nullable
    public Vec3i relativePos() {
        return this.dhdRelativePos;
    }

    public void setAutoclose(int autoclose) {
        this.autoclose = autoclose;
    }

    public int autoclose() {
        return this.autoclose;
    }

    public static interface Interface {
        public static final String DHD_POS = "dhd_pos";

        public DHDInfo dhdInfo();
    }
}

