/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.info;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.items.StargateShieldItem;

public class ShieldInfo {
    protected AbstractStargateEntity stargate;
    protected short shieldProgress;
    protected short oldShieldProgress;
    protected final ItemStackHandler shieldItemHandler;

    public ShieldInfo(AbstractStargateEntity stargate) {
        this.stargate = stargate;
        this.shieldProgress = 0;
        this.oldShieldProgress = 0;
        this.shieldItemHandler = this.createStargateShieldHandler();
    }

    protected ItemStackHandler createStargateShieldHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ShieldInfo.this.stargate.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getItem() instanceof StargateShieldItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static interface Interface {
        public static final String SHIELD_PROGRESS = "ShieldProgress";
        public static final String SHIELD_INVENTORY = "ShieldInventory";

        public ShieldInfo shieldInfo();
    }
}

