/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.world.biomemod;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.povstalec.sgjourney.common.world.biomemod.BiomeModifiers;

public record OreBiomeModifier(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) implements BiomeModifier
{
    public static final MapCodec<OreBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(OreBiomeModifier::biomes), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(OreBiomeModifier::feature)).apply((Applicative)builder, OreBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
            builder.getGenerationSettings().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, this.feature);
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)BiomeModifiers.ORE_MODIFIER.get();
    }
}

