/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.povstalec.sgjourney.common.blocks.ATAGeneDetectorBlock;
import net.povstalec.sgjourney.common.blocks.ArcheologyTableBlock;
import net.povstalec.sgjourney.common.blocks.BuddingUnityBlock;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.blocks.ChevronBlock;
import net.povstalec.sgjourney.common.blocks.ExplosiveBlock;
import net.povstalec.sgjourney.common.blocks.FirePitBlock;
import net.povstalec.sgjourney.common.blocks.GoldenIdolBlock;
import net.povstalec.sgjourney.common.blocks.SecretSwitchBlock;
import net.povstalec.sgjourney.common.blocks.SymbolBlock;
import net.povstalec.sgjourney.common.blocks.UnityClusterBlock;
import net.povstalec.sgjourney.common.blocks.dhd.AbstractDHDBlock;
import net.povstalec.sgjourney.common.blocks.dhd.ClassicDHDBlock;
import net.povstalec.sgjourney.common.blocks.dhd.MilkyWayDHDBlock;
import net.povstalec.sgjourney.common.blocks.dhd.PegasusDHDBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.MilkyWayStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.MilkyWayStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.PegasusStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.PegasusStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.TollanStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.TollanStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.UniverseStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.UniverseStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.GenericShieldingBlock;
import net.povstalec.sgjourney.common.blocks.tech.AdvancedCrystallizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.BatteryBlock;
import net.povstalec.sgjourney.common.blocks.tech.CableBlock;
import net.povstalec.sgjourney.common.blocks.tech.CrystallizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.HeavyNaquadahLiquidizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorMarkIBlock;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorMarkIIBlock;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahLiquidizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.TransceiverBlock;
import net.povstalec.sgjourney.common.blocks.tech.ZPMHubBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.AdvancedCrystalInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.BasicInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.CrystalInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.transporter.RingPanelBlock;
import net.povstalec.sgjourney.common.blocks.transporter.TransportRingsBlock;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.blocks.CartoucheBlockItem;
import net.povstalec.sgjourney.common.items.blocks.DHDItem;
import net.povstalec.sgjourney.common.items.blocks.EnergyBlockItem;
import net.povstalec.sgjourney.common.items.blocks.StargateBlockItem;
import net.povstalec.sgjourney.common.items.blocks.TransporterBlockItem;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sgjourney");
    public static final RegistryObject<UniverseStargateBlock> UNIVERSE_STARGATE = BlockInit.registerStargateBlock("universe_stargate", () -> new UniverseStargateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.EPIC);
    public static final RegistryObject<UniverseStargateRingBlock> UNIVERSE_RING = BLOCKS.register("universe_ring", () -> new UniverseStargateRingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<GenericShieldingBlock> UNIVERSE_SHIELDING = BLOCKS.register("universe_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_(), 7.0, 1.0));
    public static final RegistryObject<MilkyWayStargateBlock> MILKY_WAY_STARGATE = BlockInit.registerStargateBlock("milky_way_stargate", () -> new MilkyWayStargateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(6.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.EPIC);
    public static final RegistryObject<MilkyWayStargateRingBlock> MILKY_WAY_RING = BLOCKS.register("milky_way_ring", () -> new MilkyWayStargateRingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(6.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<GenericShieldingBlock> MILKY_WAY_SHIELDING = BLOCKS.register("milky_way_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_(), 7.0, 1.0));
    public static final RegistryObject<PegasusStargateBlock> PEGASUS_STARGATE = BlockInit.registerStargateBlock("pegasus_stargate", () -> new PegasusStargateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(6.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.EPIC);
    public static final RegistryObject<PegasusStargateRingBlock> PEGASUS_RING = BLOCKS.register("pegasus_ring", () -> new PegasusStargateRingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(6.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<GenericShieldingBlock> PEGASUS_SHIELDING = BLOCKS.register("pegasus_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_(), 7.0, 1.0));
    public static final RegistryObject<ClassicStargateBlock> CLASSIC_STARGATE = BlockInit.registerStargateBlock("classic_stargate", () -> new ClassicStargateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.UNCOMMON);
    public static final RegistryObject<ClassicStargateRingBlock> CLASSIC_RING = BLOCKS.register("classic_ring", () -> new ClassicStargateRingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<GenericShieldingBlock> CLASSIC_SHIELDING = BLOCKS.register("classic_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_(), 7.0, 1.0));
    public static final RegistryObject<ClassicStargateBaseBlock> CLASSIC_STARGATE_BASE_BLOCK = BlockInit.registerBlock("classic_stargate_base_block", () -> new ClassicStargateBaseBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f)), Rarity.UNCOMMON, 64);
    public static final RegistryObject<Block> CLASSIC_STARGATE_CHEVRON_BLOCK = BlockInit.registerBlock("classic_stargate_chevron_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f)), Rarity.UNCOMMON, 64);
    public static final RegistryObject<Block> CLASSIC_STARGATE_RING_BLOCK = BlockInit.registerBlock("classic_stargate_ring_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f)), Rarity.UNCOMMON, 64);
    public static final RegistryObject<TollanStargateBlock> TOLLAN_STARGATE = BlockInit.registerStargateBlock("tollan_stargate", () -> new TollanStargateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(6.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.EPIC);
    public static final RegistryObject<TollanStargateRingBlock> TOLLAN_RING = BLOCKS.register("tollan_ring", () -> new TollanStargateRingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(6.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<AbstractDHDBlock> MILKY_WAY_DHD = BlockInit.registerDHDBlock("milky_way_dhd", () -> new MilkyWayDHDBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.RARE);
    public static final RegistryObject<AbstractDHDBlock> PEGASUS_DHD = BlockInit.registerDHDBlock("pegasus_dhd", () -> new PegasusDHDBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 600.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.RARE);
    public static final RegistryObject<AbstractDHDBlock> CLASSIC_DHD = BlockInit.registerDHDBlock("classic_dhd", () -> new ClassicDHDBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.UNCOMMON);
    public static final RegistryObject<ChevronBlock> UNIVERSE_STARGATE_CHEVRON = BlockInit.registerBlock("universe_stargate_chevron", () -> new ChevronBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(3.0f).m_60999_().m_60955_().m_60910_().m_60953_(state -> (Boolean)state.m_61143_((Property)FirePitBlock.LIT) != false ? 7 : 0)), Rarity.UNCOMMON, 16);
    public static final RegistryObject<TransportRingsBlock> TRANSPORT_RINGS = BlockInit.registerTransporterBlock("transport_rings", () -> new TransportRingsBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(6.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.RARE);
    public static final RegistryObject<RingPanelBlock> RING_PANEL = BlockInit.registerBlock("ring_panel", () -> new RingPanelBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(6.0f).m_60918_(SoundType.f_56743_).m_60955_()), Rarity.RARE, 1);
    public static final RegistryObject<FallingBlock> SULFUR_SAND = BlockInit.registerBlock("sulfur_sand", () -> new FallingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final RegistryObject<BuddingUnityBlock> BUDDING_UNITY = BlockInit.registerBlock("budding_unity", () -> new BuddingUnityBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60978_(0.5f).m_60918_(SoundType.f_56746_).m_60977_()));
    public static final RegistryObject<UnityClusterBlock> SMALL_UNITY_BUD = BlockInit.registerBlock("small_unity_bud", () -> new UnityClusterBlock(3, 4, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(1.5f).m_60918_(SoundType.f_56744_).m_60999_()));
    public static final RegistryObject<UnityClusterBlock> MEDIUM_UNITY_BUD = BlockInit.registerBlock("medium_unity_bud", () -> new UnityClusterBlock(4, 3, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(1.5f).m_60918_(SoundType.f_56744_).m_60999_()));
    public static final RegistryObject<UnityClusterBlock> LARGE_UNITY_BUD = BlockInit.registerBlock("large_unity_bud", () -> new UnityClusterBlock(5, 3, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(1.5f).m_60918_(SoundType.f_56744_).m_60999_()));
    public static final RegistryObject<UnityClusterBlock> UNITY_CLUSTER = BlockInit.registerBlock("unity_cluster", () -> new UnityClusterBlock(7, 3, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(1.5f).m_60918_(SoundType.f_56744_).m_60999_()));
    public static final RegistryObject<ExplosiveBlock> NAQUADAH_ORE = BlockInit.registerBlock("naquadah_ore", () -> new ExplosiveBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(3.0f).m_60999_(), 4.0f));
    public static final RegistryObject<ExplosiveBlock> NETHER_NAQUADAH_ORE = BlockInit.registerBlock("nether_naquadah_ore", () -> new ExplosiveBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(3.0f).m_60999_(), 4.0f));
    public static final RegistryObject<ExplosiveBlock> DEEPSLATE_NAQUADAH_ORE = BlockInit.registerBlock("deepslate_naquadah_ore", () -> new ExplosiveBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283875_).m_60913_(4.5f, 3.0f).m_60999_(), 4.0f));
    public static final RegistryObject<ExplosiveBlock> RAW_NAQUADAH_BLOCK = BlockInit.registerBlock("raw_naquadah_block", () -> new ExplosiveBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(5.0f, 6.0f).m_60999_(), 10.0f));
    public static final RegistryObject<ExplosiveBlock> PURE_NAQUADAH_BLOCK = BlockInit.registerBlock("pure_naquadah_block", () -> new ExplosiveBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(5.0f, 6.0f).m_60999_(), 20.0f), Rarity.UNCOMMON, 64);
    public static final RegistryObject<LiquidBlock> LIQUID_NAQUADAH_BLOCK = BlockInit.registerBlock("liquid_naquadah", () -> new LiquidBlock(FluidInit.LIQUID_NAQUADAH_SOURCE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60910_().m_60978_(100.0f).m_222994_()));
    public static final RegistryObject<LiquidBlock> HEAVY_LIQUID_NAQUADAH_BLOCK = BlockInit.registerBlock("heavy_liquid_naquadah", () -> new LiquidBlock(FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60910_().m_60978_(100.0f).m_222994_()));
    public static final RegistryObject<Block> NAQUADAH_BLOCK = BlockInit.registerBlock("naquadah_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 9.0f).m_60999_()));
    public static final RegistryObject<Block> NAQUADAH_STAIRS = BlockInit.registerBlock("naquadah_stairs", () -> new StairBlock(() -> ((Block)NAQUADAH_BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 9.0f).m_60999_()));
    public static final RegistryObject<Block> NAQUADAH_SLAB = BlockInit.registerBlock("naquadah_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 9.0f).m_60999_()));
    public static final RegistryObject<Block> CUT_NAQUADAH_BLOCK = BlockInit.registerBlock("cut_naquadah_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 9.0f).m_60999_()));
    public static final RegistryObject<Block> CUT_NAQUADAH_STAIRS = BlockInit.registerBlock("cut_naquadah_stairs", () -> new StairBlock(() -> ((Block)NAQUADAH_BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 9.0f).m_60999_()));
    public static final RegistryObject<Block> CUT_NAQUADAH_SLAB = BlockInit.registerBlock("cut_naquadah_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 9.0f).m_60999_()));
    public static final RegistryObject<GoldenIdolBlock> GOLDEN_IDOL = BlockInit.registerBlock("golden_idol", () -> new GoldenIdolBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_()), Rarity.UNCOMMON, 16);
    public static final RegistryObject<ArcheologyTableBlock> ARCHEOLOGY_TABLE = BlockInit.registerBlock("archeology_table", () -> new ArcheologyTableBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<FirePitBlock> FIRE_PIT = BlockInit.registerBlock("fire_pit", () -> new FirePitBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_60966_().m_60918_(SoundType.f_56742_).m_60953_(state -> (Boolean)state.m_61143_((Property)FirePitBlock.LIT) != false ? 15 : 0), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> SANDSTONE_WITH_LAPIS = BlockInit.registerBlock("sandstone_with_lapis", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<RotatedPillarBlock> SANDSTONE_WITH_GOLD = BlockInit.registerBlock("sandstone_with_gold", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<RotatedPillarBlock> SANDSTONE_HIEROGLYPHS = BlockInit.registerBlock("sandstone_hieroglyphs", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<SecretSwitchBlock> SANDSTONE_SWITCH = BlockInit.registerBlock("sandstone_switch", () -> new SecretSwitchBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<Block> RED_SANDSTONE_WITH_LAPIS = BlockInit.registerBlock("red_sandstone_with_lapis", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<Block> RED_SANDSTONE_WITH_GOLD = BlockInit.registerBlock("red_sandstone_with_gold", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<Block> RED_SANDSTONE_GLYPHS = BlockInit.registerBlock("red_sandstone_glyphs", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<CartoucheBlock> SANDSTONE_CARTOUCHE = BlockInit.registerCartoucheBlock("sandstone_cartouche", () -> new CartoucheBlock.Sandstone(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<CartoucheBlock> RED_SANDSTONE_CARTOUCHE = BlockInit.registerCartoucheBlock("red_sandstone_cartouche", () -> new CartoucheBlock.RedSandstone(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<CartoucheBlock> STONE_CARTOUCHE = BlockInit.registerCartoucheBlock("stone_cartouche", () -> new CartoucheBlock.Stone(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f).m_60999_()));
    public static final RegistryObject<SymbolBlock> SANDSTONE_SYMBOL = BlockInit.registerBlock("sandstone_symbol", () -> new SymbolBlock.Sandstone(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<SymbolBlock> RED_SANDSTONE_SYMBOL = BlockInit.registerBlock("red_sandstone_symbol", () -> new SymbolBlock.RedSandstone(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.8f).m_60999_()));
    public static final RegistryObject<SymbolBlock> STONE_SYMBOL = BlockInit.registerBlock("stone_symbol", () -> new SymbolBlock.Stone(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f).m_60999_()));
    public static final RegistryObject<NaquadahGeneratorMarkIBlock> NAQUADAH_GENERATOR_MARK_I = BlockInit.registerEnergyBlock("naquadah_generator_mark_i", () -> new NaquadahGeneratorMarkIBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), () -> (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_capacity.get(), Rarity.COMMON);
    public static final RegistryObject<NaquadahGeneratorMarkIIBlock> NAQUADAH_GENERATOR_MARK_II = BlockInit.registerEnergyBlock("naquadah_generator_mark_ii", () -> new NaquadahGeneratorMarkIIBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), () -> (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_ii_capacity.get(), Rarity.COMMON);
    public static final RegistryObject<BasicInterfaceBlock> BASIC_INTERFACE = BlockInit.registerEnergyBlock("basic_interface", () -> new BasicInterfaceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60924_(BlockInit::never).m_60913_(5.0f, 6.0f)), () -> (Long)CommonInterfaceConfig.basic_interface_capacity.get(), Rarity.COMMON);
    public static final RegistryObject<CrystalInterfaceBlock> CRYSTAL_INTERFACE = BlockInit.registerEnergyBlock("crystal_interface", () -> new CrystalInterfaceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60924_(BlockInit::never).m_60913_(5.0f, 6.0f)), () -> (Long)CommonInterfaceConfig.crystal_interface_capacity.get(), Rarity.UNCOMMON);
    public static final RegistryObject<AdvancedCrystalInterfaceBlock> ADVANCED_CRYSTAL_INTERFACE = BlockInit.registerEnergyBlock("advanced_crystal_interface", () -> new AdvancedCrystalInterfaceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60924_(BlockInit::never).m_60913_(5.0f, 6.0f)), () -> (Long)CommonInterfaceConfig.advanced_crystal_interface_capacity.get(), Rarity.RARE);
    public static final RegistryObject<ATAGeneDetectorBlock> ANCIENT_GENE_DETECTOR = BlockInit.registerBlock("ancient_gene_detector", () -> new ATAGeneDetectorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), Rarity.RARE, 1);
    public static final RegistryObject<ZPMHubBlock> ZPM_HUB = BlockInit.registerBlock("zpm_hub", () -> new ZPMHubBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), Rarity.RARE, 1);
    public static final RegistryObject<NaquadahLiquidizerBlock> NAQUADAH_LIQUIDIZER = BlockInit.registerBlock("naquadah_liquidizer", () -> new NaquadahLiquidizerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), 1);
    public static final RegistryObject<HeavyNaquadahLiquidizerBlock> HEAVY_NAQUADAH_LIQUIDIZER = BlockInit.registerBlock("heavy_naquadah_liquidizer", () -> new HeavyNaquadahLiquidizerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), Rarity.UNCOMMON, 1);
    public static final RegistryObject<CrystallizerBlock> CRYSTALLIZER = BlockInit.registerBlock("crystallizer", () -> new CrystallizerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), Rarity.UNCOMMON, 1);
    public static final RegistryObject<AdvancedCrystallizerBlock> ADVANCED_CRYSTALLIZER = BlockInit.registerBlock("advanced_crystallizer", () -> new AdvancedCrystallizerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f)), Rarity.RARE, 1);
    public static final RegistryObject<TransceiverBlock> TRANSCEIVER = BlockInit.registerBlock("transceiver", () -> new TransceiverBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f)), 1);
    public static final RegistryObject<CableBlock> NAQUADAH_WIRE = BlockInit.registerBlock("naquadah_wire", () -> new CableBlock.NaquadahWire(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(1.0f, 6.0f).m_60955_()), 64);
    public static final RegistryObject<CableBlock> SMALL_NAQUADAH_CABLE = BlockInit.registerBlock("small_naquadah_cable", () -> new CableBlock.SmallNaquadahCable(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(1.5f, 6.0f).m_60955_().m_60999_()), 64);
    public static final RegistryObject<CableBlock> MEDIUM_NAQUADAH_CABLE = BlockInit.registerBlock("medium_naquadah_cable", () -> new CableBlock.MediumNaquadahCable(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(2.0f, 6.0f).m_60955_().m_60999_()), Rarity.UNCOMMON, 64);
    public static final RegistryObject<CableBlock> LARGE_NAQUADAH_CABLE = BlockInit.registerBlock("large_naquadah_cable", () -> new CableBlock.LargeNaquadahCable(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60955_().m_60999_()), Rarity.RARE, 64);
    public static final RegistryObject<BatteryBlock> LARGE_NAQUADAH_BATTERY = BlockInit.registerEnergyBlock("large_naquadah_battery", () -> new BatteryBlock.Naquadah(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f)), () -> (Long)CommonTechConfig.large_naquadah_battery_capacity.get(), Rarity.RARE);

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, int stacksTo) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn, stacksTo);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, Rarity rarity, int stacksTo) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn, rarity, stacksTo);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerStargateBlock(String name, Supplier<T> block, Rarity rarity) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerStargateBlockItem(name, toReturn, rarity, 1);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerTransporterBlock(String name, Supplier<T> block, Rarity rarity) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerTransporterBlockItem(name, toReturn, rarity, 1);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerDHDBlock(String name, Supplier<T> block, Rarity rarity) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerDHDItem(name, toReturn, rarity, 1);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerCartoucheBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerCartoucheBlockItem(name, toReturn, 1);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerEnergyBlock(String name, Supplier<T> block, EnergyBlockItem.CapacityGetter getter, Rarity rarity) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerEnergyBlockItem(name, toReturn, getter, rarity);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41487_(stacksTo)));
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity).m_41487_(stacksTo)));
    }

    private static <T extends Block> RegistryObject<Item> registerStargateBlockItem(String name, RegistryObject<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new StargateBlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity).m_41487_(stacksTo).m_41486_()));
    }

    private static <T extends Block> RegistryObject<Item> registerTransporterBlockItem(String name, RegistryObject<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new TransporterBlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity).m_41487_(stacksTo).m_41486_()));
    }

    private static <T extends Block> RegistryObject<Item> registerDHDItem(String name, RegistryObject<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new DHDItem((Block)block.get(), new Item.Properties().m_41497_(rarity).m_41487_(stacksTo)));
    }

    private static <T extends Block> RegistryObject<Item> registerCartoucheBlockItem(String name, RegistryObject<T> block, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new CartoucheBlockItem((Block)block.get(), new Item.Properties().m_41487_(stacksTo)));
    }

    private static <T extends Block> RegistryObject<Item> registerEnergyBlockItem(String name, RegistryObject<T> block, EnergyBlockItem.CapacityGetter getter, Rarity rarity) {
        return ItemInit.ITEMS.register(name, () -> new EnergyBlockItem.Getter((Block)block.get(), new Item.Properties().m_41497_(rarity).m_41487_(1), getter));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }
}

