/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.BatteryBlockEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public class BatteryMenu
extends InventoryMenu {
    private final BatteryBlockEntity battery;
    private final Level level;

    public BatteryMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public BatteryMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)MenuInit.NAQUADAH_BATTERY.get(), containerId);
        this.battery = (BatteryBlockEntity)entity;
        this.level = inventory.f_35978_.m_9236_();
        this.addPlayerInventory(inventory, 8, 84);
        this.addPlayerHotbar(inventory, 8, 142);
        this.battery.getItemHandler().ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 8, 36));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 152, 36));
        });
    }

    public long getEnergy() {
        return this.battery.getEnergyStored();
    }

    public long getMaxEnergy() {
        return this.battery.getEnergyCapacity();
    }

    public boolean hasItem(int slot) {
        if (slot < 0 || slot > 8) {
            return false;
        }
        IItemHandler cap = this.battery.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
        if (cap != null) {
            return !cap.getStackInSlot(slot).m_41619_();
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return BatteryMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.battery.m_58899_()), (Player)player, (Block)((Block)BlockInit.LARGE_NAQUADAH_BATTERY.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 2;
    }
}

