/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class LocatorHelper {
    public static List<AbstractStargateEntity> getNearbyStargates(Level level, BlockPos centerPos, long maxDistance) {
        ArrayList<AbstractStargateEntity> stargates = new ArrayList<AbstractStargateEntity>();
        int chunkX = SectionPos.m_123171_((int)centerPos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)centerPos.m_123343_());
        int chunkDistance = SectionPos.m_235865_((double)maxDistance);
        for (int x = chunkX - chunkDistance; x <= chunkX + chunkDistance; ++x) {
            for (int z = chunkZ - chunkDistance; z <= chunkZ + chunkDistance; ++z) {
                LevelChunk chunk = level.m_6325_(x, z);
                for (BlockPos pos : chunk.m_5928_()) {
                    AbstractStargateEntity stargate;
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (!(blockEntity instanceof AbstractStargateEntity) || CoordinateHelper.Relative.distanceSqr((Vec3i)centerPos, (Vec3i)(stargate = (AbstractStargateEntity)blockEntity).m_58899_()) > maxDistance * maxDistance) continue;
                    stargates.add(stargate);
                }
            }
        }
        return stargates;
    }

    public static List<AbstractStargateEntity> getNearbyStargatesByDistance(Level level, BlockPos centerPos, long maxDistance) {
        List<AbstractStargateEntity> stargates = LocatorHelper.getNearbyStargates(level, centerPos, maxDistance);
        stargates.sort(Comparator.comparing(stargate -> CoordinateHelper.Relative.distance((Vec3i)centerPos, (Vec3i)stargate.m_58899_())));
        return stargates;
    }

    @Nullable
    public static AbstractStargateEntity findNearestStargate(Level level, BlockPos centerPos, long maxDistance) {
        List<AbstractStargateEntity> stargates = LocatorHelper.getNearbyStargatesByDistance(level, centerPos, maxDistance);
        if (stargates.isEmpty()) {
            return null;
        }
        return stargates.get(0);
    }

    public static List<Transporter> findNearestTransporters(ServerLevel level, BlockPos centerPos) {
        List<Transporter> transporters = TransporterNetwork.get((Level)level).getTransportersFromDimension((ResourceKey<Level>)level.m_46472_());
        transporters.sort(Comparator.comparing(transporter -> CoordinateHelper.Relative.distance((Vec3i)centerPos, (Vec3i)transporter.getBlockPos())));
        transporters.removeIf(transporter -> transporter.getBlockPos() == null || transporter.getDimension() == null);
        return transporters;
    }
}

