/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.structures;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;

public abstract class SGJourneyStructure
extends Structure {
    protected final Holder<StructureTemplatePool> startPool;
    protected final Optional<ResourceLocation> startJigsawName;
    protected final int size;
    protected final HeightProvider startHeight;
    protected final Optional<Heightmap.Types> projectStartToHeightmap;
    protected final int maxDistanceFromCenter;
    @Nullable
    protected Boolean commonStargates;

    public SGJourneyStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Boolean> commonStargates) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.commonStargates = commonStargates.orElse(null);
    }

    public HolderSet<Biome> m_226559_() {
        if (this.commonStargates == null) {
            return super.m_226559_();
        }
        if (this.commonStargates.booleanValue() != CommonGenerationConfig.common_stargate_generation.get()) {
            return HolderSet.m_205809_((Holder[])new Holder[0]);
        }
        return super.m_226559_();
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context) {
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!this.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos();
        int minX = boundingBox.m_162395_();
        int maxX = boundingBox.m_162399_();
        int minZ = boundingBox.m_162398_();
        int maxZ = boundingBox.m_162401_();
        for (int x = minX; x <= maxX; x += 16) {
            for (int z = minZ; z <= maxZ; z += 16) {
                this.generateBlockEntities(level, (BlockPos)startPos.m_122178_(x, 0, z), randomSource);
            }
        }
    }

    protected void generateBlockEntities(WorldGenLevel level, BlockPos startPos, RandomSource randomSource) {
        for (BlockPos pos : level.m_46865_(startPos).m_5928_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof StructureGenEntity)) continue;
            StructureGenEntity generatedEntity = (StructureGenEntity)blockEntity;
            this.generateBlockEntity(level, startPos, randomSource, generatedEntity);
            blockEntity.m_6596_();
        }
    }

    protected void generateBlockEntity(WorldGenLevel level, BlockPos startPos, RandomSource randomSource, StructureGenEntity generatedEntity) {
        generatedEntity.generateInStructure(level, randomSource);
    }
}

