/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.povstalec.sgjourney.common.world.features.configuration.CrystalPatchConfiguration;

public class CrystalPatchFeature
extends Feature<CrystalPatchConfiguration> {
    public static int BUDDING_CHANCE = 10;

    public CrystalPatchFeature(Codec<CrystalPatchConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalPatchConfiguration> context) {
        CrystalPatchConfiguration configuration = (CrystalPatchConfiguration)context.m_159778_();
        RandomSource randomSource = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        int placed = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int xzSpread = configuration.xzSpread() + 1;
        int ySpread = configuration.ySpread() + 1;
        for (int i = 0; i < configuration.tries(); ++i) {
            mutablePos.m_122154_((Vec3i)pos, randomSource.m_188503_(xzSpread) - randomSource.m_188503_(xzSpread), randomSource.m_188503_(ySpread) - randomSource.m_188503_(ySpread), randomSource.m_188503_(xzSpread) - randomSource.m_188503_(xzSpread));
            if (mutablePos.m_123342_() > configuration.maxHeight() || !level.m_8055_(mutablePos.m_7495_()).m_60713_(configuration.fillingProvider().m_213972_(randomSource, (BlockPos)mutablePos).m_60734_())) continue;
            if (((PlacedFeature)this.randomFeature(configuration, randomSource).m_203334_()).m_226357_(level, context.m_159775_(), randomSource, (BlockPos)mutablePos)) {
                ++placed;
            }
            if (randomSource.m_188503_(BUDDING_CHANCE) != 0) continue;
            this.m_5974_((LevelWriter)level, mutablePos.m_7495_(), configuration.buddingProvider().m_213972_(randomSource, (BlockPos)mutablePos));
        }
        return placed > 0;
    }

    private Holder<PlacedFeature> randomFeature(CrystalPatchConfiguration configuration, RandomSource randomSource) {
        return switch (Math.abs(randomSource.m_188503_(4))) {
            case 1 -> configuration.smallBudFeature();
            case 2 -> configuration.mediumBudFeature();
            case 3 -> configuration.largeBudFeature();
            default -> configuration.clusterFeature();
        };
    }
}

