/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.transporter;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.blocks.transporter.TransportRingsBlock;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundRingsUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class TransportRingsEntity
extends AbstractTransporterEntity {
    public static final int MAX_TRANSPORT_HEIGHT = 16;
    @Nullable
    private BlockPos transportPos = null;
    public int emptySpace = 0;
    public int transportHeight = 0;
    public int progress = -1;
    public int progressOld = -1;

    public TransportRingsEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - 3), (double)(this.m_58899_().m_123342_() - 19), (double)(this.m_58899_().m_123343_() - 3), (double)(this.m_58899_().m_123341_() + 4), (double)(this.m_58899_().m_123342_() + 20), (double)(this.m_58899_().m_123343_() + 4));
    }

    @Override
    public int getTimeOffset() {
        return this.getTransportHeight();
    }

    @Override
    @Nullable
    public List<Entity> entitiesToTransport() {
        AABB localBox = new AABB((double)(this.transportPos.m_123341_() - 1), (double)this.transportPos.m_123342_(), (double)(this.transportPos.m_123343_() - 1), (double)(this.transportPos.m_123341_() + 2), (double)(this.transportPos.m_123342_() + 3), (double)(this.transportPos.m_123343_() + 2));
        return this.f_58857_.m_45976_(Entity.class, localBox);
    }

    @Override
    public BlockPos transportPos() {
        if (this.transportPos == null) {
            this.emptySpace = this.getEmptySpace();
            this.transportPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + this.emptySpace, this.m_58899_().m_123343_());
        }
        return this.transportPos;
    }

    public void updateClient() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundRingsUpdatePacket(this.m_58899_(), this.emptySpace, this.transportHeight, this.progress));
        }
    }

    public void startTransport(Transporter target) {
        Transporter transporter = this.getTransporter();
        if (transporter == null) {
            return;
        }
        TransporterNetwork.get(this.f_58857_).createConnection(this.f_58857_.m_7654_(), transporter, target);
    }

    @Override
    public boolean connectTransporter(UUID connectionID) {
        this.transportPos();
        return super.connectTransporter(connectionID);
    }

    @Override
    public void resetTransporter() {
        this.emptySpace = 0;
        this.transportHeight = 0;
        this.transportPos = null;
        super.resetTransporter();
    }

    public int getTransportHeight() {
        if (this.transportHeight == 0) {
            int emptySpace = this.getEmptySpace();
            this.transportHeight = emptySpace > 0 ? Math.abs(emptySpace * 4) + 8 : Math.abs(emptySpace * 4);
        }
        return this.transportHeight;
    }

    @Override
    public void updateTicks(int connectionTime) {
        this.progress = connectionTime;
        this.progressOld = connectionTime;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TransportRingsEntity rings) {
        if (rings.isConnected()) {
            rings.doClientProgress();
        } else {
            rings.progress = -1;
            rings.progressOld = -1;
        }
        rings.updateClient();
    }

    private void doClientProgress() {
        if (!this.f_58857_.m_5776_() || this.progress < 0) {
            return;
        }
        this.progressOld = this.progress++;
    }

    public void updateProgress(int progress) {
        if (this.progress == -1 || progress == -1) {
            this.progress = progress;
            this.progressOld = progress;
        }
    }

    public void setProgress(int progress) {
        this.progressOld = this.progress;
        this.progress = progress;
    }

    public float getProgress(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.progress : Mth.m_14179_((float)partialTick, (float)this.progressOld, (float)this.progress);
    }

    @Override
    public boolean isConnected() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60713_((Block)BlockInit.TRANSPORT_RINGS.get())) {
            return (Boolean)this.f_58857_.m_8055_(pos).m_61143_((Property)TransportRingsBlock.ACTIVATED);
        }
        return false;
    }

    @Override
    public void setConnected(boolean connected) {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60713_((Block)BlockInit.TRANSPORT_RINGS.get())) {
            this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)TransportRingsBlock.ACTIVATED, (Comparable)Boolean.valueOf(connected)), 2);
        }
        this.loadChunk(connected);
    }

    private int getEmptySpace() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (!state.m_60713_((Block)BlockInit.TRANSPORT_RINGS.get())) {
            return 0;
        }
        if (state.m_61143_((Property)TransportRingsBlock.FACING) == Direction.DOWN) {
            for (int i = 4; i <= 16; ++i) {
                if (this.f_58857_.m_8055_(pos.m_6625_(i)).m_60767_().m_76336_() || !this.f_58857_.m_8055_(pos.m_6625_(i - 1)).m_60767_().m_76336_() || !this.f_58857_.m_8055_(pos.m_6625_(i - 2)).m_60767_().m_76336_() || !this.f_58857_.m_8055_(pos.m_6625_(i - 3)).m_60767_().m_76336_()) continue;
                return -i + 1;
            }
        } else {
            for (int i = 1; i <= 16; ++i) {
                if (!this.f_58857_.m_8055_(pos.m_6630_(i)).m_60767_().m_76336_() || !this.f_58857_.m_8055_(pos.m_6630_(i + 1)).m_60767_().m_76336_() || !this.f_58857_.m_8055_(pos.m_6630_(i + 2)).m_60767_().m_76336_()) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public long capacity() {
        return 0L;
    }

    @Override
    public long maxReceive() {
        return 0L;
    }

    @Override
    public long maxExtract() {
        return 0L;
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.sgjourney.transport_rings");
    }
}

