/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.povstalec.sgjourney.common.blocks.UnityClusterBlock;
import net.povstalec.sgjourney.common.init.BlockInit;

public class BuddingUnityBlock
extends Block {
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingUnityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.m_188503_(5) == 0) {
            Direction direction = DIRECTIONS[randomSource.m_188503_(DIRECTIONS.length)];
            BlockPos crystalPos = pos.m_121945_(direction);
            BlockState crystalState = level.m_8055_(crystalPos);
            Block crystalBlock = null;
            if (BuddingUnityBlock.canClusterGrowAtState(crystalState)) {
                crystalBlock = (Block)BlockInit.SMALL_UNITY_BUD.get();
            } else if (crystalState.m_60713_((Block)BlockInit.SMALL_UNITY_BUD.get()) && crystalState.m_61143_((Property)UnityClusterBlock.FACING) == direction) {
                crystalBlock = (Block)BlockInit.MEDIUM_UNITY_BUD.get();
            } else if (crystalState.m_60713_((Block)BlockInit.MEDIUM_UNITY_BUD.get()) && crystalState.m_61143_((Property)UnityClusterBlock.FACING) == direction) {
                crystalBlock = (Block)BlockInit.LARGE_UNITY_BUD.get();
            } else if (crystalState.m_60713_((Block)BlockInit.LARGE_UNITY_BUD.get()) && crystalState.m_61143_((Property)UnityClusterBlock.FACING) == direction) {
                crystalBlock = (Block)BlockInit.UNITY_CLUSTER.get();
            }
            if (crystalBlock != null) {
                BlockState newCrystalState = (BlockState)((BlockState)crystalBlock.m_49966_().m_61124_((Property)UnityClusterBlock.FACING, (Comparable)direction)).m_61124_((Property)UnityClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(crystalState.m_60819_().m_76152_() == Fluids.f_76193_));
                level.m_46597_(crystalPos, newCrystalState);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76186_() == 8;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }
}

