/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChevronBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.f_61375_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape WEST = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ChevronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ORIENTATION, (Comparable)FrontAndTop.UP_NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{ORIENTATION}).m_61104_(new Property[]{LIT}).m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)rotation.m_55948_().m_56530_((FrontAndTop)state.m_61143_(ORIENTATION)));
    }

    public BlockState m_6943_(BlockState rotation, Mirror mirror) {
        return (BlockState)rotation.m_61124_(ORIENTATION, (Comparable)mirror.m_54842_().m_56530_((FrontAndTop)rotation.m_61143_(ORIENTATION)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        Direction direction1 = direction.m_122434_() == Direction.Axis.Y ? context.m_8125_().m_122424_() : Direction.UP;
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)FrontAndTop.m_122622_((Direction)direction, (Direction)direction1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos1, Block block, BlockPos pos2, boolean p_55671_) {
        boolean isLit;
        if (!level.m_5776_() && (isLit = ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) != level.m_46753_(pos1)) {
            if (isLit) {
                level.m_186460_(pos1, (Block)this, 4);
            } else {
                level.m_7731_(pos1, (BlockState)state.m_61122_((Property)LIT), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !level.m_46753_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        FrontAndTop orientation = (FrontAndTop)state.m_61143_(ORIENTATION);
        if (orientation == FrontAndTop.NORTH_UP) {
            return NORTH;
        }
        if (orientation == FrontAndTop.EAST_UP) {
            return EAST;
        }
        if (orientation == FrontAndTop.SOUTH_UP) {
            return SOUTH;
        }
        if (orientation == FrontAndTop.WEST_UP) {
            return WEST;
        }
        if (orientation.m_122625_() == Direction.DOWN) {
            return TOP;
        }
        return BOTTOM;
    }

    private boolean canSupport(BlockState state, LevelReader levelReader, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = levelReader.m_8055_(blockPos);
        return blockstate.m_60783_((BlockGetter)levelReader, pos, direction);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        FrontAndTop orientation = (FrontAndTop)state.m_61143_(ORIENTATION);
        if (orientation == FrontAndTop.NORTH_UP) {
            return this.canSupport(state, levelReader, pos, Direction.NORTH);
        }
        if (orientation == FrontAndTop.EAST_UP) {
            return this.canSupport(state, levelReader, pos, Direction.EAST);
        }
        if (orientation == FrontAndTop.SOUTH_UP) {
            return this.canSupport(state, levelReader, pos, Direction.SOUTH);
        }
        if (orientation == FrontAndTop.WEST_UP) {
            return this.canSupport(state, levelReader, pos, Direction.WEST);
        }
        if (orientation.m_122625_() == Direction.DOWN) {
            return this.canSupport(state, levelReader, pos, Direction.DOWN);
        }
        return this.canSupport(state, levelReader, pos, Direction.UP);
    }

    public BlockState m_7417_(BlockState state1, Direction direction, BlockState state2, LevelAccessor levelAccessor, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)state1.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos1, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return !this.m_7898_(state1, (LevelReader)levelAccessor, pos1) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state1, direction, state2, levelAccessor, pos1, pos2);
    }

    public void m_6807_(BlockState state1, Level level, BlockPos pos, BlockState state2, boolean p_55728_) {
        for (Direction direction : Direction.values()) {
            level.m_46672_(pos.m_121945_(direction), (Block)this);
        }
    }
}

