/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.blockstates.StargateBlockState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.misc.CoverBlockPlaceContext;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;
import net.povstalec.sgjourney.common.sgjourney.StargateBlockCover;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public abstract class AbstractStargateBlock
extends Block
implements SimpleWaterloggedBlock,
ProtectedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);
    public static final EnumProperty<StargatePart> PART = EnumProperty.m_61587_((String)"stargate_part", StargatePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected VoxelShapeProvider shapeProvider;
    protected StateDefinition<Block, BlockState> stargateStateDefinition;

    public AbstractStargateBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties);
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.stargateStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, StargateBlockState::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stargateStateDefinition.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ORIENTATION, (Comparable)((Object)Orientation.REGULAR))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)StargatePart.BASE)));
        this.shapeProvider = new VoxelShapeProvider(width, horizontalOffset);
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stargateStateDefinition;
    }

    public ArrayList<StargatePart> getParts(boolean shielded) {
        return shielded ? StargatePart.DEFAULT_SHIELDED_PARTS : StargatePart.DEFAULT_PARTS;
    }

    public ArrayList<StargatePart> getParts() {
        return this.getParts(false);
    }

    public ArrayList<ShieldingPart> getShieldingParts() {
        return ShieldingPart.DEFAULT_PARTS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{ORIENTATION}).m_61104_(new Property[]{PART});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected VoxelShape shape(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        if (state.m_61143_(ORIENTATION) != Orientation.REGULAR) {
            return this.shapeProvider.HORIZONTAL_FULL;
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? this.shapeProvider.Z_FULL : this.shapeProvider.X_FULL;
    }

    public Optional<StargateBlockCover> getBlockCover(BlockGetter reader, BlockState state, BlockPos position) {
        AbstractStargateEntity stargate = this.getStargate(reader, position, state);
        if (stargate != null) {
            return Optional.of(stargate.blockCover);
        }
        return Optional.empty();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Optional<StargateBlockCover> blockCover = this.getBlockCover(reader, state, pos);
        if (blockCover.isPresent()) {
            StargatePart part = (StargatePart)((Object)state.m_61143_(PART));
            Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
            if (coverState.isPresent()) {
                return Shapes.m_83110_((VoxelShape)this.shape(state, reader, pos, context), (VoxelShape)coverState.get().m_60808_(reader, pos));
            }
        }
        return this.shape(state, reader, pos, context);
    }

    public BlockState m_7417_(BlockState oldState, Direction direction, BlockState newState, LevelAccessor levelAccessor, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)oldState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(oldPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(oldState, direction, newState, levelAccessor, oldPos, newPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        AbstractStargateEntity stargate = this.getStargate((BlockGetter)level, pos, state);
        if (stargate != null) {
            stargate.resetStargate(StargateInfo.Feedback.STARGATE_DESTROYED, true);
            if (!level.m_5776_() && !player.m_7500_()) {
                ItemStack itemstack = new ItemStack((ItemLike)this.m_5456_());
                stargate.m_187476_(itemstack);
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                itementity.m_149678_();
                level.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void destroyStargate(Level level, BlockPos pos, ArrayList<StargatePart> parts, ArrayList<ShieldingPart> shieldingParts, Direction direction, Orientation orientation, StargatePart stargatePart) {
        if (direction == null) {
            StargateJourney.LOGGER.error("Failed to destroy Stargate because direction is null");
            return;
        }
        if (orientation == null) {
            StargateJourney.LOGGER.error("Failed to destroy Stargate because orientation is null");
            return;
        }
        AbstractShieldingBlock.destroyShielding(level, pos, shieldingParts, direction, orientation);
        for (StargatePart part : parts) {
            BlockPos ringPos;
            BlockState state;
            if (stargatePart.equals(part) || !((state = level.m_8055_(ringPos = part.getRingPos(pos, direction, orientation))).m_60734_() instanceof AbstractStargateBlock)) continue;
            boolean waterlogged = state.m_60734_() instanceof AbstractStargateRingBlock ? (Boolean)state.m_61143_((Property)AbstractStargateRingBlock.WATERLOGGED) : false;
            level.m_7731_(ringPos, waterlogged ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public abstract AbstractStargateEntity getStargate(BlockGetter var1, BlockPos var2, BlockState var3);

    @Override
    public ProtectedBlockEntity getProtectedBlockEntity(BlockGetter reader, BlockPos pos, BlockState state) {
        return this.getStargate(reader, pos, state);
    }

    @Override
    public boolean hasPermissions(BlockGetter reader, BlockPos pos, BlockState state, Player player, boolean sendMessage) {
        AbstractStargateEntity stargate = this.getStargate(reader, pos, state);
        if (stargate != null) {
            return stargate.hasPermissions(player, sendMessage);
        }
        return true;
    }

    public boolean setCover(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Optional<StargateBlockCover> blockCover;
        if (!player.m_6144_() && (blockCover = this.getBlockCover((BlockGetter)level, state, pos)).isPresent()) {
            StargatePart part = (StargatePart)((Object)state.m_61143_(PART));
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockCover.get().getBlockAt(part).isEmpty()) {
                    CoverBlockPlaceContext context = new CoverBlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stack, result);
                    BlockState coverState = blockItem.m_40614_().m_5573_((BlockPlaceContext)context);
                    if (coverState != null && !(coverState.m_60734_() instanceof EntityBlock)) {
                        if (!this.hasPermissions((BlockGetter)level, pos, state, player, true)) {
                            player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.protected_permissions"), true);
                        } else if (blockCover.get().setBlockAt(part, coverState)) {
                            level.m_247517_(player, pos, coverState.m_60734_().m_49962_(coverState).m_56777_(), SoundSource.BLOCKS);
                            if (!player.m_7500_()) {
                                stack.m_41774_(1);
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean setIris(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        AbstractStargateEntity stargate;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof StargateIrisItem && !level.m_5776_() && (stargate = this.getStargate((BlockGetter)level, pos, state)) != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            if (!this.hasPermissions((BlockGetter)level, pos, state, player, true)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.protected_permissions"), true);
            } else {
                if (irisStargate.irisInfo().addIris(stack)) {
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    return true;
                }
                player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.already_has_iris"), true);
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (this.setCover(state, level, pos, player, hand, result)) {
            return InteractionResult.SUCCESS;
        }
        if (this.setIris(state, level, pos, player, hand, result)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Optional<StargateBlockCover> blockCover = this.getBlockCover((BlockGetter)level, state, pos);
        if (blockCover.isPresent() && !blockCover.get().blockStates.isEmpty()) {
            StargatePart part = (StargatePart)((Object)state.m_61143_(PART));
            if (blockCover.get().mineBlockAt(level, player, part, pos)) {
                return false;
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Optional<StargateBlockCover> blockCover = this.getBlockCover(level, state, pos);
        if (blockCover.isPresent() && !blockCover.get().blockStates.isEmpty()) {
            StargatePart part = (StargatePart)((Object)state.m_61143_(PART));
            ItemStack stack = blockCover.get().getStackAt(target, level, player, part, pos);
            if (!stack.m_41619_()) {
                return stack;
            }
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

