/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate.shielding;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;

public abstract class AbstractShieldingBlock
extends Block
implements SimpleWaterloggedBlock,
ProtectedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);
    public static final EnumProperty<ShieldingState> SHIELDING_STATE = EnumProperty.m_61587_((String)"shielding_state", ShieldingState.class);
    public static final EnumProperty<ShieldingPart> PART = EnumProperty.m_61587_((String)"shielding_part", ShieldingPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected VoxelShapeProvider shapeProvider;

    public AbstractShieldingBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ORIENTATION, (Comparable)((Object)Orientation.REGULAR))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)ShieldingPart.ABOVE))).m_61124_(SHIELDING_STATE, (Comparable)((Object)ShieldingState.OPEN)));
        this.shapeProvider = new VoxelShapeProvider(width, horizontalOffset);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{ORIENTATION}).m_61104_(new Property[]{PART}).m_61104_(new Property[]{SHIELDING_STATE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        SoundType soundtype = state.getSoundType((LevelReader)level, pos, null);
        level.m_245747_(pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f, false);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        IrisStargateEntity stargate;
        BlockEntity blockentity = level.m_7702_(((ShieldingPart)((Object)state.m_61143_(PART))).getBaseBlockPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_(ORIENTATION))));
        if (blockentity instanceof IrisStargateEntity && (stargate = (IrisStargateEntity)blockentity).irisInfo().getIris() != null && !stargate.irisInfo().getIris().m_41619_()) {
            return stargate.irisInfo().getIris().m_41777_();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        ShieldingState shieldingState = (ShieldingState)((Object)state.m_61143_(SHIELDING_STATE));
        return switch ((ShieldingPart)((Object)state.m_61143_(PART))) {
            case ShieldingPart.LEFT_ABOVE5, ShieldingPart.ABOVE5, ShieldingPart.RIGHT_ABOVE5 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_TOP, direction, orientation);
            case ShieldingPart.LEFT2_ABOVE4, ShieldingPart.LEFT2_ABOVE3, ShieldingPart.LEFT2_ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_LEFT, direction, orientation);
            case ShieldingPart.RIGHT2_ABOVE2, ShieldingPart.RIGHT2_ABOVE3, ShieldingPart.RIGHT2_ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_RIGHT, direction, orientation);
            case ShieldingPart.LEFT_ABOVE, ShieldingPart.ABOVE, ShieldingPart.RIGHT_ABOVE -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_BOTTOM, direction, orientation);
            case ShieldingPart.LEFT_ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_BOTTOM_RIGHT) : this.shapeProvider.IRIS_CORNER_TOP_LEFT, direction, orientation);
            case ShieldingPart.RIGHT_ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_BOTTOM_LEFT) : this.shapeProvider.IRIS_CORNER_TOP_RIGHT, direction, orientation);
            case ShieldingPart.LEFT_ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_TOP_RIGHT) : this.shapeProvider.IRIS_CORNER_BOTTOM_LEFT, direction, orientation);
            case ShieldingPart.RIGHT_ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_TOP_LEFT) : this.shapeProvider.IRIS_CORNER_BOTTOM_RIGHT, direction, orientation);
            case ShieldingPart.ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_TOP, direction, orientation);
            case ShieldingPart.LEFT_ABOVE3 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_LEFT, direction, orientation);
            case ShieldingPart.RIGHT_ABOVE3 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_RIGHT, direction, orientation);
            case ShieldingPart.ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_BOTTOM, direction, orientation);
            default -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.IRIS_FULL, direction, orientation);
        };
    }

    public AbstractStargateEntity getStargate(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockPos baseBlockPos = ((ShieldingPart)((Object)state.m_61143_(PART))).getBaseBlockPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_(ORIENTATION)));
        BlockState stargateState = reader.m_8055_(baseBlockPos);
        Block block = stargateState.m_60734_();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            return stargateBlock.getStargate(reader, baseBlockPos, stargateState);
        }
        return null;
    }

    @Override
    public ProtectedBlockEntity getProtectedBlockEntity(BlockGetter reader, BlockPos pos, BlockState state) {
        return this.getStargate(reader, pos, state);
    }

    @Override
    public boolean hasPermissions(BlockGetter reader, BlockPos pos, BlockState state, Player player, boolean sendMessage) {
        AbstractStargateEntity stargate = this.getStargate(reader, pos, state);
        if (stargate != null) {
            return stargate.hasPermissions(player, sendMessage);
        }
        return true;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        AbstractStargateBaseBlock stargateBlock;
        AbstractStargateEntity stargate;
        BlockPos baseBlockPos = ((ShieldingPart)((Object)state.m_61143_(PART))).getBaseBlockPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_(ORIENTATION)));
        BlockState stargateState = level.m_8055_(baseBlockPos);
        Block block = stargateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock && (stargate = (stargateBlock = (AbstractStargateBaseBlock)block).getStargate((BlockGetter)level, baseBlockPos, stargateState)) != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            ItemStack irisStack = irisStargate.irisInfo().getIris();
            if (!(level.m_5776_() || player.m_7500_() || irisStack.equals(ItemStack.f_41583_))) {
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, irisStack);
                itementity.m_32060_();
                itementity.m_149678_();
                level.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            AbstractStargateBaseBlock stargateBlock;
            AbstractStargateEntity stargate;
            ShieldingPart shieldingPart = (ShieldingPart)((Object)oldState.m_61143_(PART));
            BlockPos baseBlockPos = shieldingPart.getBaseBlockPos(pos, (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_(ORIENTATION)));
            BlockState stargateState = level.m_8055_(baseBlockPos);
            Block block = stargateState.m_60734_();
            if (block instanceof AbstractStargateBaseBlock && (stargate = (stargateBlock = (AbstractStargateBaseBlock)block).getStargate((BlockGetter)level, baseBlockPos, stargateState)) != null && stargate instanceof IrisStargateEntity) {
                IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
                if (shieldingPart.shieldingState().isBefore(irisStargate.irisInfo().getIrisProgress())) {
                    AbstractShieldingBlock.destroyShielding(level, baseBlockPos, this.getShieldingParts(), (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_(ORIENTATION)));
                    stargateBlock.unsetIris(stargateState, level, baseBlockPos);
                }
            }
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public abstract ArrayList<ShieldingPart> getShieldingParts();

    public static void destroyShielding(Level level, BlockPos baseBlockPos, ArrayList<ShieldingPart> parts, Direction direction, Orientation orientation) {
        if (direction == null) {
            StargateJourney.LOGGER.error("Failed to destroy Shielding because direction is null");
            return;
        }
        if (orientation == null) {
            StargateJourney.LOGGER.error("Failed to destroy Shielding because orientation is null");
            return;
        }
        for (ShieldingPart part : parts) {
            BlockPos ringPos = part.getShieldingPos(baseBlockPos, direction, orientation);
            BlockState state = level.m_8055_(ringPos);
            if (!(state.m_60734_() instanceof AbstractShieldingBlock)) continue;
            boolean waterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
            level.m_7731_(ringPos, waterlogged ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static void setIrisState(AbstractShieldingBlock irisBlock, Level level, BlockPos baseBlockPos, ArrayList<ShieldingPart> parts, Direction direction, Orientation orientation, ShieldingState shieldingState) {
        if (direction == null) {
            StargateJourney.LOGGER.error("Failed to place Shielding because direction is null");
            return;
        }
        if (orientation == null) {
            StargateJourney.LOGGER.error("Failed to place Shielding because orientation is null");
            return;
        }
        for (ShieldingPart part : parts) {
            BlockPos shieldingPos = part.getShieldingPos(baseBlockPos, direction, orientation);
            BlockState state = level.m_8055_(shieldingPos);
            if (state.m_60734_() instanceof AbstractShieldingBlock && !part.canExist(shieldingState)) {
                boolean waterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
                level.m_7731_(shieldingPos, waterlogged ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (!part.canExist(shieldingState)) continue;
            float destroySpeed = state.m_60800_((BlockGetter)level, shieldingPos);
            if (state.m_60734_() instanceof AbstractShieldingBlock || state.m_60713_(Blocks.f_50016_) || state.m_60713_(Blocks.f_49990_)) {
                level.m_7731_(part.getShieldingPos(baseBlockPos, direction, orientation), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)irisBlock.m_49966_().m_61124_(SHIELDING_STATE, (Comparable)((Object)shieldingState))).m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_(ORIENTATION, (Comparable)((Object)orientation))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(part.getShieldingPos(baseBlockPos, direction, orientation)).m_76152_() == Fluids.f_76193_)), 3);
                continue;
            }
            if (!(destroySpeed > 0.0f) || !((double)destroySpeed < (Double)CommonIrisConfig.iris_breaking_strength.get()) || state.m_204336_(TagInit.Blocks.IRIS_RESISTANT)) continue;
            level.m_5898_((Player)null, 2001, shieldingPos, AbstractShieldingBlock.m_49956_((BlockState)state));
            level.m_7731_(part.getShieldingPos(baseBlockPos, direction, orientation), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)irisBlock.m_49966_().m_61124_(SHIELDING_STATE, (Comparable)((Object)shieldingState))).m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_(ORIENTATION, (Comparable)((Object)orientation))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(part.getShieldingPos(baseBlockPos, direction, orientation)).m_76152_() == Fluids.f_76193_)), 3);
        }
    }
}

