/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.armor;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.tech.AncientTech;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersonalShieldItem
extends ArmorItem
implements AncientTech {
    public static final String ENERGY = "Energy";
    protected static final int MAX_ENERGY = 100000;

    public PersonalShieldItem(ArmorMaterial material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public static int getMaxCapacity() {
        return (Integer)CommonTechConfig.personal_shield_capacity.get();
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)PersonalShieldItem.getFluidAmount(stack) / (float)PersonalShieldItem.getMaxCapacity());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)PersonalShieldItem.getFluidAmount(stack) / (float)PersonalShieldItem.getMaxCapacity());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new FluidHandlerItemStack(stack, PersonalShieldItem.getMaxCapacity()){

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return stack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
            }
        };
    }

    public static int getFluidAmount(ItemStack stack) {
        FluidStack fluidStack = PersonalShieldItem.getFluidStack(stack);
        return fluidStack.getAmount();
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        Optional fluid = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> fluidHandler.getFluidInTank(0));
        return fluid.isPresent() ? (FluidStack)fluid.get() : FluidStack.EMPTY;
    }

    public static void drainNaquadah(ItemStack stack, int amount) {
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        FluidStack fluidStack = PersonalShieldItem.getFluidStack(stack);
        if (!PersonalShieldItem.getFluidStack(stack).equals((Object)FluidStack.EMPTY)) {
            MutableComponent liquidNaquadah = Component.m_237115_((String)fluidStack.getTranslationKey()).m_130940_(ChatFormatting.GREEN);
            liquidNaquadah.m_7220_((Component)Component.m_237113_((String)(" " + fluidStack.getAmount() + "mB")).m_130940_(ChatFormatting.GREEN));
            tooltipComponents.add((Component)liquidNaquadah);
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static ItemStack personalShieldSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.PERSONAL_SHIELD_EMITTER.get());
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(((FlowingFluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()).m_5613_(), PersonalShieldItem.getMaxCapacity()), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }
}

