/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.povstalec.sgjourney.common.advancements.WormholeTravelCriterion;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.init.DamageSourceInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;
import org.jetbrains.annotations.Nullable;

public class Wormhole {
    public static final String EVENT_DECONSTRUCTING_ENTITY = "stargate_deconstructing_entity";
    public static final String EVENT_RECONSTRUCTING_ENTITY = "stargate_reconstructing_entity";
    public static final String EVENT_IRIS_THUD = "iris_thud";
    public static final double INNER_RADIUS = 2.5;
    public static final double INNER_RADIUS_SQR = 6.25;
    protected Map<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();

    protected boolean shouldWormhole(Vec3 center, Entity traveler, double oldTravelerX, double travelerX, double momentumX) {
        if (traveler.m_20159_()) {
            return false;
        }
        Vec3 travelerPos = traveler.m_20191_().m_82399_();
        if (center.m_82557_(travelerPos) > 6.25) {
            return false;
        }
        return oldTravelerX > 0.0 && travelerX < 0.0 && momentumX < 0.0;
    }

    protected boolean wormholeEntity(MinecraftServer server, StargateConnection connection, Stargate initialStargate, Stargate destinationStargate, StargateInfo.WormholeTravel twoWayWormhole, Map<Integer, Vec3> entityLocations, Entity traveler) {
        Vec3 relativePosition = initialStargate.toStargateCoords(server, traveler.m_20182_().m_82546_(initialStargate.getPosition(server)), true);
        Vec3 oldRelativePos = this.entityLocations.get(traveler.m_19879_());
        if (oldRelativePos != null) {
            Vec3 relativeMomentum = relativePosition.m_82546_(oldRelativePos);
            if (this.shouldWormhole(initialStargate.getPosition(server), traveler, oldRelativePos.m_7096_(), relativePosition.m_7096_(), relativeMomentum.m_7096_())) {
                Player player;
                Wormhole.playWormholeSound(traveler.m_9236_(), traveler);
                if (twoWayWormhole == StargateInfo.WormholeTravel.ENABLED || twoWayWormhole == StargateInfo.WormholeTravel.CREATIVE_ONLY && traveler instanceof Player && ((player = (Player)traveler).m_7500_() || player.m_5833_())) {
                    Vec3 relativeLookAngle = initialStargate.toStargateCoords(server, traveler.m_20154_(), false);
                    if (!SGJourneyEvents.onWormholeTravel(server, initialStargate, destinationStargate, traveler, twoWayWormhole) && destinationStargate.receiveTraveler(server, connection, initialStargate, traveler, relativePosition, relativeMomentum, relativeLookAngle)) {
                        this.deconstructEvent(server, initialStargate, traveler, false);
                        return true;
                    }
                } else {
                    this.handleReverseWormhole(server, initialStargate, traveler);
                }
            }
        }
        entityLocations.put(traveler.m_19879_(), relativePosition);
        return false;
    }

    public boolean wormholeEntities(MinecraftServer server, StargateConnection connection, Stargate initialStargate, Stargate destinationStargate, StargateInfo.WormholeTravel twoWayWormhole, List<Entity> wormholeCandidates) {
        boolean used = false;
        HashMap<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();
        for (Entity traveler : wormholeCandidates) {
            if (!this.wormholeEntity(server, connection, initialStargate, destinationStargate, twoWayWormhole, entityLocations, traveler)) continue;
            used = true;
        }
        this.entityLocations = entityLocations;
        return used;
    }

    public void handleReverseWormhole(MinecraftServer server, Stargate initialStargate, Entity traveler) {
        Wormhole.recursiveExecute(traveler, entity -> {
            if (((Boolean)CommonStargateConfig.reverse_wormhole_kills.get()).booleanValue()) {
                if (entity.m_6084_()) {
                    ServerPlayer player;
                    if (entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).m_7500_() || player.m_5833_())) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.one_way_wormhole").m_130940_(ChatFormatting.DARK_RED), true);
                    } else if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer player2 = (ServerPlayer)entity;
                            player2.m_36220_((ResourceLocation)StatisticsInit.TIMES_KILLED_BY_WORMHOLE.get());
                        }
                        livingEntity.m_6469_(DamageSourceInit.damageSource(server, DamageSourceInit.REVERSE_WORMHOLE), Float.POSITIVE_INFINITY);
                    } else {
                        entity.m_6074_();
                    }
                }
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.one_way_wormhole").m_130940_(ChatFormatting.DARK_RED), true);
            }
            this.deconstructEvent(server, initialStargate, entity, true);
        });
    }

    protected Entity transportEntity(ServerLevel destinationLevel, Stargate destinationStargate, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        if (traveler.m_9236_() != destinationLevel) {
            traveler = traveler.changeDimension(destinationLevel, (ITeleporter)new WormholeTeleporter(destinationPosition, destinationMomentum, CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.m_146909_()));
        } else {
            traveler.m_7678_(destinationPosition.m_7096_(), destinationPosition.m_7098_(), destinationPosition.m_7094_(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.m_146909_());
            traveler.m_20256_(destinationMomentum);
        }
        if (traveler != null) {
            this.reconstructEvent(destinationLevel.m_7654_(), destinationStargate, traveler);
        }
        return traveler;
    }

    protected Entity transportPlayer(ServerLevel destinationLevel, Stargate destinationStargate, ServerPlayer player, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        ServerLevel initialLevel = player.m_9236_();
        Vec3 initialPos = player.m_20182_();
        player.m_8999_(destinationLevel, destinationPosition.m_7096_(), destinationPosition.m_7098_(), destinationPosition.m_7094_(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), player.m_146909_());
        player.m_20256_(destinationMomentum);
        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
        this.reconstructEvent(destinationLevel.m_7654_(), destinationStargate, (Entity)player);
        ResourceLocation initialDimension = initialLevel.m_46472_().m_135782_();
        ResourceLocation targetDimension = destinationLevel.m_46472_().m_135782_();
        long distanceTraveled = Math.round(DimensionType.m_63908_((DimensionType)initialLevel.m_6042_(), (DimensionType)destinationLevel.m_6042_()) * Math.sqrt(initialPos.m_82554_(player.m_20182_())));
        player.m_36220_((ResourceLocation)StatisticsInit.TIMES_USED_WORMHOLE.get());
        player.m_36222_((ResourceLocation)StatisticsInit.DISTANCE_TRAVELED_BY_STARGATE.get(), (int)distanceTraveled * 100);
        WormholeTravelCriterion.INSTANCE.trigger(player, initialDimension, targetDimension, distanceTraveled);
        return player;
    }

    protected Entity recursivePassengerTeleport(ServerLevel destinationLevel, Stargate destinationStargate, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Level initialLevel = traveler.m_9236_();
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        if (initialLevel != destinationLevel) {
            for (Entity passenger : traveler.m_20197_()) {
                passengers.add(this.recursivePassengerTeleport(destinationLevel, destinationStargate, passenger, destinationPosition, destinationMomentum, destinationLookAngle));
            }
        }
        if (traveler instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)traveler;
            traveler = this.transportPlayer(destinationLevel, destinationStargate, player, destinationPosition, destinationMomentum, destinationLookAngle);
        } else {
            traveler = this.transportEntity(destinationLevel, destinationStargate, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        }
        if (initialLevel != destinationLevel) {
            for (Entity passenger : passengers) {
                passenger.m_7998_(traveler, true);
            }
        }
        return traveler;
    }

    public boolean receiveTraveler(ServerLevel destinationLevel, Stargate destinationStargate, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        traveler = this.recursivePassengerTeleport(destinationLevel, destinationStargate, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        Wormhole.playWormholeSound((Level)destinationLevel, traveler);
        return true;
    }

    public boolean checkShielding(IrisStargateEntity targetStargate, Vec3 destinationPos, Vec3 motionVec, Entity traveler) {
        if (targetStargate.irisInfo().isIrisClosed()) {
            return false;
        }
        EntityDimensions dimension = traveler.m_6972_(traveler.m_20089_());
        Vec3 travelerCenter = dimension.m_20393_(destinationPos).m_82399_();
        Vec3 fromVec = travelerCenter.m_82546_(motionVec);
        Vec3 toVec = travelerCenter.m_82549_(motionVec);
        Level targetLevel = targetStargate.m_58904_();
        BlockPos pos = targetStargate.m_58899_();
        BlockState state = targetLevel.m_8055_(targetStargate.m_58899_());
        Block block = state.m_60734_();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            for (ShieldingPart part : stargateBlock.getShieldingParts()) {
                BlockPos shieldingPos = part.getShieldingPos(pos, (Direction)state.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)state.m_61143_(AbstractStargateBlock.ORIENTATION)));
                BlockState shieldingState = targetLevel.m_8055_(shieldingPos);
                if (!(shieldingState.m_60734_() instanceof AbstractShieldingBlock) || shieldingState.m_60812_((BlockGetter)targetLevel, shieldingPos).m_83220_(fromVec, toVec, shieldingPos) == null) continue;
                return false;
            }
        }
        return true;
    }

    public void handleShielding(MinecraftServer server, IrisStargateEntity irisStargate, Entity traveler) {
        Wormhole.recursiveExecute(traveler, entity -> {
            ServerPlayer player;
            if (entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).m_7500_() || player.m_5833_())) {
                if (!((Boolean)CommonIrisConfig.creative_ignores_iris.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.iris").m_130940_(ChatFormatting.DARK_RED), true);
                }
            } else {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player2 = (ServerPlayer)entity;
                        player2.m_36220_((ResourceLocation)StatisticsInit.TIMES_SMASHED_AGAINST_IRIS.get());
                    }
                    livingEntity.m_6469_(DamageSourceInit.damageSource(server, DamageSourceInit.IRIS), Float.POSITIVE_INFINITY);
                } else {
                    entity.m_6074_();
                }
                this.irisThudEvent(irisStargate, entity);
                irisStargate.irisInfo().decreaseIrisDurability();
            }
        });
        irisStargate.irisInfo().playIrisThudSound();
    }

    protected void irisThudEvent(AbstractStargateEntity targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        targetStargate.updateInterfaceBlocks(EVENT_IRIS_THUD, travelerType, displayName, uuid);
    }

    protected void deconstructEvent(MinecraftServer server, Stargate initialStargate, Entity traveler, boolean disintegrated) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        initialStargate.updateInterfaceBlocks(server, null, EVENT_DECONSTRUCTING_ENTITY, travelerType, displayName, uuid, disintegrated);
    }

    protected void reconstructEvent(MinecraftServer server, Stargate targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        targetStargate.updateInterfaceBlocks(server, null, EVENT_RECONSTRUCTING_ENTITY, travelerType, displayName, uuid);
    }

    public static void recursiveExecute(Entity traveler, WormholeFunction func) {
        for (Entity passenger : traveler.m_20197_()) {
            Wormhole.recursiveExecute(passenger, func);
        }
        func.run(traveler);
    }

    public static void playWormholeSound(Level level, Entity traveler) {
        level.m_5594_(null, traveler.m_20183_(), (SoundEvent)SoundInit.WORMHOLE_ENTER.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public static interface WormholeFunction {
        public void run(Entity var1);
    }

    public static class WormholeTeleporter
    implements ITeleporter {
        private Vec3 pos;
        private Vec3 momentum;
        private float newYRot;
        private float newXRot;

        public WormholeTeleporter(Vec3 pos, Vec3 momentum, float newYRot, float newXRot) {
            this.pos = pos;
            this.momentum = momentum;
            this.newYRot = newYRot;
            this.newXRot = newXRot;
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(this.pos, this.momentum, this.newYRot, this.newXRot);
        }

        public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
            return false;
        }
    }
}

