/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.level;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class SGJourneySkyRenderer {
    protected static final ResourceLocation MOON_HALO_LOCATION = new ResourceLocation("sgjourney", "textures/environment/blue_halo.png");
    protected static final ResourceLocation MOON_LOCATION = new ResourceLocation("sgjourney", "textures/environment/moon_phases.png");
    protected static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    protected static final ResourceLocation BLACK_HOLE_HALO_LOCATION = new ResourceLocation("sgjourney", "textures/environment/black_hole_halo.png");
    protected static final ResourceLocation BLACK_HOLE_LOCATION = new ResourceLocation("sgjourney", "textures/environment/black_hole.png");
    protected static final ResourceLocation GALAXY_LOCATION = new ResourceLocation("sgjourney", "textures/environment/galaxy.png");
    protected Minecraft minecraft = Minecraft.m_91087_();
    @Nullable
    protected VertexBuffer starBuffer;
    @Nullable
    protected VertexBuffer skyBuffer;
    @Nullable
    protected VertexBuffer darkBuffer;

    public SGJourneySkyRenderer(long seed, int numberOfStars) {
        this.createStars(seed, numberOfStars);
        this.createLightSky();
        this.createDarkSky();
    }

    protected boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.m_21023_(MobEffects.f_19610_) || livingentity.m_21023_(MobEffects.f_216964_);
    }

    protected boolean isFoggy(Camera camera) {
        boolean isFoggy;
        Vec3 cameraPos = camera.m_90583_();
        boolean bl = isFoggy = this.minecraft.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)cameraPos.m_7096_()), Mth.m_14107_((double)cameraPos.m_7098_())) || this.minecraft.f_91065_.m_93090_().m_93715_();
        if (isFoggy) {
            return true;
        }
        FogType fogtype = camera.m_167685_();
        return fogtype == FogType.POWDER_SNOW || fogtype == FogType.LAVA || this.doesMobEffectBlockSky(camera);
    }

    protected void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = SGJourneySkyRenderer.buildSkyDisc(bufferbuilder, -16.0f);
        this.darkBuffer.m_85921_();
        this.darkBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    protected void createLightSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = SGJourneySkyRenderer.buildSkyDisc(bufferbuilder, 16.0f);
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    protected static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float scale) {
        float f = Math.signum(scale) * 512.0f;
        float f1 = 512.0f;
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        builder.m_5483_(0.0, (double)scale, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            builder.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)scale, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return builder.m_231175_();
    }

    protected void createStars(long seed, int numberOfStars) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.drawStars(bufferbuilder, seed, numberOfStars);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    protected BufferBuilder.RenderedBuffer drawStars(BufferBuilder builder, long seed, int numberOfStars) {
        RandomSource randomsource = RandomSource.m_216335_((long)seed);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < numberOfStars; ++i) {
            double x = randomsource.m_188501_() * 2.0f - 1.0f;
            double y = randomsource.m_188501_() * 2.0f - 1.0f;
            double z = randomsource.m_188501_() * 2.0f - 1.0f;
            double starSize = 0.15f + randomsource.m_188501_() * 0.1f;
            double distance = x * x + y * y + z * z;
            if (!(distance < 1.0) || !(distance > 0.01)) continue;
            distance = 1.0 / Math.sqrt(distance);
            double starX = (x *= distance) * 100.0;
            double starY = (y *= distance) * 100.0;
            double starZ = (z *= distance) * 100.0;
            double sphericalTheta = Math.atan2(x, z);
            double sinTheta = Math.sin(sphericalTheta);
            double cosTheta = Math.cos(sphericalTheta);
            double xzLength = Math.sqrt(x * x + z * z);
            double sphericalPhi = Math.atan2(xzLength, y);
            double sinPhi = Math.sin(sphericalPhi);
            double cosPhi = Math.cos(sphericalPhi);
            double random = randomsource.m_188500_() * Math.PI * 2.0;
            double sinRandom = Math.sin(random);
            double cosRandom = Math.cos(random);
            for (int j = 0; j < 4; ++j) {
                double aLocation = (double)((j & 2) - 1) * starSize;
                double bLocation = (double)((j + 1 & 2) - 1) * starSize;
                double height = aLocation * cosRandom - bLocation * sinRandom;
                double width = bLocation * cosRandom + aLocation * sinRandom;
                double heightProjectionY = height * sinPhi;
                double heightProjectionXZ = -height * cosPhi;
                double projectedX = heightProjectionXZ * sinTheta - width * cosTheta;
                double projectedZ = width * sinTheta + heightProjectionXZ * cosTheta;
                builder.m_5483_(starX + projectedX, starY + heightProjectionY, starZ + projectedZ).m_6122_(190, 160, 0, 170).m_5752_();
            }
        }
        return builder.m_231175_();
    }

    protected void renderStars(ClientLevel level, float partialTicks, float rain, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog) {
        float realBrightness = level.m_104811_(partialTicks) * rain;
        if (realBrightness > 0.0f) {
            RenderSystem.m_157429_((float)realBrightness, (float)realBrightness, (float)realBrightness, (float)realBrightness);
            FogRenderer.m_109017_();
            this.starBuffer.m_85921_();
            this.starBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            setupFog.run();
        }
    }

    public static float[] moveSpherical(float offsetX, float offsetY, float r, double theta, double phi) {
        double x = (double)r * Math.sin(phi) * Math.sin(theta);
        double y = (double)r * Math.cos(phi);
        double z = (double)r * Math.sin(phi) * Math.cos(theta);
        return new float[]{(float)(x += (double)(-offsetY) * Math.cos(phi) * Math.sin(theta) - (double)offsetX * Math.cos(theta)), (float)(y += (double)offsetY * Math.sin(phi)), (float)(z += (double)(-offsetY) * Math.cos(phi) * Math.cos(theta) + (double)offsetX * Math.sin(theta))};
    }

    public void createCelestialObject(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation location, float size, float distance, float[] uv) {
        this.createCelestialObject(bufferbuilder, lastMatrix, location, size, distance, 0.0f, 0.0f, uv);
    }

    public void createCelestialObject(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation location, float size, float distance, float theta, float phi, float[] uv) {
        float[] u0v0 = SGJourneySkyRenderer.moveSpherical(-size, -size, distance, theta, phi);
        float[] u1v0 = SGJourneySkyRenderer.moveSpherical(size, -size, distance, theta, phi);
        float[] u1v1 = SGJourneySkyRenderer.moveSpherical(size, size, distance, theta, phi);
        float[] u0v1 = SGJourneySkyRenderer.moveSpherical(-size, size, distance, theta, phi);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(lastMatrix, u0v0[0], u0v0[1], u0v0[2]).m_7421_(uv[0], uv[1]).m_5752_();
        bufferbuilder.m_252986_(lastMatrix, u1v0[0], u1v0[1], u1v0[2]).m_7421_(uv[2], uv[1]).m_5752_();
        bufferbuilder.m_252986_(lastMatrix, u1v1[0], u1v1[1], u1v1[2]).m_7421_(uv[2], uv[3]).m_5752_();
        bufferbuilder.m_252986_(lastMatrix, u0v1[0], u0v1[1], u0v1[2]).m_7421_(uv[0], uv[3]).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    protected void renderSun(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation texture, float size) {
        this.createCelestialObject(bufferbuilder, lastMatrix, texture, size, 100.0f, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.m_69478_();
    }

    protected void renderSun(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation texture, float size, float theta, float phi) {
        this.createCelestialObject(bufferbuilder, lastMatrix, texture, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.m_69478_();
    }

    protected void renderBlackHole(BufferBuilder bufferbuilder, Matrix4f lastMatrix, float size, float theta, float phi) {
        this.createCelestialObject(bufferbuilder, lastMatrix, BLACK_HOLE_HALO_LOCATION, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.m_69461_();
        this.createCelestialObject(bufferbuilder, lastMatrix, BLACK_HOLE_LOCATION, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.m_69478_();
    }

    protected void renderMoon(BufferBuilder bufferbuilder, Matrix4f lastMatrix, float size, int phase, float theta, float phi) {
        int x = phase % 4;
        int y = phase / 4 % 2;
        float xStart = (float)(x + 0) / 4.0f;
        float yStart = (float)(y + 0) / 2.0f;
        float xEnd = (float)(x + 1) / 4.0f;
        float yEnd = (float)(y + 1) / 2.0f;
        this.createCelestialObject(bufferbuilder, lastMatrix, MOON_HALO_LOCATION, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.m_69461_();
        this.createCelestialObject(bufferbuilder, lastMatrix, MOON_LOCATION, size / 4.0f, 100.0f, theta, phi, new float[]{xStart, yStart, xEnd, yEnd});
        RenderSystem.m_69478_();
    }

    protected void renderSunrise(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder) {
        float[] sunriseColor = level.m_104583_().m_7518_(level.m_46942_(partialTicks), partialTicks);
        if (sunriseColor != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.m_85836_();
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float sunAngle = Mth.m_14031_((float)level.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            stack.m_252781_(Axis.f_252403_.m_252977_(sunAngle));
            stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float sunriseR = sunriseColor[0];
            float sunriseG = sunriseColor[1];
            float sunriseB = sunriseColor[2];
            float sunriseA = sunriseColor[2];
            Matrix4f sunriseMatrix = stack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(sunriseMatrix, 0.0f, 100.0f, 0.0f).m_85950_(sunriseR, sunriseG, sunriseB, sunriseA).m_5752_();
            for (int i = 0; i <= 16; ++i) {
                float rotation = (float)i * ((float)Math.PI * 2) / 16.0f;
                float x = Mth.m_14031_((float)rotation);
                float y = Mth.m_14089_((float)rotation);
                bufferbuilder.m_252986_(sunriseMatrix, x * 120.0f, y * 120.0f, -y * 40.0f * sunriseA).m_85950_(sunriseR, sunriseG, sunriseB, 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            stack.m_85849_();
        }
    }

    protected abstract void renderCelestials(ClientLevel var1, float var2, PoseStack var3, Matrix4f var4, Runnable var5, BufferBuilder var6, float var7);

    protected void renderEcliptic(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
        stack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)rain);
        stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        stack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTicks) * 360.0f));
        this.renderStars(level, partialTicks, rain, stack, projectionMatrix, setupFog);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f lastMatrix = stack.m_85850_().m_252922_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        this.renderCelestials(level, partialTicks, stack, lastMatrix, setupFog, bufferbuilder, rain);
        stack.m_85849_();
    }

    public void renderSky(ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        setupFog.run();
        if (this.isFoggy(camera)) {
            return;
        }
        RenderSystem.m_69472_();
        Vec3 skyColor = level.m_171660_(this.minecraft.f_91063_.m_109153_().m_90583_(), partialTicks);
        float skyX = (float)skyColor.f_82479_;
        float skyY = (float)skyColor.f_82480_;
        float skyZ = (float)skyColor.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        this.renderSunrise(level, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float rain = 1.0f - level.m_46722_(partialTicks);
        this.renderEcliptic(level, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder, rain);
        RenderSystem.m_69472_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double height = this.minecraft.f_91074_.m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (height < 0.0) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 12.0f, 0.0f);
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            stack.m_85849_();
        }
        if (level.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(skyX * 0.2f + 0.04f), (float)(skyY * 0.2f + 0.04f), (float)(skyZ * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
    }
}

