/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.resourcepack.stargate_variant;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.resourcepack.ResourcepackModel;
import net.povstalec.sgjourney.client.resourcepack.ResourcepackSounds;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.misc.ColorUtil;

public abstract class ClientStargateVariant {
    public static final String TEXTURE = "texture";
    public static final String ENCODED_TEXTURE = "encoded_texture";
    public static final String ENGAGED_TEXTURE = "engaged_texture";
    public static final String WORMHOLE = "wormhole";
    public static final String SHINY_WORMHOLE = "shiny_wormhole";
    public static final String SYMBOLS = "symbols";
    public static final String CHEVRON_ENGAGED_SOUNDS = "chevron_engaged_sounds";
    public static final String CHEVRON_INCOMING_SOUNDS = "chevron_incoming_sounds";
    public static final String WORMHOLE_SOUNDS = "wormhole_sounds";
    public static final String FAIL_SOUNDS = "fail_sounds";
    public static final ColorUtil.RGBA DEFAULT_OPAQUE_RGBA = new ColorUtil.RGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorUtil.RGBA DEFAULT_TRANSLUCENT_RGBA = new ColorUtil.RGBA(1.0f, 1.0f, 1.0f, 0.75f);
    protected final ResourceLocation texture;
    protected final ResourceLocation encodedTexture;
    protected final ResourceLocation engagedTexture;
    protected ResourcepackModel.Wormhole wormhole;
    @Nullable
    protected ResourcepackModel.Wormhole shinyWormhole;
    protected ResourcepackModel.SymbolsModel symbols;
    protected ResourcepackSounds.Chevron chevronEngagedSounds;
    protected ResourcepackSounds.Chevron chevronIncomingSounds;
    protected ResourcepackSounds.Wormhole wormholeSounds;
    protected ResourcepackSounds.Fail failSounds;

    public ClientStargateVariant(ResourceLocation texture, Optional<ResourceLocation> encodedTexture, ResourceLocation engagedTexture, ResourcepackModel.Wormhole wormhole, Optional<ResourcepackModel.Wormhole> shinyWormhole, ResourcepackModel.SymbolsModel symbols, ResourcepackSounds.Chevron chevronEngagedSounds, ResourcepackSounds.Chevron chevronIncomingSounds, ResourcepackSounds.Wormhole wormholeSounds, ResourcepackSounds.Fail failSounds) {
        this.texture = texture;
        this.encodedTexture = encodedTexture.isPresent() ? encodedTexture.get() : engagedTexture;
        this.engagedTexture = engagedTexture;
        this.wormhole = wormhole;
        if (shinyWormhole.isPresent()) {
            this.shinyWormhole = shinyWormhole.get();
        }
        this.symbols = symbols;
        this.chevronEngagedSounds = chevronEngagedSounds;
        this.chevronIncomingSounds = chevronIncomingSounds;
        this.wormholeSounds = wormholeSounds;
        this.failSounds = failSounds;
    }

    public ResourceLocation texture() {
        return this.texture;
    }

    public ResourceLocation encodedTexture() {
        return this.encodedTexture;
    }

    public ResourceLocation engagedTexture() {
        return this.engagedTexture;
    }

    public ResourcepackModel.Wormhole wormhole() {
        return this.wormhole;
    }

    public Optional<ResourcepackModel.Wormhole> shinyWormhole() {
        return Optional.ofNullable(this.shinyWormhole);
    }

    public ResourcepackModel.Wormhole getWormhole() {
        if (ClientStargateConfig.shiny_event_horizons.get() && this.shinyWormhole != null) {
            return this.shinyWormhole;
        }
        return this.wormhole;
    }

    public ResourcepackModel.SymbolsModel symbols() {
        return this.symbols;
    }

    public ResourcepackSounds.Chevron chevronEngagedSounds() {
        return this.chevronEngagedSounds;
    }

    public ResourcepackSounds.Chevron chevronIncomingSounds() {
        return this.chevronIncomingSounds;
    }

    public ResourcepackSounds.Wormhole wormholeSounds() {
        return this.wormholeSounds;
    }

    public ResourcepackSounds.Fail failSounds() {
        return this.failSounds;
    }
}

