/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnityClusterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public UnityClusterBlock(int height, int widthInverse, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.upAabb = Block.m_49796_((double)widthInverse, (double)0.0, (double)widthInverse, (double)(16 - widthInverse), (double)height, (double)(16 - widthInverse));
        this.downAabb = Block.m_49796_((double)widthInverse, (double)(16 - height), (double)widthInverse, (double)(16 - widthInverse), (double)16.0, (double)(16 - widthInverse));
        this.northAabb = Block.m_49796_((double)widthInverse, (double)widthInverse, (double)(16 - height), (double)(16 - widthInverse), (double)(16 - widthInverse), (double)16.0);
        this.southAabb = Block.m_49796_((double)widthInverse, (double)widthInverse, (double)0.0, (double)(16 - widthInverse), (double)(16 - widthInverse), (double)height);
        this.eastAabb = Block.m_49796_((double)0.0, (double)widthInverse, (double)widthInverse, (double)height, (double)(16 - widthInverse), (double)(16 - widthInverse));
        this.westAabb = Block.m_49796_((double)(16 - height), (double)widthInverse, (double)widthInverse, (double)16.0, (double)(16 - widthInverse), (double)(16 - widthInverse));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        switch (direction) {
            case NORTH: {
                return this.northAabb;
            }
            case SOUTH: {
                return this.southAabb;
            }
            case EAST: {
                return this.eastAabb;
            }
            case WEST: {
                return this.westAabb;
            }
            case DOWN: {
                return this.downAabb;
            }
        }
        return this.upAabb;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos oppositePos = pos.m_121945_(direction.m_122424_());
        return reader.m_8055_(oppositePos).m_60783_((BlockGetter)reader, oppositePos, direction);
    }

    public BlockState m_7417_(BlockState oldState, Direction direction, BlockState newState, LevelAccessor level, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)oldState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(oldPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction == ((Direction)oldState.m_61143_((Property)FACING)).m_122424_() && !oldState.m_60710_((LevelReader)level, oldPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(oldState, direction, newState, level, oldPos, newPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }
}

