/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.sgjourney.common.capabilities.GoauldHostProvider;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.entities.goals.NearestHostGoal;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.GoauldItem;

public class Goauld
extends AgeableMob {
    public static final float MAX_HEALTH = 6.0f;

    public Goauld(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new NearestHostGoal<Human>((Mob)this, Human.class));
        this.f_21346_.m_25352_(4, new NearestHostGoal<Player>((Mob)this, Player.class));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 1.0);
    }

    public boolean m_7327_(Entity entity) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        boolean damaged = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
        if (damaged && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (entity.getClass() == Human.class) {
                mob.getCapability(GoauldHostProvider.GOAULD_HOST).ifPresent(cap -> cap.takeOverHost(this, mob));
            }
        }
        return damaged;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12419_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12421_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12422_, 0.15f, 1.0f);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = this.saveToItem();
        player.m_21008_(InteractionHand.MAIN_HAND, stack);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    public Info goauldInfo() {
        return new Info(this.m_7770_(), this.m_21223_(), this.m_146764_());
    }

    public void setFromInfo(Info goauldInfo) {
        this.m_6593_(goauldInfo.name());
        this.m_21153_(goauldInfo.health());
        this.m_146762_(goauldInfo.age());
    }

    public ItemStack saveToItem() {
        return this.goauldInfo().toItemStack();
    }

    public void loadFromItem(ItemStack stack) {
        this.setFromInfo(Info.fromItemStack(stack));
    }

    public static class Info
    implements INBTSerializable<CompoundTag> {
        public static final String GOAULD_INFO = "goauld_info";
        public static final String NAME = "name";
        public static final String HEALTH = "health";
        public static final String AGE = "age";
        @Nullable
        private Component name = null;
        private float health;
        private int age;

        public Info(@Nullable Component name, float health, int age) {
            this.name = name;
            this.health = health;
            this.age = age;
        }

        public Info() {
            this(null, 6.0f, 0);
        }

        @Nullable
        public Component name() {
            return this.name;
        }

        public float health() {
            return this.health;
        }

        public int age() {
            return this.age;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.name != null) {
                tag.m_128359_(NAME, Component.Serializer.m_130703_((Component)this.name));
            }
            tag.m_128350_(HEALTH, this.health);
            tag.m_128405_(AGE, this.age);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_(NAME, 8)) {
                this.name = Component.Serializer.m_130701_((String)tag.m_128461_(NAME));
            }
            this.health = tag.m_128457_(HEALTH);
            this.age = tag.m_128451_(AGE);
        }

        public Info copy() {
            return new Info(this.name, this.health, this.age);
        }

        public static Info fromItemStack(ItemStack stack) {
            Info goauldInfo = new Info();
            if (stack.m_41720_() instanceof GoauldItem && stack.m_41783_() != null && stack.m_41783_().m_128425_(GOAULD_INFO, 10)) {
                goauldInfo.deserializeNBT(stack.m_41783_().m_128469_(GOAULD_INFO));
            }
            if (stack.m_41788_()) {
                goauldInfo.name = stack.m_41786_();
            }
            return goauldInfo;
        }

        public ItemStack toItemStack() {
            ItemStack goauldStack = new ItemStack((ItemLike)ItemInit.GOAULD.get());
            goauldStack.m_41784_().m_128365_(GOAULD_INFO, (Tag)this.serializeNBT());
            if (this.name != null) {
                goauldStack.m_41714_(this.name);
            }
            return goauldStack;
        }
    }
}

