/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities.goals;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public class StaffWeaponAttackGoal<T extends PathfinderMob>
extends MeleeAttackGoal {
    public static final int ATTACK_DELAY = 40;
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    protected final T f_25540_;
    protected final double f_25541_;
    protected final float meleeAttackRadiusSqr;
    protected final float pursueRadiusSqr;
    protected int seeTime;
    protected int attackDelay;
    protected int updatePathDelay;

    public StaffWeaponAttackGoal(T mob, double speedModifier, float meleeRadius, float pursueRadius) {
        super(mob, speedModifier, false);
        this.f_25540_ = mob;
        this.f_25541_ = speedModifier;
        this.meleeAttackRadiusSqr = meleeRadius * meleeRadius;
        this.pursueRadiusSqr = pursueRadius * pursueRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attackDelay = 40;
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingStaffWeapon();
    }

    private boolean isHoldingStaffWeapon() {
        return this.f_25540_.m_21093_(stack -> stack.m_41720_() instanceof StaffWeaponItem);
    }

    private boolean staffWeaponCanFire() {
        return this.f_25540_.m_21093_(stack -> {
            StaffWeaponItem staffWeapon;
            Item patt1768$temp = stack.m_41720_();
            return patt1768$temp instanceof StaffWeaponItem && (staffWeapon = (StaffWeaponItem)patt1768$temp).getFluidAmount((ItemStack)stack) > 0;
        });
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.f_25540_.m_21573_().m_26571_()) && this.isHoldingStaffWeapon();
    }

    private boolean isValidTarget() {
        return this.f_25540_.m_5448_() != null && this.f_25540_.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.f_25540_.m_21561_(false);
        this.f_25540_.m_6710_(null);
        this.seeTime = 0;
        if (this.f_25540_.m_6117_()) {
            this.f_25540_.m_5810_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void meleeTick(LivingEntity target) {
        super.m_8037_();
    }

    public void rangedTick(LivingEntity target, double distanceSqr) {
        boolean shouldMoveToTarget;
        boolean hasSeenTarget;
        boolean hasLineOfSight = this.f_25540_.m_21574_().m_148306_((Entity)target);
        boolean bl = hasSeenTarget = this.seeTime > 0;
        if (hasLineOfSight != hasSeenTarget) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        boolean bl2 = shouldMoveToTarget = distanceSqr > (double)this.pursueRadiusSqr || this.seeTime < 5;
        if (shouldMoveToTarget) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.f_25540_.m_21573_().m_5624_((Entity)target, this.f_25541_);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.f_25540_.m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            this.f_25540_.m_21573_().m_26573_();
        }
        this.f_25540_.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        } else {
            ((RangedAttackMob)this.f_25540_).m_6504_(target, 1.0f);
            this.attackDelay = 40;
        }
    }

    public void m_8037_() {
        LivingEntity target = this.f_25540_.m_5448_();
        if (target == null) {
            return;
        }
        double distanceSqr = this.f_25540_.m_20280_((Entity)target);
        if (distanceSqr > (double)this.meleeAttackRadiusSqr && this.staffWeaponCanFire()) {
            this.rangedTick(target, distanceSqr);
        } else {
            this.meleeTick(target);
        }
    }
}

