/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.capabilities.ItemEnergyProvider;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends Item {
    public static final String ENERGY = "energy";

    public BatteryItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)BatteryItem.getEnergy(stack) / (float)this.getCapacity());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)BatteryItem.getEnergy(stack) / (float)this.getCapacity());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static CompoundTag tagSetup(int energy) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(ENERGY, energy);
        return tag;
    }

    public static long getEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(ENERGY, 4)) {
            return tag.m_128454_(ENERGY);
        }
        return 0L;
    }

    public long getCapacity() {
        return (Long)CommonTechConfig.small_naquadah_battery_capacity.get();
    }

    public long getTransfer() {
        return (Long)CommonTechConfig.small_naquadah_battery_max_transfer.get();
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack){

            @Override
            public long capacity() {
                return BatteryItem.this.getCapacity();
            }

            @Override
            public long maxReceive() {
                return BatteryItem.this.getTransfer();
            }

            @Override
            public long maxExtract() {
                return BatteryItem.this.getTransfer();
            }
        };
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + SGJourneyEnergy.energyToString(BatteryItem.getEnergy(stack), this.getCapacity())))).m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

