/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractNaquadahLiquidizerEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public abstract class LiquidizerMenu
extends InventoryMenu {
    protected final AbstractNaquadahLiquidizerEntity blockEntity;
    protected final Level level;
    protected FluidStack fluidStack1;
    protected FluidStack fluidStack2;
    private static final int TE_INVENTORY_INPUT_BUCKET_SLOT_INDEX = 1;
    private static final int TE_INVENTORY_OUTPUT_BUCKET_SLOT_INDEX = 2;

    public LiquidizerMenu(MenuType<LiquidizerMenu> type, int containerId, Inventory inventory, BlockEntity blockEntity) {
        super(type, containerId);
        LiquidizerMenu.m_38869_((Container)inventory, (int)3);
        this.blockEntity = (AbstractNaquadahLiquidizerEntity)blockEntity;
        this.level = inventory.f_35978_.f_19853_;
        this.fluidStack1 = this.blockEntity.getFluid1();
        this.fluidStack2 = this.blockEntity.getFluid2();
        this.addPlayerInventory(inventory, 8, 84);
        this.addPlayerHotbar(inventory, 8, 142);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 20)));
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.NORTH).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 34, 20)));
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 126, 58)));
    }

    public void setFluid1(FluidStack fluidStack) {
        this.fluidStack1 = fluidStack;
    }

    public void setFluid2(FluidStack fluidStack) {
        this.fluidStack2 = fluidStack;
    }

    public FluidStack getFluid1() {
        return this.blockEntity.getFluid1();
    }

    public FluidStack getFluid2() {
        return this.blockEntity.getFluid2();
    }

    public Fluid getDesiredFluid1() {
        return this.blockEntity.getDesiredFluid1();
    }

    public Fluid getDesiredFluid2() {
        return this.blockEntity.getDesiredFluid2();
    }

    public int getProgress() {
        return this.blockEntity.progress;
    }

    public boolean m_6875_(Player player) {
        return LiquidizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.NAQUADAH_LIQUIDIZER.get())) || LiquidizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.HEAVY_NAQUADAH_LIQUIDIZER.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 3;
    }

    private boolean hasRequiredLiquid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).getFluid().m_6212_(this.blockEntity.getDesiredFluid1());
        }
        return false;
    }

    private boolean canAcceptResultingLiquid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).isEmpty() || fluidHandler.getFluidInTank(0).getFluid().m_6212_(this.blockEntity.getDesiredFluid2());
        }
        return false;
    }

    private static boolean countEquals(ItemStack first, ItemStack second) {
        return first.m_41613_() == second.m_41613_();
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        boolean stopQuickMove = false;
        if (index < 36) {
            stopQuickMove = true;
            if (this.hasRequiredLiquid(sourceStack)) {
                this.m_38903_(sourceStack, 37, 38, false);
            } else if (this.canAcceptResultingLiquid(sourceSlot.m_7993_())) {
                this.m_38903_(sourceStack, 38, 39, false);
            }
            if (LiquidizerMenu.countEquals(sourceStack, copyOfSourceStack) && !this.m_38903_(sourceStack, 36, 36 + this.TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + this.TE_INVENTORY_SLOT_COUNT) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        if (stopQuickMove) {
            return ItemStack.f_41583_;
        }
        return copyOfSourceStack;
    }

    public static class HeavyLiquidNaquadah
    extends LiquidizerMenu {
        public HeavyLiquidNaquadah(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
            this(containerId, inventory, inventory.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
        }

        public HeavyLiquidNaquadah(int containerId, Inventory inventory, BlockEntity blockEntity) {
            super((MenuType<LiquidizerMenu>)((MenuType)MenuInit.HEAVY_NAQUADAH_LIQUIDIZER.get()), containerId, inventory, blockEntity);
        }
    }

    public static class LiquidNaquadah
    extends LiquidizerMenu {
        public LiquidNaquadah(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
            this(containerId, inventory, inventory.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
        }

        public LiquidNaquadah(int containerId, Inventory inventory, BlockEntity blockEntity) {
            super((MenuType<LiquidizerMenu>)((MenuType)MenuInit.NAQUADAH_LIQUIDIZER.get()), containerId, inventory, blockEntity);
        }
    }
}

