/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.povstalec.sgjourney.client.models.block_entity.AbstractStargateModel;
import net.povstalec.sgjourney.client.models.block_entity.GenericChevronModel;
import net.povstalec.sgjourney.client.models.block_entity.MovieChevronModel;
import net.povstalec.sgjourney.client.models.block_entity.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.GenericStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public abstract class GenericStargateModel<StargateEntity extends AbstractStargateEntity, Variant extends GenericStargateVariant>
extends AbstractStargateModel<StargateEntity, Variant> {
    protected static final float STARGATE_RING_THICKNESS = 7.0f;
    protected static final float STARGATE_RING_OFFSET = 0.21875f;
    protected static final float STARGATE_RING_OUTER_RADIUS = 3.499f;
    protected static final float STARGATE_RING_OUTER_LENGTH = SGJourneyModel.getUsedWidth(36, 3.499f, 3.5f);
    protected static final float STARGATE_RING_OUTER_CENTER = STARGATE_RING_OUTER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_STOP_RADIUS = 3.0625f;
    protected static final float STARGATE_RING_STOP_LENGTH = SGJourneyModel.getUsedWidth(36, 3.0625f, 3.5f);
    protected static final float STARGATE_RING_STOP_CENTER = STARGATE_RING_STOP_LENGTH / 2.0f;
    protected static final float STARGATE_RING_START_RADIUS = 2.6875f;
    protected static final float STARGATE_RING_START_LENGTH = SGJourneyModel.getUsedWidth(36, 2.6875f, 3.5f);
    protected static final float STARGATE_RING_START_CENTER = STARGATE_RING_START_LENGTH / 2.0f;
    protected static final float STARGATE_RING_INNER_HEIGHT = 2.501f;
    protected static final float STARGATE_RING_INNER_LENGTH = SGJourneyModel.getUsedWidth(36, 2.501f, 3.5f);
    protected static final float STARGATE_RING_INNER_CENTER = STARGATE_RING_INNER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_HEIGHT = 0.99800014f;
    protected static final float STARGATE_EDGE_TO_CUTOUT_HEIGHT = 0.43650007f;
    protected static final float STARGATE_RING_CUTOUT_HEIGHT = 0.375f;
    protected static final float STARGATE_CUTOUT_TO_INNER_HEIGHT = 0.18650007f;
    protected float symbolAngle;
    protected static final float STARGATE_SYMBOL_RING_OUTER_HEIGHT = 3.125f;
    protected float stargateSymbolRingOuterLength;
    protected float stargateSymbolRingOuterCenter;
    protected static final float STARGATE_SYMBOL_RING_INNER_HEIGHT = 2.625f;
    protected float stargateSymbolRingInnerLength;
    protected float stargateSymbolRingInnerCenter;
    protected static final float STARGATE_SYMBOL_RING_HEIGHT = 0.5f;
    protected static final float DIVIDER_THICKNESS = 0.0625f;
    protected static final float DIVIDER_CENTER = 0.03125f;
    protected static final float DIVIDER_HEIGHT = 0.5f;
    protected static final float DIVIDER_OFFSET = 0.03125f;
    protected static final float DIVIDER_Y_CENTER = 2.875f;
    protected float rotation = 0.0f;

    public GenericStargateModel(short numberOfSymbols) {
        super(numberOfSymbols);
        this.symbolAngle = 360.0f / (float)numberOfSymbols;
        this.stargateSymbolRingOuterLength = SGJourneyModel.getUsedWidth(numberOfSymbols, 3.125f, 3.5f);
        this.stargateSymbolRingOuterCenter = this.stargateSymbolRingOuterLength / 2.0f;
        this.stargateSymbolRingInnerLength = SGJourneyModel.getUsedWidth(numberOfSymbols, 2.625f, 3.5f);
        this.stargateSymbolRingInnerCenter = this.stargateSymbolRingInnerLength / 2.0f;
    }

    @Override
    public void renderRing(StargateEntity stargate, Variant stargateVariant, float partialTick, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderOuterRing(stack, consumer, source, combinedLight);
        this.renderSymbolRing(stargate, stargateVariant, stack, consumer, source, combinedLight, this.rotation);
    }

    protected boolean isPrimaryChevronBackRaised(StargateEntity stargate, Variant stargateVariant) {
        return false;
    }

    protected boolean isChevronBackRaised(StargateEntity stargate, Variant stargateVariant, int chevronNumber) {
        return false;
    }

    @Override
    protected void renderPrimaryChevron(StargateEntity stargate, Variant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean chevronEngaged) {
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        stack.m_85836_();
        stack.m_85837_(0.0, 3.34375, 0.0);
        GenericChevronModel.renderChevronLight(stack, consumer, source, light, this.isPrimaryChevronRaised(stargate, stargateVariant), this.isPrimaryChevronBackRaised(stargate, stargateVariant));
        if (((GenericStargateVariant)stargateVariant).stargateModel().useMovieStargatePrimaryChevron()) {
            MovieChevronModel.renderMovieChevronFront(stack, consumer, source, light);
        } else {
            GenericChevronModel.renderOuterChevronFront(stack, consumer, source, light, this.isPrimaryChevronLowered(stargate, stargateVariant));
        }
        GenericChevronModel.renderOuterChevronBack(stack, consumer, source, light);
        stack.m_85849_();
    }

    @Override
    protected void renderChevron(StargateEntity stargate, Variant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int chevronNumber, boolean chevronEngaged) {
        int chevron = AbstractStargateEntity.getChevron(stargate, chevronNumber);
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122227_.m_122240_(-40.0f * (float)chevron));
        stack.m_85837_(0.0, 3.34375, 0.0);
        GenericChevronModel.renderChevronLight(stack, consumer, source, light, this.isChevronRaised(stargate, stargateVariant, chevronNumber), this.isChevronBackRaised(stargate, stargateVariant, chevronNumber));
        GenericChevronModel.renderOuterChevronFront(stack, consumer, source, light, this.isChevronLowered(stargate, stargateVariant, chevronNumber));
        GenericChevronModel.renderOuterChevronBack(stack, consumer, source, light);
        stack.m_85849_();
    }

    protected void renderOuterRing(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight) {
        for (int j = 0; j < 36; ++j) {
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122227_.m_122240_((float)j * -10.0f));
            Matrix4f matrix4 = stack.m_85850_().m_85861_();
            Matrix3f matrix3 = stack.m_85850_().m_85864_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10949999f, -STARGATE_RING_STOP_CENTER, 3.0625f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_STOP_CENTER * 16.0f) / 64.0f, 0.21862501f, STARGATE_RING_STOP_CENTER, 3.0625f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_STOP_CENTER * 16.0f) / 64.0f, 0.21862501f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10949999f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -STARGATE_RING_START_CENTER, 2.6875f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_START_CENTER * 16.0f) / 64.0f, 0.500125f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.54675f, STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.54675f, STARGATE_RING_START_CENTER, 2.6875f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_START_CENTER * 16.0f) / 64.0f, 0.500125f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.23462498f, STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.48412502f, -STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.48412502f, -STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.23462498f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.109375f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.109375f, STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, STARGATE_RING_STOP_CENTER, 3.0625f, 0.15625f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_STOP_CENTER * 16.0f) / 64.0f, 0.21875f, STARGATE_RING_STOP_CENTER, 3.0625f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_STOP_CENTER * 16.0f) / 64.0f, 0.234375f, -STARGATE_RING_STOP_CENTER, 3.0625f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_STOP_CENTER * 16.0f) / 64.0f, 0.234375f, -STARGATE_RING_STOP_CENTER, 3.0625f, 0.15625f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_STOP_CENTER * 16.0f) / 64.0f, 0.21875f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -STARGATE_RING_START_CENTER, 2.6875f, 0.15625f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_START_CENTER * 16.0f) / 64.0f, 0.484375f, -STARGATE_RING_START_CENTER, 2.6875f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f - STARGATE_RING_START_CENTER * 16.0f) / 64.0f, 0.5f, STARGATE_RING_START_CENTER, 2.6875f, 0.21875f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_START_CENTER * 16.0f) / 64.0f, 0.5f, STARGATE_RING_START_CENTER, 2.6875f, 0.15625f, (10.0f * (float)(j % 4) + 5.0f + STARGATE_RING_START_CENTER * 16.0f) / 64.0f, 0.484375f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (8.0f * (float)(j % 4) + 4.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.546875f, STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (8.0f * (float)(j % 4) + 4.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.65625f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (8.0f * (float)(j % 4) + 4.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.65625f, -STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (8.0f * (float)(j % 4) + 4.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.546875f);
            stack.m_85849_();
        }
    }

    protected void renderSymbolRing(StargateEntity stargate, Variant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        Matrix3f matrix3;
        Matrix4f matrix4;
        int j;
        for (j = 0; j < this.numberOfSymbols; ++j) {
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122227_.m_122240_((float)j * -this.symbolAngle + rotation));
            matrix4 = stack.m_85850_().m_85861_();
            matrix3 = stack.m_85850_().m_85864_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -this.stargateSymbolRingOuterCenter, 3.125f, 0.15625f, (4.0f - this.stargateSymbolRingOuterCenter * 16.0f) / 64.0f, 0.65625f, -this.stargateSymbolRingInnerCenter, 2.625f, 0.15625f, (4.0f - this.stargateSymbolRingInnerCenter * 16.0f) / 64.0f, 0.78125f, this.stargateSymbolRingInnerCenter, 2.625f, 0.15625f, (4.0f + this.stargateSymbolRingInnerCenter * 16.0f) / 64.0f, 0.78125f, this.stargateSymbolRingOuterCenter, 3.125f, 0.15625f, (4.0f + this.stargateSymbolRingOuterCenter * 16.0f) / 64.0f, 0.65625f);
            stack.m_85849_();
        }
        for (j = 0; j < this.numberOfSymbols; ++j) {
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122227_.m_122240_((float)j * -this.symbolAngle - this.symbolAngle / 2.0f + rotation));
            matrix4 = stack.m_85850_().m_85861_();
            matrix3 = stack.m_85850_().m_85864_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.03125f, 3.125f, 0.1875f, 0.140625f, 0.65625f, -0.03125f, 2.625f, 0.1875f, 0.140625f, 0.78125f, 0.03125f, 2.625f, 0.1875f, 0.15625f, 0.78125f, 0.03125f, 3.125f, 0.1875f, 0.15625f, 0.65625f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 0.0f, 0.0f, -0.03125f, 3.125f, 0.15625f, 0.1328125f, 0.65625f, -0.03125f, 2.625f, 0.15625f, 0.1328125f, 0.78125f, -0.03125f, 2.625f, 0.1875f, 0.140625f, 0.78125f, -0.03125f, 3.125f, 0.1875f, 0.140625f, 0.65625f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 0.0f, 0.0f, 0.03125f, 3.125f, 0.1875f, 0.15625f, 0.65625f, 0.03125f, 2.625f, 0.1875f, 0.15625f, 0.78125f, 0.03125f, 2.625f, 0.15625f, 0.1640625f, 0.78125f, 0.03125f, 3.125f, 0.15625f, 0.1640625f, 0.65625f);
            stack.m_85849_();
        }
        this.renderSymbols(stargate, stargateVariant, stack, consumer, source, combinedLight, rotation);
    }

    protected void renderSymbols(StargateEntity stargate, Variant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        Symbols symbols;
        PointOfOrigin pointOfOrigin = this.getPointOfOrigin((AbstractStargateEntity)stargate, stargateVariant);
        if (pointOfOrigin != null) {
            boolean pointOfOriginEngaged = false;
            if (((ClientStargateVariant)stargateVariant).symbols().engageEncodedSymbols() && (!((AbstractStargateEntity)stargate).isConnected() || ((AbstractStargateEntity)stargate).isDialingOut())) {
                pointOfOriginEngaged = ((AbstractStargateEntity)stargate).isConnected();
            } else if (((AbstractStargateEntity)stargate).isConnected()) {
                pointOfOriginEngaged = ((ClientStargateVariant)stargateVariant).symbols().engageSymbolsOnIncoming();
            }
            consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getPointOfOriginTexture(pointOfOrigin)));
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, this.symbolsGlow(stargate, stargateVariant, pointOfOriginEngaged) ? 0xF000F0 : combinedLight, 0, 0.5f, 1, rotation, this.getSymbolColor(stargate, stargateVariant, pointOfOriginEngaged));
        }
        if ((symbols = this.getSymbols((AbstractStargateEntity)stargate, stargateVariant)) == null) {
            return;
        }
        consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getSymbolTexture(symbols)));
        for (int j = 1; j < this.numberOfSymbols; ++j) {
            boolean symbolEngaged = false;
            if (((ClientStargateVariant)stargateVariant).symbols().engageEncodedSymbols() && (!((AbstractStargateEntity)stargate).isConnected() || ((AbstractStargateEntity)stargate).isDialingOut())) {
                for (int i = 0; i < ((AbstractStargateEntity)stargate).getAddress().getLength(); ++i) {
                    int addressSymbol = ((AbstractStargateEntity)stargate).getAddress().toArray()[i];
                    if (addressSymbol != j) continue;
                    symbolEngaged = true;
                }
            } else if (((AbstractStargateEntity)stargate).isConnected()) {
                symbolEngaged = ((ClientStargateVariant)stargateVariant).symbols().engageSymbolsOnIncoming();
            }
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, this.symbolsGlow(stargate, stargateVariant, symbolEngaged) ? 0xF000F0 : combinedLight, j, symbols.getTextureOffset(j), symbols.getSize(), rotation, this.getSymbolColor(stargate, stargateVariant, symbolEngaged));
        }
    }

    protected void renderSymbol(StargateEntity stargate, Variant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int symbolNumber, float symbolOffset, int textureXSize, float rotation, ColorUtil.RGBA symbolColor) {
        if (symbolNumber >= this.numberOfSymbols) {
            return;
        }
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122227_.m_122240_((float)symbolNumber * -this.symbolAngle + rotation));
        Matrix4f matrix4 = stack.m_85850_().m_85861_();
        Matrix3f matrix3 = stack.m_85850_().m_85864_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, symbolColor.red(), symbolColor.green(), symbolColor.blue(), symbolColor.alpha(), -this.stargateSymbolRingOuterCenter, 3.125f, 0.15625f, symbolOffset - this.stargateSymbolRingOuterCenter * 32.0f / 16.0f / (float)textureXSize, 0.0f, -this.stargateSymbolRingInnerCenter, 2.625f, 0.15625f, symbolOffset - this.stargateSymbolRingInnerCenter * 32.0f / 16.0f / (float)textureXSize, 1.0f, this.stargateSymbolRingInnerCenter, 2.625f, 0.15625f, symbolOffset + this.stargateSymbolRingInnerCenter * 32.0f / 16.0f / (float)textureXSize, 1.0f, this.stargateSymbolRingOuterCenter, 3.125f, 0.15625f, symbolOffset + this.stargateSymbolRingOuterCenter * 32.0f / 16.0f / (float)textureXSize, 0.0f);
        stack.m_85849_();
    }
}

