/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.client.ClientUtil;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.CartoucheEntity;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public abstract class CartoucheRenderer {
    protected static final float MAX_WIDTH = 0.625f;
    protected static final float MAX_HEIGHT = 1.625f;
    protected static final float SYMBOL_OFFSET = 0.51f;
    protected int red;
    protected int green;
    protected int blue;

    public CartoucheRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected Symbols getSymbols(CartoucheEntity cartouche) {
        return ClientUtil.getSymbols(cartouche.getSymbols());
    }

    protected void renderSymbol(VertexConsumer consumer, Matrix4f matrix4, Matrix3f matrix3, int light, float size, float x, float y, float z, float textureSize, float textureOffset) {
        float halfsize = size / 2.0f;
        float textureHalf = 1.0f / textureSize / 2.0f;
        consumer.m_85982_(matrix4, x - halfsize, y + halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(textureOffset - textureHalf, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(matrix4, x - halfsize, y - halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(textureOffset - textureHalf, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(matrix4, x + halfsize, y - halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(textureOffset + textureHalf, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(matrix4, x + halfsize, y + halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(textureOffset + textureHalf, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    protected void renderCartoucheBlock(CartoucheEntity cartouche, PoseStack stack, MultiBufferSource source, int light) {
        BlockState blockstate = cartouche.m_58900_();
        if (blockstate.m_61143_(CartoucheBlock.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        Direction direction = (Direction)blockstate.m_61143_((Property)CartoucheBlock.f_54117_);
        float facing = direction.m_122435_();
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_(CartoucheBlock.ORIENTATION));
        BlockPos pos = cartouche.m_58899_().m_121945_(Orientation.getForwardDirection(direction, orientation));
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        }
        if (cartouche != null) {
            Matrix4f matrix4 = stack.m_85850_().m_85861_();
            Matrix3f matrix3 = stack.m_85850_().m_85864_();
            Symbols symbols = this.getSymbols(cartouche);
            light = LevelRenderer.m_109541_((BlockAndTintGetter)cartouche.m_58904_(), (BlockPos)pos);
            Address address = cartouche.getAddress();
            if (address != null) {
                float symbolSize = 1.625f / (float)address.getLength();
                if (symbolSize > 0.625f) {
                    symbolSize = 0.625f;
                }
                if (symbols != null) {
                    ResourceLocation texture = symbols.getSymbolTexture();
                    for (int i = 0; i < address.getLength(); ++i) {
                        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.symbol(texture));
                        float yStart = 0.5f + symbolSize * (float)address.getLength() / 2.0f;
                        if (yStart > 1.3125f) {
                            yStart = 1.3125f;
                        }
                        float yPos = yStart - symbolSize / 2.0f - symbolSize * (float)i;
                        this.renderSymbol(consumer, matrix4, matrix3, light, symbolSize, 0.0f, yPos, 0.51f, symbols.getSize(), symbols.getTextureOffset(address.getSymbol(i)));
                    }
                }
            }
        }
        stack.m_85849_();
    }

    public static class RedSandstone
    extends CartoucheRenderer
    implements BlockEntityRenderer<CartoucheEntity.RedSandstone> {
        public RedSandstone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 159;
            this.green = 78;
            this.blue = 11;
        }

        public void render(CartoucheEntity.RedSandstone cartouche, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderCartoucheBlock(cartouche, stack, source, combinedLight);
        }
    }

    public static class Sandstone
    extends CartoucheRenderer
    implements BlockEntityRenderer<CartoucheEntity.Sandstone> {
        public Sandstone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 198;
            this.green = 174;
            this.blue = 113;
        }

        public void render(CartoucheEntity.Sandstone cartouche, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderCartoucheBlock(cartouche, stack, source, combinedLight);
        }
    }

    public static class Stone
    extends CartoucheRenderer
    implements BlockEntityRenderer<CartoucheEntity.Stone> {
        public Stone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 90;
            this.green = 89;
            this.blue = 90;
        }

        public void render(CartoucheEntity.Stone cartouche, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderCartoucheBlock(cartouche, stack, source, combinedLight);
        }
    }
}

