/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.level;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.render.level.SGJourneySkyRenderer;

public class PlanetSkyRenderers {

    public static class AthosSkyRenderer
    extends SGJourneySkyRenderer {
        public static final ResourceLocation ATHOS_STAR_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/athos_star.png");

        public AthosSkyRenderer() {
            super(27392L, 1250);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderSun(bufferbuilder, lastMatrix, ATHOS_STAR_TEXTURE, 30.0f);
            this.renderMoon(bufferbuilder, lastMatrix, 20.0f, level.m_46941_(), (float)Math.toRadians(40.0), (float)Math.toRadians(180.0));
        }
    }

    public static class LanteaSkyRenderer
    extends SGJourneySkyRenderer {
        public static final ResourceLocation LANTEA_STAR_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/lantea_star.png");

        public LanteaSkyRenderer() {
            super(17892L, 2250);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderSun(bufferbuilder, lastMatrix, LANTEA_STAR_TEXTURE, 30.0f);
            this.renderMoon(bufferbuilder, lastMatrix, 20.0f, level.m_46941_(), 0.0f, (float)Math.toRadians(180.0));
        }
    }

    public static class RimaSkyRenderer
    extends SGJourneySkyRenderer {
        public static final ResourceLocation RIMA_STAR_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/rima_star.png");

        public RimaSkyRenderer() {
            super(87163L, 1800);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderSun(bufferbuilder, lastMatrix, RIMA_STAR_TEXTURE, 30.0f);
            this.renderMoon(bufferbuilder, lastMatrix, 20.0f, level.m_46941_(), (float)Math.toRadians(-126.0), (float)Math.toRadians(191.0));
            this.renderMoon(bufferbuilder, lastMatrix, 25.0f, level.m_46941_(), (float)Math.toRadians(31.0), (float)Math.toRadians(152.5));
        }
    }

    public static class UnitasSkyRenderer
    extends SGJourneySkyRenderer {
        public static final ResourceLocation UNITAS_STAR_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/unitas_star.png");

        public UnitasSkyRenderer() {
            super(87163L, 1800);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderSun(bufferbuilder, lastMatrix, UNITAS_STAR_TEXTURE, 30.0f);
        }
    }

    public static class CavumTenebraeSkyRenderer
    extends SGJourneySkyRenderer {
        public CavumTenebraeSkyRenderer() {
            super(28486L, 1000);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderBlackHole(bufferbuilder, lastMatrix, 70.0f, 0.0f, 0.0f);
        }
    }

    public static class ChulakSkyRenderer
    extends SGJourneySkyRenderer {
        public static final ResourceLocation DENNAL_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/dennal.png");
        public static final ResourceLocation CHAAPORIS_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/chaaporis.png");

        public ChulakSkyRenderer() {
            super(14812L, 1500);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderSun(bufferbuilder, lastMatrix, DENNAL_TEXTURE, 30.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(10.0));
            this.renderSun(bufferbuilder, lastMatrix, CHAAPORIS_TEXTURE, 30.0f, (float)Math.toRadians(15.0), (float)Math.toRadians(-10.0));
            this.renderMoon(bufferbuilder, lastMatrix, 45.0f, level.m_46941_(), 0.0f, (float)Math.toRadians(180.0));
        }
    }

    public static class AbydosSkyRenderer
    extends SGJourneySkyRenderer {
        public static final ResourceLocation NUT_TEXTURE = new ResourceLocation("sgjourney", "textures/environment/star/nut.png");

        public AbydosSkyRenderer() {
            super(28843L, 1500);
        }

        @Override
        protected void renderCelestials(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f lastMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
            this.renderSun(bufferbuilder, lastMatrix, NUT_TEXTURE, 50.0f);
            this.renderMoon(bufferbuilder, lastMatrix, 20.0f, level.m_46941_(), (float)Math.toRadians(-120.0), (float)Math.toRadians(170.0));
            this.renderMoon(bufferbuilder, lastMatrix, 25.0f, level.m_46941_(), (float)Math.toRadians(80.0), (float)Math.toRadians(152.5));
            this.renderMoon(bufferbuilder, lastMatrix, 35.0f, level.m_46941_(), (float)Math.toRadians(-65.0), (float)Math.toRadians(150.0));
        }
    }
}

