/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import net.povstalec.sgjourney.common.tech.AncientTech;

public class ATAGeneDetectorBlock
extends Block
implements AncientTech {
    public static final IntegerProperty MEASURED_GENE = IntegerProperty.m_61631_((String)"measured_gene", (int)0, (int)3);
    public static final double DETECTION_DISTANCE = 5.0;
    private static final int TICKS_ACTIVE = 20;
    private static final int NO_GENE = 0;
    private static final int ARTIFICIAL_GENE = 9;
    private static final int INHERITED_GENE = 12;
    private static final int ANCIENT_GENE = 15;
    private int signalStrength = 0;

    public ATAGeneDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MEASURED_GENE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{MEASURED_GENE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.f_46443_) {
            int measured = switch (this.getGeneType((Entity)player)) {
                case AncientGene.ATAGene.ARTIFICIAL -> 1;
                case AncientGene.ATAGene.INHERITED -> 2;
                case AncientGene.ATAGene.ANCIENT -> 3;
                default -> 0;
            };
            if ((Integer)state.m_61143_((Property)MEASURED_GENE) != measured) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MEASURED_GENE, (Comparable)Integer.valueOf(measured)), 3);
            }
        }
        level.m_186460_(pos, (Block)this, 20);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)MEASURED_GENE, (Comparable)Integer.valueOf(0)), 3);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int measuredGene = (Integer)state.m_61143_((Property)MEASURED_GENE);
        switch (measuredGene) {
            case 1: {
                return 9;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 15;
            }
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        if (level.m_5776_()) {
            return;
        }
        int newSignalStrength = level.m_46755_(pos);
        if (newSignalStrength > this.signalStrength || newSignalStrength == 0) {
            this.signalStrength = newSignalStrength;
        }
        if (level.m_46753_(pos) && this.signalStrength == newSignalStrength) {
            int measured = this.detectATAGene(state, level, pos, (double)this.signalStrength * 2.0);
            if ((Integer)state.m_61143_((Property)MEASURED_GENE) != measured) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MEASURED_GENE, (Comparable)Integer.valueOf(measured)), 3);
            }
        }
    }

    private int detectATAGene(BlockState state, Level level, BlockPos pos, double detectionDistance) {
        AABB localBox = new AABB((double)pos.m_123341_() - detectionDistance, (double)pos.m_123342_() - detectionDistance, (double)pos.m_123343_() - detectionDistance, (double)(pos.m_123341_() + 1) + detectionDistance, (double)(pos.m_123342_() + 1) + detectionDistance, (double)(pos.m_123343_() + 1) + detectionDistance);
        List localEntities = level.m_45976_(Entity.class, localBox);
        return this.measureHighestLevel(localEntities);
    }

    private int measureHighestLevel(List<Entity> entities) {
        int measured = 0;
        if (entities.stream().anyMatch(entity -> this.getGeneType((Entity)entity) == AncientGene.ATAGene.ARTIFICIAL)) {
            measured = 1;
        }
        if (entities.stream().anyMatch(entity -> this.getGeneType((Entity)entity) == AncientGene.ATAGene.INHERITED)) {
            measured = 2;
        }
        if (entities.stream().anyMatch(entity -> this.getGeneType((Entity)entity) == AncientGene.ATAGene.ANCIENT)) {
            measured = 3;
        }
        return measured;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)ComponentHelper.description("block.sgjourney.ancient_gene_detector.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("block.sgjourney.ancient_gene_detector.right_click"));
        tooltipComponents.add((Component)ComponentHelper.usage("block.sgjourney.ancient_gene_detector.redstone"));
    }
}

