/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.entities.goals.NearestThreatGoal;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public class Jaffa
extends Human {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/player/wide/efe.png");
    private static final ResourceLocation ABYDOS = new ResourceLocation("sgjourney", "abydos");

    public Jaffa(EntityType<? extends Jaffa> type, Level level) {
        super((EntityType<? extends Human>)type, level);
    }

    @Override
    public ResourceLocation texture() {
        return TEXTURE;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, new NearestThreatGoal<Player>((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Human.createAttributes().m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void setupHelmet() {
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemInit.JAFFA_HELMET.get()));
    }

    protected void setupDimensionHelmet(ServerLevelAccessor level, RandomSource randomSource) {
        if (level.m_6018_().m_46472_().m_135782_().equals((Object)ABYDOS)) {
            this.m_8061_(EquipmentSlot.HEAD, randomSource.m_188501_() > 0.7f ? new ItemStack((ItemLike)ItemInit.JACKAL_HELMET.get()) : new ItemStack((ItemLike)ItemInit.FALCON_HELMET.get()));
        } else {
            this.setupHelmet();
        }
    }

    protected void setupArmor() {
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ItemInit.JAFFA_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ItemInit.JAFFA_LEGGINGS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ItemInit.JAFFA_BOOTS.get()));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        RandomSource randomSource = level.m_213780_();
        spawnGroupData = super.m_6518_(level, difficulty, type, spawnGroupData, tag);
        this.m_21008_(InteractionHand.MAIN_HAND, StaffWeaponItem.filledStaffWeapon(randomSource.m_188501_() > (float)difficulty.m_19048_().m_19028_() / 3.0f, (int)(randomSource.m_188501_() * (float)((Integer)CommonTechConfig.vial_capacity.get()).intValue())));
        if (type != MobSpawnType.EVENT) {
            if (type == MobSpawnType.NATURAL) {
                this.setupDimensionHelmet(level, randomSource);
            } else {
                this.setupHelmet();
            }
            this.setupArmor();
        }
        return spawnGroupData;
    }
}

