/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.misc.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public class StargateUpgradeItem
extends Item {
    public static final String TYPE = "Type";

    public StargateUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public Optional<AbstractStargateBaseBlock> getStargateBaseBlock(ItemStack stack) {
        Block block;
        Optional<AbstractStargateBaseBlock> stargate = Optional.empty();
        Optional<String> string = StargateUpgradeItem.getStargateString(stack);
        if (string.isPresent() && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string.get()))) instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            stargate = Optional.of(stargateBlock);
        }
        return stargate;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            items.addAll(RecipeUtil.getAllVariants(((Object)((Object)this)).getClass(), TYPE));
        }
    }

    public static Optional<String> getStargateString(ItemStack stack) {
        Optional<String> stargate = Optional.empty();
        if (stack.m_41720_() instanceof StargateUpgradeItem && stack.m_41784_().m_128441_(TYPE)) {
            String stargateString = stack.m_41783_().m_128461_(TYPE);
            stargate = Optional.of(stargateString);
        }
        return stargate;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (stack.m_41782_() && stack.m_41784_().m_128441_(TYPE)) {
            String variant = stack.m_41784_().m_128461_(TYPE);
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.stargate_type").m_7220_((Component)Component.m_237113_((String)(": " + variant))).m_130940_(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.stargate_upgrade.description").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static <StargateBlock extends AbstractStargateBlock> ItemStack stargateType(StargateBlock stargate) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.STARGATE_UPGRADE_CRYSTAL.get());
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_(TYPE, ForgeRegistries.BLOCKS.getKey(stargate).toString());
        stack.m_41751_(compoundtag);
        return stack;
    }
}

