/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;

public class StargateBlockItem
extends BlockItem {
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    private static final String POINT_OF_ORIGIN = "PointOfOrigin";
    private static final String SYMBOLS = "Symbols";
    private static final String IRIS_PROGRESS = "IrisProgress";
    private static final ResourceLocation EMPTY = StargateJourney.EMPTY_LOCATION;

    public StargateBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        Orientation orientation = Orientation.getOrientationFromXRot(player);
        if (orientation == Orientation.REGULAR && blockpos.m_123342_() > level.m_151558_() - 6) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            CompoundTag blockEntityTag;
            CompoundTag itemTag;
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                if (part.equals(StargatePart.BASE) || level.m_8055_(part.getRingPos(blockpos, context.m_8125_().m_122424_(), orientation)).m_60629_(context)) continue;
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.not_enough_space"), true);
                }
                return false;
            }
            ItemStack stack = context.m_43722_();
            if (stack.m_41783_() != null && (itemTag = stack.m_41783_()).m_128441_(BLOCK_ENTITY_TAG) && (blockEntityTag = itemTag.m_128469_(BLOCK_ENTITY_TAG)).m_128441_(IRIS_PROGRESS)) {
                short irisProgress = blockEntityTag.m_128448_(IRIS_PROGRESS);
                for (ShieldingPart part : stargateBlock.getShieldingParts()) {
                    if (!part.canExist(ShieldingState.fromProgress(irisProgress)) || level.m_8055_(part.getShieldingPos(blockpos, context.m_8125_().m_122424_(), orientation)).m_60629_(context)) continue;
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.not_enough_space"), true);
                    }
                    return false;
                }
            }
        } else {
            return false;
        }
        return (!this.m_6652_() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), collisioncontext);
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return StargateBlockItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundtag = StargateBlockItem.m_186336_((ItemStack)stack);
        if (compoundtag != null) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity != null) {
                if (!(level.m_5776_() || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                    return false;
                }
                CompoundTag compoundtag1 = blockentity.m_187482_();
                CompoundTag compoundtag2 = compoundtag1.m_6426_();
                compoundtag1.m_128391_(compoundtag);
                if (!compoundtag1.equals((Object)compoundtag2)) {
                    blockentity.m_142466_(compoundtag1);
                    blockentity.m_6596_();
                    return StargateBlockItem.setupBlockEntity(level, blockentity, compoundtag);
                }
            }
        } else {
            BlockEntity baseEntity = level.m_7702_(pos);
            if (baseEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)baseEntity;
                stargate.addStargateToNetwork();
                stargate.generateAdditional(StructureGenEntity.Step.READY);
                if (stargate instanceof MilkyWayStargateEntity) {
                    MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
                    milkyWayStargate.symbolInfo().setPointOfOrigin(PointOfOrigin.randomPointOfOrigin(level.m_7654_(), (ResourceKey<Level>)level.m_46472_()));
                } else if (stargate instanceof ClassicStargateEntity) {
                    ClassicStargateEntity classicStargate = (ClassicStargateEntity)stargate;
                    classicStargate.symbolInfo().setPointOfOrigin(PointOfOrigin.randomPointOfOrigin(level.m_7654_(), (ResourceKey<Level>)level.m_46472_()));
                }
            }
        }
        return false;
    }

    private static boolean setupBlockEntity(Level level, BlockEntity baseEntity, CompoundTag info) {
        if (baseEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)baseEntity;
            StructureGenEntity.Step generationStep = info.m_128425_("generation_step", 1) ? StructureGenEntity.Step.fromByte(info.m_128445_("generation_step")) : StructureGenEntity.Step.GENERATED;
            if (generationStep == StructureGenEntity.Step.GENERATED) {
                stargate.addStargateToNetwork();
                stargate.generateAdditional(StructureGenEntity.Step.GENERATED);
                if (!level.m_5776_()) {
                    StargateNetwork.get(level).updateStargate((ServerLevel)level, stargate);
                }
            } else {
                stargate.generateAdditional(StructureGenEntity.Step.SETUP);
            }
        }
        return false;
    }
}

