/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3d;

public class Matrix3d {
    public double m00 = 1.0;
    public double m01 = 0.0;
    public double m02 = 0.0;
    public double m10 = 0.0;
    public double m11 = 1.0;
    public double m12 = 0.0;
    public double m20 = 0.0;
    public double m21 = 0.0;
    public double m22 = 1.0;

    public Matrix3d rotate(Quaternion quaternion) {
        double w2 = quaternion.m_80156_() * quaternion.m_80156_();
        double x2 = quaternion.m_80140_() * quaternion.m_80140_();
        double y2 = quaternion.m_80150_() * quaternion.m_80150_();
        double z2 = quaternion.m_80153_() * quaternion.m_80153_();
        double zw = quaternion.m_80153_() * quaternion.m_80156_();
        double dzw = zw + zw;
        double xy = quaternion.m_80140_() * quaternion.m_80150_();
        double dxy = xy + xy;
        double xz = quaternion.m_80140_() * quaternion.m_80153_();
        double dxz = xz + xz;
        double yw = quaternion.m_80150_() * quaternion.m_80156_();
        double dyw = yw + yw;
        double yz = quaternion.m_80150_() * quaternion.m_80153_();
        double dyz = yz + yz;
        double xw = quaternion.m_80140_() * quaternion.m_80156_();
        double dxw = xw + xw;
        double rm00 = w2 + x2 - z2 - y2;
        double rm01 = dxy + dzw;
        double rm02 = dxz - dyw;
        double rm10 = dxy - dzw;
        double rm11 = y2 - z2 + w2 - x2;
        double rm12 = dyz + dxw;
        double rm20 = dyw + dxz;
        double rm21 = dyz - dxw;
        double rm22 = z2 - y2 - x2 + w2;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        this.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        this.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        this.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        return this;
    }

    public Vector3d transform(Vector3d vec) {
        double rx = Math.fma(this.m00, vec.f_86214_, Math.fma(this.m10, vec.f_86215_, this.m20 * vec.f_86216_));
        double ry = Math.fma(this.m01, vec.f_86214_, Math.fma(this.m11, vec.f_86215_, this.m21 * vec.f_86216_));
        double rz = Math.fma(this.m02, vec.f_86214_, Math.fma(this.m12, vec.f_86215_, this.m22 * vec.f_86216_));
        vec.f_86214_ = rx;
        vec.f_86215_ = ry;
        vec.f_86216_ = rz;
        return vec;
    }
}

