/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AdvancedCrystallizerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation recipeID;
    private final NonNullList<Ingredient> ingredients;
    private final int[] amounts;
    private final ItemStack output;
    private final boolean depletePrimary;
    private final boolean depleteSecondary;

    public AdvancedCrystallizerRecipe(ResourceLocation recipeID, ItemStack output, NonNullList<Ingredient> ingredients, int[] amounts, boolean depletePrimary, boolean depleteSecondary) {
        this.recipeID = recipeID;
        this.ingredients = ingredients;
        this.amounts = amounts;
        this.output = output;
        this.depletePrimary = depletePrimary;
        this.depleteSecondary = depleteSecondary;
    }

    public int getAmountInSlot(int slot) {
        if (slot < 0 || slot >= this.amounts.length) {
            return 0;
        }
        return this.amounts[slot];
    }

    public boolean depletePrimary() {
        return this.depletePrimary;
    }

    public boolean depleteSecondary() {
        return this.depleteSecondary;
    }

    public boolean itemStackMatches(SimpleContainer container, int slot) {
        ItemStack stack = container.m_8020_(slot);
        return ((Ingredient)this.ingredients.get(slot)).test(stack) && this.amounts[slot] <= stack.m_41613_();
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        return this.itemStackMatches(container, 0) && this.itemStackMatches(container, 1) && this.itemStackMatches(container, 2);
    }

    public ItemStack assemble(SimpleContainer container) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.recipeID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public static class Serializer
    implements RecipeSerializer<AdvancedCrystallizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("sgjourney", "advanced_crystallizing");

        public static Pair<Ingredient, Integer> getIngredient(Set<Map.Entry<String, JsonElement>> set) {
            HashMap<String, JsonElement> mapFromSet = new HashMap<String, JsonElement>();
            for (Map.Entry<String, JsonElement> entry : set) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            JsonElement item = (JsonElement)mapFromSet.get("item");
            JsonObject json = new JsonObject();
            json.add("item", item);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json);
            int amount = ((JsonElement)mapFromSet.get("amount")).getAsInt();
            return new Pair((Object)ingredient, (Object)amount);
        }

        public AdvancedCrystallizerRecipe fromJson(ResourceLocation recipeID, JsonObject serializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"output"));
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            int[] amounts = new int[ingredients.size()];
            Pair<Ingredient, Integer> crystalBase = Serializer.getIngredient(GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"crystal_base").entrySet());
            Pair<Ingredient, Integer> primaryIngredient = Serializer.getIngredient(GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"primary_ingredient").entrySet());
            Pair<Ingredient, Integer> secondaryIngredient = Serializer.getIngredient(GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"secondary_ingredient").entrySet());
            boolean depletePrimary = GsonHelper.m_13880_((JsonObject)serializedRecipe, (String)"deplete_primary") ? GsonHelper.m_13912_((JsonObject)serializedRecipe, (String)"deplete_primary") : true;
            boolean depleteSecondary = GsonHelper.m_13880_((JsonObject)serializedRecipe, (String)"deplete_secondary") ? GsonHelper.m_13912_((JsonObject)serializedRecipe, (String)"deplete_secondary") : true;
            ingredients.set(0, (Object)((Ingredient)crystalBase.getFirst()));
            amounts[0] = (Integer)crystalBase.getSecond();
            ingredients.set(1, (Object)((Ingredient)primaryIngredient.getFirst()));
            amounts[1] = (Integer)primaryIngredient.getSecond();
            ingredients.set(2, (Object)((Ingredient)secondaryIngredient.getFirst()));
            amounts[2] = (Integer)secondaryIngredient.getSecond();
            return new AdvancedCrystallizerRecipe(recipeID, output, (NonNullList<Ingredient>)ingredients, amounts, depletePrimary, depleteSecondary);
        }

        @Nullable
        public AdvancedCrystallizerRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf friendlyByteBuf) {
            int[] amounts = friendlyByteBuf.m_130100_();
            NonNullList ingredients = NonNullList.m_122780_((int)friendlyByteBuf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            ItemStack output = friendlyByteBuf.m_130267_();
            boolean depletePrimary = friendlyByteBuf.readBoolean();
            boolean depleteSecondary = friendlyByteBuf.readBoolean();
            return new AdvancedCrystallizerRecipe(recipeID, output, (NonNullList<Ingredient>)ingredients, amounts, depletePrimary, depleteSecondary);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, AdvancedCrystallizerRecipe recipe) {
            friendlyByteBuf.m_130089_(recipe.amounts);
            friendlyByteBuf.writeInt(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.writeItemStack(recipe.m_8043_(), false);
            friendlyByteBuf.writeBoolean(recipe.depletePrimary);
            friendlyByteBuf.writeBoolean(recipe.depleteSecondary);
        }
    }

    public static class Type
    implements RecipeType<AdvancedCrystallizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "advanced_crystallizing";

        private Type() {
        }
    }
}

