/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.client.BestiaryToast;
import com.araxer.araxers_bestiary.client.ClientProgressionData;
import com.araxer.araxers_bestiary.client.gui.BestiaryScreen;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryAttributeManager;
import com.araxer.araxers_bestiary.data.BestiarySpawnLocationManager;
import com.araxer.araxers_bestiary.data.EntityAttributes;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.RankXConfig;
import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary", value={Dist.CLIENT})
public class PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation PROGRESSION_TOAST_CHANNEL = CommonPacketHandler.PROGRESSION_TOAST_CHANNEL;
    private static final ResourceLocation PROGRESSION_UPDATE_CHANNEL = CommonPacketHandler.PROGRESSION_UPDATE_CHANNEL;
    private static final ResourceLocation PROGRESSION_SYNC_CHANNEL = CommonPacketHandler.PROGRESSION_SYNC_CHANNEL;
    private static final ResourceLocation LOOT_SYNC_CHANNEL = CommonPacketHandler.LOOT_SYNC_CHANNEL;
    private static final ResourceLocation SPAWN_LOCATION_SYNC_CHANNEL = CommonPacketHandler.SPAWN_LOCATION_SYNC_CHANNEL;
    private static final ResourceLocation ATTRIBUTE_SYNC_CHANNEL = CommonPacketHandler.ATTRIBUTE_SYNC_CHANNEL;
    private static final ResourceLocation PROGRESSION_VIEWED_CHANNEL = CommonPacketHandler.PROGRESSION_VIEWED_CHANNEL;
    private static EventNetworkChannel TOAST_CHANNEL;
    private static EventNetworkChannel UPDATE_CHANNEL;
    private static EventNetworkChannel SYNC_CHANNEL;
    private static EventNetworkChannel LOOT_CHANNEL;
    private static EventNetworkChannel SPAWN_LOCATION_CHANNEL;
    private static EventNetworkChannel ATTRIBUTE_CHANNEL;
    private static EventNetworkChannel VIEWED_CHANNEL;
    private static EventNetworkChannel SCANNING_CHANNEL;
    private static final Set<String> processedToastPackets;
    private static int currentScanningTicks;
    private static int maxScanningTicks;
    private static ResourceLocation currentScannedEntity;
    private static long lastScanSoundTime;
    @OnlyIn(value=Dist.CLIENT)
    private static int clientLootVersion;

    public static void init() {
        LOGGER.debug("Initializing client packet handler");
        PacketHandler.clearProcessedPackets();
        try {
            if (CommonPacketHandler.TOAST_CHANNEL == null) {
                LOGGER.warn("CommonPacketHandler channels are not initialized yet. Attempting to initialize them now.");
                CommonPacketHandler.init();
                if (CommonPacketHandler.TOAST_CHANNEL == null) {
                    LOGGER.error("Failed to initialize CommonPacketHandler channels. Toast notifications may not work correctly.");
                    return;
                }
            }
            TOAST_CHANNEL = CommonPacketHandler.TOAST_CHANNEL;
            UPDATE_CHANNEL = CommonPacketHandler.UPDATE_CHANNEL;
            SYNC_CHANNEL = CommonPacketHandler.SYNC_CHANNEL;
            LOOT_CHANNEL = CommonPacketHandler.LOOT_CHANNEL;
            SPAWN_LOCATION_CHANNEL = CommonPacketHandler.SPAWN_LOCATION_CHANNEL;
            ATTRIBUTE_CHANNEL = CommonPacketHandler.ATTRIBUTE_CHANNEL;
            VIEWED_CHANNEL = CommonPacketHandler.VIEWED_CHANNEL;
            SCANNING_CHANNEL = CommonPacketHandler.SCANNING_CHANNEL;
            if (TOAST_CHANNEL != null) {
                TOAST_CHANNEL.addListener(PacketHandler::handleProgressionToast);
                LOGGER.debug("Added listener for progression toast channel");
            } else {
                LOGGER.error("Toast channel is null, cannot add listener");
            }
            if (UPDATE_CHANNEL != null) {
                UPDATE_CHANNEL.addListener(PacketHandler::handleProgressionUpdate);
                LOGGER.debug("Added listener for progression update channel");
            } else {
                LOGGER.error("Update channel is null, cannot add listener");
            }
            if (SYNC_CHANNEL != null) {
                SYNC_CHANNEL.addListener(PacketHandler::handleProgressionSync);
                LOGGER.debug("Added listener for progression sync channel");
            } else {
                LOGGER.error("Sync channel is null, cannot add listener");
            }
            if (LOOT_CHANNEL != null) {
                LOOT_CHANNEL.addListener(PacketHandler::handleLootSync);
                LOGGER.debug("Added listener for loot sync channel");
            } else {
                LOGGER.error("Loot channel is null, cannot add listener");
            }
            if (SPAWN_LOCATION_CHANNEL != null) {
                SPAWN_LOCATION_CHANNEL.addListener(PacketHandler::handleSpawnLocationSync);
                LOGGER.debug("Added listener for spawn location sync channel");
            } else {
                LOGGER.error("Spawn location channel is null, cannot add listener");
            }
            if (ATTRIBUTE_CHANNEL != null) {
                ATTRIBUTE_CHANNEL.addListener(PacketHandler::handleAttributeSync);
                LOGGER.debug("Added listener for attribute sync channel");
            } else {
                LOGGER.error("Attribute channel is null, cannot add listener");
            }
            if (SCANNING_CHANNEL != null) {
                SCANNING_CHANNEL.addListener(PacketHandler::handleScanningProgress);
                LOGGER.debug("Added listener for scanning progress channel");
            } else {
                LOGGER.error("Scanning channel is null, cannot add listener");
            }
            LOGGER.debug("Successfully added all client-side packet listeners");
        }
        catch (Exception e) {
            LOGGER.error("Error initializing client packet handler: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static void handleProgressionToast(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            String packetKey;
            String newRank;
            String oldRank;
            boolean isRankToast;
            ResourceLocation entityTypeId = buf.m_130281_();
            int threshold = buf.readInt();
            boolean bl = isRankToast = threshold == -1;
            if (isRankToast) {
                int originalPosition = buf.readerIndex();
                oldRank = buf.m_130277_();
                newRank = buf.m_130277_();
                packetKey = entityTypeId.toString() + ":rank:" + oldRank + ":" + newRank;
                buf.readerIndex(originalPosition);
                LOGGER.debug("Reset buffer position from {} to {} for rank toast packet", (Object)(buf.readerIndex() + (oldRank.length() + newRank.length() + 8)), (Object)originalPosition);
            } else {
                packetKey = entityTypeId.toString() + ":" + threshold;
            }
            if (processedToastPackets.contains(packetKey)) {
                if (isRankToast) {
                    LOGGER.warn("Duplicate rank toast packet received for entity {}", (Object)entityTypeId);
                } else {
                    LOGGER.warn("Duplicate progression toast packet received for entity {} with threshold {}", (Object)entityTypeId, (Object)threshold);
                }
                return;
            }
            processedToastPackets.add(packetKey);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
            if (entityType == null) {
                LOGGER.error("Unknown entity type: {}", (Object)entityTypeId);
                return;
            }
            if (isRankToast) {
                oldRank = buf.m_130277_();
                newRank = buf.m_130277_();
                LOGGER.debug("Received rank toast packet for entity {} with rank change {} -> {}", new Object[]{entityTypeId, oldRank, newRank});
                Minecraft.m_91087_().execute(() -> {
                    ClientProgressionData.updateRank(entityType, newRank);
                    LOGGER.debug("Updated rank from toast packet: {} -> {}", (Object)oldRank, (Object)newRank);
                    BestiaryToast.showRankIncrease(entityType, oldRank, newRank);
                    if (Minecraft.m_91087_().f_91080_ instanceof BestiaryScreen) {
                        BestiaryScreen.onProgressionDataChanged();
                    }
                });
            } else {
                LOGGER.debug("Received progression toast packet for entity {} with threshold {}", (Object)entityTypeId, (Object)threshold);
                if (threshold == Config.descriptionThreshold) {
                    LOGGER.debug("This is a DESCRIPTION threshold toast packet (threshold={})", (Object)threshold);
                } else if (threshold == Config.spawnLocationThreshold) {
                    LOGGER.debug("This is a SPAWN LOCATION threshold toast packet (threshold={})", (Object)threshold);
                } else if (threshold == Config.lootIconThreshold) {
                    LOGGER.debug("This is a LOOT ICON threshold toast packet (threshold={})", (Object)threshold);
                } else if (threshold == Config.advancedAttributesThreshold) {
                    LOGGER.debug("This is an ADVANCED ATTRIBUTES threshold toast packet (threshold={})", (Object)threshold);
                } else if (threshold == Config.lootChanceThreshold) {
                    LOGGER.debug("This is a LOOT CHANCE threshold toast packet (threshold={})", (Object)threshold);
                } else if (threshold == 1) {
                    LOGGER.debug("This is a DISCOVERY toast packet (threshold={})", (Object)threshold);
                } else if (threshold == 2) {
                    LOGGER.debug("This is an OBSERVATION toast packet (threshold={})", (Object)threshold);
                }
                Minecraft.m_91087_().execute(() -> {
                    int currentKillCount = ClientProgressionData.getKillCount(entityType);
                    if (currentKillCount < threshold) {
                        ClientProgressionData.updateKillCount(entityType, threshold);
                        LOGGER.debug("Updated kill count from toast packet: {} -> {}", (Object)currentKillCount, (Object)threshold);
                    }
                    if (threshold == 2) {
                        BestiaryToast.showObservation(entityType);
                    } else {
                        BestiaryToast.show(entityType, threshold);
                    }
                    if (Minecraft.m_91087_().f_91080_ instanceof BestiaryScreen) {
                        BestiaryScreen.onProgressionDataChanged();
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing progression toast packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing toast packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static void handleProgressionUpdate(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            boolean isSpyglassObserved;
            ResourceLocation entityTypeId = buf.m_130281_();
            int killCount = buf.readInt();
            String progressionSystemType = buf.m_130277_();
            String rank = "ranks".equals(progressionSystemType) ? buf.m_130277_() : null;
            boolean isNewlyDiscovered = buf.readBoolean();
            boolean bl = isSpyglassObserved = buf.readableBytes() > 0 ? buf.readBoolean() : false;
            if ("ranks".equals(progressionSystemType)) {
                LOGGER.debug("Received progression update packet for entity {} with kill count {}, rank {}, new status {}, spyglass observed {}", new Object[]{entityTypeId, killCount, rank, isNewlyDiscovered, isSpyglassObserved});
            } else {
                LOGGER.debug("Received progression update packet for entity {} with kill count {}, new status {}, spyglass observed {}", new Object[]{entityTypeId, killCount, isNewlyDiscovered, isSpyglassObserved});
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
            if (entityType == null) {
                LOGGER.error("Unknown entity type: {}", (Object)entityTypeId);
                return;
            }
            boolean hasRankXBlock = false;
            int rxPts = 0;
            int rxDaysSinceS = -1;
            int rxSessions = 0;
            Map rxPerCh = Collections.emptyMap();
            if (buf.readableBytes() > 0 && (hasRankXBlock = buf.readBoolean())) {
                rxPts = buf.readInt();
                rxDaysSinceS = buf.readInt();
                rxSessions = buf.readInt();
                int chCount = buf.readInt();
                HashMap<String, Integer> perChTmp = new HashMap<String, Integer>();
                for (int i = 0; i < chCount; ++i) {
                    String chId = buf.m_130277_();
                    int awarded = buf.readInt();
                    perChTmp.put(chId, awarded);
                }
                rxPerCh = perChTmp;
            }
            boolean hasESBlock = false;
            int esPoints = 0;
            int esThreshold = 0;
            if (buf.readableBytes() > 0 && (hasESBlock = buf.readBoolean())) {
                esPoints = buf.readInt();
                esThreshold = buf.readInt();
            }
            boolean fHasRankXBlock = hasRankXBlock;
            int fRxPts = rxPts;
            int fRxDaysSinceS = rxDaysSinceS;
            int fRxSessions = rxSessions;
            Map fRxPerCh = rxPerCh;
            boolean fHasESBlock = hasESBlock;
            int fESPoints = esPoints;
            int fESThreshold = esThreshold;
            Minecraft.m_91087_().execute(() -> {
                ClientProgressionData.updateKillCount(entityType, killCount);
                if ("ranks".equals(progressionSystemType) && rank != null) {
                    String currentRank = ClientProgressionData.getRank(entityType);
                    LOGGER.debug("Updating rank for entity {} from {} to {} (progression update)", new Object[]{entityType.m_20675_(), currentRank, rank});
                    ClientProgressionData.updateRank(entityType, rank);
                }
                ClientProgressionData.updateNewlyDiscoveredStatus(entityType, isNewlyDiscovered);
                LOGGER.debug("Updated newly discovered status for entity {} to {} (progression update)", (Object)entityType.m_20675_(), (Object)isNewlyDiscovered);
                if (Config.enableProgressionSystem) {
                    ClientProgressionData.updateSpyglassObservedStatus(entityType, isSpyglassObserved);
                    LOGGER.debug("Updated spyglass observed status for entity {} to {} (progression update)", (Object)entityType.m_20675_(), (Object)isSpyglassObserved);
                } else if (isSpyglassObserved) {
                    LOGGER.debug("Skipped updating spyglass observed status for entity {} because progression mode is disabled", (Object)entityType.m_20675_());
                }
                if (fHasRankXBlock) {
                    ClientProgressionData.updateRankXProgress(entityType, fRxPts, fRxDaysSinceS, fRxSessions, fRxPerCh);
                }
                if (fHasESBlock) {
                    ClientProgressionData.updateESProgress(entityType, fESPoints, fESThreshold);
                } else {
                    ClientProgressionData.updateESProgress(entityType, 0, 0);
                }
                if (Minecraft.m_91087_().f_91080_ instanceof BestiaryScreen) {
                    BestiaryScreen.onProgressionDataChanged();
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing progression update packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static void handleProgressionSync(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            EntityType entityType;
            String progressionSystemType = buf.m_130277_();
            int killCountEntries = buf.readInt();
            LOGGER.debug("Received progression sync packet with {} kill count entries", (Object)killCountEntries);
            ClientProgressionData.clear();
            for (int i = 0; i < killCountEntries; ++i) {
                ResourceLocation entityTypeId = buf.m_130281_();
                int killCount = buf.readInt();
                boolean isNewlyDiscovered = buf.readBoolean();
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                if (entityType == null) {
                    LOGGER.error("Unknown entity type in sync packet: {}", (Object)entityTypeId);
                    continue;
                }
                ClientProgressionData.updateKillCount(entityType, killCount);
                ClientProgressionData.updateNewlyDiscoveredStatus(entityType, isNewlyDiscovered);
                LOGGER.debug("Updated newly discovered status for entity {} to {} (progression sync)", (Object)entityType.m_20675_(), (Object)isNewlyDiscovered);
            }
            if ("ranks".equals(progressionSystemType)) {
                int rankEntries = buf.readInt();
                LOGGER.debug("Processing {} rank entries for rank-based progression", (Object)rankEntries);
                for (int i = 0; i < rankEntries; ++i) {
                    ResourceLocation entityTypeId = buf.m_130281_();
                    String rank = buf.m_130277_();
                    entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                    if (entityType == null) {
                        LOGGER.error("Unknown entity type in rank data: {}", (Object)entityTypeId);
                        continue;
                    }
                    ClientProgressionData.updateRank(entityType, rank);
                }
            }
            if (buf.readableBytes() > 0) {
                int spyglassObservedEntries = buf.readInt();
                LOGGER.debug("Processing {} spyglass observed entries", (Object)spyglassObservedEntries);
                for (int i = 0; i < spyglassObservedEntries; ++i) {
                    ResourceLocation entityTypeId = buf.m_130281_();
                    EntityType entityType2 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                    if (entityType2 == null) {
                        LOGGER.error("Unknown entity type in spyglass observed data: {}", (Object)entityTypeId);
                        continue;
                    }
                    if (Config.enableProgressionSystem) {
                        ClientProgressionData.updateSpyglassObservedStatus(entityType2, true);
                        LOGGER.debug("Updated spyglass observed status for entity {} to true (progression sync)", (Object)entityType2.m_20675_());
                        continue;
                    }
                    LOGGER.debug("Skipped updating spyglass observed status for entity {} because progression mode is disabled", (Object)entityType2.m_20675_());
                }
            }
            if (buf.readableBytes() > 0) {
                int fullyDiscoveredEntries = buf.readInt();
                LOGGER.debug("Processing {} fully discovered entries", (Object)fullyDiscoveredEntries);
                for (int i = 0; i < fullyDiscoveredEntries; ++i) {
                    ResourceLocation entityTypeId = buf.m_130281_();
                    EntityType entityType3 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                    if (entityType3 == null) {
                        LOGGER.error("Unknown entity type in fully discovered data: {}", (Object)entityTypeId);
                        continue;
                    }
                    if (Config.enableProgressionSystem) {
                        ClientProgressionData.updateFullyDiscoveredStatus(entityType3, true);
                        LOGGER.debug("Updated fully discovered status for entity {} to true (progression sync)", (Object)entityType3.m_20675_());
                        continue;
                    }
                    LOGGER.debug("Skipped updating fully discovered status for entity {} because progression mode is disabled", (Object)entityType3.m_20675_());
                }
            }
            if (buf.readableBytes() > 0) {
                int rxEntryCount = buf.readInt();
                LOGGER.debug("Processing {} Rank-X entries from sync", (Object)rxEntryCount);
                for (int i = 0; i < rxEntryCount; ++i) {
                    ResourceLocation entityTypeId = buf.m_130281_();
                    EntityType entityType4 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                    if (entityType4 == null) {
                        LOGGER.error("Unknown entity type in Rank-X sync: {}", (Object)entityTypeId);
                        if (buf.readableBytes() >= 4) {
                            buf.readInt();
                        }
                        if (buf.readableBytes() >= 4) {
                            buf.readInt();
                        }
                        if (buf.readableBytes() >= 4) {
                            buf.readInt();
                        }
                        int chCount = buf.readableBytes() >= 4 ? buf.readInt() : 0;
                        for (int j = 0; j < chCount; ++j) {
                            if (buf.readableBytes() > 0) {
                                buf.m_130277_();
                            }
                            if (buf.readableBytes() < 4) continue;
                            buf.readInt();
                        }
                        continue;
                    }
                    int pts = buf.readInt();
                    int daysSinceS = buf.readInt();
                    int sessions = buf.readInt();
                    int chCount = buf.readInt();
                    HashMap<String, Integer> perCh = new HashMap<String, Integer>();
                    for (int j = 0; j < chCount; ++j) {
                        String id = buf.m_130277_();
                        int awarded = buf.readInt();
                        perCh.put(id, awarded);
                    }
                    ClientProgressionData.updateRankXProgress(entityType4, pts, daysSinceS, sessions, perCh);
                }
            }
            if (buf.readableBytes() > 0) {
                int esEntryCount = buf.readInt();
                LOGGER.debug("Processing {} ES points entries from sync", (Object)esEntryCount);
                for (int i = 0; i < esEntryCount; ++i) {
                    ResourceLocation entityTypeId = buf.m_130281_();
                    int points = buf.readInt();
                    int threshold = buf.readInt();
                    EntityType entityType5 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                    if (entityType5 != null) {
                        ClientProgressionData.updateESProgress(entityType5, points, threshold);
                        continue;
                    }
                    LOGGER.error("Unknown entity type in ES sync: {}", (Object)entityTypeId);
                }
            }
            LOGGER.debug("Finished processing progression sync packet");
        }
        catch (Exception e) {
            LOGGER.error("Error processing progression sync packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing sync packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleLootSync(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            int serverVersion = buf.readInt();
            boolean isFullSync = buf.readBoolean();
            int entryCount = buf.readInt();
            LOGGER.debug("Received loot sync packet v{} with {} entity types (fullSync={})", new Object[]{serverVersion, entryCount, isFullSync});
            clientLootVersion = serverVersion;
            ArrayList<String> updatedEntities = new ArrayList<String>();
            HashMap updates = new HashMap();
            for (int i = 0; i < entryCount; ++i) {
                ResourceLocation entityTypeId = buf.m_130281_();
                int lootEntryCount = buf.readInt();
                updatedEntities.add(entityTypeId.toString());
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                if (entityType == null) {
                    LOGGER.error("Unknown entity type in loot sync packet: {}", (Object)entityTypeId);
                    for (int j = 0; j < lootEntryCount; ++j) {
                        buf.m_130277_();
                        buf.readFloat();
                    }
                    continue;
                }
                LOGGER.debug("Processing loot data for entity {} with {} entries", (Object)entityTypeId, (Object)lootEntryCount);
                ArrayList<LootItemEntry> lootEntries = new ArrayList<LootItemEntry>();
                for (int j = 0; j < lootEntryCount; ++j) {
                    String itemId = buf.m_130277_();
                    float dropChance = buf.readFloat();
                    String displayNameStr = "";
                    try {
                        displayNameStr = buf.m_130277_();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ResourceLocation itemResourceLocation = ResourceLocation.m_135820_((String)itemId);
                    if (itemResourceLocation == null) {
                        LOGGER.error("Invalid item ID in loot sync packet: {}", (Object)itemId);
                        continue;
                    }
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemResourceLocation);
                    if (item == null) {
                        LOGGER.error("Unknown item in loot sync packet: {}", (Object)itemId);
                        continue;
                    }
                    ItemStack itemStack = new ItemStack((ItemLike)item);
                    Component displayName = displayNameStr != null && !displayNameStr.isEmpty() ? Component.m_237113_((String)displayNameStr) : itemStack.m_41786_();
                    LootItemEntry lootEntry = new LootItemEntry(itemStack, displayName, dropChance);
                    lootEntries.add(lootEntry);
                }
                updates.put(entityType, lootEntries);
            }
            Minecraft.m_91087_().execute(() -> {
                try {
                    if (isFullSync) {
                        if (entryCount > 0) {
                            LOGGER.info("Clearing client loot cache before applying full sync ({} entity types)", (Object)entryCount);
                            EntityDataProvider.clearCache();
                        } else {
                            LOGGER.warn("Received full loot sync with 0 entities; preserving current client loot cache");
                        }
                    }
                    for (Map.Entry e : updates.entrySet()) {
                        EntityDataProvider.updateLootCache((EntityType)e.getKey(), (List)e.getValue());
                    }
                    LOGGER.debug("Updated loot data for {} entities: {}", (Object)updatedEntities.size(), (Object)String.join((CharSequence)", ", updatedEntities));
                    LOGGER.debug("Finished processing loot sync packet (applied on main thread)");
                    BestiaryScreen.applyLootUpdates(updates, false);
                }
                catch (Exception ex) {
                    LOGGER.error("Error applying loot sync on main thread: {}", (Object)ex.getMessage(), (Object)ex);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing loot sync packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing loot sync packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendEntityViewedPacket(EntityType<?> entityType) {
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.m_91403_() != null) {
                minecraft.m_91403_().m_104955_((Packet)new ServerboundCustomPayloadPacket(PROGRESSION_VIEWED_CHANNEL, buf));
                LOGGER.debug("Sent entity viewed packet for entity {}", (Object)entityType.m_20675_());
            } else {
                LOGGER.error("Cannot send entity viewed packet: client connection is null");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error sending entity viewed packet: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void clearProcessedPackets() {
        processedToastPackets.clear();
        LOGGER.debug("Cleared processed toast packets");
    }

    @SubscribeEvent
    public static void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        PacketHandler.clearProcessedPackets();
        LOGGER.debug("Player logged out, cleared processed toast packets");
    }

    @SubscribeEvent
    public static void onPlayerRespawn(ClientPlayerNetworkEvent.Clone event) {
        PacketHandler.clearProcessedPackets();
        LOGGER.debug("Player respawned, cleared processed toast packets");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnLocationSync(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            int entryCount = buf.readInt();
            LOGGER.debug("Received spawn location sync packet with {} entity types", (Object)entryCount);
            BestiarySpawnLocationManager.clearCache();
            for (int i = 0; i < entryCount; ++i) {
                ResourceLocation entityTypeId = buf.m_130281_();
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                if (entityType == null) {
                    LOGGER.error("Unknown entity type in spawn location sync packet: {}", (Object)entityTypeId);
                    continue;
                }
                boolean override = buf.readBoolean();
                int locationCount = buf.readInt();
                LOGGER.debug("Processing spawn location data for entity {} with {} locations and override={}", new Object[]{entityTypeId, locationCount, override});
                ArrayList<Component> spawnLocations = new ArrayList<Component>();
                for (int j = 0; j < locationCount; ++j) {
                    MutableComponent location = Component.m_237115_((String)buf.m_130277_());
                    spawnLocations.add((Component)location);
                }
                SpawnLocationInfo spawnLocationInfo = new SpawnLocationInfo(spawnLocations, override);
                BestiarySpawnLocationManager.updateSpawnLocationCache(entityType, spawnLocationInfo);
            }
            LOGGER.debug("Finished processing spawn location sync packet");
            HashMap<EntityType, SpawnLocationInfo> uiUpdates = new HashMap<EntityType, SpawnLocationInfo>();
            for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
                SpawnLocationInfo info = BestiarySpawnLocationManager.getSpawnLocationsForEntity(et);
                if (info == null) continue;
                uiUpdates.put(et, info);
            }
            Minecraft.m_91087_().execute(() -> {
                BestiaryScreen.applySpawnLocationUpdates(uiUpdates);
                BestiaryScreen.onProgressionDataChanged();
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing spawn location sync packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing spawn location sync packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static void handleAttributeSync(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            int hiddenCount = buf.readInt();
            LOGGER.debug("Received attribute sync packet: {} hidden entities to apply", (Object)hiddenCount);
            HashSet hiddenSet = new HashSet();
            for (int i = 0; i < hiddenCount; ++i) {
                ResourceLocation hiddenId = buf.m_130281_();
                EntityType hiddenType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(hiddenId);
                if (hiddenType != null) {
                    hiddenSet.add(hiddenType);
                    continue;
                }
                LOGGER.warn("Unknown hidden entity id in packet: {}", (Object)hiddenId);
            }
            BestiaryAttributeManager.clearCache();
            BestiaryAttributeManager.setHiddenEntities(hiddenSet);
            int entryCount = buf.readInt();
            LOGGER.debug("Received attribute sync packet with {} entity types (after hidden set)", (Object)entryCount);
            for (int i = 0; i < entryCount; ++i) {
                boolean hasRankX;
                ResourceLocation entityTypeId = buf.m_130281_();
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                if (entityType == null) {
                    LOGGER.error("Unknown entity type in attribute sync packet: {}", (Object)entityTypeId);
                    continue;
                }
                int health = buf.readInt();
                int damage = buf.readInt();
                float knockbackResistance = buf.readFloat();
                int armor = buf.readInt();
                float armorToughness = buf.readFloat();
                float movementSpeed = buf.readFloat();
                int experience = buf.readInt();
                boolean override = buf.readBoolean();
                MutableComponent description = Component.m_237115_((String)buf.m_130277_());
                boolean boss = buf.readBoolean();
                LOGGER.debug("Processing attribute data for entity {} with health={}, damage={}, knockbackResistance={}, armor={}, armorToughness={}, movementSpeed={}, experience={}, override={}, description={}, boss={}", new Object[]{entityTypeId, health, damage, Float.valueOf(knockbackResistance), armor, Float.valueOf(armorToughness), Float.valueOf(movementSpeed), experience, override, description, boss});
                RankXConfig rankX = null;
                if (buf.readableBytes() > 0 && (hasRankX = buf.readBoolean())) {
                    int target = buf.readInt();
                    RankXConfig.GateConfig gates = null;
                    boolean hasGates = buf.readBoolean();
                    if (hasGates) {
                        int minDays = buf.readInt();
                        int minSessions = buf.readInt();
                        gates = new RankXConfig.GateConfig(minDays, minSessions);
                    }
                    int chCount = buf.readInt();
                    ArrayList<RankXConfig.Challenge> ch = new ArrayList<RankXConfig.Challenge>();
                    for (int j = 0; j < chCount; ++j) {
                        String id = buf.m_130277_();
                        int pts = buf.readInt();
                        int cap = buf.readInt();
                        ch.add(new RankXConfig.Challenge(id, pts, cap));
                    }
                    int disCount = buf.readInt();
                    ArrayList<String> dis = new ArrayList<String>();
                    for (int j = 0; j < disCount; ++j) {
                        dis.add(buf.m_130277_());
                    }
                    rankX = new RankXConfig(target, gates, ch, dis);
                }
                EntityAttributes attributes = new EntityAttributes(health, damage, knockbackResistance, armor, armorToughness, movementSpeed, experience, override, (Component)description, boss, rankX);
                BestiaryAttributeManager.updateAttributeCache(entityType, attributes);
            }
            EntityDataProvider.invalidateMonsterEntriesCache();
            LOGGER.debug("Finished processing attribute sync packet");
            HashMap<EntityType, EntityAttributes> uiUpdates = new HashMap<EntityType, EntityAttributes>();
            for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
                EntityAttributes at = BestiaryAttributeManager.getAttributesForEntity(et);
                if (at == null) continue;
                uiUpdates.put(et, at);
            }
            Minecraft.m_91087_().execute(() -> {
                BestiaryScreen.applyAttributeUpdates(uiUpdates);
                BestiaryScreen.onProgressionDataChanged();
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing attribute sync packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing attribute sync packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static void handleScanningProgress(NetworkEvent.ServerCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            ResourceLocation entityTypeId = buf.m_130281_();
            int currentTicks = buf.readInt();
            int maxTicks = buf.readInt();
            currentScanningTicks = currentTicks;
            maxScanningTicks = maxTicks;
            currentScannedEntity = entityTypeId;
            boolean completion = false;
            if (buf.readableBytes() > 0) {
                try {
                    completion = buf.readBoolean();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (completion) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11871_, (float)1.0f, (float)0.8f));
                lastScanSoundTime = System.currentTimeMillis();
                LOGGER.debug("Playing completion ping for entity {}", (Object)entityTypeId);
            } else {
                int soundInterval;
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastScanSoundTime > (long)(soundInterval = Math.max(50, 200 - currentTicks * 4))) {
                    float pitch = 0.8f + (float)currentTicks / (float)maxTicks * 0.7f;
                    float volume = 0.2f + (float)currentTicks / (float)maxTicks * 0.3f;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_144231_, (float)volume, (float)pitch));
                    lastScanSoundTime = currentTime;
                    LOGGER.debug("Playing scanning sound: progress={}/{}, pitch={}, volume={}", new Object[]{currentTicks, maxTicks, Float.valueOf(pitch), Float.valueOf(volume)});
                }
            }
            LOGGER.debug("Received scanning progress packet for entity {}: {}/{} ticks", new Object[]{entityTypeId, currentTicks, maxTicks});
        }
        catch (Exception e) {
            LOGGER.error("Error processing scanning progress packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing scanning progress packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    public static boolean isScanSoundRecentlyPlayed() {
        long now = System.currentTimeMillis();
        return currentScannedEntity != null && now - lastScanSoundTime < 120L;
    }

    static {
        processedToastPackets = new HashSet<String>();
        currentScanningTicks = 0;
        maxScanningTicks = 40;
        currentScannedEntity = null;
        lastScanSoundTime = 0L;
        clientLootVersion = 0;
    }
}

