/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.client.PacketHandler;
import com.mojang.logging.LogUtils;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary", value={Dist.CLIENT})
public class SpyglassParticleHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int particleTickCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_6117_()) {
            return;
        }
        ItemStack inUse = player.m_21211_();
        if (inUse.m_41619_() || !inUse.m_150930_(Items.f_151059_)) {
            return;
        }
        HitResult hitResult = player.m_19907_(100.0, 0.0f, false);
        double blockDistance = Double.MAX_VALUE;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 eyePos = player.m_146892_();
            blockDistance = hitResult.m_82450_().m_82554_(eyePos);
        }
        EntityHitResult bestEntityResult = null;
        double bestAlignment = 0.98;
        double bestDistance = Double.MAX_VALUE;
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        for (Entity e : player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(100.0))) {
            Vec3 entityPos;
            Vec3 toEntity;
            double entityDist;
            if (!(e instanceof LivingEntity) || (entityDist = (toEntity = (entityPos = e.m_20182_().m_82520_(0.0, (double)e.m_20206_() * 0.5, 0.0)).m_82546_(eyePos)).m_82553_()) > 100.0 || entityDist >= blockDistance) continue;
            double alignment = toEntity.m_82541_().m_82526_(lookVec);
            if (!player.m_142582_(e)) continue;
            if (alignment > bestAlignment) {
                bestAlignment = alignment;
                bestDistance = entityDist;
                bestEntityResult = new EntityHitResult(e);
                continue;
            }
            if (!(Math.abs(alignment - bestAlignment) <= 1.0E-6) || !(entityDist < bestDistance)) continue;
            bestDistance = entityDist;
            bestEntityResult = new EntityHitResult(e);
        }
        if (bestEntityResult == null) {
            return;
        }
        Entity targetEntity = bestEntityResult.m_82443_();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        if (!PacketHandler.isScanSoundRecentlyPlayed()) {
            return;
        }
        SpyglassParticleHandler.spawnEnchantParticles((Level)mc.f_91073_, (LivingEntity)targetEntity);
    }

    private static void spawnEnchantParticles(Level level, LivingEntity entity) {
        ++particleTickCounter;
        double w = Math.max(0.6, (double)entity.m_20205_());
        double h = Math.max(0.9, (double)entity.m_20206_());
        int baseCount = 6 + Mth.m_14143_((float)((float)(w * 2.0)));
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        double cx = entity.m_20185_();
        double cy = entity.m_20186_() + h * 0.6;
        double cz = entity.m_20189_();
        double radius = Math.max(0.6, w * 0.7);
        for (int i = 0; i < baseCount; ++i) {
            double angle = rnd.nextDouble() * Math.PI * 2.0;
            double r = radius + rnd.nextDouble() * 0.3;
            double px = cx + Math.cos(angle) * r;
            double pz = cz + Math.sin(angle) * r;
            double py = cy + (rnd.nextDouble() - 0.5) * (h * 0.3);
            double vx = (cx - px) * 0.05 + (rnd.nextDouble() - 0.5) * 0.02;
            double vy = (cy - py) * 0.05 + rnd.nextDouble() * 0.02;
            double vz = (cz - pz) * 0.05 + (rnd.nextDouble() - 0.5) * 0.02;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, px, py, pz, vx, vy, vz);
        }
    }
}

