/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.config;

import com.araxer.araxers_bestiary.client.gui.BestiaryScreen;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="araxers_bestiary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_PROGRESSION_SYSTEM = BUILDER.comment("Enable the progression system where entity information is gradually revealed as you progress").define("enableProgressionSystem", true);
    private static final ForgeConfigSpec.ConfigValue<String> PROGRESSION_SYSTEM_TYPE_VALUE = BUILDER.comment("Type of progression system to use: \"kills\" (original system based on kill count), \"ranks\" (rank-based system with chance to increase rank), or \"sighting\" (allows full discovery of entities with a spyglass)").define("progressionSystemType", (Object)"ranks");
    private static final ForgeConfigSpec.IntValue SPAWN_LOCATION_THRESHOLD_VALUE = BUILDER.comment("Number of kills required to unlock spawn locations").defineInRange("spawnLocationThreshold", 10, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue LOOT_ICON_THRESHOLD_VALUE = BUILDER.comment("Number of kills required to unlock loot icons").defineInRange("lootIconThreshold", 20, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue LOOT_CHANCE_THRESHOLD_VALUE = BUILDER.comment("Number of kills required to unlock loot drop chances").defineInRange("lootChanceThreshold", 50, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue ADVANCED_ATTRIBUTES_THRESHOLD_VALUE = BUILDER.comment("Number of kills required to unlock advanced attributes (knockback resistance, armor, movement speed)").defineInRange("advancedAttributesThreshold", 30, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue DESCRIPTION_THRESHOLD_VALUE = BUILDER.comment("Number of kills required to unlock entity descriptions").defineInRange("descriptionThreshold", 40, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.DoubleValue RANK_KILL_CHANCE_VALUE = BUILDER.comment("Base chance (0.0-1.0) to increase rank when killing an entity (used when esMode = 'chance')").defineInRange("rankKillChance", 0.15, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_FEED_CHANCE_VALUE = BUILDER.comment("Base chance (0.0-1.0) to increase rank when feeding an entity (used when esMode = 'chance')").defineInRange("rankFeedChance", 0.03, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_HIT_CHANCE_VALUE = BUILDER.comment("Base chance (0.0-1.0) to increase rank when hitting an entity (used when esMode = 'chance')").defineInRange("rankHitChance", 0.01, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_TRADE_CHANCE_VALUE = BUILDER.comment("Base chance (0.0-1.0) to increase rank when trading with a villager (used when esMode = 'chance')").defineInRange("rankTradeChance", 0.1, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue COMMAND_ROLLS_VALUE = BUILDER.comment("Chance (0.0-1.0) used by the /bestiary rank roll command to apply a rolled rank").defineInRange("commandRolls", 0.15, 0.0, 1.0);
    private static final ForgeConfigSpec.DoubleValue BOSS_RANK_MULTIPLIER_VALUE = BUILDER.comment("Multiplier for rank increase chance when interacting with boss entities (higher value = easier) - chance mode only").defineInRange("bossRankMultiplier", 3.0, 1.0, 10.0);
    private static final ForgeConfigSpec.ConfigValue<String> ES_MODE_VALUE = BUILDER.comment("E\u2192S progression mode: 'chance' (existing behavior) or 'points' (deterministic points)").define("esMode", (Object)"points");
    private static final ForgeConfigSpec.IntValue POINTS_E_TO_D_VALUE = BUILDER.comment("Points required to advance from E to D (points mode)").defineInRange("pointsEToD", 10, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_D_TO_C_VALUE = BUILDER.comment("Points required to advance from D to C (points mode)").defineInRange("pointsDToC", 20, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_C_TO_B_VALUE = BUILDER.comment("Points required to advance from C to B (points mode)").defineInRange("pointsCToB", 30, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_B_TO_A_VALUE = BUILDER.comment("Points required to advance from B to A (points mode)").defineInRange("pointsBToA", 40, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_A_TO_S_VALUE = BUILDER.comment("Points required to advance from A to S (points mode)").defineInRange("pointsAToS", 50, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_KILL_VALUE = BUILDER.comment("Points awarded on killing an entity (points mode)").defineInRange("pointsKill", 3, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_FEED_VALUE = BUILDER.comment("Points awarded on feeding an entity (points mode)").defineInRange("pointsFeed", 1, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_HIT_VALUE = BUILDER.comment("Points awarded on hitting an entity (points mode)").defineInRange("pointsHit", 0, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_TRADE_VALUE = BUILDER.comment("Points awarded on trading with a villager (points mode)").defineInRange("pointsTrade", 2, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_BREED_VALUE = BUILDER.comment("Points awarded on breeding (points mode)").defineInRange("pointsBreed", 2, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_OBSERVE_VALUE = BUILDER.comment("Points awarded on observing with spyglass (points mode)").defineInRange("pointsObserve", 5, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_TAME_VALUE = BUILDER.comment("Points awarded on taming (points mode)").defineInRange("pointsTame", 4, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue POINTS_SPECIAL_BIOME_VALUE = BUILDER.comment("Points awarded for special biome (points mode, reserved)").defineInRange("pointsSpecialBiome", 0, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.DoubleValue POINTS_BOSS_MULTIPLIER_VALUE = BUILDER.comment("Multiplier applied to point awards when the context entity is a boss (points mode)").defineInRange("pointsBossMultiplier", 2.0, 0.0, 100.0);
    private static final ForgeConfigSpec.BooleanValue ENABLE_PROGRESSIVE_RANK_DIFFICULTY_VALUE = BUILDER.comment("Enable progressive rank difficulty (higher ranks are harder to achieve)").define("enableProgressiveRankDifficulty", true);
    private static final ForgeConfigSpec.DoubleValue RANK_D_DIFFICULTY_MULTIPLIER_VALUE = BUILDER.comment("Difficulty multiplier for rank D (lower value = harder)").defineInRange("rankDDifficultyMultiplier", 0.4, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_C_DIFFICULTY_MULTIPLIER_VALUE = BUILDER.comment("Difficulty multiplier for rank C (lower value = harder)").defineInRange("rankCDifficultyMultiplier", 0.3, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_B_DIFFICULTY_MULTIPLIER_VALUE = BUILDER.comment("Difficulty multiplier for rank B (lower value = harder)").defineInRange("rankBDifficultyMultiplier", 0.2, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_A_DIFFICULTY_MULTIPLIER_VALUE = BUILDER.comment("Difficulty multiplier for rank A (lower value = harder)").defineInRange("rankADifficultyMultiplier", 0.1, 0.01, 1.0);
    private static final ForgeConfigSpec.DoubleValue RANK_S_DIFFICULTY_MULTIPLIER_VALUE = BUILDER.comment("Difficulty multiplier for rank S (lower value = harder)").defineInRange("rankSDifficultyMultiplier", 0.05, 0.01, 1.0);
    private static final ForgeConfigSpec.ConfigValue<String> SPAWN_LOCATION_RANK_VALUE = BUILDER.comment("Minimum rank required to unlock spawn locations (E, D, C, B, A, S)").define("spawnLocationRank", (Object)"D");
    private static final ForgeConfigSpec.ConfigValue<String> LOOT_ICON_RANK_VALUE = BUILDER.comment("Minimum rank required to unlock loot icons (E, D, C, B, A, S)").define("lootIconRank", (Object)"C");
    private static final ForgeConfigSpec.ConfigValue<String> LOOT_CHANCE_RANK_VALUE = BUILDER.comment("Minimum rank required to unlock loot drop chances (E, D, C, B, A, S)").define("lootChanceRank", (Object)"A");
    private static final ForgeConfigSpec.ConfigValue<String> ADVANCED_ATTRIBUTES_RANK_VALUE = BUILDER.comment("Minimum rank required to unlock advanced attributes (E, D, C, B, A, S)").define("advancedAttributesRank", (Object)"B");
    private static final ForgeConfigSpec.ConfigValue<String> DESCRIPTION_RANK_VALUE = BUILDER.comment("Minimum rank required to unlock entity descriptions (E, D, C, B, A, S)").define("descriptionRank", (Object)"B");
    private static final ForgeConfigSpec.IntValue RANK_E_WEIGHT_VALUE = BUILDER.comment("Weight for rank E when discovering new entities (higher value = more common)").defineInRange("rankEWeight", 150, 0, 1000);
    private static final ForgeConfigSpec.IntValue RANK_D_WEIGHT_VALUE = BUILDER.comment("Weight for rank D when discovering new entities (higher value = more common)").defineInRange("rankDWeight", 50, 0, 1000);
    private static final ForgeConfigSpec.IntValue RANK_C_WEIGHT_VALUE = BUILDER.comment("Weight for rank C when discovering new entities (higher value = more common)").defineInRange("rankCWeight", 25, 0, 1000);
    private static final ForgeConfigSpec.IntValue RANK_B_WEIGHT_VALUE = BUILDER.comment("Weight for rank B when discovering new entities (higher value = more common)").defineInRange("rankBWeight", 15, 0, 1000);
    private static final ForgeConfigSpec.IntValue RANK_A_WEIGHT_VALUE = BUILDER.comment("Weight for rank A when discovering new entities (higher value = more common)").defineInRange("rankAWeight", 10, 0, 1000);
    private static final ForgeConfigSpec.IntValue RANK_S_WEIGHT_VALUE = BUILDER.comment("Weight for rank S when discovering new entities (higher value = more common)").defineInRange("rankSWeight", 2, 0, 1000);
    private static final ForgeConfigSpec.BooleanValue HIDE_ZERO_KILL_ENTITIES_VALUE = BUILDER.comment("Hide entities with 0 kills when progression system is enabled (for kill-based progression)").define("hideZeroKillEntities", false);
    private static final ForgeConfigSpec.BooleanValue HIDE_NO_RANK_ENTITIES_VALUE = BUILDER.comment("Hide entities with no rank when progression system is enabled (for rank-based progression)").define("hideNoRankEntities", false);
    private static final ForgeConfigSpec.BooleanValue FORCE_OBFUSCATION = BUILDER.comment("Forces the obfuscation of entities when progression system is enabled (if ranks are none or kills are 0)").define("forceObfuscation", false);
    private static final ForgeConfigSpec.BooleanValue HIDE_UNDISCOVERED_VALUE = BUILDER.comment("Hide undiscovered entities completely instead of showing them obfuscated").define("hideUndiscovered", false);
    private static final ForgeConfigSpec.BooleanValue DEBUG_MODE = BUILDER.comment("Enables the debug mode (for development purposes only)").define("debugMode", false);
    private static final ForgeConfigSpec.BooleanValue SHOW_CHALLENGES = BUILDER.comment("Enables the Challenges page in the bestiary for rank x progression").define("showChallenges", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_CHEESE_DETECTION = BUILDER.comment("Enable Rank-X boss 'cheese' detection (beds, end crystals, respawn anchors). If false, disallowedCheese from datapacks are ignored.").define("enableCheeseDetection", true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MONSTER_CATEGORIES_VALUE = BUILDER.comment("List of mob categories to be considered as monsters (all categories: \"monster\", \"creature\", \"water_creature\", \"underground_water_creature\", \"ambient\", \"water_ambient\", \"axolotls\", \"misc\")").defineList("monsterCategories", List.of(), s -> s instanceof String);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_BLACKLIST_VALUE = BUILDER.comment("List of entities that should not be shown in the bestiary (format: \"minecraft:sheep\")").defineList("entityBlacklist", Arrays.asList("minecraft:armor_stand"), s -> s instanceof String);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_INCLUDELIST_VALUE = BUILDER.comment("List of entities that should be prioritized and included in the bestiary regardless of their category (format: \"minecraft:sheep\")").defineList("entityIncludeList", Arrays.asList(new String[0]), s -> s instanceof String);
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> GLOBAL_S_RANK_THRESHOLDS_VALUE = BUILDER.comment("Thresholds for total S-ranked entities to advance global progression. Progress fills between consecutive values. Default: [50]").defineList("globalSRankThresholds", Arrays.asList(50), o -> o instanceof Integer);
    private static final ForgeConfigSpec.ConfigValue<String> GLOBAL_RANK_PROGRESS_BAR_TYPE_VALUE = BUILDER.comment("Which global progress bar to display under the entity list: \"S\" for S-ranks (>= S), or \"X\" for X-ranks. Default: S").define("globalRankProgressBarType", (Object)"S");
    private static final ForgeConfigSpec.BooleanValue ENABLE_GLOBAL_RANK_PROGRESS_BAR_CYCLING = BUILDER.comment("If true, clicking the global progress bar cycles between S and X. Default: true").define("enableGlobalRankProgressBarCycling", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_KEYBIND_VALUE = BUILDER.comment("Enable the keybind to open the bestiary screen").define("enableKeybind", true);
    private static final ForgeConfigSpec.IntValue INITIAL_LOOT_SAMPLE_BATCHES_VALUE = BUILDER.comment("Number of random loot sampling iterations used to estimate initial drop chances from loot tables (higher = more accurate, slower). Applies to initial generation before dynamic refinement.").defineInRange("initialLootSampleBatches", 300, 50, 2000);
    private static final ForgeConfigSpec.BooleanValue PREWARM_LOOT_CACHE_ON_START_VALUE = BUILDER.comment("If true, gradually prewarm the loot cache over ticks after server start; if false, loot is generated lazily on demand").define("prewarmLootCacheOnStart", false);
    private static final ForgeConfigSpec.IntValue PREWARM_MAX_ENTITIES_PER_TICK_VALUE = BUILDER.comment("Maximum number of entities to prewarm per server tick when prewarmLootCacheOnStart is enabled").defineInRange("prewarmMaxEntitiesPerTick", 50, 1, 500);
    private static final ForgeConfigSpec.BooleanValue ENABLE_DYNAMIC_DROP_TRACKING_VALUE = BUILDER.comment("Enable tracking of actual entity drops to enhance loot information").define("enableDynamicDropTracking", true);
    private static final ForgeConfigSpec.IntValue DYNAMIC_DROP_SAMPLE_SIZE_VALUE = BUILDER.comment("Number of drop events to track before calculating drop chances (higher value means more accurate chances)").defineInRange("dynamicDropSampleSize", 50, 10, 1000);
    private static final ForgeConfigSpec.DoubleValue DYNAMIC_DROP_WEIGHT_VALUE = BUILDER.comment("Weight given to dynamic drops vs. loot table entries (0.0 = only use loot tables, 1.0 = only use dynamic drops)").defineInRange("dynamicDropWeight", 0.7, 0.0, 1.0);
    private static final ForgeConfigSpec.BooleanValue IGNORE_MODIFIED_DROP_EVENTS_VALUE = BUILDER.comment("Ignore recording drops if killer's tool or enchantments may have modified the drops (e.g., Looting, Fire Aspect)").define("ignoreModifiedDropEvents", true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MODIFIED_DROP_ENCHANTMENTS_VALUE = BUILDER.comment("When ignoreModifiedDropEvents is true: If this list is non-empty, only ignore drop events when the killer's held item has any enchantment from this list (e.g., \"minecraft:looting\"). If empty, any enchantment on the held item will cause the event to be ignored.").defineList("modifiedDropEnchantments", Arrays.asList("minecraft:looting", "minecraft:fire_aspect"), s -> s instanceof String);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean enableProgressionSystem;
    public static String progressionSystemType;
    public static int initialLootSampleBatches;
    public static int spawnLocationThreshold;
    public static int lootIconThreshold;
    public static int lootChanceThreshold;
    public static int advancedAttributesThreshold;
    public static int descriptionThreshold;
    public static double rankKillChance;
    public static double rankFeedChance;
    public static double rankHitChance;
    public static double rankTradeChance;
    public static double commandRolls;
    public static double bossRankMultiplier;
    public static String spawnLocationRank;
    public static String lootIconRank;
    public static String lootChanceRank;
    public static String advancedAttributesRank;
    public static String descriptionRank;
    public static String esMode;
    public static int pointsEToD;
    public static int pointsDToC;
    public static int pointsCToB;
    public static int pointsBToA;
    public static int pointsAToS;
    public static int pointsKill;
    public static int pointsFeed;
    public static int pointsHit;
    public static int pointsTrade;
    public static int pointsBreed;
    public static int pointsObserve;
    public static int pointsTame;
    public static int pointsSpecialBiome;
    public static double pointsBossMultiplier;
    public static boolean enableProgressiveRankDifficulty;
    public static double rankDDifficultyMultiplier;
    public static double rankCDifficultyMultiplier;
    public static double rankBDifficultyMultiplier;
    public static double rankADifficultyMultiplier;
    public static double rankSDifficultyMultiplier;
    public static int rankEWeight;
    public static int rankDWeight;
    public static int rankCWeight;
    public static int rankBWeight;
    public static int rankAWeight;
    public static int rankSWeight;
    public static boolean debugMode;
    public static boolean showChallenges;
    public static boolean enableCheeseDetection;
    public static boolean hideZeroKillEntities;
    public static boolean hideNoRankEntities;
    public static boolean forceObfuscation;
    public static boolean hideUndiscovered;
    public static List<String> monsterCategories;
    public static List<String> entityBlacklist;
    public static List<String> entityIncludeList;
    public static boolean enableKeybind;
    public static boolean prewarmLootCacheOnStart;
    public static int prewarmMaxEntitiesPerTick;
    public static boolean enableDynamicDropTracking;
    public static int dynamicDropSampleSize;
    public static double dynamicDropWeight;
    public static boolean ignoreModifiedDropEvents;
    public static List<String> modifiedDropEnchantments;
    public static List<Integer> globalSRankThresholds;
    public static String globalRankProgressBarType;
    public static boolean enableGlobalRankProgressBarCycling;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        enableProgressionSystem = (Boolean)ENABLE_PROGRESSION_SYSTEM.get();
        progressionSystemType = (String)PROGRESSION_SYSTEM_TYPE_VALUE.get();
        spawnLocationThreshold = (Integer)SPAWN_LOCATION_THRESHOLD_VALUE.get();
        lootIconThreshold = (Integer)LOOT_ICON_THRESHOLD_VALUE.get();
        lootChanceThreshold = (Integer)LOOT_CHANCE_THRESHOLD_VALUE.get();
        advancedAttributesThreshold = (Integer)ADVANCED_ATTRIBUTES_THRESHOLD_VALUE.get();
        descriptionThreshold = (Integer)DESCRIPTION_THRESHOLD_VALUE.get();
        rankKillChance = (Double)RANK_KILL_CHANCE_VALUE.get();
        rankFeedChance = (Double)RANK_FEED_CHANCE_VALUE.get();
        rankHitChance = (Double)RANK_HIT_CHANCE_VALUE.get();
        rankTradeChance = (Double)RANK_TRADE_CHANCE_VALUE.get();
        commandRolls = (Double)COMMAND_ROLLS_VALUE.get();
        bossRankMultiplier = (Double)BOSS_RANK_MULTIPLIER_VALUE.get();
        spawnLocationRank = (String)SPAWN_LOCATION_RANK_VALUE.get();
        lootIconRank = (String)LOOT_ICON_RANK_VALUE.get();
        lootChanceRank = (String)LOOT_CHANCE_RANK_VALUE.get();
        advancedAttributesRank = (String)ADVANCED_ATTRIBUTES_RANK_VALUE.get();
        descriptionRank = (String)DESCRIPTION_RANK_VALUE.get();
        enableProgressiveRankDifficulty = (Boolean)ENABLE_PROGRESSIVE_RANK_DIFFICULTY_VALUE.get();
        rankDDifficultyMultiplier = (Double)RANK_D_DIFFICULTY_MULTIPLIER_VALUE.get();
        rankCDifficultyMultiplier = (Double)RANK_C_DIFFICULTY_MULTIPLIER_VALUE.get();
        rankBDifficultyMultiplier = (Double)RANK_B_DIFFICULTY_MULTIPLIER_VALUE.get();
        rankADifficultyMultiplier = (Double)RANK_A_DIFFICULTY_MULTIPLIER_VALUE.get();
        rankSDifficultyMultiplier = (Double)RANK_S_DIFFICULTY_MULTIPLIER_VALUE.get();
        rankEWeight = (Integer)RANK_E_WEIGHT_VALUE.get();
        rankDWeight = (Integer)RANK_D_WEIGHT_VALUE.get();
        rankCWeight = (Integer)RANK_C_WEIGHT_VALUE.get();
        rankBWeight = (Integer)RANK_B_WEIGHT_VALUE.get();
        rankAWeight = (Integer)RANK_A_WEIGHT_VALUE.get();
        rankSWeight = (Integer)RANK_S_WEIGHT_VALUE.get();
        esMode = (String)ES_MODE_VALUE.get();
        pointsEToD = (Integer)POINTS_E_TO_D_VALUE.get();
        pointsDToC = (Integer)POINTS_D_TO_C_VALUE.get();
        pointsCToB = (Integer)POINTS_C_TO_B_VALUE.get();
        pointsBToA = (Integer)POINTS_B_TO_A_VALUE.get();
        pointsAToS = (Integer)POINTS_A_TO_S_VALUE.get();
        pointsKill = (Integer)POINTS_KILL_VALUE.get();
        pointsFeed = (Integer)POINTS_FEED_VALUE.get();
        pointsHit = (Integer)POINTS_HIT_VALUE.get();
        pointsTrade = (Integer)POINTS_TRADE_VALUE.get();
        pointsBreed = (Integer)POINTS_BREED_VALUE.get();
        pointsObserve = (Integer)POINTS_OBSERVE_VALUE.get();
        pointsTame = (Integer)POINTS_TAME_VALUE.get();
        pointsSpecialBiome = (Integer)POINTS_SPECIAL_BIOME_VALUE.get();
        pointsBossMultiplier = (Double)POINTS_BOSS_MULTIPLIER_VALUE.get();
        debugMode = (Boolean)DEBUG_MODE.get();
        showChallenges = (Boolean)SHOW_CHALLENGES.get();
        enableCheeseDetection = (Boolean)ENABLE_CHEESE_DETECTION.get();
        hideZeroKillEntities = (Boolean)HIDE_ZERO_KILL_ENTITIES_VALUE.get();
        forceObfuscation = (Boolean)FORCE_OBFUSCATION.get();
        hideNoRankEntities = (Boolean)HIDE_NO_RANK_ENTITIES_VALUE.get();
        hideUndiscovered = (Boolean)HIDE_UNDISCOVERED_VALUE.get();
        monsterCategories = new ArrayList<String>((Collection)MONSTER_CATEGORIES_VALUE.get());
        entityBlacklist = new ArrayList<String>((Collection)ENTITY_BLACKLIST_VALUE.get());
        entityIncludeList = new ArrayList<String>((Collection)ENTITY_INCLUDELIST_VALUE.get());
        enableKeybind = (Boolean)ENABLE_KEYBIND_VALUE.get();
        initialLootSampleBatches = (Integer)INITIAL_LOOT_SAMPLE_BATCHES_VALUE.get();
        prewarmLootCacheOnStart = (Boolean)PREWARM_LOOT_CACHE_ON_START_VALUE.get();
        prewarmMaxEntitiesPerTick = (Integer)PREWARM_MAX_ENTITIES_PER_TICK_VALUE.get();
        enableDynamicDropTracking = (Boolean)ENABLE_DYNAMIC_DROP_TRACKING_VALUE.get();
        dynamicDropSampleSize = (Integer)DYNAMIC_DROP_SAMPLE_SIZE_VALUE.get();
        dynamicDropWeight = (Double)DYNAMIC_DROP_WEIGHT_VALUE.get();
        ignoreModifiedDropEvents = (Boolean)IGNORE_MODIFIED_DROP_EVENTS_VALUE.get();
        modifiedDropEnchantments = new ArrayList<String>((Collection)MODIFIED_DROP_ENCHANTMENTS_VALUE.get());
        try {
            List raw = (List)GLOBAL_S_RANK_THRESHOLDS_VALUE.get();
            globalSRankThresholds = new ArrayList<Integer>();
            if (raw != null) {
                for (Integer v : raw) {
                    if (v == null || v <= 0) continue;
                    globalSRankThresholds.add(v);
                }
            }
            if (globalSRankThresholds.isEmpty()) {
                globalSRankThresholds.add(50);
            }
            Collections.sort(globalSRankThresholds);
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(globalSRankThresholds);
            globalSRankThresholds.clear();
            globalSRankThresholds.addAll(set);
        }
        catch (Exception e) {
            globalSRankThresholds = new ArrayList<Integer>();
            globalSRankThresholds.add(50);
        }
        try {
            globalRankProgressBarType = (String)GLOBAL_RANK_PROGRESS_BAR_TYPE_VALUE.get();
            if (globalRankProgressBarType == null) {
                globalRankProgressBarType = "S";
            }
        }
        catch (Exception e) {
            globalRankProgressBarType = "S";
        }
        try {
            enableGlobalRankProgressBarCycling = (Boolean)ENABLE_GLOBAL_RANK_PROGRESS_BAR_CYCLING.get();
        }
        catch (Exception e) {
            enableGlobalRankProgressBarCycling = true;
        }
        if (event.getConfig().getModId().equals("araxers_bestiary")) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Config.refreshBestiaryScreen());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void refreshBestiaryScreen() {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ instanceof BestiaryScreen) {
                minecraft.execute(() -> minecraft.m_91152_((Screen)new BestiaryScreen()));
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Error refreshing bestiary screen: {}", (Object)e.getMessage());
        }
    }
}

