/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.EntityAttributes;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.RankESConfig;
import com.araxer.araxers_bestiary.data.RankUtils;
import com.araxer.araxers_bestiary.data.RankXConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary")
public class BestiaryAttributeManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FOLDER_PATH = "bestiary";
    private static Map<EntityType<?>, EntityAttributes> attributesMap = new HashMap();
    private static Set<EntityType<?>> hiddenEntities = new HashSet();
    private static Map<EntityType<?>, RankESConfig> esConfigMap = new HashMap();
    private static final RankXConfig DEFAULT_RANKX = new RankXConfig(45, new RankXConfig.GateConfig(0, 0), List.of(new RankXConfig.Challenge("observe", 5, 25), new RankXConfig.Challenge("biome_diversity", 10, 20)), Collections.emptyList());

    private static EntityAttributes withDefaultRankX(EntityAttributes base) {
        if (base == null) {
            return new EntityAttributes(20, 2, 0.0f, 0, 0.0f, 0.3f, 0, false, null, false, DEFAULT_RANKX);
        }
        if (base.rankX() == null) {
            return new EntityAttributes(base.health(), base.damage(), base.knockbackResistance(), base.armor(), base.armorToughness(), base.movementSpeed(), base.experience(), base.override(), base.description(), base.boss(), DEFAULT_RANKX);
        }
        return base;
    }

    public BestiaryAttributeManager() {
        super(GSON, FOLDER_PATH);
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BestiaryAttributeManager());
        LOGGER.debug("Registered bestiary attribute manager as resource reload listener");
    }

    public static EntityAttributes getAttributesForEntity(EntityType<?> entityType) {
        if (entityType == null) {
            return null;
        }
        EntityAttributes attributes = attributesMap.get(entityType);
        return BestiaryAttributeManager.withDefaultRankX(attributes);
    }

    public static boolean hasAttributesForEntity(EntityType<?> entityType) {
        return attributesMap.containsKey(entityType);
    }

    public static boolean isEntityHidden(EntityType<?> entityType) {
        return hiddenEntities.contains(entityType);
    }

    public static void clearCache() {
        attributesMap.clear();
        hiddenEntities.clear();
        LOGGER.debug("BestiaryAttributeManager cache cleared.");
    }

    public static void setHiddenEntities(Set<EntityType<?>> entities) {
        hiddenEntities.clear();
        if (entities != null) {
            hiddenEntities.addAll(entities);
        }
        LOGGER.debug("Updated hidden entities set from server: {} entries", (Object)hiddenEntities.size());
    }

    public static void updateAttributeCache(EntityType<?> entityType, EntityAttributes attributes) {
        if (attributes != null) {
            attributesMap.put(entityType, attributes);
            LOGGER.debug("Updated attribute cache for {} with health={}, damage={}, knockbackResistance={}, armor={}, armorToughness={}, movementSpeed={}, override={}, description={}", new Object[]{entityType.m_20676_().getString(), attributes.health(), attributes.damage(), Float.valueOf(attributes.knockbackResistance()), attributes.armor(), Float.valueOf(attributes.armorToughness()), Float.valueOf(attributes.movementSpeed()), attributes.override(), attributes.description() != null && !attributes.description().getString().isEmpty() ? "present" : "empty"});
        } else {
            LOGGER.warn("Attempted to update attribute cache with null attributes for {}", (Object)entityType.m_20676_().getString());
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.debug("Loading bestiary attribute data from data packs");
        attributesMap.clear();
        hiddenEntities.clear();
        esConfigMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceMap.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            try {
                String path = resourceLocation.m_135815_();
                String[] pathParts = path.split("/");
                if (pathParts.length != 2) {
                    LOGGER.warn("Invalid bestiary file path: {}", (Object)path);
                    continue;
                }
                String entityNamespace = pathParts[0];
                String entityPath = pathParts[1].replace(".json", "");
                ResourceLocation entityId = ResourceLocation.m_135820_((String)(entityNamespace + ":" + entityPath));
                if (entityId == null) {
                    LOGGER.warn("Invalid entity ID built from path: {}/{}", (Object)entityNamespace, (Object)entityPath);
                    continue;
                }
                LOGGER.debug("Processing entity file: {} with path: {}", (Object)resourceLocation, (Object)path);
                LOGGER.debug("Extracted entity ID: {}", (Object)entityId);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
                if (entityType == null) {
                    LOGGER.warn("Unknown entity type: {}", (Object)entityId);
                    LOGGER.debug("Failed to find entity type for ID: {}", (Object)entityId);
                    continue;
                }
                LOGGER.debug("Found entity type: {} for ID: {}", (Object)entityType.m_20676_().getString(), (Object)entityId);
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                boolean hidden = false;
                try {
                    if (jsonObject.has("hidden") && jsonObject.get("hidden").isJsonPrimitive()) {
                        hidden = jsonObject.get("hidden").getAsBoolean();
                    }
                    if (!hidden && jsonObject.has("bestiary_hidden") && jsonObject.get("bestiary_hidden").isJsonPrimitive()) {
                        hidden = jsonObject.get("bestiary_hidden").getAsBoolean();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (hidden) {
                    hiddenEntities.add(entityType);
                    LOGGER.debug("Entity {} is marked hidden via datapack and will not be shown in the bestiary", (Object)entityId);
                }
                EntityAttributes attributes = this.parseAttributes(jsonObject);
                try {
                    if (jsonObject.has("rankProgression") && jsonObject.get("rankProgression").isJsonObject()) {
                        JsonObject rp = jsonObject.getAsJsonObject("rankProgression");
                        String mode = rp.has("mode") && rp.get("mode").isJsonPrimitive() ? rp.get("mode").getAsString() : null;
                        RankESConfig.Points pts = null;
                        if (rp.has("points") && rp.get("points").isJsonObject()) {
                            JsonObject p = rp.getAsJsonObject("points");
                            HashMap<String, Integer> thresholds = new HashMap<String, Integer>();
                            HashMap<String, Integer> values = new HashMap<String, Integer>();
                            double bossMult = Config.pointsBossMultiplier;
                            if (p.has("thresholds") && p.get("thresholds").isJsonObject()) {
                                JsonObject t = p.getAsJsonObject("thresholds");
                                if (t.has("E_to_D") && t.get("E_to_D").isJsonPrimitive()) {
                                    thresholds.put("E_to_D", Math.max(1, t.get("E_to_D").getAsInt()));
                                }
                                if (t.has("D_to_C") && t.get("D_to_C").isJsonPrimitive()) {
                                    thresholds.put("D_to_C", Math.max(1, t.get("D_to_C").getAsInt()));
                                }
                                if (t.has("C_to_B") && t.get("C_to_B").isJsonPrimitive()) {
                                    thresholds.put("C_to_B", Math.max(1, t.get("C_to_B").getAsInt()));
                                }
                                if (t.has("B_to_A") && t.get("B_to_A").isJsonPrimitive()) {
                                    thresholds.put("B_to_A", Math.max(1, t.get("B_to_A").getAsInt()));
                                }
                                if (t.has("A_to_S") && t.get("A_to_S").isJsonPrimitive()) {
                                    thresholds.put("A_to_S", Math.max(1, t.get("A_to_S").getAsInt()));
                                }
                            }
                            if (p.has("values") && p.get("values").isJsonObject()) {
                                JsonObject v = p.getAsJsonObject("values");
                                if (v.has("kill") && v.get("kill").isJsonPrimitive()) {
                                    values.put("kill", Math.max(0, v.get("kill").getAsInt()));
                                }
                                if (v.has("feed") && v.get("feed").isJsonPrimitive()) {
                                    values.put("feed", Math.max(0, v.get("feed").getAsInt()));
                                }
                                if (v.has("trade") && v.get("trade").isJsonPrimitive()) {
                                    values.put("trade", Math.max(0, v.get("trade").getAsInt()));
                                }
                                if (v.has("hit") && v.get("hit").isJsonPrimitive()) {
                                    values.put("hit", Math.max(0, v.get("hit").getAsInt()));
                                }
                                if (v.has("breed") && v.get("breed").isJsonPrimitive()) {
                                    values.put("breed", Math.max(0, v.get("breed").getAsInt()));
                                }
                                if (v.has("observe") && v.get("observe").isJsonPrimitive()) {
                                    values.put("observe", Math.max(0, v.get("observe").getAsInt()));
                                }
                                if (v.has("tame") && v.get("tame").isJsonPrimitive()) {
                                    values.put("tame", Math.max(0, v.get("tame").getAsInt()));
                                }
                                if (v.has("special_biome") && v.get("special_biome").isJsonPrimitive()) {
                                    values.put("special_biome", Math.max(0, v.get("special_biome").getAsInt()));
                                }
                            }
                            if (p.has("boss_multiplier") && p.get("boss_multiplier").isJsonPrimitive()) {
                                bossMult = Math.max(0.0, p.get("boss_multiplier").getAsDouble());
                            }
                            pts = new RankESConfig.Points(thresholds, values, bossMult);
                        }
                        RankESConfig esCfg = new RankESConfig(mode, pts);
                        esConfigMap.put(entityType, esCfg);
                        LOGGER.debug("Parsed rankProgression for {}: mode={}, thresholds={}, values={}, bossMult={}", new Object[]{entityId, esCfg.mode, esCfg.points != null ? esCfg.points.thresholds : Collections.emptyMap(), esCfg.points != null ? esCfg.points.values : Collections.emptyMap(), esCfg.points != null ? esCfg.points.bossMultiplier : Config.pointsBossMultiplier});
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to parse rankProgression: {}", (Object)ex.getMessage());
                }
                if (attributes == null) continue;
                attributesMap.put(entityType, attributes);
                LOGGER.debug("Loaded attributes for entity {}: health={}, damage={}, knockbackResistance={}, armor={}, armorToughness={}, movementSpeed={}, description={}", new Object[]{entityId, attributes.health(), attributes.damage(), Float.valueOf(attributes.knockbackResistance()), attributes.armor(), Float.valueOf(attributes.armorToughness()), Float.valueOf(attributes.movementSpeed()), attributes.description() != null && !attributes.description().getString().isEmpty() ? "present" : "empty"});
                LOGGER.debug("Stored attributes for entity {}: boss={}", (Object)entityType.m_20676_().getString(), (Object)attributes.boss());
            }
            catch (Exception e) {
                LOGGER.error("Error loading bestiary file {}: {}", (Object)resourceLocation, (Object)e.getMessage());
            }
        }
        EntityDataProvider.invalidateMonsterEntriesCache();
        LOGGER.debug("Loaded bestiary attribute data for {} entities ({} with rankProgression overrides)", (Object)attributesMap.size(), (Object)esConfigMap.size());
    }

    public static String getEffectiveESMode(EntityType<?> entityType) {
        RankESConfig cfg = esConfigMap.get(entityType);
        String mode = cfg != null && cfg.mode != null ? cfg.mode : Config.esMode;
        return mode != null && mode.equalsIgnoreCase("points") ? "points" : "chance";
    }

    public static int getEffectiveESValue(EntityType<?> entityType, String action) {
        if (entityType == null || action == null) {
            return 0;
        }
        RankESConfig cfg = esConfigMap.get(entityType);
        Integer v = null;
        if (cfg != null && cfg.points != null && cfg.points.values != null) {
            v = cfg.points.values.get(action);
        }
        if (v != null) {
            return Math.max(0, v);
        }
        switch (action) {
            case "kill": {
                return Config.pointsKill;
            }
            case "feed": {
                return Config.pointsFeed;
            }
            case "trade": {
                return Config.pointsTrade;
            }
            case "hit": {
                return Config.pointsHit;
            }
            case "breed": {
                return Config.pointsBreed;
            }
            case "observe": {
                return Config.pointsObserve;
            }
            case "tame": {
                return Config.pointsTame;
            }
            case "special_biome": {
                return Config.pointsSpecialBiome;
            }
        }
        return 0;
    }

    public static int getEffectiveESThreshold(EntityType<?> entityType, String currentRank) {
        Integer t;
        String r;
        if (currentRank != null && RankUtils.compareRanks(currentRank, "S") >= 0) {
            return 0;
        }
        String stepKey = switch (r = currentRank == null || currentRank.isEmpty() ? "" : currentRank) {
            case "E" -> "E_to_D";
            case "D" -> "D_to_C";
            case "C" -> "C_to_B";
            case "B" -> "B_to_A";
            case "A" -> "A_to_S";
            default -> "E_to_D";
        };
        RankESConfig cfg = esConfigMap.get(entityType);
        if (cfg != null && cfg.points != null && cfg.points.thresholds != null && (t = cfg.points.thresholds.get(stepKey)) != null) {
            return Math.max(1, t);
        }
        switch (stepKey) {
            case "E_to_D": {
                return Config.pointsEToD;
            }
            case "D_to_C": {
                return Config.pointsDToC;
            }
            case "C_to_B": {
                return Config.pointsCToB;
            }
            case "B_to_A": {
                return Config.pointsBToA;
            }
            case "A_to_S": {
                return Config.pointsAToS;
            }
        }
        return Config.pointsEToD;
    }

    public static double getEffectiveESBossMultiplier(EntityType<?> entityType) {
        RankESConfig cfg = esConfigMap.get(entityType);
        if (cfg != null && cfg.points != null) {
            return Math.max(0.0, cfg.points.bossMultiplier);
        }
        return Config.pointsBossMultiplier;
    }

    private EntityAttributes parseAttributes(JsonObject jsonObject) throws JsonParseException {
        if (!jsonObject.has("attributes") || !jsonObject.get("attributes").isJsonObject()) {
            return null;
        }
        JsonObject attributesObject = jsonObject.getAsJsonObject("attributes");
        int health = 20;
        int damage = 2;
        float knockbackResistance = 0.0f;
        int armor = 0;
        float armorToughness = 0.0f;
        float movementSpeed = 0.3f;
        int experience = 0;
        boolean override = false;
        MutableComponent description = null;
        boolean boss = false;
        if (attributesObject.has("health") && attributesObject.get("health").isJsonPrimitive()) {
            health = attributesObject.get("health").getAsInt();
        }
        if (attributesObject.has("damage") && attributesObject.get("damage").isJsonPrimitive()) {
            damage = attributesObject.get("damage").getAsInt();
        }
        if (attributesObject.has("knockbackResistance") && attributesObject.get("knockbackResistance").isJsonPrimitive()) {
            knockbackResistance = attributesObject.get("knockbackResistance").getAsFloat();
            LOGGER.debug("Found knockback resistance for attributes: {}", (Object)Float.valueOf(knockbackResistance));
        }
        if (attributesObject.has("armor") && attributesObject.get("armor").isJsonPrimitive()) {
            armor = attributesObject.get("armor").getAsInt();
            LOGGER.debug("Found armor for attributes: {}", (Object)armor);
        }
        if (attributesObject.has("movementSpeed") && attributesObject.get("movementSpeed").isJsonPrimitive()) {
            movementSpeed = attributesObject.get("movementSpeed").getAsFloat();
            LOGGER.debug("Found movement speed for attributes: {}", (Object)Float.valueOf(movementSpeed));
        }
        if (attributesObject.has("armorToughness") && attributesObject.get("armorToughness").isJsonPrimitive()) {
            armorToughness = attributesObject.get("armorToughness").getAsFloat();
            LOGGER.debug("Found armor toughness for attributes: {}", (Object)Float.valueOf(armorToughness));
        }
        if (attributesObject.has("experience") && attributesObject.get("experience").isJsonPrimitive()) {
            experience = attributesObject.get("experience").getAsInt();
            LOGGER.debug("Found experience for attributes: {}", (Object)experience);
        }
        if (attributesObject.has("override") && attributesObject.get("override").isJsonPrimitive()) {
            override = attributesObject.get("override").getAsBoolean();
            LOGGER.debug("Found override flag for attributes: {}", (Object)override);
        }
        if (attributesObject.has("boss") && attributesObject.get("boss").isJsonPrimitive()) {
            boss = attributesObject.get("boss").getAsBoolean();
            LOGGER.debug("Found boss flag in JSON for entity with value: {}", (Object)boss);
        } else {
            LOGGER.debug("No boss flag found in JSON for entity, using default: false");
        }
        if (jsonObject.has("description") && jsonObject.get("description").isJsonPrimitive() || jsonObject.has("descriptionKey") && jsonObject.get("descriptionKey").isJsonPrimitive()) {
            String descriptionKey;
            String descriptionText = jsonObject.has("description") ? jsonObject.get("description").getAsString() : null;
            String string = descriptionKey = jsonObject.has("descriptionKey") ? jsonObject.get("descriptionKey").getAsString() : null;
            description = descriptionKey != null ? Component.m_237115_((String)descriptionKey) : (descriptionText != null ? Component.m_237113_((String)descriptionText) : Component.m_237113_((String)""));
            LOGGER.debug("Found description for entity: {}", (Object)description);
        }
        RankXConfig rankXConfig = null;
        try {
            if (jsonObject.has("rankX") && jsonObject.get("rankX").isJsonObject()) {
                JsonObject rankXObj = jsonObject.getAsJsonObject("rankX");
                int target = rankXObj.has("target") && rankXObj.get("target").isJsonPrimitive() ? rankXObj.get("target").getAsInt() : 100;
                RankXConfig.GateConfig gates = null;
                if (rankXObj.has("gates") && rankXObj.get("gates").isJsonObject()) {
                    JsonObject gatesObj = rankXObj.getAsJsonObject("gates");
                    int minDaysSinceS = gatesObj.has("minDaysSinceS") && gatesObj.get("minDaysSinceS").isJsonPrimitive() ? gatesObj.get("minDaysSinceS").getAsInt() : 3;
                    int minSessions = gatesObj.has("minSessions") && gatesObj.get("minSessions").isJsonPrimitive() ? gatesObj.get("minSessions").getAsInt() : 3;
                    gates = new RankXConfig.GateConfig(minDaysSinceS, minSessions);
                }
                ArrayList<RankXConfig.Challenge> challenges = new ArrayList<RankXConfig.Challenge>();
                if (rankXObj.has("challenges") && rankXObj.get("challenges").isJsonArray()) {
                    for (JsonElement el : rankXObj.getAsJsonArray("challenges")) {
                        int cap;
                        if (!el.isJsonObject()) continue;
                        JsonObject ch = el.getAsJsonObject();
                        String id = ch.has("id") && ch.get("id").isJsonPrimitive() ? ch.get("id").getAsString() : null;
                        int points = ch.has("points") && ch.get("points").isJsonPrimitive() ? ch.get("points").getAsInt() : 0;
                        int n = cap = ch.has("cap") && ch.get("cap").isJsonPrimitive() ? ch.get("cap").getAsInt() : points;
                        if (id == null || id.isEmpty()) continue;
                        challenges.add(new RankXConfig.Challenge(id, points, cap));
                    }
                }
                ArrayList<String> disallowed = new ArrayList<String>();
                if (rankXObj.has("disallowedCheese") && rankXObj.get("disallowedCheese").isJsonArray()) {
                    for (JsonElement el : rankXObj.getAsJsonArray("disallowedCheese")) {
                        if (!el.isJsonPrimitive()) continue;
                        disallowed.add(el.getAsString());
                    }
                }
                rankXConfig = new RankXConfig(target, gates, challenges, disallowed);
                LOGGER.debug("Parsed Rank-X config: target={}, gates(days={}, sessions={}), challenges={}, disallowedCheese={}", new Object[]{rankXConfig.getTarget(), rankXConfig.getGates() != null ? rankXConfig.getGates().getMinDaysSinceS() : -1, rankXConfig.getGates() != null ? rankXConfig.getGates().getMinSessions() : -1, challenges.size(), disallowed.size()});
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse rankX section: {}", (Object)ex.getMessage());
        }
        return new EntityAttributes(health, damage, knockbackResistance, armor, armorToughness, movementSpeed, experience, override, (Component)description, boss, rankXConfig);
    }
}

