/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.client.EntityDataClientHelper;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryAttributeManager;
import com.araxer.araxers_bestiary.data.BestiaryLootManager;
import com.araxer.araxers_bestiary.data.BestiaryServerState;
import com.araxer.araxers_bestiary.data.BestiarySpawnLocationManager;
import com.araxer.araxers_bestiary.data.EntityAttributes;
import com.araxer.araxers_bestiary.data.EntityDataServerHelper;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.MonsterEntry;
import com.araxer.araxers_bestiary.data.ObservedDropsData;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.araxer.araxers_bestiary.data.ProgressiveEntityData;
import com.araxer.araxers_bestiary.data.RankXConfig;
import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
public class EntityDataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<EntityType<?>, List<LootItemEntry>> LOOT_CACHE = new ConcurrentHashMap();
    private static final AtomicInteger LOOT_VERSION = new AtomicInteger(1);
    private static final Map<EntityType<?>, Integer> ENTITY_UPDATED_VERSION = new ConcurrentHashMap();
    private static List<MonsterEntry> MONSTER_ENTRIES_CACHE = null;
    private static final Map<EntityType<?>, Map<Item, Integer>> OBSERVED_DROPS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentLinkedQueue<EntityType<?>> PREWARM_QUEUE = new ConcurrentLinkedQueue();
    private static volatile boolean PREWARM_ACTIVE = false;
    private static final ConcurrentLinkedQueue<EntityType<?>> LAZY_QUEUE = new ConcurrentLinkedQueue();
    private static volatile boolean LAZY_ACTIVE = false;
    private static final Set<EntityType<?>> CLICK_SIMULATED = ConcurrentHashMap.newKeySet();
    private static final Map<String, Map<String, Boolean>> DIMENSION_ENTITY_COMPATIBILITY_CACHE = new ConcurrentHashMap<String, Map<String, Boolean>>();
    private static final Map<String, Integer> CACHE_HITS = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> CACHE_MISSES = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Long> DIMENSION_PROCESSING_TIMES = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Integer> ENTITIES_PROCESSED = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Long> ENTITY_PROCESSING_TIMES = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Integer> ENTITIES_PER_SECOND = new ConcurrentHashMap<String, Integer>();
    private static boolean DEBUG_MODE = false;
    private static int MAX_DEBUG_LOG_ENTRIES = 100;
    private static int debugLogCount = 0;
    private static final int MAX_ENTITIES_PER_DIMENSION = 100;

    private static void bumpLootVersion(EntityType<?> type) {
        try {
            int v = LOOT_VERSION.incrementAndGet();
            ENTITY_UPDATED_VERSION.put(type, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getLootVersion() {
        return LOOT_VERSION.get();
    }

    public static void invalidateMonsterEntriesCache() {
        MONSTER_ENTRIES_CACHE = null;
        LOGGER.debug("Invalidated MONSTER_ENTRIES_CACHE due to bestiary data reload");
    }

    public static boolean hasBeenSimulatedOnClick(EntityType<?> type) {
        return CLICK_SIMULATED.contains(type);
    }

    public static void markSimulatedOnClick(EntityType<?> type) {
        if (type != null) {
            CLICK_SIMULATED.add(type);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        try {
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (!LOOT_CACHE.isEmpty()) {
                return;
            }
            LOGGER.debug("Entity joined level during startup; deferring any prewarm to player login.");
        }
        catch (Throwable t) {
            try {
                System.err.println("[AraxersBestiary] onEntityJoinLevel failed: " + String.valueOf(t));
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        try {
            LOGGER.info("Server starting");
            if (!LOOT_CACHE.isEmpty()) {
                LOGGER.debug("Loot cache already initialized with {} entries", (Object)LOOT_CACHE.size());
            } else {
                LOGGER.debug("Deferring any loot prewarm to player login (prewarmLootCacheOnStart={})", (Object)Config.prewarmLootCacheOnStart);
            }
        }
        catch (Throwable t) {
            try {
                System.err.println("[AraxersBestiary] onServerStarting failed: " + String.valueOf(t));
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void schedulePrewarm(MinecraftServer server) {
        Iterator iterator;
        if (server == null) {
            return;
        }
        if (PREWARM_ACTIVE) {
            return;
        }
        PREWARM_QUEUE.clear();
        ServerLevel overworld = server.m_129783_();
        if (overworld == null && (iterator = server.m_129785_().iterator()).hasNext()) {
            ServerLevel lvl;
            overworld = lvl = (ServerLevel)iterator.next();
        }
        if (overworld == null) {
            LOGGER.warn("Cannot schedule loot prewarm: no server level available");
            return;
        }
        int queued = 0;
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            try {
                if (LOOT_CACHE.containsKey(entityType) && !LOOT_CACHE.getOrDefault(entityType, Collections.emptyList()).isEmpty() || !EntityDataProvider.isMonster(entityType, (Level)overworld) || !EntityDataProvider.canSpawnInDimension(entityType, overworld)) continue;
                PREWARM_QUEUE.add(entityType);
                ++queued;
            }
            catch (Exception exception) {}
        }
        PREWARM_ACTIVE = !PREWARM_QUEUE.isEmpty();
        LOGGER.info("Queued {} entity types for loot cache prewarm", (Object)queued);
    }

    public static void enqueueLazyBatchGeneration(ServerLevel level, EntityType<?> primary) {
        if (level == null) {
            return;
        }
        if (primary == null) {
            return;
        }
        if (LAZY_QUEUE.contains(primary)) {
            LOGGER.debug("Lazy generation already queued for {}", (Object)primary.m_20676_().getString());
            return;
        }
        LAZY_QUEUE.add(primary);
        LAZY_ACTIVE = true;
        LOGGER.debug("Enqueued 1 entity for lazy loot generation (primary={})", (Object)primary.m_20676_().getString());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        block30: {
            try {
                EntityType<?> type;
                Iterator iterator;
                if (event.phase != TickEvent.Phase.END) {
                    return;
                }
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return;
                }
                ServerLevel overworld = server.m_129783_();
                if (overworld == null && (iterator = server.m_129785_().iterator()).hasNext()) {
                    ServerLevel lvl;
                    overworld = lvl = (ServerLevel)iterator.next();
                }
                if (overworld == null) {
                    return;
                }
                if (PREWARM_ACTIVE) {
                    int budget = Math.max(1, Config.prewarmMaxEntitiesPerTick);
                    for (int processed = 0; processed < budget && (type = PREWARM_QUEUE.poll()) != null; ++processed) {
                        try {
                            EntityDataProvider.getLootEntries(type, (Level)overworld);
                            continue;
                        }
                        catch (Exception ex) {
                            LOGGER.debug("Prewarm failed for {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(type), (Object)ex.getMessage());
                        }
                    }
                    if (PREWARM_QUEUE.isEmpty()) {
                        PREWARM_ACTIVE = false;
                        LOGGER.info("Loot cache prewarm complete. Cached {} entity types.", (Object)LOOT_CACHE.size());
                        try {
                            String currentVersion = ModList.get().getModContainerById("araxers_bestiary").map(c -> c.getModInfo().getVersion().toString()).orElse("unknown");
                            BestiaryServerState state = BestiaryServerState.getOrCreate(server);
                            state.setLastPrewarmVersion(currentVersion);
                        }
                        catch (Throwable currentVersion) {
                            // empty catch block
                        }
                    }
                }
                if (!LAZY_ACTIVE) break block30;
                int lazyBudget = 1;
                for (int processedLazy = 0; processedLazy < lazyBudget && (type = LAZY_QUEUE.poll()) != null; ++processedLazy) {
                    try {
                        List<LootItemEntry> before = LOOT_CACHE.get(type);
                        List<LootItemEntry> after = EntityDataProvider.getLootEntries(type, (Level)overworld);
                        if (after == null || after.isEmpty()) {
                            try {
                                int batches = Math.max(20, Config.initialLootSampleBatches / 2);
                                List<LootItemEntry> sampled = EntityDataServerHelper.simulateAdditionalLootSamples(type, overworld, batches);
                                if (sampled != null && !sampled.isEmpty()) {
                                    EntityDataProvider.updateLootCache(type, sampled);
                                    after = EntityDataProvider.getCachedLoot(type);
                                }
                            }
                            catch (Exception sampEx) {
                                LOGGER.debug("Lazy sampling pass failed for {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(type), (Object)sampEx.getMessage());
                            }
                        }
                        boolean changed = false;
                        if (after != null && !after.isEmpty()) {
                            if (before == null || before.isEmpty()) {
                                changed = true;
                            } else {
                                HashMap<Item, Float> beforeMap = new HashMap<Item, Float>();
                                for (LootItemEntry e : before) {
                                    beforeMap.put(e.itemStack().m_41720_(), Float.valueOf(e.dropChance()));
                                }
                                float EPS = 1.0E-4f;
                                for (LootItemEntry e : after) {
                                    Item it = e.itemStack().m_41720_();
                                    Float old = (Float)beforeMap.get(it);
                                    if (old == null) {
                                        changed = true;
                                        break;
                                    }
                                    float oldVal = old.floatValue();
                                    boolean oldUnknown = oldVal == -1.0f;
                                    boolean newUnknown = e.hasUnknownDropChance();
                                    if (oldUnknown && !newUnknown) {
                                        changed = true;
                                        break;
                                    }
                                    if (oldUnknown || newUnknown || !(Math.abs(oldVal - e.dropChance()) > 1.0E-4f)) continue;
                                    changed = true;
                                    break;
                                }
                            }
                        }
                        if (!changed) continue;
                        EntityDataProvider.sendLootUpdateToAllPlayers(type, after);
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Lazy generation failed for {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(type), (Object)ex.getMessage());
                    }
                }
                if (LAZY_QUEUE.isEmpty()) {
                    LAZY_ACTIVE = false;
                    LOGGER.debug("Lazy loot generation batch complete");
                }
            }
            catch (Throwable t) {
                PREWARM_ACTIVE = false;
                LAZY_ACTIVE = false;
                try {
                    System.err.println("[AraxersBestiary] onServerTick failed: " + String.valueOf(t));
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void addItemToLootCacheWithUnknownChance(EntityType<?> entityType, Item item) {
        List<LootItemEntry> existingEntries = LOOT_CACHE.get(entityType);
        if (existingEntries == null) {
            existingEntries = new ArrayList<LootItemEntry>();
        } else {
            for (LootItemEntry entry : existingEntries) {
                if (entry.itemStack().m_41720_() != item) continue;
                if (!entry.hasUnknownDropChance()) {
                    LOGGER.debug("Item {} already exists in loot cache for {} with known drop chance {}, not overriding", new Object[]{entry.displayName().getString(), entityType.m_20676_().getString(), Float.valueOf(entry.dropChance())});
                    return;
                }
                LOGGER.debug("Item {} already exists in loot cache for {} with unknown drop chance, keeping it", (Object)entry.displayName().getString(), (Object)entityType.m_20676_().getString());
                return;
            }
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        Component displayName = itemStack.m_41786_();
        LootItemEntry newEntry = LootItemEntry.createWithUnknownChance(itemStack, displayName);
        existingEntries.add(newEntry);
        LOOT_CACHE.put(entityType, existingEntries);
        EntityDataProvider.bumpLootVersion(entityType);
        LOGGER.debug("Added item {} to loot cache for {} with unknown drop chance", (Object)displayName.getString(), (Object)entityType.m_20676_().getString());
        EntityDataProvider.sendLootUpdateToAllPlayers(entityType, existingEntries);
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (!Config.enableDynamicDropTracking) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity == null || !(entity.m_9236_() instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity.m_9236_();
        EntityType entityType = entity.m_6095_();
        if (EntityDataProvider.isEntityBlacklisted(entityType)) {
            return;
        }
        if (Config.ignoreModifiedDropEvents) {
            int lootingLevel = 0;
            boolean shouldSkipDueToEnchant = false;
            AtomicReference<Object> matchedEnchantIdRef = new AtomicReference<Object>(null);
            try {
                Method m = event.getClass().getMethod("getLootingLevel", new Class[0]);
                Object val = m.invoke((Object)event, new Object[0]);
                if (val instanceof Integer) {
                    Integer i = (Integer)val;
                    lootingLevel = i;
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                LivingEntity killer = entity.m_21232_();
                if (killer instanceof Player) {
                    Player player = (Player)killer;
                    ItemStack main = player.m_21205_();
                    ItemStack off = player.m_21206_();
                    List<String> cfg = Config.modifiedDropEnchantments;
                    if (cfg != null && !cfg.isEmpty()) {
                        HashSet<String> wanted = new HashSet<String>();
                        for (String s : cfg) {
                            String n;
                            if (s == null || (n = s.toLowerCase(Locale.ROOT).trim()).isEmpty()) continue;
                            wanted.add(n);
                        }
                        Function<ItemStack, Boolean> hasListedEnchant = stk -> {
                            if (stk == null || stk.m_41619_()) {
                                return false;
                            }
                            Map map = EnchantmentHelper.m_44831_((ItemStack)stk);
                            for (Enchantment e : map.keySet()) {
                                String id;
                                ResourceLocation key = ForgeRegistries.ENCHANTMENTS.getKey((Object)e);
                                if (key == null || !wanted.contains(id = key.toString().toLowerCase(Locale.ROOT))) continue;
                                matchedEnchantIdRef.set(id);
                                return true;
                            }
                            return false;
                        };
                        shouldSkipDueToEnchant = hasListedEnchant.apply(main) != false || hasListedEnchant.apply(off) != false;
                    } else {
                        shouldSkipDueToEnchant = !main.m_41619_() && main.m_41793_() || !off.m_41619_() && off.m_41793_();
                    }
                }
            }
            catch (Throwable killer) {
                // empty catch block
            }
            if (lootingLevel > 0 || shouldSkipDueToEnchant) {
                LOGGER.debug("Skipping drop tracking for {} due to modified drops (lootingLevel={}, skipDueToEnchant={}, matchedEnchant={}, configuredListSize={})", new Object[]{entityType.m_20676_().getString(), lootingLevel, shouldSkipDueToEnchant, matchedEnchantIdRef.get(), Config.modifiedDropEnchantments == null ? 0 : Config.modifiedDropEnchantments.size()});
                return;
            }
        }
        ObservedDropsData observedDropsData = ObservedDropsData.getOrCreate(serverLevel);
        int eventCount = observedDropsData.incrementDropEventCount(entityType);
        for (ItemEntity itemEntity : event.getDrops()) {
            ItemStack itemStack = itemEntity.m_32055_();
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            observedDropsData.recordObservedDrop(entityType, item, 1);
            if (eventCount >= Config.dynamicDropSampleSize) continue;
            EntityDataProvider.addItemToLootCacheWithUnknownChance(entityType, item);
        }
        LOGGER.debug("Processed drop event for {} (event #{}) with {} items", new Object[]{entityType.m_20676_().getString(), eventCount, event.getDrops().size()});
        if (eventCount % Config.dynamicDropSampleSize == 0) {
            Map<Item, Integer> itemFrequency = observedDropsData.getObservedDrops(entityType);
            EntityDataProvider.updateLootCacheWithObservedDrops(observedDropsData, entityType, itemFrequency, eventCount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void updateLootCacheWithObservedDrops(ObservedDropsData observedDropsData, EntityType<?> entityType, Map<Item, Integer> itemFrequency, int eventCount) {
        void var6_12;
        LOGGER.info("Updating loot cache with observed drops for {} after {} events", (Object)entityType.m_20676_().getString(), (Object)eventCount);
        ArrayList<LootItemEntry> observedEntries = new ArrayList<LootItemEntry>();
        for (Map.Entry<Item, Integer> entry : itemFrequency.entrySet()) {
            Item item = entry.getKey();
            int frequency = entry.getValue();
            float dropChance = (float)frequency / (float)Math.max(1, eventCount);
            if (dropChance < 0.0f) {
                dropChance = 0.0f;
            }
            if (dropChance > 1.0f) {
                dropChance = 1.0f;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            Component displayName = itemStack.m_41786_();
            observedEntries.add(new LootItemEntry(itemStack, displayName, dropChance, false));
            LOGGER.debug("Observed drop: {} with chance {} ({}/{} events)", new Object[]{displayName.getString(), Float.valueOf(dropChance), frequency, eventCount});
        }
        try {
            HashMap<Item, Float> chanceMap = new HashMap<Item, Float>();
            for (LootItemEntry e2 : observedEntries) {
                chanceMap.put(e2.itemStack().m_41720_(), Float.valueOf(e2.dropChance()));
            }
            observedDropsData.setLastComputedChances(entityType, chanceMap, eventCount);
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to persist last computed chances for {}: {}", (Object)entityType.m_20676_().getString(), (Object)ex.getMessage());
        }
        List<LootItemEntry> existingEntries = LOOT_CACHE.get(entityType);
        if (existingEntries != null && !existingEntries.isEmpty()) {
            List<LootItemEntry> mergedEntries = EntityDataProvider.mergeObservedWithExistingEntries(observedEntries, existingEntries);
            LOOT_CACHE.put(entityType, mergedEntries);
            EntityDataProvider.bumpLootVersion(entityType);
            List<LootItemEntry> list = mergedEntries;
            LOGGER.info("Merged {} observed drops with {} existing entries for {}", new Object[]{observedEntries.size(), existingEntries.size(), entityType.m_20676_().getString()});
        } else {
            ArrayList<LootItemEntry> supplemented = new ArrayList<LootItemEntry>(observedEntries);
            try {
                List<LootItemEntry> datapack;
                if (BestiaryLootManager.hasLootForEntity(entityType) && (datapack = BestiaryLootManager.getLootForEntity(entityType)) != null && !datapack.isEmpty()) {
                    Set observedItems = observedEntries.stream().map(e -> e.itemStack().m_41720_()).collect(Collectors.toSet());
                    for (LootItemEntry dpEntry : datapack) {
                        Item dpItem = dpEntry.itemStack().m_41720_();
                        if (observedItems.contains(dpItem)) continue;
                        supplemented.add(dpEntry);
                        LOGGER.debug("Supplemented datapack loot {} while initializing observed cache for {}", (Object)dpEntry.displayName().getString(), (Object)entityType.m_20676_().getString());
                    }
                }
            }
            catch (Exception e3) {
                LOGGER.debug("Could not supplement datapack loot for {}: {}", (Object)entityType.m_20676_().getString(), (Object)e3.getMessage());
            }
            LOOT_CACHE.put(entityType, supplemented);
            EntityDataProvider.bumpLootVersion(entityType);
            ArrayList<LootItemEntry> arrayList = supplemented;
            LOGGER.info("Initialized cache for {} with {} observed and {} total after datapack supplement", new Object[]{entityType.m_20676_().getString(), observedEntries.size(), supplemented.size()});
        }
        EntityDataProvider.sendLootUpdateToAllPlayers(entityType, (List<LootItemEntry>)var6_12);
    }

    private static List<LootItemEntry> mergeObservedWithExistingEntries(List<LootItemEntry> observedEntries, List<LootItemEntry> existingEntries) {
        HashMap<Item, LootItemEntry> observedItemMap = new HashMap<Item, LootItemEntry>();
        for (LootItemEntry lootItemEntry : observedEntries) {
            observedItemMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
        }
        HashMap<Item, LootItemEntry> existingItemMap = new HashMap<Item, LootItemEntry>();
        for (LootItemEntry entry : existingEntries) {
            existingItemMap.put(entry.itemStack().m_41720_(), entry);
        }
        ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>();
        HashSet allItems = new HashSet();
        allItems.addAll(observedItemMap.keySet());
        allItems.addAll(existingItemMap.keySet());
        for (Item item : allItems) {
            LootItemEntry observedEntry = (LootItemEntry)observedItemMap.get(item);
            LootItemEntry existingEntry = (LootItemEntry)existingItemMap.get(item);
            if (observedEntry != null && existingEntry != null) {
                if (existingEntry.hasUnknownDropChance()) {
                    arrayList.add(new LootItemEntry(existingEntry.itemStack(), existingEntry.displayName(), observedEntry.dropChance(), existingEntry.override()));
                    LOGGER.debug("Replaced unknown drop chance for {} with observed drop chance {}", (Object)existingEntry.displayName().getString(), (Object)Float.valueOf(observedEntry.dropChance()));
                    continue;
                }
                float blendedChance = (float)((double)observedEntry.dropChance() * Config.dynamicDropWeight + (double)existingEntry.dropChance() * (1.0 - Config.dynamicDropWeight));
                if (blendedChance < 0.0f) {
                    blendedChance = 0.0f;
                }
                if (blendedChance > 1.0f) {
                    blendedChance = 1.0f;
                }
                arrayList.add(new LootItemEntry(existingEntry.itemStack(), existingEntry.displayName(), blendedChance, existingEntry.override()));
                LOGGER.debug("Merged drop chance for {}: observed={}, existing={}, blended={}", new Object[]{existingEntry.displayName().getString(), Float.valueOf(observedEntry.dropChance()), Float.valueOf(existingEntry.dropChance()), Float.valueOf(blendedChance)});
                continue;
            }
            if (observedEntry != null) {
                float adjustedChance = (float)((double)observedEntry.dropChance() * Config.dynamicDropWeight);
                if (adjustedChance < 0.0f) {
                    adjustedChance = 0.0f;
                }
                if (adjustedChance > 1.0f) {
                    adjustedChance = 1.0f;
                }
                arrayList.add(new LootItemEntry(observedEntry.itemStack(), observedEntry.displayName(), adjustedChance, false));
                LOGGER.debug("Added observed-only drop {}: chance={}, adjusted={}", new Object[]{observedEntry.displayName().getString(), Float.valueOf(observedEntry.dropChance()), Float.valueOf(adjustedChance)});
                continue;
            }
            if (existingEntry == null) continue;
            arrayList.add(existingEntry);
            LOGGER.debug("Kept existing-only drop {}: chance={}", (Object)existingEntry.displayName().getString(), existingEntry.hasUnknownDropChance() ? "?" : Float.valueOf(existingEntry.dropChance()));
        }
        return arrayList;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            LOGGER.debug("Player {} logged in, sending sync packets", (Object)player2.m_7755_().getString());
            if (Config.prewarmLootCacheOnStart) {
                MinecraftServer server = level.m_7654_();
                if (server != null && !PREWARM_ACTIVE) {
                    String currentVersion = "unknown";
                    try {
                        currentVersion = ModList.get().getModContainerById("araxers_bestiary").map(c -> c.getModInfo().getVersion().toString()).orElse("unknown");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String lastVersion = "";
                    try {
                        BestiaryServerState state = BestiaryServerState.getOrCreate(server);
                        lastVersion = state.getLastPrewarmVersion();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!currentVersion.equals(lastVersion)) {
                        LOGGER.info("Scheduling loot cache prewarm on player login (per-tick budget: {}, lastVersion='{}', current='{}')", new Object[]{Config.prewarmMaxEntitiesPerTick, lastVersion, currentVersion});
                        EntityDataProvider.schedulePrewarm(server);
                    } else {
                        LOGGER.debug("Skipping prewarm on login: already completed for version {}", (Object)currentVersion);
                    }
                }
            } else if (LOOT_CACHE.isEmpty()) {
                LOGGER.info("Loot cache empty at login; will generate lazily on demand (no prewarm)");
            }
            if (Config.enableDynamicDropTracking) {
                EntityDataProvider.loadObservedDropsData(level);
            }
            EntityDataProvider.sendLootSyncPacket(player2);
            EntityDataProvider.sendSpawnLocationSyncPacket(player2);
            EntityDataProvider.sendAttributeSyncPacket(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            LOGGER.debug("Player {} changed dimension from {} to {}, syncing data", new Object[]{player2.m_7755_().getString(), event.getFrom().m_135782_(), event.getTo().m_135782_()});
            if (LOOT_CACHE.isEmpty()) {
                if (Config.prewarmLootCacheOnStart) {
                    LOGGER.info("Loot cache empty on dimension change; scheduling prewarm instead of blocking initialization");
                    MinecraftServer server = level.m_7654_();
                    if (server != null && !PREWARM_ACTIVE) {
                        EntityDataProvider.schedulePrewarm(server);
                    }
                } else {
                    LOGGER.info("Loot cache empty on dimension change; will generate lazily on demand (no prewarm)");
                }
            }
            if (Config.enableDynamicDropTracking) {
                EntityDataProvider.loadObservedDropsData(level);
            }
            EntityDataProvider.sendLootSyncPacket(player2);
            EntityDataProvider.sendSpawnLocationSyncPacket(player2);
            EntityDataProvider.sendAttributeSyncPacket(player2);
            LOGGER.debug("Data sync completed for player {} after dimension change", (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Server stopping, ensuring observed drops data is saved");
        MinecraftServer server = event.getServer();
        if (server != null) {
            for (ServerLevel level : server.m_129785_()) {
                ObservedDropsData observedDropsData = ObservedDropsData.getOrCreate(level);
                observedDropsData.m_77762_();
                LOGGER.debug("Marked observed drops data as dirty for dimension: {}", (Object)level.m_46472_().m_135782_());
            }
        }
        LOGGER.info("Observed drops data saving complete");
    }

    public static void clearCache() {
        LOOT_CACHE.clear();
        MONSTER_ENTRIES_CACHE = null;
        OBSERVED_DROPS_CACHE.clear();
        ENTITY_UPDATED_VERSION.clear();
        CLICK_SIMULATED.clear();
        LOOT_VERSION.incrementAndGet();
        LOGGER.debug("EntityDataProvider in-memory caches cleared (loot, monster entries, observed drops). Loot version bumped to {}.", (Object)LOOT_VERSION.get());
    }

    public static void clearCache(MinecraftServer server) {
        EntityDataProvider.clearCache();
        if (server != null) {
            for (ServerLevel level : server.m_129785_()) {
                ObservedDropsData observedDropsData = ObservedDropsData.getOrCreate(level);
                observedDropsData.clearAll();
                LOGGER.debug("Cleared persisted observed drops data for dimension: {}", (Object)level.m_46472_().m_135782_());
            }
            LOGGER.info("Cleared persisted observed drops data for all dimensions");
        } else {
            LOGGER.warn("Cannot clear persisted observed drops data: server is null");
        }
    }

    public static void updateLootCache(EntityType<?> entityType, List<LootItemEntry> lootEntries) {
        LOGGER.debug("Updating loot cache for entity: {} with {} entries", (Object)entityType.m_20676_().getString(), (Object)(lootEntries != null ? lootEntries.size() : 0));
        if (lootEntries != null && !lootEntries.isEmpty()) {
            List<LootItemEntry> existingEntries = LOOT_CACHE.get(entityType);
            if (existingEntries != null && !existingEntries.isEmpty()) {
                LOGGER.debug("Found {} existing entries for entity: {}", (Object)existingEntries.size(), (Object)entityType.m_20676_().getString());
                HashMap<Item, LootItemEntry> existingItemMap = new HashMap<Item, LootItemEntry>();
                for (LootItemEntry lootItemEntry : existingEntries) {
                    existingItemMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Existing entry: {} with drop chance: {} (unknown: {})", new Object[]{lootItemEntry.displayName().getString(), Float.valueOf(lootItemEntry.dropChance()), lootItemEntry.hasUnknownDropChance()});
                }
                HashMap<Item, LootItemEntry> newItemMap = new HashMap<Item, LootItemEntry>();
                for (LootItemEntry entry : lootEntries) {
                    newItemMap.put(entry.itemStack().m_41720_(), entry);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("New entry: {} with drop chance: {} (unknown: {})", new Object[]{entry.displayName().getString(), Float.valueOf(entry.dropChance()), entry.hasUnknownDropChance()});
                }
                ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>();
                HashSet allItems = new HashSet();
                allItems.addAll(existingItemMap.keySet());
                allItems.addAll(newItemMap.keySet());
                LOGGER.debug("Merging {} total unique items for entity: {}", (Object)allItems.size(), (Object)entityType.m_20676_().getString());
                int preservedCount = 0;
                int updatedCount = 0;
                int addedCount = 0;
                for (Item item : allItems) {
                    LootItemEntry existingEntry = (LootItemEntry)existingItemMap.get(item);
                    LootItemEntry newEntry = (LootItemEntry)newItemMap.get(item);
                    if (existingEntry != null && newEntry != null) {
                        if (!existingEntry.hasUnknownDropChance() && newEntry.hasUnknownDropChance()) {
                            arrayList.add(existingEntry);
                            ++preservedCount;
                            LOGGER.debug("Preserved known drop chance for {} in entity {}: {}", new Object[]{existingEntry.displayName().getString(), entityType.m_20676_().getString(), Float.valueOf(existingEntry.dropChance())});
                            continue;
                        }
                        arrayList.add(newEntry);
                        ++updatedCount;
                        LOGGER.debug("Updated entry for {} in entity {}: {} -> {}", new Object[]{newEntry.displayName().getString(), entityType.m_20676_().getString(), existingEntry.hasUnknownDropChance() ? "?" : Float.valueOf(existingEntry.dropChance()), newEntry.hasUnknownDropChance() ? "?" : Float.valueOf(newEntry.dropChance())});
                        continue;
                    }
                    if (existingEntry != null) {
                        arrayList.add(existingEntry);
                        ++preservedCount;
                        LOGGER.debug("Kept existing entry for {} in entity {}: {}", new Object[]{existingEntry.displayName().getString(), entityType.m_20676_().getString(), existingEntry.hasUnknownDropChance() ? "?" : Float.valueOf(existingEntry.dropChance())});
                        continue;
                    }
                    if (newEntry == null) continue;
                    arrayList.add(newEntry);
                    ++addedCount;
                    LOGGER.debug("Added new entry for {} in entity {}: {}", new Object[]{newEntry.displayName().getString(), entityType.m_20676_().getString(), newEntry.hasUnknownDropChance() ? "?" : Float.valueOf(newEntry.dropChance())});
                }
                LOOT_CACHE.put(entityType, arrayList);
                EntityDataProvider.bumpLootVersion(entityType);
                LOGGER.debug("Updated loot cache for {} with {} merged entries: {} preserved, {} updated, {} added", new Object[]{entityType.m_20676_().getString(), arrayList.size(), preservedCount, updatedCount, addedCount});
            } else {
                LOOT_CACHE.put(entityType, new ArrayList<LootItemEntry>(lootEntries));
                EntityDataProvider.bumpLootVersion(entityType);
                LOGGER.debug("Added {} new entries to loot cache for {} (no existing entries)", (Object)lootEntries.size(), (Object)entityType.m_20676_().getString());
                if (LOGGER.isDebugEnabled()) {
                    for (LootItemEntry entry : lootEntries) {
                        LOGGER.debug("New entry: {} with drop chance: {} (unknown: {})", new Object[]{entry.displayName().getString(), Float.valueOf(entry.dropChance()), entry.hasUnknownDropChance()});
                    }
                }
            }
            MONSTER_ENTRIES_CACHE = null;
            LOGGER.debug("Invalidated MONSTER_ENTRIES_CACHE after loot update for {}", (Object)entityType.m_20676_().getString());
        } else {
            List<LootItemEntry> existing = LOOT_CACHE.get(entityType);
            if (existing == null) {
                LOOT_CACHE.put(entityType, new ArrayList());
                EntityDataProvider.bumpLootVersion(entityType);
                MONSTER_ENTRIES_CACHE = null;
                LOGGER.debug("Marked {} as loot-cache eligible with 0 entries (no existing entries)", (Object)entityType.m_20676_().getString());
            } else {
                LOGGER.debug("Received empty loot update for {} but cache already exists with {} entries; keeping existing", (Object)entityType.m_20676_().getString(), (Object)existing.size());
            }
        }
    }

    public static void sendLootSyncPacket(ServerPlayer player) {
        LOGGER.debug("Sending loot sync packet to player {}", (Object)player.m_7755_().getString());
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        LinkedHashMap<EntityType, List<LootItemEntry>> toSend = new LinkedHashMap<EntityType, List<LootItemEntry>>();
        for (Map.Entry<EntityType<?>, List<LootItemEntry>> entry : LOOT_CACHE.entrySet()) {
            EntityType et = entry.getKey();
            List<LootItemEntry> list = entry.getValue();
            if (et == null || list == null) continue;
            toSend.put(et, list);
        }
        int placeholders = 0;
        for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
            try {
                if (et == null || !EntityDataProvider.shouldTrackProgression(et) || toSend.containsKey(et)) continue;
                toSend.put(et, Collections.emptyList());
                ++placeholders;
            }
            catch (Throwable list) {}
        }
        if (!Config.enableProgressionSystem && serverLevel != null) {
            for (Map.Entry e : new ArrayList(toSend.entrySet())) {
                EntityType et = (EntityType)e.getKey();
                List list = (List)e.getValue();
                if (list == null || list.isEmpty()) continue;
                boolean hasUnknown = false;
                for (LootItemEntry li : list) {
                    if (!li.hasUnknownDropChance()) continue;
                    hasUnknown = true;
                    break;
                }
                if (!hasUnknown) continue;
                try {
                    Object it;
                    List<LootItemEntry> tableLoot = EntityDataServerHelper.generateLootEntriesFromTable(et, serverLevel);
                    if (tableLoot == null || tableLoot.isEmpty()) continue;
                    HashMap<Item, LootItemEntry> tableMap = new HashMap<Item, LootItemEntry>();
                    for (LootItemEntry te : tableLoot) {
                        tableMap.put(te.itemStack().m_41720_(), te);
                    }
                    ArrayList<LootItemEntry> merged = new ArrayList<LootItemEntry>();
                    HashSet<Item> present = new HashSet<Item>();
                    for (LootItemEntry li : list) {
                        it = li.itemStack().m_41720_();
                        present.add((Item)it);
                        LootItemEntry te = (LootItemEntry)tableMap.get(it);
                        if (li.hasUnknownDropChance() && te != null && !te.hasUnknownDropChance()) {
                            merged.add(new LootItemEntry(li.itemStack(), li.displayName(), te.dropChance(), li.override()));
                            continue;
                        }
                        merged.add(li);
                    }
                    for (LootItemEntry te : tableLoot) {
                        it = te.itemStack().m_41720_();
                        if (present.contains(it)) continue;
                        merged.add(te);
                    }
                    try {
                        List<LootItemEntry> dp;
                        if (BestiaryLootManager.hasLootForEntity(et) && (dp = BestiaryLootManager.getLootForEntity(et)) != null && !dp.isEmpty()) {
                            HashMap<Item, LootItemEntry> dpMap = new HashMap<Item, LootItemEntry>();
                            for (LootItemEntry de : dp) {
                                dpMap.put(de.itemStack().m_41720_(), de);
                            }
                            for (int i = 0; i < merged.size(); ++i) {
                                LootItemEntry de;
                                LootItemEntry mi = (LootItemEntry)merged.get(i);
                                if (!mi.hasUnknownDropChance() || (de = (LootItemEntry)dpMap.get(mi.itemStack().m_41720_())) == null || de.hasUnknownDropChance()) continue;
                                merged.set(i, new LootItemEntry(mi.itemStack(), de.displayName().getString().isEmpty() ? mi.displayName() : de.displayName(), de.dropChance(), mi.override() || de.override()));
                            }
                            HashSet<Item> items = new HashSet<Item>();
                            for (LootItemEntry m : merged) {
                                items.add(m.itemStack().m_41720_());
                            }
                            for (LootItemEntry de : dp) {
                                Item it2 = de.itemStack().m_41720_();
                                if (items.contains(it2)) continue;
                                merged.add(de);
                            }
                        }
                    }
                    catch (Throwable dp) {
                        // empty catch block
                    }
                    toSend.put(et, merged);
                    LOOT_CACHE.put(et, merged);
                    EntityDataProvider.bumpLootVersion(et);
                    LOGGER.debug("Pre-refined UNKNOWN chances for {} before full sync (entries: {})", (Object)et.m_20676_().getString(), (Object)merged.size());
                }
                catch (Exception ex) {
                    LOGGER.debug("Failed to pre-refine UNKNOWN chances for {}: {}", (Object)et.m_20676_().getString(), (Object)ex.getMessage());
                }
            }
        }
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        friendlyByteBuf.writeInt(EntityDataProvider.getLootVersion());
        friendlyByteBuf.writeBoolean(true);
        friendlyByteBuf.writeInt(toSend.size());
        for (Map.Entry entry : toSend.entrySet()) {
            EntityType entityType = (EntityType)entry.getKey();
            List<LootItemEntry> lootEntries = (List<LootItemEntry>)entry.getValue();
            if (lootEntries == null) {
                lootEntries = Collections.emptyList();
            }
            ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
            friendlyByteBuf.m_130085_(entityTypeId);
            friendlyByteBuf.writeInt(lootEntries.size());
            for (LootItemEntry lootEntry : lootEntries) {
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)lootEntry.itemStack().m_41720_());
                friendlyByteBuf.m_130070_(itemId.toString());
                friendlyByteBuf.writeFloat(lootEntry.dropChance());
                String dn = null;
                try {
                    dn = lootEntry.displayName() != null ? lootEntry.displayName().getString() : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dn == null) {
                    try {
                        dn = lootEntry.itemStack().m_41786_().getString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                friendlyByteBuf.m_130070_(dn != null ? dn : "");
            }
        }
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CommonPacketHandler.LOOT_SYNC_CHANNEL, friendlyByteBuf));
        LOGGER.info("Sent loot sync packet to player {} with {} entity types ({} placeholders)", new Object[]{player.m_7755_().getString(), toSend.size(), placeholders});
    }

    public static void sendLootUpdatePacket(ServerPlayer player, EntityType<?> entityType, List<LootItemEntry> lootEntries) {
        block22: {
            Level level;
            LOGGER.debug("Sending loot update packet to player {} for entity {}", (Object)player.m_7755_().getString(), (Object)entityType.m_20676_().getString());
            if (!Config.enableProgressionSystem && player != null && (level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel sv = (ServerLevel)level;
                boolean hasUnknown = false;
                for (LootItemEntry li : lootEntries) {
                    if (!li.hasUnknownDropChance()) continue;
                    hasUnknown = true;
                    break;
                }
                if (hasUnknown) {
                    try {
                        Object it;
                        List<LootItemEntry> tableLoot = EntityDataServerHelper.generateLootEntriesFromTable(entityType, sv);
                        if (tableLoot == null || tableLoot.isEmpty()) break block22;
                        HashMap<Item, LootItemEntry> tableMap = new HashMap<Item, LootItemEntry>();
                        for (LootItemEntry te : tableLoot) {
                            tableMap.put(te.itemStack().m_41720_(), te);
                        }
                        ArrayList<LootItemEntry> merged = new ArrayList<LootItemEntry>();
                        HashSet<Item> present = new HashSet<Item>();
                        for (LootItemEntry li : lootEntries) {
                            it = li.itemStack().m_41720_();
                            present.add((Item)it);
                            LootItemEntry te = (LootItemEntry)tableMap.get(it);
                            if (li.hasUnknownDropChance() && te != null && !te.hasUnknownDropChance()) {
                                merged.add(new LootItemEntry(li.itemStack(), li.displayName(), te.dropChance(), li.override()));
                                continue;
                            }
                            merged.add(li);
                        }
                        for (LootItemEntry te : tableLoot) {
                            it = te.itemStack().m_41720_();
                            if (present.contains(it)) continue;
                            merged.add(te);
                        }
                        try {
                            List<LootItemEntry> dp;
                            if (BestiaryLootManager.hasLootForEntity(entityType) && (dp = BestiaryLootManager.getLootForEntity(entityType)) != null && !dp.isEmpty()) {
                                HashMap<Item, LootItemEntry> dpMap = new HashMap<Item, LootItemEntry>();
                                for (LootItemEntry de : dp) {
                                    dpMap.put(de.itemStack().m_41720_(), de);
                                }
                                for (int i = 0; i < merged.size(); ++i) {
                                    LootItemEntry de;
                                    LootItemEntry mi = (LootItemEntry)merged.get(i);
                                    if (!mi.hasUnknownDropChance() || (de = (LootItemEntry)dpMap.get(mi.itemStack().m_41720_())) == null || de.hasUnknownDropChance()) continue;
                                    merged.set(i, new LootItemEntry(mi.itemStack(), de.displayName().getString().isEmpty() ? mi.displayName() : de.displayName(), de.dropChance(), mi.override() || de.override()));
                                }
                                HashSet<Item> items = new HashSet<Item>();
                                for (LootItemEntry m : merged) {
                                    items.add(m.itemStack().m_41720_());
                                }
                                for (LootItemEntry de : dp) {
                                    Item it2 = de.itemStack().m_41720_();
                                    if (items.contains(it2)) continue;
                                    merged.add(de);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        lootEntries = merged;
                        LOOT_CACHE.put(entityType, merged);
                        EntityDataProvider.bumpLootVersion(entityType);
                        LOGGER.debug("Pre-refined UNKNOWN chances for {} before partial update (entries: {})", (Object)entityType.m_20676_().getString(), (Object)merged.size());
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Failed to pre-refine UNKNOWN chances for {} before partial update: {}", (Object)entityType.m_20676_().getString(), (Object)ex.getMessage());
                    }
                }
            }
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(EntityDataProvider.getLootVersion());
        buf.writeBoolean(false);
        buf.writeInt(1);
        ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        buf.m_130085_(entityTypeId);
        buf.writeInt(lootEntries.size());
        for (LootItemEntry lootEntry : lootEntries) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)lootEntry.itemStack().m_41720_());
            buf.m_130070_(itemId.toString());
            buf.writeFloat(lootEntry.dropChance());
            String dn = null;
            try {
                dn = lootEntry.displayName() != null ? lootEntry.displayName().getString() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dn == null) {
                try {
                    dn = lootEntry.itemStack().m_41786_().getString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            buf.m_130070_(dn != null ? dn : "");
        }
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CommonPacketHandler.LOOT_SYNC_CHANNEL, buf));
        LOGGER.debug("Sent loot update packet to player {} for entity {} with {} entries (v{})", new Object[]{player.m_7755_().getString(), entityType.m_20676_().getString(), lootEntries.size(), EntityDataProvider.getLootVersion()});
    }

    public static void sendLootUpdateToAllPlayers(EntityType<?> entityType, List<LootItemEntry> lootEntries) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            LOGGER.warn("Cannot send loot update to players: no server available");
            return;
        }
        List players = server.m_6846_().m_11314_();
        if (players.isEmpty()) {
            LOGGER.debug("No players connected to send loot update for {}", (Object)entityType.m_20676_().getString());
            return;
        }
        LOGGER.info("Sending loot update for {} to {} connected players", (Object)entityType.m_20676_().getString(), (Object)players.size());
        if (LOGGER.isDebugEnabled()) {
            StringBuilder playerNames = new StringBuilder();
            for (ServerPlayer player : players) {
                if (playerNames.length() > 0) {
                    playerNames.append(", ");
                }
                playerNames.append(player.m_7755_().getString());
            }
            LOGGER.debug("Connected players: {}", (Object)playerNames);
            StringBuilder itemsInfo = new StringBuilder();
            for (LootItemEntry entry : lootEntries) {
                if (itemsInfo.length() > 0) {
                    itemsInfo.append("; ");
                }
                String chanceStr = entry.hasUnknownDropChance() ? "?" : String.format("%.3f", Float.valueOf(entry.dropChance()));
                itemsInfo.append(entry.displayName().getString()).append("=").append(chanceStr);
            }
            LOGGER.debug("Loot update contents for {}: {}", (Object)entityType.m_20676_().getString(), (Object)itemsInfo);
        }
        for (ServerPlayer player : players) {
            EntityDataProvider.sendLootUpdatePacket(player, entityType, lootEntries);
        }
        LOGGER.info("Loot update for {} sent to all connected players", (Object)entityType.m_20676_().getString());
    }

    public static void sendSpawnLocationSyncPacket(ServerPlayer player) {
        LOGGER.debug("Sending spawn location sync packet to player {}", (Object)player.m_7755_().getString());
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        HashMap spawnLocationsMap = new HashMap();
        ServerLevel level = (ServerLevel)player.m_9236_();
        ForgeRegistries.ENTITY_TYPES.forEach(entityType -> {
            SpawnLocationInfo spawnLocationInfo;
            if (EntityDataProvider.isMonster(entityType, (Level)level) && (spawnLocationInfo = EntityDataProvider.getSpawnLocationInfo(entityType, (Level)level)) != null) {
                spawnLocationsMap.put(entityType, spawnLocationInfo);
            }
        });
        buf.writeInt(spawnLocationsMap.size());
        for (Map.Entry entry : spawnLocationsMap.entrySet()) {
            EntityType entityType2 = (EntityType)entry.getKey();
            SpawnLocationInfo spawnLocationInfo = (SpawnLocationInfo)entry.getValue();
            ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType2);
            buf.m_130085_(entityTypeId);
            List<Component> locations = spawnLocationInfo.getAllLocations();
            buf.writeBoolean(spawnLocationInfo.isOverride());
            buf.writeInt(locations.size());
            for (Component location : locations) {
                buf.m_130070_(location != null ? location.getString() : "");
            }
        }
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CommonPacketHandler.SPAWN_LOCATION_SYNC_CHANNEL, buf));
        LOGGER.debug("Sent spawn location sync packet to player {} with {} entity types", (Object)player.m_7755_().getString(), (Object)spawnLocationsMap.size());
    }

    public static void sendAttributeSyncPacket(ServerPlayer player) {
        LOGGER.debug("Sending attribute sync packet to player {}", (Object)player.m_7755_().getString());
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        Level level = player.m_9236_();
        HashMap attributesMap = new HashMap();
        ForgeRegistries.ENTITY_TYPES.forEach(entityType -> {
            EntityAttributes attributes;
            if (EntityDataProvider.isMonster(entityType, level) && BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
                attributesMap.put(entityType, attributes);
            }
        });
        ArrayList hiddenList = new ArrayList();
        ForgeRegistries.ENTITY_TYPES.forEach(entityType -> {
            if (BestiaryAttributeManager.isEntityHidden(entityType)) {
                hiddenList.add(entityType);
            }
        });
        buf.writeInt(hiddenList.size());
        for (EntityType entityType2 : hiddenList) {
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType2);
            buf.m_130085_(id);
        }
        buf.writeInt(attributesMap.size());
        for (Map.Entry entry : attributesMap.entrySet()) {
            EntityType entityType2 = (EntityType)entry.getKey();
            EntityAttributes attributes = (EntityAttributes)entry.getValue();
            ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType2);
            buf.m_130085_(entityTypeId);
            buf.writeInt(attributes.health());
            buf.writeInt(attributes.damage());
            buf.writeFloat(attributes.knockbackResistance());
            buf.writeInt(attributes.armor());
            buf.writeFloat(attributes.armorToughness());
            buf.writeFloat(attributes.movementSpeed());
            buf.writeInt(attributes.experience());
            buf.writeBoolean(attributes.override());
            buf.m_130070_(attributes.description() != null ? attributes.description().getString() : "");
            buf.writeBoolean(attributes.boss());
            RankXConfig rx = attributes.rankX();
            if (rx != null && Config.enableProgressionSystem) {
                buf.writeBoolean(true);
                buf.writeInt(rx.getTarget());
                RankXConfig.GateConfig gates = rx.getGates();
                if (gates != null) {
                    buf.writeBoolean(true);
                    buf.writeInt(gates.getMinDaysSinceS());
                    buf.writeInt(gates.getMinSessions());
                } else {
                    buf.writeBoolean(false);
                }
                List<RankXConfig.Challenge> ch = rx.getChallenges();
                buf.writeInt(ch.size());
                for (RankXConfig.Challenge c : ch) {
                    buf.m_130070_(c.id());
                    buf.writeInt(c.points());
                    buf.writeInt(c.cap());
                }
                List<String> dis = rx.getDisallowedCheese();
                buf.writeInt(dis.size());
                for (String s : dis) {
                    buf.m_130070_(s);
                }
            } else {
                buf.writeBoolean(false);
            }
            LOGGER.debug("Sending description for entity {}: {}, boss={} ", new Object[]{entityType2.m_20676_().getString(), attributes.description() != null && !attributes.description().toString().isEmpty() ? "present" : "empty", attributes.boss()});
        }
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(CommonPacketHandler.ATTRIBUTE_SYNC_CHANNEL, buf));
        LOGGER.debug("Sent attribute sync packet to player {} with {} entity types ({} hidden)", new Object[]{player.m_7755_().getString(), attributesMap.size(), hiddenList.size()});
    }

    private static void loadObservedDropsData(ServerLevel serverLevel) {
        LOGGER.info("Loading persisted observed drops data for dimension: {}", (Object)serverLevel.m_46472_().m_135782_());
        ObservedDropsData observedDropsData = ObservedDropsData.getOrCreate(serverLevel);
        int entitiesWithData = 0;
        int entitiesWithSampleSize = 0;
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            Map<Item, Integer> itemFrequency;
            int eventCount;
            if (EntityDataProvider.isEntityBlacklisted(entityType) || (eventCount = observedDropsData.getDropEventCount(entityType)) == 0 || (itemFrequency = observedDropsData.getObservedDrops(entityType)).isEmpty()) continue;
            ++entitiesWithData;
            if (eventCount >= Config.dynamicDropSampleSize && eventCount % Config.dynamicDropSampleSize == 0) {
                EntityDataProvider.updateLootCacheWithObservedDrops(observedDropsData, entityType, itemFrequency, eventCount);
                ++entitiesWithSampleSize;
                continue;
            }
            Map<Item, Float> lastChances = observedDropsData.getLastComputedChances(entityType);
            if (eventCount >= Config.dynamicDropSampleSize && lastChances != null && !lastChances.isEmpty()) {
                List<LootItemEntry> finalEntries;
                LOGGER.info("Restoring last computed chances for {} (event count: {}, last multiple: {})", new Object[]{entityType.m_20676_().getString(), eventCount, observedDropsData.getLastComputedEventMultiple(entityType)});
                ArrayList<LootItemEntry> observedEntries = new ArrayList<LootItemEntry>();
                for (Map.Entry<Item, Float> chanceEntry : lastChances.entrySet()) {
                    Item item = chanceEntry.getKey();
                    float chance = chanceEntry.getValue().floatValue();
                    if (chance < 0.0f) {
                        chance = 0.0f;
                    }
                    if (chance > 1.0f) {
                        chance = 1.0f;
                    }
                    ItemStack stack = new ItemStack((ItemLike)item);
                    Component name = stack.m_41786_();
                    observedEntries.add(new LootItemEntry(stack, name, chance, false));
                }
                List<LootItemEntry> existingEntries = LOOT_CACHE.get(entityType);
                if (existingEntries != null && !existingEntries.isEmpty()) {
                    finalEntries = EntityDataProvider.mergeObservedWithExistingEntries(observedEntries, existingEntries);
                } else {
                    ArrayList<LootItemEntry> supplemented = new ArrayList<LootItemEntry>(observedEntries);
                    try {
                        List<LootItemEntry> datapack;
                        if (BestiaryLootManager.hasLootForEntity(entityType) && (datapack = BestiaryLootManager.getLootForEntity(entityType)) != null && !datapack.isEmpty()) {
                            Set observedItems = observedEntries.stream().map(e -> e.itemStack().m_41720_()).collect(Collectors.toSet());
                            for (LootItemEntry dpEntry : datapack) {
                                Item dpItem = dpEntry.itemStack().m_41720_();
                                if (observedItems.contains(dpItem)) continue;
                                supplemented.add(dpEntry);
                                LOGGER.debug("Supplemented datapack loot {} while restoring observed cache for {}", (Object)dpEntry.displayName().getString(), (Object)entityType.m_20676_().getString());
                            }
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.debug("Could not supplement datapack loot for {}: {}", (Object)entityType.m_20676_().getString(), (Object)e2.getMessage());
                    }
                    finalEntries = supplemented;
                }
                LOOT_CACHE.put(entityType, finalEntries);
                EntityDataProvider.bumpLootVersion(entityType);
                EntityDataProvider.sendLootUpdateToAllPlayers(entityType, finalEntries);
                continue;
            }
            LOGGER.debug("Adding items with unknown drop chance for {} (event count: {})", (Object)entityType.m_20676_().getString(), (Object)eventCount);
            for (Item item : itemFrequency.keySet()) {
                EntityDataProvider.addItemToLootCacheWithUnknownChance(entityType, item);
            }
        }
        LOGGER.info("Loaded persisted observed drops data for {} entities in dimension {}, {} have reached sample size", new Object[]{entitiesWithData, serverLevel.m_46472_().m_135782_(), entitiesWithSampleSize});
    }

    private static void initializeLootCache(MinecraftServer server) {
        LOGGER.info("Initializing loot cache from all server dimensions");
        EntityDataProvider.preloadDimensionEntityCompatibilityCache(server);
        int totalProcessed = 0;
        int totalSkipped = 0;
        int totalFiltered = 0;
        for (ServerLevel serverLevel : server.m_129785_()) {
            LOGGER.info("Processing dimension: {}", (Object)serverLevel.m_46472_().m_135782_());
            int cacheSizeBefore = LOOT_CACHE.size();
            int[] dimensionProcessed = new int[]{0};
            int[] dimensionSkipped = new int[]{0};
            int[] dimensionFiltered = new int[]{0};
            long startTime = System.nanoTime();
            EntityDataProvider.processLootCacheForDimension(serverLevel);
            EntityDataProvider.loadObservedDropsData(serverLevel);
            EntityDataProvider.supplementLootCacheWithDatapackEntries((Level)serverLevel);
            long endTime = System.nanoTime();
            long processingTime = endTime - startTime;
            DIMENSION_PROCESSING_TIMES.put(serverLevel.m_46472_().m_135782_().toString(), processingTime);
            int entitiesAdded = LOOT_CACHE.size() - cacheSizeBefore;
            totalProcessed += entitiesAdded;
            int potentialEntities = 0;
            for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
                if (!EntityDataProvider.isMonster(entityType, (Level)serverLevel)) continue;
                ++potentialEntities;
                if (EntityDataProvider.canSpawnInDimension(entityType, serverLevel)) continue;
                ++totalFiltered;
            }
            totalSkipped += potentialEntities - entitiesAdded - totalFiltered;
        }
        int totalEntitiesChecked = totalProcessed + totalSkipped + totalFiltered;
        float cacheEfficiency = totalEntitiesChecked > 0 ? (float)totalSkipped / (float)totalEntitiesChecked * 100.0f : 0.0f;
        float filterEfficiency = totalEntitiesChecked > 0 ? (float)totalFiltered / (float)totalEntitiesChecked * 100.0f : 0.0f;
        float totalEfficiency = totalEntitiesChecked > 0 ? (float)(totalSkipped + totalFiltered) / (float)totalEntitiesChecked * 100.0f : 0.0f;
        LOGGER.info("Loot cache initialization complete: {} total entity types in cache", (Object)LOOT_CACHE.size());
        LOGGER.info("Optimization statistics across all dimensions:");
        LOGGER.info("  - Processed: {} entities", (Object)totalProcessed);
        LOGGER.info("  - Skipped (already in cache): {} entities ({}% cache efficiency)", (Object)totalSkipped, (Object)Math.round(cacheEfficiency));
        LOGGER.info("  - Filtered (don't belong in dimension): {} entities ({}% filter efficiency)", (Object)totalFiltered, (Object)Math.round(filterEfficiency));
        LOGGER.info("  - Total efficiency: {}%", (Object)Math.round(totalEfficiency));
        EntityDataProvider.logPerformanceStatistics();
    }

    private static void preloadDimensionEntityCompatibilityCache(MinecraftServer server) {
        LOGGER.info("Preloading dimension-entity compatibility cache");
        long startTime = System.nanoTime();
        ArrayList<ServerLevel> levels = new ArrayList<ServerLevel>();
        for (ServerLevel level : server.m_129785_()) {
            levels.add(level);
        }
        levels.sort((a, b) -> {
            String aDim = a.m_46472_().m_135782_().toString();
            String bDim = b.m_46472_().m_135782_().toString();
            if (aDim.startsWith("minecraft:") && !bDim.startsWith("minecraft:")) {
                return -1;
            }
            if (!aDim.startsWith("minecraft:") && bDim.startsWith("minecraft:")) {
                return 1;
            }
            return aDim.compareTo(bDim);
        });
        for (ServerLevel level : levels) {
            String dimensionId = level.m_46472_().m_135782_().toString();
            LOGGER.info("Preloading compatibility cache for dimension: {}", (Object)dimensionId);
            Map dimensionCache = DIMENSION_ENTITY_COMPATIBILITY_CACHE.computeIfAbsent(dimensionId, k -> new ConcurrentHashMap());
            int preloadedCount = 0;
            ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
            for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
                if (!EntityDataProvider.isMonster(entityType, (Level)level)) continue;
                entityTypes.add(entityType);
            }
            entityTypes.sort((a, b) -> {
                String aId = ForgeRegistries.ENTITY_TYPES.getKey(a).toString();
                String bId = ForgeRegistries.ENTITY_TYPES.getKey(b).toString();
                if (aId.startsWith("minecraft:") && !bId.startsWith("minecraft:")) {
                    return -1;
                }
                if (!aId.startsWith("minecraft:") && bId.startsWith("minecraft:")) {
                    return 1;
                }
                return aId.compareTo(bId);
            });
            int limit = Math.min(50, entityTypes.size());
            for (int i = 0; i < limit; ++i) {
                EntityType entityType = (EntityType)entityTypes.get(i);
                String entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).toString();
                if (dimensionCache.containsKey(entityId)) continue;
                boolean canSpawn = false;
                if (EntityDataProvider.isBossEntity(entityType)) {
                    canSpawn = true;
                } else {
                    MobCategory category = entityType.m_20674_();
                    SpawnLocationInfo spawnLocations = EntityDataServerHelper.getServerSideSpawnLocations(entityType, level, category);
                    boolean bl = canSpawn = spawnLocations != null && !spawnLocations.getAllLocations().isEmpty();
                    if (!canSpawn) {
                        boolean isMonsterType = false;
                        try {
                            isMonsterType = EntityDataProvider.isMonster(entityType, (Level)level);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        boolean hasLootTable = false;
                        try {
                            ResourceLocation tableId = entityType.m_20677_();
                            hasLootTable = tableId != null && !tableId.equals((Object)BuiltInLootTables.f_78712_);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (isMonsterType || hasLootTable) {
                            canSpawn = true;
                            EntityDataProvider.debugLog("Permissive include (preload) for {} in {} (monsterType={}, hasLootTable={})", entityId, dimensionId, isMonsterType, hasLootTable);
                        }
                    }
                }
                dimensionCache.put(entityId, canSpawn);
                ++preloadedCount;
            }
            LOGGER.info("Preloaded {} entities for dimension {}", (Object)preloadedCount, (Object)dimensionId);
        }
        long endTime = System.nanoTime();
        long processingTime = endTime - startTime;
        LOGGER.info("Dimension-entity compatibility cache preloading complete in {} ms", (Object)(processingTime / 1000000L));
    }

    private static void supplementLootCacheWithDatapackEntries(Level level) {
        int added = 0;
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            try {
                List<LootItemEntry> jsonLoot;
                List<LootItemEntry> existing = LOOT_CACHE.get(entityType);
                boolean hasNonEmptyCache = existing != null && !existing.isEmpty();
                if (hasNonEmptyCache || !BestiaryLootManager.hasLootForEntity(entityType) || (jsonLoot = BestiaryLootManager.getLootForEntity(entityType)) == null || jsonLoot.isEmpty()) continue;
                LOOT_CACHE.put(entityType, new ArrayList<LootItemEntry>(jsonLoot));
                EntityDataProvider.bumpLootVersion(entityType);
                ++added;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Supplemented LOOT_CACHE with datapack entries for {} ({} items)", (Object)entityType.m_20676_().getString(), (Object)jsonLoot.size());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to supplement datapack loot for {}: {}", (Object)entityType, (Object)e.getMessage());
            }
        }
        if (added > 0) {
            LOGGER.info("Supplemented loot cache with datapack entries for {} entities (datapack-defined)", (Object)added);
        }
    }

    private static void logCacheStatistics() {
        LOGGER.info("Cache statistics:");
        int totalHits = CACHE_HITS.values().stream().mapToInt(Integer::intValue).sum();
        int totalMisses = CACHE_MISSES.values().stream().mapToInt(Integer::intValue).sum();
        int totalLookups = totalHits + totalMisses;
        float hitRate = totalLookups > 0 ? (float)totalHits / (float)totalLookups * 100.0f : 0.0f;
        LOGGER.info("  - Total cache lookups: {}", (Object)totalLookups);
        LOGGER.info("  - Cache hits: {} ({}% hit rate)", (Object)totalHits, (Object)Math.round(hitRate));
        LOGGER.info("  - Cache misses: {}", (Object)totalMisses);
        for (String dimensionId : DIMENSION_ENTITY_COMPATIBILITY_CACHE.keySet()) {
            int misses;
            Map<String, Boolean> dimensionCache = DIMENSION_ENTITY_COMPATIBILITY_CACHE.get(dimensionId);
            int cacheSize = dimensionCache.size();
            int hits = CACHE_HITS.getOrDefault(dimensionId, 0);
            int lookups = hits + (misses = CACHE_MISSES.getOrDefault(dimensionId, 0).intValue());
            float dimensionHitRate = lookups > 0 ? (float)hits / (float)lookups * 100.0f : 0.0f;
            LOGGER.info("  - Dimension {}: {} cached entities, {} hits, {} misses ({}% hit rate)", new Object[]{dimensionId, cacheSize, hits, misses, Math.round(dimensionHitRate)});
        }
    }

    public static void invalidateDimensionEntityCompatibilityCache() {
        LOGGER.info("Invalidating dimension-entity compatibility cache");
        DIMENSION_ENTITY_COMPATIBILITY_CACHE.clear();
        CACHE_HITS.clear();
        CACHE_MISSES.clear();
        DIMENSION_PROCESSING_TIMES.clear();
        ENTITIES_PROCESSED.clear();
        ENTITY_PROCESSING_TIMES.clear();
        ENTITIES_PER_SECOND.clear();
    }

    public static void setDebugMode(boolean enabled) {
        DEBUG_MODE = enabled;
        LOGGER.info("Debug mode {}", (Object)(enabled ? "enabled" : "disabled"));
        if (enabled) {
            debugLogCount = 0;
        }
    }

    public static void setMaxDebugLogEntries(int maxEntries) {
        MAX_DEBUG_LOG_ENTRIES = maxEntries;
        LOGGER.info("Max debug log entries set to {}", (Object)maxEntries);
    }

    private static void debugLog(String message, Object ... args) {
        if (DEBUG_MODE && debugLogCount < MAX_DEBUG_LOG_ENTRIES) {
            LOGGER.debug(message, args);
            if (++debugLogCount == MAX_DEBUG_LOG_ENTRIES) {
                LOGGER.warn("Maximum number of debug log entries ({}) reached. Further debug logs will be suppressed.", (Object)MAX_DEBUG_LOG_ENTRIES);
            }
        }
    }

    private static void trackEntityProcessing(String dimensionId, long processingTime) {
        ENTITIES_PROCESSED.merge(dimensionId, 1, Integer::sum);
        ENTITY_PROCESSING_TIMES.merge(dimensionId, processingTime, Long::sum);
        int entitiesProcessed = ENTITIES_PROCESSED.getOrDefault(dimensionId, 0);
        long totalProcessingTime = ENTITY_PROCESSING_TIMES.getOrDefault(dimensionId, 0L);
        if (totalProcessingTime > 0L) {
            int entitiesPerSecond = (int)((long)entitiesProcessed * 1000000000L / totalProcessingTime);
            ENTITIES_PER_SECOND.put(dimensionId, entitiesPerSecond);
        }
    }

    public static void logPerformanceStatistics() {
        LOGGER.info("Performance statistics:");
        int totalHits = CACHE_HITS.values().stream().mapToInt(Integer::intValue).sum();
        int totalMisses = CACHE_MISSES.values().stream().mapToInt(Integer::intValue).sum();
        int totalLookups = totalHits + totalMisses;
        float hitRate = totalLookups > 0 ? (float)totalHits / (float)totalLookups * 100.0f : 0.0f;
        LOGGER.info("  Cache statistics:");
        LOGGER.info("    - Total cache lookups: {}", (Object)totalLookups);
        LOGGER.info("    - Cache hits: {} ({}% hit rate)", (Object)totalHits, (Object)Math.round(hitRate));
        LOGGER.info("    - Cache misses: {}", (Object)totalMisses);
        int totalEntitiesProcessed = ENTITIES_PROCESSED.values().stream().mapToInt(Integer::intValue).sum();
        long totalProcessingTime = ENTITY_PROCESSING_TIMES.values().stream().mapToLong(Long::longValue).sum();
        int averageEntitiesPerSecond = totalProcessingTime > 0L ? (int)((long)totalEntitiesProcessed * 1000000000L / totalProcessingTime) : 0;
        LOGGER.info("  Entity processing statistics:");
        LOGGER.info("    - Total entities processed: {}", (Object)totalEntitiesProcessed);
        LOGGER.info("    - Total processing time: {} ms", (Object)(totalProcessingTime / 1000000L));
        LOGGER.info("    - Average processing rate: {} entities/second", (Object)averageEntitiesPerSecond);
        LOGGER.info("  Dimension-specific statistics:");
        for (String dimensionId : DIMENSION_PROCESSING_TIMES.keySet()) {
            int dimensionCacheMisses;
            long dimensionProcessingTime = DIMENSION_PROCESSING_TIMES.getOrDefault(dimensionId, 0L);
            int dimensionEntitiesProcessed = ENTITIES_PROCESSED.getOrDefault(dimensionId, 0);
            int dimensionEntitiesPerSecond = ENTITIES_PER_SECOND.getOrDefault(dimensionId, 0);
            int dimensionCacheHits = CACHE_HITS.getOrDefault(dimensionId, 0);
            int dimensionCacheLookups = dimensionCacheHits + (dimensionCacheMisses = CACHE_MISSES.getOrDefault(dimensionId, 0).intValue());
            float dimensionHitRate = dimensionCacheLookups > 0 ? (float)dimensionCacheHits / (float)dimensionCacheLookups * 100.0f : 0.0f;
            LOGGER.info("    Dimension {}:", (Object)dimensionId);
            LOGGER.info("      - Processing time: {} ms", (Object)(dimensionProcessingTime / 1000000L));
            LOGGER.info("      - Entities processed: {}", (Object)dimensionEntitiesProcessed);
            LOGGER.info("      - Processing rate: {} entities/second", (Object)dimensionEntitiesPerSecond);
            LOGGER.info("      - Cache hit rate: {}%", (Object)Math.round(dimensionHitRate));
        }
    }

    private static void initializeLootCache(ServerLevel serverLevel) {
        LOGGER.info("Initializing loot cache from server level: {}", (Object)serverLevel.m_46472_().m_135782_());
        MinecraftServer server = serverLevel.m_7654_();
        if (server != null) {
            EntityDataProvider.initializeLootCache(server);
        } else {
            LOGGER.warn("Server not available, falling back to single dimension processing");
            EntityDataProvider.processLootCacheForDimension(serverLevel);
        }
    }

    private static boolean canSpawnInDimension(EntityType<?> entityType, ServerLevel serverLevel) {
        boolean canSpawn;
        long startTime = System.nanoTime();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        ResourceLocation dimensionId = serverLevel.m_46472_().m_135782_();
        if (entityId == null || dimensionId == null) {
            return false;
        }
        String entityIdStr = entityId.toString();
        String dimensionIdStr = dimensionId.toString();
        Map entityCompatibilityCache = DIMENSION_ENTITY_COMPATIBILITY_CACHE.computeIfAbsent(dimensionIdStr, k -> new ConcurrentHashMap());
        if (entityCompatibilityCache.containsKey(entityIdStr)) {
            boolean compatible = (Boolean)entityCompatibilityCache.get(entityIdStr);
            CACHE_HITS.merge(dimensionIdStr, 1, Integer::sum);
            EntityDataProvider.debugLog("Using cached compatibility for entity {} in dimension {}: {}", entityIdStr, dimensionIdStr, compatible);
            return compatible;
        }
        CACHE_MISSES.merge(dimensionIdStr, 1, Integer::sum);
        if (EntityDataProvider.isBossEntity(entityType)) {
            EntityDataProvider.debugLog("Boss entity {} allowed in any dimension (permissive mode)", entityIdStr);
            entityCompatibilityCache.put(entityIdStr, true);
            return true;
        }
        MobCategory category = entityType.m_20674_();
        SpawnLocationInfo spawnLocations = EntityDataServerHelper.getServerSideSpawnLocations(entityType, serverLevel, category);
        boolean bl = canSpawn = spawnLocations != null && !spawnLocations.getAllLocations().isEmpty();
        if (!canSpawn) {
            boolean isMonsterType = false;
            try {
                isMonsterType = EntityDataProvider.isMonster(entityType, (Level)serverLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean hasLootTable = false;
            try {
                ResourceLocation tableId = entityType.m_20677_();
                hasLootTable = tableId != null && !tableId.equals((Object)BuiltInLootTables.f_78712_);
            }
            catch (Throwable tableId) {
                // empty catch block
            }
            if (isMonsterType || hasLootTable) {
                canSpawn = true;
                EntityDataProvider.debugLog("Permissive include for {} in {} (monsterType={}, hasLootTable={})", entityIdStr, dimensionIdStr, isMonsterType, hasLootTable);
            }
        }
        entityCompatibilityCache.put(entityIdStr, canSpawn);
        long endTime = System.nanoTime();
        long processingTime = endTime - startTime;
        DIMENSION_PROCESSING_TIMES.merge(dimensionIdStr, processingTime, Long::sum);
        EntityDataProvider.trackEntityProcessing(dimensionIdStr, processingTime);
        EntityDataProvider.debugLog("Entity {} {} allowed for loot in dimension {}", entityIdStr, canSpawn ? "is" : "is not", dimensionIdStr);
        return canSpawn;
    }

    private static boolean isBossEntity(EntityType<?> entityType) {
        if (entityType == EntityType.f_20565_ || entityType == EntityType.f_20496_ || entityType == EntityType.f_20563_ || entityType == EntityType.f_217015_) {
            return true;
        }
        String entityName = entityType.m_20676_().getString().toLowerCase();
        return entityName.contains("boss") || entityName.contains("king") || entityName.contains("queen") || entityName.contains("lord") || entityName.contains("guardian") || entityName.contains("ancient") || entityName.contains("elder");
    }

    private static void processLootCacheForDimension(ServerLevel serverLevel) {
        long startTime = System.nanoTime();
        int[] skippedCount = new int[]{0};
        int[] processedCount = new int[]{0};
        int[] dimensionFilteredCount = new int[]{0};
        ResourceLocation dimensionId = serverLevel.m_46472_().m_135782_();
        String dimensionIdStr = dimensionId.toString();
        LOGGER.debug("Processing dimension: {} (optimized)", (Object)dimensionIdStr);
        ArrayList<EntityType> entityTypesToProcess = new ArrayList<EntityType>();
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            try {
                List<LootItemEntry> existingLoot = LOOT_CACHE.get(entityType);
                if (existingLoot != null && !existingLoot.isEmpty()) {
                    skippedCount[0] = skippedCount[0] + 1;
                    continue;
                }
                if (!EntityDataProvider.canSpawnInDimension(entityType, serverLevel)) {
                    dimensionFilteredCount[0] = dimensionFilteredCount[0] + 1;
                    continue;
                }
                if (!EntityDataProvider.isMonster(entityType, (Level)serverLevel)) continue;
                entityTypesToProcess.add(entityType);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error filtering entity type: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        int batchSize = Config.initialLootSampleBatches;
        if (entityTypesToProcess.size() > batchSize) {
            HashMap byNs = new HashMap();
            for (EntityType et : entityTypesToProcess) {
                ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)et);
                if (id == null) continue;
                byNs.computeIfAbsent(id.m_135827_(), k -> new ArrayList()).add(et);
            }
            for (List list : byNs.values()) {
                list.sort((a, b) -> {
                    String aId = ForgeRegistries.ENTITY_TYPES.getKey(a).toString();
                    String bId = ForgeRegistries.ENTITY_TYPES.getKey(b).toString();
                    return aId.compareTo(bId);
                });
            }
            ArrayList namespaces = new ArrayList(byNs.keySet());
            namespaces.sort((a, b) -> {
                if (a.equals("minecraft") && !b.equals("minecraft")) {
                    return -1;
                }
                if (!a.equals("minecraft") && b.equals("minecraft")) {
                    return 1;
                }
                return a.compareTo((String)b);
            });
            ArrayList<EntityType> fairSelection = new ArrayList<EntityType>(batchSize);
            int picked = 0;
            int nsIndex = 0;
            HashMap<String, Integer> cursors = new HashMap<String, Integer>();
            for (String ns : namespaces) {
                cursors.put(ns, 0);
            }
            while (picked < batchSize && !namespaces.isEmpty()) {
                String ns;
                boolean advanced = false;
                ns = (String)namespaces.get(nsIndex);
                List list = (List)byNs.get(ns);
                int cursor = (Integer)cursors.get(ns);
                if (cursor < list.size()) {
                    fairSelection.add((EntityType)list.get(cursor));
                    cursors.put(ns, cursor + 1);
                    ++picked;
                    advanced = true;
                }
                nsIndex = (nsIndex + 1) % namespaces.size();
                if (advanced) continue;
                boolean anyLeft = false;
                for (String n : namespaces) {
                    if ((Integer)cursors.get(n) >= ((List)byNs.get(n)).size()) continue;
                    anyLeft = true;
                    break;
                }
                if (anyLeft) continue;
                break;
            }
            LOGGER.info("Limiting processing to {} out of {} eligible entities for dimension {} (balanced across {} namespaces)", new Object[]{fairSelection.size(), entityTypesToProcess.size(), dimensionIdStr, namespaces.size()});
            entityTypesToProcess = fairSelection;
        }
        for (EntityType entityType : entityTypesToProcess) {
            try {
                List<LootItemEntry> existingLoot = LOOT_CACHE.get(entityType);
                if (existingLoot != null && !existingLoot.isEmpty()) {
                    skippedCount[0] = skippedCount[0] + 1;
                    continue;
                }
                String entityName = entityType.m_20676_().getString();
                ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
                EntityDataProvider.debugLog("Generating loot cache for entity: {} ({}) in dimension: {}", entityName, entityId, dimensionIdStr);
                long entityStartTime = System.nanoTime();
                ArrayList<LootItemEntry> lootEntries = new ArrayList<LootItemEntry>();
                ArrayList<LootItemEntry> datapackEntries = new ArrayList<LootItemEntry>();
                boolean overrideEnabled = false;
                try {
                    overrideEnabled = BestiaryLootManager.isLootOverrideEnabled(entityType);
                }
                catch (Exception cursor) {
                    // empty catch block
                }
                if (overrideEnabled) {
                    List<LootItemEntry> jsonLoot = BestiaryLootManager.getLootForEntity(entityType);
                    if (jsonLoot != null && !jsonLoot.isEmpty()) {
                        lootEntries.addAll(jsonLoot);
                        LOOT_CACHE.put(entityType, lootEntries);
                        EntityDataProvider.bumpLootVersion(entityType);
                        processedCount[0] = processedCount[0] + 1;
                        LOGGER.debug("Cached {} datapack override loot entries for {}", (Object)lootEntries.size(), (Object)entityName);
                        continue;
                    }
                    LOGGER.warn("Datapack override is enabled for {} but no entries found; continuing with loot tables", (Object)entityName);
                }
                try {
                    List<LootItemEntry> tableLoot = EntityDataServerHelper.generateLootEntriesFromTable(entityType, serverLevel);
                    if (!tableLoot.isEmpty()) {
                        LOGGER.debug("Generated {} loot entries from table for entity: {}", (Object)tableLoot.size(), (Object)entityId);
                        lootEntries.addAll(tableLoot);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to generate loot entries from table for {}: {}", new Object[]{entityId, e.getMessage(), e});
                }
                try {
                    List<LootItemEntry> jsonLoot;
                    if (BestiaryLootManager.hasLootForEntity(entityType) && (jsonLoot = BestiaryLootManager.getLootForEntity(entityType)) != null && !jsonLoot.isEmpty()) {
                        datapackEntries.addAll(jsonLoot);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Failed loading datapack entries for {}: {}", (Object)entityId, (Object)e.getMessage());
                }
                if (!lootEntries.isEmpty() && !datapackEntries.isEmpty()) {
                    HashMap<Item, LootItemEntry> lootTableItemMap = new HashMap<Item, LootItemEntry>();
                    for (LootItemEntry entry : lootEntries) {
                        lootTableItemMap.put(entry.itemStack().m_41720_(), entry);
                    }
                    for (LootItemEntry datapackEntry : datapackEntries) {
                        Item item = datapackEntry.itemStack().m_41720_();
                        if (lootTableItemMap.containsKey(item)) continue;
                        lootEntries.add(datapackEntry);
                    }
                } else if (lootEntries.isEmpty() && !datapackEntries.isEmpty()) {
                    lootEntries.addAll(datapackEntries);
                }
                if (!lootEntries.isEmpty()) {
                    LOOT_CACHE.put(entityType, lootEntries);
                    EntityDataProvider.bumpLootVersion(entityType);
                    processedCount[0] = processedCount[0] + 1;
                    LOGGER.debug("Cached {} loot entries for {} in dimension {}", new Object[]{lootEntries.size(), entityName, dimensionIdStr});
                } else {
                    processedCount[0] = processedCount[0] + 1;
                    EntityDataProvider.debugLog("No loot entries to cache for {} in dimension {}", entityName, dimensionIdStr);
                }
                long entityEndTime = System.nanoTime();
                long entityProcessingTime = entityEndTime - entityStartTime;
                EntityDataProvider.trackEntityProcessing(dimensionIdStr, entityProcessingTime);
            }
            catch (Exception e) {
                LOGGER.error("Failed to cache loot for {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
            }
        }
        long endTime = System.nanoTime();
        long processingTime = endTime - startTime;
        int totalEntities = processedCount[0] + skippedCount[0] + dimensionFilteredCount[0];
        float cacheEfficiency = totalEntities > 0 ? (float)skippedCount[0] / (float)totalEntities * 100.0f : 0.0f;
        float dimensionFilterEfficiency = totalEntities > 0 ? (float)dimensionFilteredCount[0] / (float)totalEntities * 100.0f : 0.0f;
        float totalEfficiency = totalEntities > 0 ? (float)(skippedCount[0] + dimensionFilteredCount[0]) / (float)totalEntities * 100.0f : 0.0f;
        LOGGER.info("Dimension {}: Processed {} entities, skipped {} entities that were already in cache ({}% cache efficiency), filtered {} entities that don't belong in this dimension ({}% dimension filter efficiency), total efficiency: {}%, processing time: {} ms", new Object[]{dimensionIdStr, processedCount[0], skippedCount[0], Math.round(cacheEfficiency), dimensionFilteredCount[0], Math.round(dimensionFilterEfficiency), Math.round(totalEfficiency), processingTime / 1000000L});
    }

    public static List<MonsterEntry> getMonsterEntries(Level level) {
        ResourceLocation resourceLocation;
        ServerLevel sl;
        Level effectiveLevel;
        if (MONSTER_ENTRIES_CACHE != null && !MONSTER_ENTRIES_CACHE.isEmpty()) {
            LOGGER.debug("Using cached monster entries: {}", (Object)MONSTER_ENTRIES_CACHE.size());
            return MONSTER_ENTRIES_CACHE;
        }
        Object object = effectiveLevel = level instanceof ServerLevel && (sl = (ServerLevel)level).m_7654_() != null && sl.m_7654_().m_129783_() != null ? sl.m_7654_().m_129783_() : level;
        if (effectiveLevel instanceof ServerLevel) {
            ServerLevel cl = (ServerLevel)effectiveLevel;
            resourceLocation = cl.m_46472_().m_135782_();
        } else {
            resourceLocation = level != null ? level.m_46472_().m_135782_() : null;
        }
        LOGGER.info("Fetching monster entities from the game registry using canonical level: {}", resourceLocation);
        ArrayList<MonsterEntry> monsters = new ArrayList<MonsterEntry>();
        ForgeRegistries.ENTITY_TYPES.forEach(entityType -> {
            block5: {
                try {
                    if (!EntityDataProvider.isMonster(entityType, effectiveLevel)) break block5;
                    LOGGER.debug("Found monster entity: {}", (Object)entityType.m_20676_().getString());
                    try {
                        MonsterEntry entry = EntityDataProvider.createMonsterEntry(entityType, effectiveLevel);
                        if (entry != null) {
                            monsters.add(entry);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating monster entry for {}: {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error processing entity type: {}", (Object)e.getMessage());
                }
            }
        });
        LOGGER.info("Found {} monster entities", (Object)monsters.size());
        MONSTER_ENTRIES_CACHE = monsters;
        return monsters;
    }

    public static List<MonsterEntry> getProgressiveMonsterEntries(Level level, Player player) {
        PlayerProgressionData progressionData;
        List<MonsterEntry> baseEntries = EntityDataProvider.getMonsterEntries(level);
        if (!Config.enableProgressionSystem || player == null) {
            LOGGER.debug("Progression disabled or player null, returning base entries");
            return baseEntries;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            progressionData = PlayerProgressionData.getOrCreate(serverLevel);
            LOGGER.debug("Got server-side progression data for player: {}", (Object)player.m_7755_().getString());
        } else {
            LOGGER.debug("Client-side progression: using client-side cache");
            progressionData = null;
        }
        List<MonsterEntry> progressiveEntries = baseEntries.stream().map(entry -> {
            ProgressiveEntityData progressiveData = new ProgressiveEntityData((MonsterEntry)entry, player, progressionData);
            return progressiveData.toMonsterEntry();
        }).collect(Collectors.toList());
        LOGGER.debug("Created {} progressive monster entries for player {}", (Object)progressiveEntries.size(), (Object)player.m_7755_().getString());
        return progressiveEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMonster(EntityType<?> entityType, Level level) {
        try {
            if (EntityDataProvider.isEntityBlacklisted(entityType)) {
                return false;
            }
            if (BestiaryAttributeManager.isEntityHidden(entityType)) {
                return false;
            }
            if (EntityDataProvider.isEntityIncluded(entityType)) {
                return true;
            }
            MobCategory category = entityType.m_20674_();
            if (Config.monsterCategories.isEmpty()) {
                if (category != MobCategory.MISC) return true;
                Entity temp = null;
                try {
                    temp = entityType.m_20615_(level);
                    if (temp instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)temp;
                        AttributeInstance attr = living.m_21051_(Attributes.f_22276_);
                        boolean bl = attr != null && attr.m_22135_() > 0.0;
                        return bl;
                    }
                    boolean living = false;
                    return living;
                }
                finally {
                    if (temp != null) {
                        temp.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
            for (String categoryName : Config.monsterCategories) {
                try {
                    if (!category.equals((Object)MobCategory.byName((String)categoryName))) continue;
                    if (!"misc".equals(categoryName)) return true;
                    return true;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Invalid mob category in config: {}", (Object)categoryName);
                }
            }
            if (entityType.m_142225_() == null) return false;
            if (!Monster.class.isAssignableFrom(entityType.m_142225_())) return false;
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Error checking if entity type is a monster or creature: {}, {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
            return false;
        }
    }

    private static boolean isEntityBlacklisted(EntityType<?> entityType) {
        try {
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            if (entityId == null) {
                return false;
            }
            String entityIdString = entityId.toString();
            for (String blacklistedEntity : Config.entityBlacklist) {
                if (!blacklistedEntity.equals(entityIdString)) continue;
                LOGGER.debug("Entity {} is blacklisted and will not be shown in the bestiary", (Object)entityIdString);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Error checking if entity is blacklisted: {}, {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
            return false;
        }
    }

    private static boolean isEntityIncluded(EntityType<?> entityType) {
        try {
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            if (entityId == null) {
                return false;
            }
            String entityIdString = entityId.toString();
            for (String includedEntity : Config.entityIncludeList) {
                if (!includedEntity.equals(entityIdString)) continue;
                LOGGER.debug("Entity {} is in the include list and will be prioritized in the bestiary", (Object)entityIdString);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Error checking if entity is in include list: {}, {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
            return false;
        }
    }

    public static boolean shouldTrackProgression(EntityType<?> entityType) {
        try {
            if (EntityDataProvider.isEntityBlacklisted(entityType)) {
                return false;
            }
            return !BestiaryAttributeManager.isEntityHidden(entityType);
        }
        catch (Exception e) {
            LOGGER.warn("Error checking progression eligibility for {}: {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
            return true;
        }
    }

    private static MonsterEntry createMonsterEntry(EntityType<?> entityType, Level level) {
        try {
            List<LootItemEntry> loot;
            Component name = entityType.m_20676_();
            LOGGER.debug("Creating monster entry for: {}", (Object)name);
            int health = EntityDataProvider.getEntityHealth(entityType, level);
            int damage = EntityDataProvider.getEntityDamage(entityType, level);
            float knockbackResistance = EntityDataProvider.getEntityKnockbackResistance(entityType, level);
            int armor = EntityDataProvider.getEntityArmor(entityType, level);
            float armorToughness = EntityDataProvider.getEntityArmorToughness(entityType, level);
            float movementSpeed = EntityDataProvider.getEntityMovementSpeed(entityType, level);
            int experience = EntityDataProvider.getEntityExperience(entityType, level);
            SpawnLocationInfo spawnLocation = EntityDataProvider.getSpawnLocationInfo(entityType, level);
            if (LOOT_CACHE.containsKey(entityType)) {
                loot = LOOT_CACHE.get(entityType);
                LOGGER.debug("Using cached loot for {}: {} entries", (Object)name, (Object)loot.size());
            } else {
                loot = EntityDataProvider.getLootEntries(entityType, level);
                LOGGER.debug("Generated loot for {}: {} entries", (Object)name, (Object)loot.size());
            }
            MutableComponent description = Component.m_237119_();
            boolean isBoss = false;
            LOGGER.debug("Checking if entity {} has attributes", (Object)name);
            boolean hasAttributes = BestiaryAttributeManager.hasAttributesForEntity(entityType);
            LOGGER.debug("Entity {} {} attributes", (Object)name, (Object)(hasAttributes ? "has" : "does not have"));
            if (hasAttributes) {
                LOGGER.debug("Getting attributes for entity: {}", (Object)name);
                EntityAttributes attributes = BestiaryAttributeManager.getAttributesForEntity(entityType);
                if (attributes != null) {
                    description = attributes.description();
                    isBoss = attributes.boss();
                    LOGGER.debug("Retrieved attributes for entity {}: boss={}, experience={}", new Object[]{name, isBoss, experience});
                    LOGGER.debug("Using description from attributes for {}: {}", (Object)name, (Object)description);
                    LOGGER.debug("Entity {} is {}a boss with {} experience", new Object[]{name, isBoss ? "" : "not ", experience});
                    if (entityType.m_20675_().contains("hoglin")) {
                        LOGGER.debug("HOGLIN ENTITY BOSS FLAG: {}, EXPERIENCE: {}", (Object)isBoss, (Object)experience);
                    }
                } else {
                    LOGGER.debug("Retrieved NULL attributes for entity: {}", (Object)name);
                }
            } else {
                LOGGER.debug("No attributes found for entity: {}", (Object)name);
            }
            LOGGER.debug("Created monster entry: {} (Health: {}, Damage: {}, KnockbackResistance: {}, Armor: {}, ArmorToughness: {}, MovementSpeed: {}, Experience: {}, Loot items: {}, Has description: {}, Is boss: {})", new Object[]{name, health, damage, Float.valueOf(knockbackResistance), armor, Float.valueOf(armorToughness), Float.valueOf(movementSpeed), experience, loot.size(), !description.getString().isEmpty(), isBoss});
            return new MonsterEntry(name, health, damage, knockbackResistance, armor, armorToughness, movementSpeed, experience, spawnLocation, loot, entityType, description.getString(), isBoss);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create monster entry for: {}", (Object)entityType.m_20676_().getString(), (Object)e);
            return null;
        }
    }

    private static <T extends Entity> T createEntityInstance(EntityType<?> entityType, Level level) {
        try {
            if (level != null) {
                LOGGER.debug("Attempting to create entity instance for {} with level {}", (Object)entityType.m_20676_().getString(), (Object)level.m_46472_().m_135782_());
                Entity entity = entityType.m_20615_(level);
                if (entity != null) {
                    LOGGER.debug("Successfully created entity instance for {}", (Object)entityType.m_20676_().getString());
                    return (T)entity;
                }
                LOGGER.error("Failed to create entity instance for {}: entity is null", (Object)entityType.m_20676_().getString());
            } else {
                LOGGER.error("Failed to create entity instance for {}: level is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception creating entity instance for {}: {}", new Object[]{entityType.m_20676_().getString(), e.getMessage(), e});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getEntityHealth(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        int defaultHealth = 20;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using health from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes2.health());
            return attributes2.health();
        }
        Object entity = null;
        int gameHealth = -1;
        try {
            LOGGER.debug("Getting health for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (livingEntity.m_21051_(Attributes.f_22276_) != null) {
                    double maxHealth = livingEntity.m_21051_(Attributes.f_22276_).m_22135_();
                    LOGGER.debug("Got actual health for {}: {}", (Object)entityType.m_20676_().getString(), (Object)maxHealth);
                    gameHealth = (int)maxHealth;
                } else {
                    float maxHealth = livingEntity.m_21233_();
                    LOGGER.debug("Got health from getMaxHealth for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(maxHealth));
                    gameHealth = (int)maxHealth;
                }
            } else {
                LOGGER.debug("Failed to get health for {}: entity is not a LivingEntity or is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception getting health for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting health: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameHealth > 0) {
            return gameHealth;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            LOGGER.debug("Using health from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes.health());
            return attributes.health();
        }
        LOGGER.debug("Using default health value ({}) for {}", (Object)defaultHealth, (Object)entityType.m_20676_().getString());
        return defaultHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getEntityDamage(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        int defaultDamage = 0;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using damage from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes2.damage());
            return attributes2.damage();
        }
        Object entity = null;
        int gameDamage = -1;
        try {
            LOGGER.debug("Getting damage for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null) {
                if (entity instanceof Mob) {
                    Mob mob = entity;
                    if (mob.m_21051_(Attributes.f_22281_) != null) {
                        double attackDamage = mob.m_21051_(Attributes.f_22281_).m_22135_();
                        LOGGER.debug("Got actual damage for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attackDamage);
                        gameDamage = (int)attackDamage;
                    } else {
                        LOGGER.debug("Failed to get damage for {}: ATTACK_DAMAGE attribute is null", (Object)entityType.m_20676_().getString());
                    }
                } else if (entity instanceof LivingEntity) {
                    LOGGER.debug("Entity is LivingEntity but not Mob, using default damage for {}", (Object)entityType.m_20676_().getString());
                } else {
                    LOGGER.debug("Entity is not a LivingEntity, using default damage for {}", (Object)entityType.m_20676_().getString());
                }
            } else {
                LOGGER.debug("Failed to get damage for {}: entity instance is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting damage for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting damage: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameDamage > 0) {
            return gameDamage;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            LOGGER.debug("Using damage from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes.damage());
            return attributes.damage();
        }
        LOGGER.debug("Using default damage value ({}) for {}", (Object)defaultDamage, (Object)entityType.m_20676_().getString());
        return defaultDamage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getEntityKnockbackResistance(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        float defaultKnockbackResistance = 0.0f;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using knockback resistance from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(attributes2.knockbackResistance()));
            return attributes2.knockbackResistance();
        }
        Object entity = null;
        float gameKnockbackResistance = -1.0f;
        try {
            LOGGER.debug("Getting knockback resistance for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (livingEntity.m_21051_(Attributes.f_22278_) != null) {
                    double knockbackResistance = livingEntity.m_21051_(Attributes.f_22278_).m_22135_();
                    LOGGER.debug("Got actual knockback resistance for {}: {}", (Object)entityType.m_20676_().getString(), (Object)knockbackResistance);
                    gameKnockbackResistance = (float)knockbackResistance;
                } else {
                    LOGGER.warn("Failed to get knockback resistance for {}: KNOCKBACK_RESISTANCE attribute is null", (Object)entityType.m_20676_().getString());
                }
            } else {
                LOGGER.debug("Failed to get knockback resistance for {}: entity is not a LivingEntity or is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception getting knockback resistance for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting knockback resistance: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameKnockbackResistance >= 0.0f) {
            return gameKnockbackResistance;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            LOGGER.debug("Using knockback resistance from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(attributes.knockbackResistance()));
            return attributes.knockbackResistance();
        }
        LOGGER.debug("Using default knockback resistance value ({}) for {}", (Object)Float.valueOf(defaultKnockbackResistance), (Object)entityType.m_20676_().getString());
        return defaultKnockbackResistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getEntityArmor(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        int defaultArmor = 0;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using armor from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes2.armor());
            return attributes2.armor();
        }
        Object entity = null;
        int gameArmor = -1;
        try {
            LOGGER.debug("Getting armor for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (livingEntity.m_21051_(Attributes.f_22284_) != null) {
                    double armor = livingEntity.m_21051_(Attributes.f_22284_).m_22135_();
                    LOGGER.debug("Got actual armor for {}: {}", (Object)entityType.m_20676_().getString(), (Object)armor);
                    gameArmor = (int)armor;
                } else {
                    LOGGER.warn("Failed to get armor for {}: ARMOR attribute is null", (Object)entityType.m_20676_().getString());
                }
            } else {
                LOGGER.debug("Failed to get armor for {}: entity is not a LivingEntity or is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception getting armor for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting armor: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameArmor >= 0) {
            return gameArmor;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            LOGGER.debug("Using armor from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes.armor());
            return attributes.armor();
        }
        LOGGER.debug("Using default armor value ({}) for {}", (Object)defaultArmor, (Object)entityType.m_20676_().getString());
        return defaultArmor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getEntityArmorToughness(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        float defaultArmorToughness = 0.0f;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using armor toughness from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(attributes2.armorToughness()));
            return attributes2.armorToughness();
        }
        Object entity = null;
        float gameArmorToughness = -1.0f;
        try {
            LOGGER.debug("Getting armor toughness for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (livingEntity.m_21051_(Attributes.f_22285_) != null) {
                    double armorToughness = livingEntity.m_21051_(Attributes.f_22285_).m_22135_();
                    LOGGER.debug("Got actual armor toughness for {}: {}", (Object)entityType.m_20676_().getString(), (Object)armorToughness);
                    gameArmorToughness = (float)armorToughness;
                } else {
                    LOGGER.warn("Failed to get armor toughness for {}: ARMOR_TOUGHNESS attribute is null", (Object)entityType.m_20676_().getString());
                }
            } else {
                LOGGER.debug("Failed to get armor toughness for {}: entity is not a LivingEntity or is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception getting armor toughness for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting armor toughness: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameArmorToughness >= 0.0f) {
            return gameArmorToughness;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            LOGGER.debug("Using armor toughness from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(attributes.armorToughness()));
            return attributes.armorToughness();
        }
        LOGGER.debug("Using default armor toughness value ({}) for {}", (Object)Float.valueOf(defaultArmorToughness), (Object)entityType.m_20676_().getString());
        return defaultArmorToughness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getEntityMovementSpeed(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        float defaultMovementSpeed = 0.3f;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using movement speed from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(attributes2.movementSpeed()));
            return attributes2.movementSpeed();
        }
        Object entity = null;
        float gameMovementSpeed = -1.0f;
        try {
            LOGGER.debug("Getting movement speed for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                    double movementSpeed = livingEntity.m_21051_(Attributes.f_22279_).m_22135_();
                    LOGGER.debug("Got actual movement speed for {}: {}", (Object)entityType.m_20676_().getString(), (Object)movementSpeed);
                    gameMovementSpeed = (float)movementSpeed;
                } else {
                    LOGGER.warn("Failed to get movement speed for {}: MOVEMENT_SPEED attribute is null", (Object)entityType.m_20676_().getString());
                }
            } else {
                LOGGER.debug("Failed to get movement speed for {}: entity is not a LivingEntity or is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception getting movement speed for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting movement speed: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameMovementSpeed > 0.0f) {
            return gameMovementSpeed;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            LOGGER.debug("Using movement speed from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)Float.valueOf(attributes.movementSpeed()));
            return attributes.movementSpeed();
        }
        LOGGER.debug("Using default movement speed value ({}) for {}", (Object)Float.valueOf(defaultMovementSpeed), (Object)entityType.m_20676_().getString());
        return defaultMovementSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getEntityExperience(EntityType<?> entityType, Level level) {
        EntityAttributes attributes;
        EntityAttributes attributes2;
        int defaultExperience = 0;
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes2 = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null && attributes2.override()) {
            LOGGER.debug("Using experience from JSON with override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)attributes2.experience());
            return attributes2.experience();
        }
        Object entity = null;
        int gameExperience = -1;
        try {
            LOGGER.debug("Getting experience for entity type: {}", (Object)entityType.m_20676_().getString());
            entity = EntityDataProvider.createEntityInstance(entityType, level);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                Player dummyPlayer = null;
                if (level != null && level.m_6907_().size() > 0) {
                    dummyPlayer = (Player)level.m_6907_().get(0);
                }
                int experienceReward = livingEntity.m_213860_();
                LOGGER.debug("Got actual experience for {}: {}", (Object)entityType.m_20676_().getString(), (Object)experienceReward);
                gameExperience = experienceReward;
            } else {
                LOGGER.debug("Failed to get experience for {}: entity is not a LivingEntity or is null", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception getting experience for entity type {}: {}", new Object[]{entityType.m_20675_(), e.getMessage(), e});
        }
        finally {
            if (entity != null) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                LOGGER.debug("Disposed entity after getting experience: {}", (Object)entityType.m_20676_().getString());
            }
        }
        if (gameExperience > 0) {
            return gameExperience;
        }
        if (BestiaryAttributeManager.hasAttributesForEntity(entityType) && (attributes = BestiaryAttributeManager.getAttributesForEntity(entityType)) != null) {
            int jsonExperience = attributes.experience();
            if (gameExperience == 0 && jsonExperience > 0) {
                LOGGER.debug("Game returned 0 XP for {}, using non-zero JSON value instead: {}", (Object)entityType.m_20676_().getString(), (Object)jsonExperience);
                return jsonExperience;
            }
            if (gameExperience < 0) {
                LOGGER.debug("Using experience from JSON for {}: {}", (Object)entityType.m_20676_().getString(), (Object)jsonExperience);
                return jsonExperience;
            }
        }
        if (gameExperience == 0) {
            LOGGER.debug("Using game experience value (0) for {}", (Object)entityType.m_20676_().getString());
            return gameExperience;
        }
        LOGGER.debug("Using default experience value ({}) for {}", (Object)defaultExperience, (Object)entityType.m_20676_().getString());
        return defaultExperience;
    }

    private static SpawnLocationInfo getSpawnLocationInfo(EntityType<?> entityType) {
        return EntityDataProvider.getSpawnLocationInfo(entityType, null);
    }

    private static SpawnLocationInfo getSpawnLocationInfo(EntityType<?> entityType, Level level) {
        LOGGER.debug("Getting spawn location info for entity: {}", (Object)entityType.m_20676_().getString());
        try {
            SpawnLocationInfo datapackSpawnLocations;
            MobCategory category = entityType.m_20674_();
            String entityId = entityType.m_20675_().toLowerCase();
            if (BestiarySpawnLocationManager.hasSpawnLocationsForEntity(entityType) && (datapackSpawnLocations = BestiarySpawnLocationManager.getSpawnLocationsForEntity(entityType)) != null && datapackSpawnLocations.isOverride()) {
                LOGGER.debug("Using datapack spawn locations with override for {}", (Object)entityType.m_20676_().getString());
                return datapackSpawnLocations;
            }
            SpawnLocationInfo gameSpawnLocations = null;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LOGGER.debug("Using server-side method to get spawn locations for {}", (Object)entityType.m_20676_().getString());
                gameSpawnLocations = EntityDataServerHelper.getServerSideSpawnLocations(entityType, serverLevel, category);
            } else {
                LOGGER.debug("Using client-side method to get spawn locations for {}", (Object)entityType.m_20676_().getString());
                gameSpawnLocations = (SpawnLocationInfo)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> EntityDataClientHelper.getClientSideSpawnLocations(entityType, category));
            }
            SpawnLocationInfo datapackSpawnLocations2 = null;
            if (BestiarySpawnLocationManager.hasSpawnLocationsForEntity(entityType)) {
                datapackSpawnLocations2 = BestiarySpawnLocationManager.getSpawnLocationsForEntity(entityType);
                LOGGER.debug("Found spawn locations in data pack for entity: {}", (Object)entityType.m_20676_().getString());
            }
            if (gameSpawnLocations != null) {
                if (datapackSpawnLocations2 != null) {
                    ArrayList<Component> combinedLocations = new ArrayList<Component>(gameSpawnLocations.getAllLocations());
                    for (Component datapackLocation : datapackSpawnLocations2.getAllLocations()) {
                        if (combinedLocations.contains(datapackLocation)) continue;
                        combinedLocations.add(datapackLocation);
                    }
                    return new SpawnLocationInfo(combinedLocations, false);
                }
                return gameSpawnLocations;
            }
            if (datapackSpawnLocations2 != null) {
                return datapackSpawnLocations2;
            }
            LOGGER.debug("No spawn locations found for {}, using fallback", (Object)entityType.m_20676_().getString());
            return EntityDataProvider.getFallbackSpawnLocations(entityType, category, entityId);
        }
        catch (Exception e) {
            LOGGER.error("Error determining spawn locations for {}: {}", (Object)entityType.m_20676_().getString(), (Object)e.getMessage());
            return new SpawnLocationInfo((Component)Component.m_237115_((String)"screen.araxers_bestiary.spawn.various_spawn_locations"));
        }
    }

    private static SpawnLocationInfo getFallbackSpawnLocations(EntityType<?> entityType, MobCategory category, String entityId) {
        try {
            SpawnLocationInfo spawnLocations;
            ResourceLocation entityResLoc = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            if (entityResLoc == null) {
                throw new IllegalArgumentException("Entity type has no registry key");
            }
            String namespace = entityResLoc.m_135827_();
            String path = entityResLoc.m_135815_();
            LOGGER.debug("Attempting to load fallback spawn locations for entity: {}:{}", (Object)namespace, (Object)path);
            if (BestiarySpawnLocationManager.hasSpawnLocationsForEntity(entityType) && (spawnLocations = BestiarySpawnLocationManager.getSpawnLocationsForEntity(entityType)) != null) {
                LOGGER.debug("Found spawn locations in data pack for entity: {}", (Object)entityResLoc);
                return spawnLocations;
            }
            LOGGER.debug("No spawn locations found in data packs for entity: {}, using category-based fallback", (Object)entityResLoc);
            return new SpawnLocationInfo((Component)Component.m_237115_((String)"screen.araxers_bestiary.spawn.various_spawn_locations"));
        }
        catch (Exception e) {
            LOGGER.error("Failed to get fallback spawn locations: {}", (Object)e.getMessage());
            return new SpawnLocationInfo((Component)Component.m_237115_((String)"screen.araxers_bestiary.spawn.various_spawn_locations"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<LootItemEntry> getLootEntries(EntityType<?> entityType, Level level) {
        List<LootItemEntry> jsonLoot;
        if (LOOT_CACHE.containsKey(entityType)) {
            List<LootItemEntry> cached = LOOT_CACHE.get(entityType);
            if (cached != null && !cached.isEmpty()) {
                boolean hasUnknown = false;
                for (LootItemEntry e : cached) {
                    if (!e.hasUnknownDropChance()) continue;
                    hasUnknown = true;
                    break;
                }
                if (hasUnknown && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    try {
                        List<LootItemEntry> tableLoot = EntityDataServerHelper.generateLootEntriesFromTable(entityType, serverLevel);
                        if (tableLoot != null && !tableLoot.isEmpty()) {
                            void var10_43;
                            Item it;
                            void var7_21;
                            HashMap<Item, LootItemEntry> tableMap = new HashMap<Item, LootItemEntry>();
                            for (LootItemEntry lootItemEntry : tableLoot) {
                                tableMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                            }
                            boolean bl = false;
                            for (LootItemEntry e : cached) {
                                if (!e.hasUnknownDropChance()) continue;
                                ++var7_21;
                            }
                            ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>();
                            HashSet present = new HashSet();
                            for (LootItemEntry lootItemEntry : cached) {
                                it = lootItemEntry.itemStack().m_41720_();
                                present.add(it);
                                LootItemEntry te = (LootItemEntry)tableMap.get(it);
                                if (lootItemEntry.hasUnknownDropChance() && te != null && !te.hasUnknownDropChance()) {
                                    arrayList.add(new LootItemEntry(lootItemEntry.itemStack(), lootItemEntry.displayName(), te.dropChance(), lootItemEntry.override()));
                                    continue;
                                }
                                arrayList.add(lootItemEntry);
                            }
                            for (LootItemEntry lootItemEntry : tableLoot) {
                                it = lootItemEntry.itemStack().m_41720_();
                                if (present.contains(it)) continue;
                                arrayList.add(lootItemEntry);
                            }
                            boolean bl2 = false;
                            for (LootItemEntry e : arrayList) {
                                if (!e.hasUnknownDropChance()) continue;
                                ++var10_43;
                            }
                            if (var10_43 < var7_21 || arrayList.size() != cached.size()) {
                                LOOT_CACHE.put(entityType, arrayList);
                                EntityDataProvider.bumpLootVersion(entityType);
                                LOGGER.debug("Refined cached loot for {}: unknown {} -> {}, entries {} -> {}", new Object[]{entityType.m_20676_().getString(), (int)var7_21, (int)var10_43, cached.size(), arrayList.size()});
                                return arrayList;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Failed refining cached loot for {}: {}", (Object)entityType.m_20676_().getString(), (Object)ex.getMessage());
                    }
                }
                if (!hasUnknown && level instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level;
                    try {
                        List<LootItemEntry> tableLoot2 = EntityDataServerHelper.generateLootEntriesFromTable(entityType, serverLevel2);
                        if (tableLoot2 != null && !tableLoot2.isEmpty()) {
                            boolean bl;
                            HashMap<Item, LootItemEntry> existingMap = new HashMap<Item, LootItemEntry>();
                            for (LootItemEntry lootItemEntry : cached) {
                                existingMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                            }
                            boolean bl3 = false;
                            ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>(cached);
                            for (LootItemEntry lootItemEntry : tableLoot2) {
                                int idx;
                                Item item = lootItemEntry.itemStack().m_41720_();
                                LootItemEntry ex = (LootItemEntry)existingMap.get(item);
                                if (ex == null) {
                                    arrayList.add(lootItemEntry);
                                    existingMap.put(item, lootItemEntry);
                                    bl = true;
                                    continue;
                                }
                                if (!ex.hasUnknownDropChance() || lootItemEntry.hasUnknownDropChance() || (idx = arrayList.indexOf(ex)) < 0) continue;
                                arrayList.set(idx, new LootItemEntry(ex.itemStack(), ex.displayName(), lootItemEntry.dropChance(), ex.override()));
                                bl = true;
                            }
                            if (bl) {
                                LOOT_CACHE.put(entityType, arrayList);
                                EntityDataProvider.bumpLootVersion(entityType);
                                LOGGER.debug("Supplemented cached loot for {} with {} new/refined items from sampling", (Object)entityType.m_20676_().getString(), (Object)(arrayList.size() - cached.size()));
                                return arrayList;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Sampling enrichment on cached loot failed for {}: {}", (Object)entityType.m_20676_().getString(), (Object)ex.getMessage());
                    }
                }
                LOGGER.debug("Using cached loot entries for {}", (Object)entityType.m_20676_().getString());
                return cached;
            }
            LOGGER.debug("Cache entry for {} is empty; proceeding to resolve loot entries", (Object)entityType.m_20676_().getString());
        }
        LOGGER.debug("Resolving loot entries for {} on {}", (Object)entityType.m_20676_().getString(), (Object)(level instanceof ServerLevel ? "server" : "client"));
        List<Object> lootEntries = new ArrayList();
        ArrayList<LootItemEntry> datapackEntries = new ArrayList<LootItemEntry>();
        boolean overrideEnabled = false;
        try {
            overrideEnabled = BestiaryLootManager.isLootOverrideEnabled(entityType);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (overrideEnabled) {
            try {
                jsonLoot = BestiaryLootManager.getLootForEntity(entityType);
                if (jsonLoot != null && !jsonLoot.isEmpty()) {
                    LOGGER.debug("Using datapack override: {} entries for {}", (Object)jsonLoot.size(), (Object)entityType.m_20676_().getString());
                    LOOT_CACHE.put(entityType, new ArrayList<LootItemEntry>(jsonLoot));
                    EntityDataProvider.bumpLootVersion(entityType);
                    return new ArrayList<LootItemEntry>(jsonLoot);
                }
                LOGGER.warn("Datapack override enabled for {} but no entries found; falling back to loot tables", (Object)entityType.m_20676_().getString());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load datapack override for {}: {}", (Object)entityType.m_20676_().getString(), (Object)e.getMessage());
            }
        }
        try {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                lootEntries = EntityDataServerHelper.generateLootEntriesFromTable(entityType, serverLevel);
                LOGGER.debug("Generated {} loot entries from loot table for {}", (Object)lootEntries.size(), (Object)entityType.m_20676_().getString());
            } else {
                LOGGER.debug("No ServerLevel available for {}, attempting client-side fallback/datapack", (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error generating loot entries from table for {}: {}", (Object)entityType.m_20676_().getString(), (Object)e.getMessage());
        }
        try {
            if (BestiaryLootManager.hasLootForEntity(entityType) && (jsonLoot = BestiaryLootManager.getLootForEntity(entityType)) != null && !jsonLoot.isEmpty()) {
                datapackEntries.addAll(jsonLoot);
                LOGGER.debug("Found {} datapack loot entries for {}", (Object)jsonLoot.size(), (Object)entityType.m_20676_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get datapack loot entries for {}: {}", (Object)entityType.m_20676_().getString(), (Object)e.getMessage());
        }
        if (!lootEntries.isEmpty() && !datapackEntries.isEmpty()) {
            HashMap<Item, LootItemEntry> tableMap = new HashMap<Item, LootItemEntry>();
            for (LootItemEntry lootItemEntry : lootEntries) {
                tableMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
            }
            for (LootItemEntry lootItemEntry : datapackEntries) {
                Item item = lootItemEntry.itemStack().m_41720_();
                if (tableMap.containsKey(item)) continue;
                lootEntries.add(lootItemEntry);
                LOGGER.debug("Added supplementary datapack entry: {} with chance {}", (Object)lootItemEntry.displayName(), (Object)Float.valueOf(lootItemEntry.dropChance()));
            }
        } else if (lootEntries.isEmpty() && !datapackEntries.isEmpty()) {
            lootEntries.addAll(datapackEntries);
        }
        if (lootEntries.isEmpty() && !(level instanceof ServerLevel)) {
            EntityDataProvider.addFallbackLootEntries(entityType, lootEntries);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevelForSampling = (ServerLevel)level;
            try {
                List<LootItemEntry> list;
                int batches = Config.initialLootSampleBatches;
                if (batches <= 0) {
                    batches = 100;
                }
                if (batches > 300) {
                    batches = 300;
                }
                if ((list = EntityDataServerHelper.simulateAdditionalLootSamples(entityType, serverLevelForSampling, Math.max(20, batches / 2))) != null && !list.isEmpty()) {
                    HashMap<Item, LootItemEntry> hashMap = new HashMap<Item, LootItemEntry>();
                    for (LootItemEntry lootItemEntry : lootEntries) {
                        hashMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                    }
                    boolean changed = false;
                    ArrayList<Object> arrayList = new ArrayList<Object>(lootEntries);
                    for (LootItemEntry se : list) {
                        int idx;
                        Item it = se.itemStack().m_41720_();
                        LootItemEntry ex = (LootItemEntry)hashMap.get(it);
                        if (ex == null) {
                            arrayList.add(se);
                            hashMap.put(it, se);
                            changed = true;
                            continue;
                        }
                        if (!ex.hasUnknownDropChance() || se.hasUnknownDropChance() || (idx = arrayList.indexOf(ex)) < 0) continue;
                        arrayList.set(idx, new LootItemEntry(ex.itemStack(), ex.displayName(), se.dropChance(), ex.override()));
                        changed = true;
                    }
                    if (changed) {
                        lootEntries = arrayList;
                    }
                }
            }
            catch (Exception sampEx) {
                LOGGER.debug("Sampling supplement failed for {}: {}", (Object)entityType.m_20676_().getString(), (Object)sampEx.getMessage());
            }
        }
        if (!lootEntries.isEmpty()) {
            LOOT_CACHE.put(entityType, new ArrayList<Object>(lootEntries));
            EntityDataProvider.bumpLootVersion(entityType);
        }
        return lootEntries;
    }

    private static void addFallbackLootEntries(EntityType<?> entityType, List<LootItemEntry> lootEntries) {
        block10: {
            LOGGER.debug("Adding fallback loot entries for {}", (Object)entityType.m_20676_().getString());
            try {
                ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
                if (entityId == null) {
                    throw new IllegalArgumentException("Entity type has no registry key");
                }
                String namespace = entityId.m_135827_();
                String path = entityId.m_135815_();
                LOGGER.debug("Attempting to load fallback loot for entity: {}:{}", (Object)namespace, (Object)path);
                if (LOOT_CACHE.containsKey(entityType)) {
                    List<LootItemEntry> cachedLoot = LOOT_CACHE.get(entityType);
                    if (cachedLoot != null && !cachedLoot.isEmpty()) {
                        LOGGER.debug("Found {} loot entries in cache for entity: {}", (Object)cachedLoot.size(), (Object)entityId);
                        lootEntries.addAll(cachedLoot);
                        return;
                    }
                    LOGGER.debug("No loot entries found in cache for entity: {}", (Object)entityId);
                } else {
                    LOGGER.debug("No loot cache entry for entity: {}", (Object)entityId);
                }
                if (BestiaryLootManager.hasLootForEntity(entityType)) {
                    List<LootItemEntry> jsonLoot = BestiaryLootManager.getLootForEntity(entityType);
                    if (jsonLoot != null && !jsonLoot.isEmpty()) {
                        LOGGER.debug("Found {} loot entries in data pack for entity: {}", (Object)jsonLoot.size(), (Object)entityId);
                        lootEntries.addAll(jsonLoot);
                        LOOT_CACHE.put(entityType, new ArrayList<LootItemEntry>(jsonLoot));
                        EntityDataProvider.bumpLootVersion(entityType);
                        LOGGER.debug("Added {} loot entries to cache for entity: {}", (Object)jsonLoot.size(), (Object)entityId);
                    } else {
                        LOGGER.debug("No loot entries found in data pack for entity: {}", (Object)entityId);
                    }
                } else {
                    LOGGER.debug("No loot defined in data pack for entity: {}", (Object)entityId);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to add fallback loot entries: {}", (Object)e.getMessage(), (Object)e);
                if (!lootEntries.isEmpty()) break block10;
                LOGGER.info("Adding generic 'Unknown Drop' entry due to error for {}", (Object)entityType.m_20676_().getString());
                ItemStack unknownItem = new ItemStack((ItemLike)Items.f_42127_);
                unknownItem.m_41714_((Component)Component.m_237115_((String)"screen.araxers_bestiary.loot.unknown_drop"));
                lootEntries.add(new LootItemEntry(unknownItem, (Component)Component.m_237115_((String)"screen.araxers_bestiary.loot.unknown_drop"), 1.0f));
            }
        }
    }

    private static void processLootCacheForAllEntities(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        long start = System.nanoTime();
        String dimensionIdStr = serverLevel.m_46472_().m_135782_().toString();
        ArrayList<EntityType> candidates = new ArrayList<EntityType>();
        for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
            try {
                ResourceLocation tableId;
                Iterator existing;
                if (et == null || !EntityDataProvider.shouldTrackProgression(et) || (existing = LOOT_CACHE.get(et)) != null && !existing.isEmpty() || (tableId = et.m_20677_()) == null || tableId.equals((Object)BuiltInLootTables.f_78712_)) continue;
                candidates.add(et);
            }
            catch (Throwable existing) {}
        }
        if (candidates.isEmpty()) {
            return;
        }
        int batchSize = Config.initialLootSampleBatches;
        if (candidates.size() > batchSize) {
            HashMap<String, List> byNs = new HashMap<String, List>();
            for (EntityType et : candidates) {
                ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)et);
                if (id == null) continue;
                byNs.computeIfAbsent(id.m_135827_(), k -> new ArrayList()).add(et);
            }
            for (List list : byNs.values()) {
                list.sort((a, b) -> {
                    String aId = String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(a));
                    String bId = String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(b));
                    return aId.compareTo(bId);
                });
            }
            ArrayList namespaces = new ArrayList(byNs.keySet());
            namespaces.sort((a, b) -> {
                if ("minecraft".equals(a) && !"minecraft".equals(b)) {
                    return -1;
                }
                if (!"minecraft".equals(a) && "minecraft".equals(b)) {
                    return 1;
                }
                return a.compareTo((String)b);
            });
            ArrayList<EntityType> fair = new ArrayList<EntityType>(batchSize);
            HashMap<String, Integer> cursors = new HashMap<String, Integer>();
            Iterator iterator = namespaces.iterator();
            while (iterator.hasNext()) {
                String ns = (String)iterator.next();
                cursors.put(ns, 0);
            }
            int picked = 0;
            int idx = 0;
            while (picked < batchSize && !namespaces.isEmpty()) {
                boolean advanced = false;
                String ns = (String)namespaces.get(idx);
                List list = (List)byNs.get(ns);
                int cursor = (Integer)cursors.get(ns);
                if (cursor < list.size()) {
                    fair.add((EntityType)list.get(cursor));
                    cursors.put(ns, cursor + 1);
                    ++picked;
                    advanced = true;
                }
                idx = (idx + 1) % namespaces.size();
                if (advanced) continue;
                boolean anyLeft = false;
                Iterator iterator2 = namespaces.iterator();
                while (iterator2.hasNext()) {
                    String n = (String)iterator2.next();
                    if ((Integer)cursors.get(n) >= ((List)byNs.get(n)).size()) continue;
                    anyLeft = true;
                    break;
                }
                if (anyLeft) continue;
                break;
            }
            LOGGER.info("All-entities loot scan limited to {} of {} candidates (dimension {})", new Object[]{fair.size(), candidates.size(), dimensionIdStr});
            candidates = fair;
        }
        int cached = 0;
        for (EntityType et : candidates) {
            try {
                ArrayList<LootItemEntry> lootEntries = new ArrayList<LootItemEntry>();
                try {
                    List<LootItemEntry> tableLoot = EntityDataServerHelper.generateLootEntriesFromTable(et, serverLevel);
                    if (tableLoot != null && !tableLoot.isEmpty()) {
                        lootEntries.addAll(tableLoot);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("All-entities: table gen failed for {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)et), (Object)e.getMessage());
                }
                try {
                    List<LootItemEntry> dp;
                    if (BestiaryLootManager.hasLootForEntity(et) && (dp = BestiaryLootManager.getLootForEntity(et)) != null && !dp.isEmpty()) {
                        if (!lootEntries.isEmpty()) {
                            HashMap<Item, LootItemEntry> map = new HashMap<Item, LootItemEntry>();
                            for (LootItemEntry le : lootEntries) {
                                map.put(le.itemStack().m_41720_(), le);
                            }
                            for (LootItemEntry de : dp) {
                                Item it = de.itemStack().m_41720_();
                                if (map.containsKey(it)) continue;
                                lootEntries.add(de);
                            }
                        } else {
                            lootEntries.addAll(dp);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lootEntries.isEmpty()) continue;
                LOOT_CACHE.put(et, lootEntries);
                EntityDataProvider.bumpLootVersion(et);
                ++cached;
            }
            catch (Throwable t) {
                LOGGER.debug("All-entities: failed processing {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)et), (Object)t.getMessage());
            }
        }
        long end = System.nanoTime();
        LOGGER.info("All-entities loot scan cached {} entity types in {} ms", (Object)cached, (Object)((end - start) / 1000000L));
    }

    public static List<LootItemEntry> getCachedLoot(EntityType<?> entityType) {
        List<LootItemEntry> list = LOOT_CACHE.get(entityType);
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<LootItemEntry>(list);
    }

    public static int resimulateAllLoot(ServerLevel serverLevel, boolean sendSync) {
        if (serverLevel == null) {
            return 0;
        }
        MinecraftServer server = serverLevel.m_7654_();
        LOGGER.info("Resimulating loot for all entities (dimension-agnostic) ...");
        try {
            try {
                EntityDataServerHelper.clearLootTableCache();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EntityDataProvider.clearCache();
            int cached = 0;
            for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
                try {
                    if (et == null || !EntityDataProvider.shouldTrackProgression(et)) continue;
                    ArrayList<LootItemEntry> lootEntries = new ArrayList<LootItemEntry>();
                    try {
                        List<LootItemEntry> tableLoot = EntityDataServerHelper.generateLootEntriesFromTable(et, serverLevel);
                        if (tableLoot != null && !tableLoot.isEmpty()) {
                            lootEntries.addAll(tableLoot);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Resimulate: table gen failed for {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)et), (Object)ex.getMessage());
                    }
                    try {
                        List<LootItemEntry> dp;
                        if (BestiaryLootManager.hasLootForEntity(et) && (dp = BestiaryLootManager.getLootForEntity(et)) != null && !dp.isEmpty()) {
                            if (!lootEntries.isEmpty()) {
                                HashMap<Item, LootItemEntry> map = new HashMap<Item, LootItemEntry>();
                                for (LootItemEntry le : lootEntries) {
                                    map.put(le.itemStack().m_41720_(), le);
                                }
                                for (LootItemEntry de : dp) {
                                    int idx;
                                    Item it = de.itemStack().m_41720_();
                                    LootItemEntry existing = (LootItemEntry)map.get(it);
                                    if (existing == null) {
                                        lootEntries.add(de);
                                        continue;
                                    }
                                    if (!existing.hasUnknownDropChance() || de.hasUnknownDropChance() || (idx = lootEntries.indexOf(existing)) < 0) continue;
                                    lootEntries.set(idx, new LootItemEntry(existing.itemStack(), de.displayName().getString().isEmpty() ? existing.displayName() : de.displayName(), de.dropChance(), existing.override() || de.override()));
                                }
                            } else {
                                lootEntries.addAll(dp);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (lootEntries.isEmpty()) continue;
                    LOOT_CACHE.put(et, new ArrayList(lootEntries));
                    EntityDataProvider.bumpLootVersion(et);
                    ++cached;
                }
                catch (Throwable t) {
                    LOGGER.debug("Resimulate: failed processing {}: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)et), (Object)t.getMessage());
                }
            }
            try {
                EntityDataProvider.supplementLootCacheWithDatapackEntries((Level)serverLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sendSync && server != null) {
                for (ServerPlayer pl : server.m_6846_().m_11314_()) {
                    try {
                        EntityDataProvider.sendLootSyncPacket(pl);
                    }
                    catch (Throwable throwable) {}
                }
            }
            LOGGER.info("Resimulation complete. Cached {} entities with loot.", (Object)cached);
            return cached;
        }
        catch (Throwable t) {
            LOGGER.error("Resimulate all loot failed: {}", (Object)t.toString());
            return 0;
        }
    }
}

