/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryLootManager;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class EntityDataServerHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Field lootTablePoolsField;
    private static Field lootPoolEntriesField;
    private static Field lootPoolRollsField;
    private static Field constantValueField;
    private static Field lootItemItemField;
    private static Field lootEntryWeightField;
    private static final Map<ResourceLocation, List<LootItemEntry>> LOOT_TABLE_CACHE;
    private static final Map<ResourceLocation, SampleAggregate> SAMPLE_CACHE;
    private static volatile boolean REFLECTION_TRIED;
    private static volatile boolean REFLECTION_INITIALIZED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureReflectionInitialized() {
        if (REFLECTION_INITIALIZED || REFLECTION_TRIED) {
            return;
        }
        Class<EntityDataServerHelper> clazz = EntityDataServerHelper.class;
        synchronized (EntityDataServerHelper.class) {
            if (REFLECTION_INITIALIZED || REFLECTION_TRIED) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            REFLECTION_TRIED = true;
            try {
                lootTablePoolsField = LootTable.class.getDeclaredField("pools");
                lootTablePoolsField.setAccessible(true);
                lootPoolEntriesField = LootPool.class.getDeclaredField("entries");
                lootPoolEntriesField.setAccessible(true);
                lootPoolRollsField = LootPool.class.getDeclaredField("rolls");
                lootPoolRollsField.setAccessible(true);
                constantValueField = ConstantValue.class.getDeclaredField("value");
                constantValueField.setAccessible(true);
                lootItemItemField = LootItem.class.getDeclaredField("item");
                lootItemItemField.setAccessible(true);
                lootEntryWeightField = LootPoolEntryContainer.class.getDeclaredField("weight");
                lootEntryWeightField.setAccessible(true);
                REFLECTION_INITIALIZED = true;
                LOGGER.debug("Initialized loot reflection fields (dev environment)");
            }
            catch (Throwable t) {
                lootTablePoolsField = null;
                lootPoolEntriesField = null;
                lootPoolRollsField = null;
                constantValueField = null;
                lootItemItemField = null;
                lootEntryWeightField = null;
                LOGGER.debug("Skipping direct reflection into loot internals; will use fallback path: {}", (Object)t.getMessage());
            }
            return;
        }
    }

    public static void clearLootTableCache() {
        LOGGER.debug("Clearing loot table cache ({} entries)", (Object)LOOT_TABLE_CACHE.size());
        LOOT_TABLE_CACHE.clear();
        SAMPLE_CACHE.clear();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LootItemEntry> generateLootEntriesFromTable(EntityType<?> entityType, ServerLevel serverLevel) {
        block76: {
            startTime = System.nanoTime();
            entityName = entityType.m_20676_().getString();
            try {
                resolvedLootTableId = lootTableId = entityType.m_20677_();
                try {
                    if ((resolvedLootTableId == null || resolvedLootTableId.equals((Object)BuiltInLootTables.f_78712_)) && (entId = ForgeRegistries.ENTITY_TYPES.getKey(entityType)) != null) {
                        resolvedLootTableId = guess = ResourceLocation.m_135820_((String)(entId.m_135827_() + ":entities/" + entId.m_135815_()));
                        EntityDataServerHelper.LOGGER.debug("Default loot table for {} was null/empty; trying conventional table path {}", (Object)entityName, (Object)resolvedLootTableId);
                    }
                }
                catch (Throwable entId) {
                    // empty catch block
                }
                if (resolvedLootTableId != null && EntityDataServerHelper.LOOT_TABLE_CACHE.containsKey(resolvedLootTableId)) {
                    block73: {
                        cachedEntries = EntityDataServerHelper.LOOT_TABLE_CACHE.get(resolvedLootTableId);
                        if (cachedEntries == null) {
                            return new ArrayList<LootItemEntry>();
                        }
                        if (EntityDataServerHelper.containsUnknownChances(cachedEntries)) {
                            try {
                                block74: {
                                    ltCached = serverLevel.m_7654_().m_278653_().m_278676_(resolvedLootTableId);
                                    if (ltCached == null) break block73;
                                    refined = new ArrayList<LootItemEntry>(cachedEntries);
                                    beforeUnknown = 0;
                                    for (LootItemEntry var12_36 : refined) {
                                        if (!var12_36.hasUnknownDropChance()) continue;
                                        ++beforeUnknown;
                                    }
                                    EntityDataServerHelper.mergeSampledChances(ltCached, serverLevel, entityType, refined);
                                    afterUnknown = 0;
                                    for (LootItemEntry e : refined) {
                                        if (!e.hasUnknownDropChance()) continue;
                                        ++afterUnknown;
                                    }
                                    try {
                                        if (BestiaryLootManager.hasLootForEntity(entityType) && (var12_38 = BestiaryLootManager.getLootForEntity(entityType)) != null && !var12_38.isEmpty()) {
                                            map = new HashMap<Object, LootItemEntry>();
                                            for (LootItemEntry re : refined) {
                                                map.put(re.itemStack().m_41720_(), re);
                                            }
                                            for (LootItemEntry de : var12_38) {
                                                it = de.itemStack().m_41720_();
                                                ex = (LootItemEntry)map.get(it);
                                                if (ex == null) {
                                                    refined.add(de);
                                                    map.put(it, de);
                                                    continue;
                                                }
                                                if (!ex.hasUnknownDropChance() || de.hasUnknownDropChance() || (idx = refined.indexOf(ex)) < 0) continue;
                                                refined.set(idx, new LootItemEntry(ex.itemStack(), de.displayName().getString().isEmpty() != false ? ex.displayName() : de.displayName(), de.dropChance(), ex.override() != false || de.override() != false));
                                            }
                                        }
                                    }
                                    catch (Exception var12_40) {
                                        EntityDataServerHelper.LOGGER.debug("Datapack supplement on cache hit skipped for {}: {}", (Object)entityName, (Object)var12_40.getMessage());
                                    }
                                    try {
                                        var12_42 = refined.size();
                                        EntityDataServerHelper.supplementFromGlobalLootModifiers(resolvedLootTableId, serverLevel, entityType, refined, new HashSet<ResourceLocation>());
                                        if (refined.size() <= var12_42) {
                                            // empty if block
                                        }
                                    }
                                    catch (Exception var12_43) {
                                        EntityDataServerHelper.LOGGER.debug("GLM supplement on cache hit skipped for {}: {}", (Object)entityName, (Object)var12_43.getMessage());
                                    }
                                    try {
                                        var12_44 = Config.initialLootSampleBatches;
                                        if (var12_44 <= 0) {
                                            var12_45 = 50;
                                        }
                                        if (var12_45 > 300) {
                                            var12_46 = 300;
                                        }
                                        if ((sampled = EntityDataServerHelper.simulateAdditionalLootSamples(entityType, serverLevel, suppBatches = Math.max(20, Math.min(100, var12_46 / 3)))) == null || sampled.isEmpty()) break block74;
                                        present = new HashSet<Item>();
                                        for (LootItemEntry e : refined) {
                                            present.add(e.itemStack().m_41720_());
                                        }
                                        added = 0;
                                        for (LootItemEntry se : sampled) {
                                            if (present.contains(se.itemStack().m_41720_())) continue;
                                            refined.add(se);
                                            present.add(se.itemStack().m_41720_());
                                            ++added;
                                        }
                                        if (added > 0) {
                                            EntityDataServerHelper.LOGGER.debug("Supplemented {} sampled items on cache hit for {} (loot table: {})", new Object[]{added, entityName, resolvedLootTableId});
                                        }
                                    }
                                    catch (Exception var12_47) {
                                        EntityDataServerHelper.LOGGER.debug("Sampling supplement on cache hit skipped for {}: {}", (Object)entityName, (Object)var12_47.getMessage());
                                    }
                                }
                                refined = EntityDataServerHelper.deduplicateAndNormalize(refined);
                                EntityDataServerHelper.LOOT_TABLE_CACHE.put(resolvedLootTableId, new ArrayList<LootItemEntry>(refined));
                                EntityDataServerHelper.LOGGER.debug("Updated cached loot entries for {} (loot table: {}) after full refinement (unknown {} -> {})", new Object[]{entityName, resolvedLootTableId, beforeUnknown, afterUnknown});
                                return refined;
                            }
                            catch (Exception ex) {
                                EntityDataServerHelper.LOGGER.debug("Failed to refine cached loot entries for {}: {}", (Object)entityName, (Object)ex.getMessage());
                            }
                        } else {
                            try {
                                block75: {
                                    enriched = new ArrayList<LootItemEntry>(cachedEntries);
                                    ltCached = serverLevel.m_7654_().m_278653_().m_278676_(resolvedLootTableId);
                                    if (ltCached != null) {
                                        EntityDataServerHelper.mergeSampledChances(ltCached, serverLevel, entityType, enriched);
                                    }
                                    try {
                                        beforeGLM = enriched.size();
                                        EntityDataServerHelper.supplementFromGlobalLootModifiers(resolvedLootTableId, serverLevel, entityType, enriched, new HashSet<ResourceLocation>());
                                        if (enriched.size() > beforeGLM) {
                                            EntityDataServerHelper.LOGGER.debug("Supplemented {} GLM items on cache hit for {} (loot table: {})", new Object[]{enriched.size() - beforeGLM, entityName, resolvedLootTableId});
                                        }
                                    }
                                    catch (Exception glmEx) {
                                        EntityDataServerHelper.LOGGER.debug("GLM supplement on cache hit skipped for {}: {}", (Object)entityName, (Object)glmEx.getMessage());
                                    }
                                    try {
                                        batches = Config.initialLootSampleBatches;
                                        if (batches <= 0) {
                                            batches = 50;
                                        }
                                        if (batches > 300) {
                                            batches = 300;
                                        }
                                        if ((var12_48 = EntityDataServerHelper.simulateAdditionalLootSamples(entityType, serverLevel, suppBatches = Math.max(20, Math.min(100, batches / 3)))) == null || var12_48.isEmpty()) break block75;
                                        present = new HashSet<Item>();
                                        for (LootItemEntry e : enriched) {
                                            present.add(e.itemStack().m_41720_());
                                        }
                                        added = 0;
                                        for (LootItemEntry se : var12_48) {
                                            if (present.contains(se.itemStack().m_41720_())) continue;
                                            enriched.add(se);
                                            present.add(se.itemStack().m_41720_());
                                            ++added;
                                        }
                                        if (added > 0) {
                                            EntityDataServerHelper.LOGGER.debug("Supplemented {} sampled items on cache hit for {} (loot table: {})", new Object[]{added, entityName, resolvedLootTableId});
                                        }
                                    }
                                    catch (Exception sampEx) {
                                        EntityDataServerHelper.LOGGER.debug("Sampling supplement on cache hit skipped for {}: {}", (Object)entityName, (Object)sampEx.getMessage());
                                    }
                                }
                                enriched = EntityDataServerHelper.deduplicateAndNormalize(enriched);
                                EntityDataServerHelper.LOOT_TABLE_CACHE.put(resolvedLootTableId, new ArrayList<LootItemEntry>(enriched));
                                EntityDataServerHelper.LOGGER.debug("Updated cached loot entries for {} (loot table: {}) after sampling refinement on cache hit", (Object)entityName, (Object)resolvedLootTableId);
                                return enriched;
                            }
                            catch (Exception ex) {
                                EntityDataServerHelper.LOGGER.debug("Sampling refinement on cache hit failed for {}: {}", (Object)entityName, (Object)ex.getMessage());
                            }
                        }
                    }
                    EntityDataServerHelper.LOGGER.debug("Using cached loot entries for entity: {} (loot table: {})", (Object)entityName, (Object)resolvedLootTableId);
                    return new ArrayList<LootItemEntry>(cachedEntries);
                }
                EntityDataServerHelper.LOGGER.debug("Generating loot entries for entity: {} from loot table: {}", (Object)entityName, (Object)resolvedLootTableId);
                lootEntries = new ArrayList<LootItemEntry>();
                try {
                    block79: {
                        block78: {
                            v0 = lootTable = resolvedLootTableId != null ? serverLevel.m_7654_().m_278653_().m_278676_(resolvedLootTableId) : null;
                            if (lootTable != null) {
                                try {
                                    EntityDataServerHelper.ensureReflectionInitialized();
                                    if (EntityDataServerHelper.lootTablePoolsField != null) {
                                        try {
                                            pools = (List)EntityDataServerHelper.lootTablePoolsField.get(lootTable);
                                            if (pools != null && !pools.isEmpty()) {
                                                poolsProcessed = 0;
                                                var11_35 = pools.iterator();
                                                break block76;
                                            }
                                            EntityDataServerHelper.LOGGER.debug("No loot pools found for entity: {}", (Object)entityName);
                                        }
                                        catch (IllegalAccessException e) {
                                            EntityDataServerHelper.LOGGER.debug("Failed to access loot pools for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                                            EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                                        }
                                    } else {
                                        EntityDataServerHelper.LOGGER.debug("Reflection fields not initialized, using fallback method for entity: {}", (Object)entityName);
                                        EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                                    }
lbl170:
                                    // 4 sources

                                    while (true) {
                                        if (lootEntries.isEmpty()) {
                                            EntityDataServerHelper.LOGGER.debug("No loot entries extracted for entity {}, using random fallback sampling", (Object)entityName);
                                            EntityDataServerHelper.fallbackToRandomLoot(lootTable, serverLevel, lootEntries);
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    EntityDataServerHelper.LOGGER.error("Error processing loot table for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                                    EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                                }
                            } else {
                                EntityDataServerHelper.LOGGER.debug("Loot table is null for entity: {}", (Object)entityName);
                                EntityDataServerHelper.fallbackToCommonDrops(null, serverLevel, lootEntries, entityType);
                            }
                            if (!lootEntries.isEmpty() && resolvedLootTableId != null) {
                                EntityDataServerHelper.LOOT_TABLE_CACHE.put(resolvedLootTableId, new ArrayList<LootItemEntry>(lootEntries));
                                EntityDataServerHelper.LOGGER.debug("Cached {} loot entries for entity {} (loot table: {})", new Object[]{lootEntries.size(), entityName, resolvedLootTableId});
                            } else {
                                try {
                                    if (resolvedLootTableId != null) {
                                        before = lootEntries.size();
                                        EntityDataServerHelper.extractItemsFromLootTableJson(resolvedLootTableId, serverLevel, lootEntries, new HashSet<ResourceLocation>());
                                        added = lootEntries.size() - before;
                                        if (added > 0) {
                                            EntityDataServerHelper.LOOT_TABLE_CACHE.put(resolvedLootTableId, new ArrayList<LootItemEntry>(lootEntries));
                                            EntityDataServerHelper.LOGGER.debug("Extracted {} loot entries for entity {} via JSON inspection (loot table: {})", new Object[]{added, entityName, resolvedLootTableId});
                                            break block78;
                                        } else {
                                            EntityDataServerHelper.LOGGER.debug("No loot entries generated for entity: {}", (Object)entityName);
                                        }
                                        break block78;
                                    }
                                    EntityDataServerHelper.LOGGER.debug("No loot entries generated for entity: {}", (Object)entityName);
                                }
                                catch (Exception jsonEx) {
                                    EntityDataServerHelper.LOGGER.debug("JSON inspection failed for {}: {}", (Object)entityName, (Object)jsonEx.getMessage());
                                }
                            }
                        }
                        try {
                            if (resolvedLootTableId == null) break block79;
                            beforeGLM = lootEntries.size();
                            EntityDataServerHelper.supplementFromGlobalLootModifiers(resolvedLootTableId, serverLevel, entityType, lootEntries, new HashSet<ResourceLocation>());
                            addedGLM = lootEntries.size() - beforeGLM;
                            if (addedGLM > 0) {
                                EntityDataServerHelper.LOGGER.debug("Supplemented {} items via Global Loot Modifiers for {}", (Object)addedGLM, (Object)entityName);
                            }
                        }
                        catch (Exception ex) {
                            EntityDataServerHelper.LOGGER.debug("GLM supplement skipped for {}: {}", (Object)entityName, (Object)ex.getMessage());
                        }
                    }
                    try {
                        if (!lootEntries.isEmpty() && resolvedLootTableId != null && (lt2 = serverLevel.m_7654_().m_278653_().m_278676_(resolvedLootTableId)) != null) {
                            EntityDataServerHelper.mergeSampledChances(lt2, serverLevel, entityType, lootEntries);
                        }
                    }
                    catch (Exception refineEx) {
                        EntityDataServerHelper.LOGGER.debug("Chance refinement via sampling skipped for {}: {}", (Object)entityName, (Object)refineEx.getMessage());
                    }
                    if (!lootEntries.isEmpty()) {
                        lootEntries = EntityDataServerHelper.deduplicateAndNormalize(lootEntries);
                    }
                    if (!lootEntries.isEmpty() && resolvedLootTableId != null) {
                        EntityDataServerHelper.LOOT_TABLE_CACHE.put(resolvedLootTableId, new ArrayList<LootItemEntry>(lootEntries));
                        EntityDataServerHelper.LOGGER.debug("Cached {} loot entries for entity {} (post-refinement, loot table: {})", new Object[]{lootEntries.size(), entityName, resolvedLootTableId});
                    }
                }
                catch (Exception e) {
                    EntityDataServerHelper.LOGGER.error("Error accessing loot table for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                    EntityDataServerHelper.fallbackToCommonDrops(null, serverLevel, lootEntries, entityType);
                }
                endTime = System.nanoTime();
                processingTime = endTime - startTime;
                EntityDataServerHelper.LOGGER.debug("Generated {} loot entries for entity {} in {} ms", new Object[]{lootEntries.size(), entityName, processingTime / 1000000L});
                return lootEntries;
            }
            catch (Exception e) {
                EntityDataServerHelper.LOGGER.error("Unexpected error generating loot entries for entity {}: {}", new Object[]{entityName, e.getMessage(), e});
                return new ArrayList<LootItemEntry>();
            }
        }
        while (var11_35.hasNext()) {
            var12_49 = (LootPool)var11_35.next();
            try {
                entriesBefore = lootEntries.size();
                EntityDataServerHelper.processLootPool(var12_49, lootEntries);
                entriesAfter = lootEntries.size();
                if (entriesAfter <= entriesBefore) continue;
                ++poolsProcessed;
            }
            catch (Exception e) {
                EntityDataServerHelper.LOGGER.debug("Error processing loot pool for entity {}: {}", (Object)entityName, (Object)e.getMessage());
            }
        }
        EntityDataServerHelper.LOGGER.debug("Processed {}/{} loot pools for entity: {}", new Object[]{poolsProcessed, pools.size(), entityName});
        ** while (true)
    }

    private static void processLootPool(LootPool pool, List<LootItemEntry> lootEntries) {
        try {
            if (lootPoolEntriesField == null || lootPoolRollsField == null || constantValueField == null || lootItemItemField == null || lootEntryWeightField == null) {
                LOGGER.warn("Reflection fields not initialized, cannot process loot pool");
                return;
            }
            Object entriesObj = lootPoolEntriesField.get(pool);
            LootPoolEntryContainer[] entries = null;
            if (entriesObj instanceof LootPoolEntryContainer[]) {
                entries = (LootPoolEntryContainer[])entriesObj;
                LOGGER.debug("Loot pool entries retrieved as array ({} entries)", (Object)entries.length);
            } else if (entriesObj instanceof List) {
                List list = (List)entriesObj;
                entries = list.toArray(new LootPoolEntryContainer[0]);
                LOGGER.debug("Loot pool entries retrieved as list ({} entries)", (Object)entries.length);
            } else if (entriesObj != null) {
                LOGGER.debug("Unknown entries object type: {} \u2014 skipping pool", (Object)entriesObj.getClass().getName());
                return;
            }
            if (entries == null || entries.length == 0) {
                LOGGER.debug("No entries found in loot pool");
                return;
            }
            NumberProvider rolls = (NumberProvider)lootPoolRollsField.get(pool);
            float baseChance = 1.0f;
            if (rolls instanceof ConstantValue) {
                float value = constantValueField.getFloat(rolls);
                baseChance = value > 0.0f ? 1.0f / value : 1.0f;
                LOGGER.debug("Base chance calculated from constant rolls value {} -> {}", (Object)Float.valueOf(value), (Object)Float.valueOf(baseChance));
            } else {
                try {
                    Class<?> rc = rolls.getClass();
                    String cn = rc.getSimpleName().toLowerCase(Locale.ROOT);
                    if (cn.contains("uniform")) {
                        Field minF = rc.getDeclaredField("min");
                        Field maxF = rc.getDeclaredField("max");
                        minF.setAccessible(true);
                        maxF.setAccessible(true);
                        Object minProv = minF.get(rolls);
                        Object maxProv = maxF.get(rolls);
                        float min = minProv instanceof ConstantValue ? constantValueField.getFloat(minProv) : 1.0f;
                        float max = maxProv instanceof ConstantValue ? constantValueField.getFloat(maxProv) : min;
                        float avg = (min + max) / 2.0f;
                        baseChance = avg > 0.0f ? 1.0f / avg : 1.0f;
                        LOGGER.debug("Base chance from uniform rolls [{}, {}] -> avg {} -> {}", new Object[]{Float.valueOf(min), Float.valueOf(max), Float.valueOf(avg), Float.valueOf(baseChance)});
                    } else if (cn.contains("binomial")) {
                        try {
                            Field nF = rc.getDeclaredField("n");
                            Field pF = rc.getDeclaredField("p");
                            nF.setAccessible(true);
                            pF.setAccessible(true);
                            int n = nF.getInt(rolls);
                            float p = pF.getFloat(rolls);
                            float exp = Math.max(0.0f, (float)n * p);
                            baseChance = exp > 0.0f ? 1.0f / exp : 1.0f;
                            LOGGER.debug("Base chance from binomial rolls n={}, p={} -> exp {} -> {}", new Object[]{n, Float.valueOf(p), Float.valueOf(exp), Float.valueOf(baseChance)});
                        }
                        catch (Throwable ignored) {
                            LOGGER.debug("Binomial rolls reflection failed; using default base chance {}");
                        }
                    } else {
                        LOGGER.debug("Using default base chance: {} (rolls provider type: {})", (Object)Float.valueOf(baseChance), (Object)rc.getName());
                    }
                }
                catch (Throwable t) {
                    LOGGER.debug("Failed to infer base chance from rolls provider ({}); using default {}", (Object)t.getMessage(), (Object)Float.valueOf(baseChance));
                }
            }
            if (baseChance < 0.0f) {
                baseChance = 0.0f;
            }
            if (baseChance > 1.0f) {
                baseChance = 1.0f;
            }
            int entriesProcessed = 0;
            for (LootPoolEntryContainer entry : entries) {
                if (!(entry instanceof LootItem)) continue;
                LootItem lootItem = (LootItem)entry;
                try {
                    float dropChance;
                    int weight;
                    Item item = (Item)lootItemItemField.get(lootItem);
                    try {
                        weight = lootEntryWeightField.getInt(lootItem);
                    }
                    catch (Throwable t) {
                        weight = 1;
                        try {
                            Field wf = lootItem.getClass().getDeclaredField("weight");
                            wf.setAccessible(true);
                            weight = wf.getInt(lootItem);
                        }
                        catch (Throwable wf) {
                            // empty catch block
                        }
                    }
                    if (weight < 0) {
                        weight = 0;
                    }
                    if ((dropChance = (float)weight * baseChance) > 1.0f) {
                        dropChance = 1.0f;
                    }
                    if (dropChance < 0.0f) {
                        dropChance = 0.0f;
                    }
                    if (item != Items.f_41852_) {
                        ItemStack itemStack = new ItemStack((ItemLike)item);
                        Component displayName = itemStack.m_41786_();
                        lootEntries.add(new LootItemEntry(itemStack, displayName, dropChance, false));
                        LOGGER.debug("Added loot entry: {} with chance {} (weight={}, base={})", new Object[]{displayName, Float.valueOf(dropChance), weight, Float.valueOf(baseChance)});
                        ++entriesProcessed;
                        continue;
                    }
                    LOGGER.debug("Skipped air item");
                }
                catch (IllegalAccessException e) {
                    LOGGER.debug("Failed to process loot item: {}", (Object)e.getMessage());
                }
            }
            LOGGER.debug("Processed {} loot entries from pool", (Object)entriesProcessed);
        }
        catch (Exception e) {
            LOGGER.error("Error processing loot pool: {}", (Object)e.getMessage());
        }
    }

    private static void fallbackToCommonDrops(LootTable lootTable, ServerLevel serverLevel, List<LootItemEntry> lootEntries, EntityType<?> entityType) {
        LOGGER.debug("Using loot table fallback mechanism for entity: {}", (Object)(entityType != null ? entityType.m_20676_().getString() : "unknown"));
        if (serverLevel == null) {
            LOGGER.debug("Cannot attempt fallback loot: serverLevel is null");
            return;
        }
        ResourceLocation resolvedId = null;
        if (entityType != null) {
            try {
                ResourceLocation entId;
                ResourceLocation id;
                resolvedId = id = entityType.m_20677_();
                if ((resolvedId == null || resolvedId.equals((Object)BuiltInLootTables.f_78712_)) && (entId = ForgeRegistries.ENTITY_TYPES.getKey(entityType)) != null) {
                    resolvedId = ResourceLocation.m_135820_((String)(entId.m_135827_() + ":entities/" + entId.m_135815_()));
                    LOGGER.debug("Fallback resolving loot table for {} via conventional path {}", (Object)entityType.m_20675_(), (Object)resolvedId);
                }
                if (lootTable == null && resolvedId != null) {
                    lootTable = serverLevel.m_7654_().m_278653_().m_278676_(resolvedId);
                    LOGGER.debug("Resolved loot table {} for {} during fallback", (Object)resolvedId, (Object)entityType.m_20675_());
                }
            }
            catch (Throwable t) {
                LOGGER.debug("Failed resolving loot table for {} during fallback: {}", (Object)(entityType != null ? entityType.m_20675_() : "unknown"), (Object)t.getMessage());
            }
        }
        ArrayList<LootItemEntry> sampled = new ArrayList<LootItemEntry>();
        ArrayList<LootItemEntry> jsonExtracted = new ArrayList<LootItemEntry>();
        if (lootTable != null) {
            try {
                EntityDataServerHelper.fallbackToRandomLoot(lootTable, serverLevel, sampled);
                LOGGER.debug("Random sampling fallback produced {} entries for {}", (Object)sampled.size(), (Object)(entityType != null ? entityType.m_20675_() : "unknown"));
            }
            catch (Exception e) {
                LOGGER.debug("Failed random sampling in fallback: {}", (Object)e.getMessage());
            }
        }
        if (resolvedId != null) {
            try {
                EntityDataServerHelper.extractItemsFromLootTableJson(resolvedId, serverLevel, jsonExtracted, new HashSet<ResourceLocation>());
                LOGGER.debug("JSON inspection extracted {} items for {}", (Object)jsonExtracted.size(), (Object)(entityType != null ? entityType.m_20675_() : "unknown"));
            }
            catch (Exception e) {
                LOGGER.debug("JSON inspection failed during fallback: {}", (Object)e.getMessage());
            }
            try {
                int before = jsonExtracted.size();
                EntityDataServerHelper.supplementFromGlobalLootModifiers(resolvedId, serverLevel, entityType, jsonExtracted, new HashSet<ResourceLocation>());
                int added = jsonExtracted.size() - before;
                if (added > 0) {
                    LOGGER.debug("GLM supplement added {} items during fallback for {}", (Object)added, (Object)(entityType != null ? entityType.m_20675_() : "unknown"));
                }
            }
            catch (Exception glmEx) {
                LOGGER.debug("GLM supplement failed during fallback: {}", (Object)glmEx.getMessage());
            }
        } else if (lootTable == null) {
            LOGGER.debug("No loot table id available for JSON/GLM extraction during fallback");
        }
        ArrayList<LootItemEntry> merged = new ArrayList<LootItemEntry>();
        if (lootEntries != null && !lootEntries.isEmpty()) {
            merged.addAll(lootEntries);
        }
        if (!sampled.isEmpty()) {
            merged.addAll(sampled);
        }
        if (!jsonExtracted.isEmpty()) {
            merged.addAll(jsonExtracted);
        }
        if (merged.isEmpty()) {
            LOGGER.debug("Fallback produced no entries for {}", (Object)(entityType != null ? entityType.m_20675_() : "unknown"));
            return;
        }
        List<LootItemEntry> deduped = EntityDataServerHelper.deduplicateAndNormalize(merged);
        lootEntries.clear();
        lootEntries.addAll(deduped);
        LOGGER.debug("Fallback merged {} -> {} entries for {} (sampled={}, json={})", new Object[]{merged.size(), deduped.size(), entityType != null ? entityType.m_20675_() : "unknown", sampled.size(), jsonExtracted.size()});
    }

    private static void fallbackToRandomLoot(LootTable lootTable, ServerLevel serverLevel, List<LootItemEntry> lootEntries) {
        LOGGER.debug("Using fallback random loot generation");
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel);
        LootParams lootParams = lootParamsBuilder.m_287235_(LootContextParamSets.f_81410_);
        HashMap<Item, Integer> dropCounts = new HashMap<Item, Integer>();
        int totalBatches = Config.initialLootSampleBatches;
        for (int i = 0; i < totalBatches; ++i) {
            ObjectArrayList generatedLoot = lootTable.m_287195_(lootParams);
            for (ItemStack itemStack : generatedLoot) {
                Item item = itemStack.m_41720_();
                dropCounts.put(item, dropCounts.getOrDefault(item, 0) + 1);
            }
        }
        for (Map.Entry entry : dropCounts.entrySet()) {
            Item item = (Item)entry.getKey();
            if (item == Items.f_41852_) {
                LOGGER.debug("Skipped air item");
                continue;
            }
            float dropChance = (float)((Integer)entry.getValue()).intValue() / (float)totalBatches;
            if (dropChance > 1.0f) {
                dropChance = 1.0f;
            }
            if (dropChance < 0.0f) {
                dropChance = 0.0f;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            Component displayName = itemStack.m_41786_();
            lootEntries.add(new LootItemEntry(itemStack, displayName, dropChance, false));
            LOGGER.debug("Added estimated loot entry: {} with chance {}", (Object)displayName, (Object)Float.valueOf(dropChance));
        }
    }

    public static SpawnLocationInfo getServerSideSpawnLocations(EntityType<?> entityType, ServerLevel serverLevel, MobCategory category) {
        ArrayList<ResourceLocation> spawnBiomes = new ArrayList<ResourceLocation>();
        try {
            if (serverLevel != null && serverLevel.m_9598_() != null) {
                Registry biomeRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256952_);
                for (ResourceLocation biomeKey : biomeRegistry.m_6566_()) {
                    try {
                        Biome biome = (Biome)biomeRegistry.m_7745_(biomeKey);
                        if (biome == null || !EntityDataServerHelper.canEntitySpawnInBiome(entityType, biome, category)) continue;
                        spawnBiomes.add(biomeKey);
                        LOGGER.debug("Entity {} can spawn in biome {}", (Object)entityType.m_20676_().getString(), (Object)biomeKey);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error checking if entity can spawn in biome {}: {}", (Object)biomeKey, (Object)e.getMessage());
                    }
                }
                if (!spawnBiomes.isEmpty()) {
                    return SpawnLocationInfo.fromBiomeKeys(spawnBiomes, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting server-side spawn locations: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static boolean canEntitySpawnInBiome(EntityType<?> entityType, Biome biome, MobCategory category) {
        try {
            List spawners = biome.m_47518_().m_151798_(category).m_146338_();
            for (MobSpawnSettings.SpawnerData spawnerData : spawners) {
                if (spawnerData.f_48404_ != entityType) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.debug("Error checking spawn rule for {} in biome {}: {}", new Object[]{entityType.m_20675_(), biome.toString(), e.getMessage()});
            return false;
        }
    }

    private static void extractItemsFromLootTableJson(ResourceLocation tableId, ServerLevel serverLevel, List<LootItemEntry> out, Set<ResourceLocation> visited) {
        if (tableId == null || serverLevel == null) {
            return;
        }
        if (visited.contains(tableId)) {
            return;
        }
        visited.add(tableId);
        try {
            ResourceLocation jsonPath = ResourceLocation.m_135820_((String)(tableId.m_135827_() + ":loot_tables/" + tableId.m_135815_() + ".json"));
            if (jsonPath == null) {
                LOGGER.debug("Failed to build JSON path for {} (namespace={}, path={})", new Object[]{tableId, tableId.m_135827_(), tableId.m_135815_()});
                return;
            }
            ResourceManager rm = serverLevel.m_7654_().m_177941_();
            if (rm == null) {
                LOGGER.debug("ResourceManager is null; cannot inspect loot table JSON for {}", (Object)tableId);
                return;
            }
            Optional resOpt = rm.m_213713_(jsonPath);
            if (resOpt.isEmpty()) {
                LOGGER.debug("Loot table JSON not found at {} for {}", (Object)jsonPath, (Object)tableId);
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(((Resource)resOpt.get()).m_215507_(), StandardCharsets.UTF_8);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (root == null || !root.has("pools") || !root.get("pools").isJsonArray()) {
                    LOGGER.debug("Loot table JSON for {} has no pools array", (Object)tableId);
                    return;
                }
                HashSet<Item> dedup = new HashSet<Item>();
                JsonArray pools = root.getAsJsonArray("pools");
                for (JsonElement poolEl : pools) {
                    JsonObject eobj;
                    float max;
                    float min;
                    if (!poolEl.isJsonObject()) continue;
                    JsonObject poolObj = poolEl.getAsJsonObject();
                    float poolFactor = EntityDataServerHelper.extractChanceFactorFromConditions(poolObj);
                    float rolls = 1.0f;
                    if (poolObj.has("rolls")) {
                        try {
                            if (poolObj.get("rolls").isJsonPrimitive()) {
                                rolls = poolObj.get("rolls").getAsFloat();
                            } else if (poolObj.get("rolls").isJsonObject()) {
                                JsonObject r = poolObj.getAsJsonObject("rolls");
                                min = r.has("min") ? r.get("min").getAsFloat() : 1.0f;
                                max = r.has("max") ? r.get("max").getAsFloat() : min;
                                rolls = (min + max) / 2.0f;
                            }
                        }
                        catch (Exception r) {
                            // empty catch block
                        }
                    }
                    if (poolObj.has("bonus_rolls")) {
                        try {
                            if (poolObj.get("bonus_rolls").isJsonPrimitive()) {
                                float bonus = poolObj.get("bonus_rolls").getAsFloat();
                                LOGGER.debug("JSON loot: encountered bonus_rolls={} (ignored at Luck=0)", (Object)Float.valueOf(bonus));
                            } else if (poolObj.get("bonus_rolls").isJsonObject()) {
                                JsonObject br = poolObj.getAsJsonObject("bonus_rolls");
                                min = br.has("min") ? br.get("min").getAsFloat() : 0.0f;
                                max = br.has("max") ? br.get("max").getAsFloat() : min;
                                LOGGER.debug("JSON loot: encountered bonus_rolls {min={}, max={}} (ignored at Luck=0)", (Object)Float.valueOf(min), (Object)Float.valueOf(max));
                            }
                        }
                        catch (Exception br) {
                            // empty catch block
                        }
                    }
                    if (rolls < 1.0f) {
                        rolls = 1.0f;
                    }
                    boolean simpleWeightedPool = false;
                    float totalWeight = 0.0f;
                    if (!poolObj.has("entries") || !poolObj.get("entries").isJsonArray()) continue;
                    JsonArray entries = poolObj.getAsJsonArray("entries");
                    simpleWeightedPool = true;
                    for (JsonElement entryEl : entries) {
                        if (!entryEl.isJsonObject()) {
                            simpleWeightedPool = false;
                            break;
                        }
                        eobj = entryEl.getAsJsonObject();
                        String type = eobj.has("type") && eobj.get("type").isJsonPrimitive() ? eobj.get("type").getAsString() : "minecraft:item";
                        String simple = type.contains(":") ? type.substring(type.indexOf(58) + 1) : type;
                        if ("item".equals(simple)) continue;
                        simpleWeightedPool = false;
                        break;
                    }
                    if (simpleWeightedPool) {
                        for (JsonElement entryEl : entries) {
                            float w;
                            eobj = entryEl.getAsJsonObject();
                            float f = w = eobj.has("weight") && eobj.get("weight").isJsonPrimitive() ? eobj.get("weight").getAsFloat() : 1.0f;
                            if (w < 0.0f) {
                                w = 0.0f;
                            }
                            totalWeight += w;
                        }
                        if (totalWeight <= 0.0f) {
                            simpleWeightedPool = false;
                        }
                    }
                    for (JsonElement entryEl : entries) {
                        if (!entryEl.isJsonObject()) continue;
                        EntityDataServerHelper.processEntryJsonWithContext(entryEl.getAsJsonObject(), serverLevel, out, visited, dedup, poolFactor, rolls, totalWeight, simpleWeightedPool);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed JSON loot inspection for {}: {}", (Object)tableId, (Object)e.getMessage());
        }
    }

    private static void processEntryJson(JsonObject entryObj, ServerLevel serverLevel, List<LootItemEntry> out, Set<ResourceLocation> visited, Set<Item> dedup) {
        EntityDataServerHelper.processEntryJsonWithContext(entryObj, serverLevel, out, visited, dedup, 1.0f, 1.0f, -1.0f, false);
    }

    private static void processEntryJsonWithContext(JsonObject entryObj, ServerLevel serverLevel, List<LootItemEntry> out, Set<ResourceLocation> visited, Set<Item> dedup, float poolFactor, float rolls, float totalWeight, boolean simpleWeightedPool) {
        try {
            String simpleType;
            String type = entryObj.has("type") && entryObj.get("type").isJsonPrimitive() ? entryObj.get("type").getAsString() : "minecraft:item";
            switch (simpleType = type.contains(":") ? type.substring(type.indexOf(58) + 1) : type) {
                case "item": {
                    float weight;
                    Item item;
                    String itemId;
                    ResourceLocation itemRL;
                    if (!entryObj.has("name") || (itemRL = ResourceLocation.m_135820_((String)(itemId = entryObj.get("name").getAsString()))) == null || (item = (Item)ForgeRegistries.ITEMS.getValue(itemRL)) == null || item == Items.f_41852_ || dedup.contains(item)) break;
                    float f = weight = entryObj.has("weight") && entryObj.get("weight").isJsonPrimitive() ? entryObj.get("weight").getAsFloat() : 1.0f;
                    if (weight < 0.0f) {
                        weight = 0.0f;
                    }
                    float chancePerRoll = simpleWeightedPool && totalWeight > 0.0f ? weight / totalWeight : -1.0f;
                    float chanceFromWeights = -1.0f;
                    if (chancePerRoll >= 0.0f) {
                        double p = Math.max(0.0, Math.min(1.0, (double)chancePerRoll));
                        double r = Math.max(1.0, (double)rolls);
                        chanceFromWeights = (float)(1.0 - Math.pow(1.0 - p, r));
                    }
                    float entryFactor = EntityDataServerHelper.extractChanceFactorFromConditions(entryObj);
                    float finalChance = -1.0f;
                    if (chanceFromWeights >= 0.0f) {
                        finalChance = chanceFromWeights * poolFactor * entryFactor;
                    } else if (entryFactor > 0.0f) {
                        finalChance = Math.max(0.0f, Math.min(1.0f, poolFactor * entryFactor));
                    }
                    ItemStack stack = new ItemStack((ItemLike)item);
                    Component name = stack.m_41786_();
                    if (finalChance >= 0.0f) {
                        if (finalChance > 1.0f) {
                            finalChance = 1.0f;
                        }
                        out.add(new LootItemEntry(stack, name, finalChance, false));
                    } else {
                        out.add(new LootItemEntry(stack, name, -1.0f, false));
                    }
                    dedup.add(item);
                    break;
                }
                case "alternatives": 
                case "sequence": 
                case "group": {
                    float entryFactor = EntityDataServerHelper.extractChanceFactorFromConditions(entryObj);
                    float nextPoolFactor = poolFactor * entryFactor;
                    if (!entryObj.has("children") || !entryObj.get("children").isJsonArray()) break;
                    for (JsonElement childEl : entryObj.getAsJsonArray("children")) {
                        if (!childEl.isJsonObject()) continue;
                        EntityDataServerHelper.processEntryJsonWithContext(childEl.getAsJsonObject(), serverLevel, out, visited, dedup, nextPoolFactor, rolls, -1.0f, false);
                    }
                    break;
                }
                case "loot_table": {
                    String childTable;
                    ResourceLocation childId;
                    if (!entryObj.has("name") || (childId = ResourceLocation.m_135820_((String)(childTable = entryObj.get("name").getAsString()))) == null) break;
                    EntityDataServerHelper.extractItemsFromLootTableJson(childId, serverLevel, out, visited);
                    break;
                }
                case "tag": {
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to process loot entry JSON: {}", (Object)e.getMessage());
        }
    }

    private static float extractChanceFactorFromConditions(JsonObject obj) {
        float factor = 1.0f;
        try {
            if (obj != null && obj.has("conditions") && obj.get("conditions").isJsonArray()) {
                for (JsonElement condEl : obj.getAsJsonArray("conditions")) {
                    float c;
                    String simple;
                    JsonObject cond;
                    if (!condEl.isJsonObject() || !(cond = condEl.getAsJsonObject()).has("condition")) continue;
                    String condType = cond.get("condition").getAsString();
                    String string = simple = condType.contains(":") ? condType.substring(condType.indexOf(58) + 1) : condType;
                    if ("random_chance".equals(simple)) {
                        if (!cond.has("chance") || !cond.get("chance").isJsonPrimitive() || !((c = cond.get("chance").getAsFloat()) >= 0.0f)) continue;
                        factor *= c;
                        continue;
                    }
                    if (!"random_chance_with_looting".equals(simple) || !cond.has("chance") || !cond.get("chance").isJsonPrimitive() || !((c = cond.get("chance").getAsFloat()) >= 0.0f)) continue;
                    factor *= c;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (factor < 0.0f) {
            factor = 0.0f;
        }
        return factor;
    }

    private static boolean containsUnknownChances(List<LootItemEntry> list) {
        for (LootItemEntry e : list) {
            if (!e.hasUnknownDropChance()) continue;
            return true;
        }
        return false;
    }

    private static void mergeSampledChances(LootTable lootTable, ServerLevel serverLevel, EntityType<?> entityType, List<LootItemEntry> lootEntries) {
        try {
            ArrayList<LootItemEntry> sampled = new ArrayList<LootItemEntry>();
            EntityDataServerHelper.fallbackToRandomLoot(lootTable, serverLevel, sampled);
            if (sampled.isEmpty()) {
                return;
            }
            HashMap<Item, Float> sampledChances = new HashMap<Item, Float>();
            for (LootItemEntry se : sampled) {
                sampledChances.put(se.itemStack().m_41720_(), Float.valueOf(se.dropChance()));
            }
            HashSet<Item> existingItems = new HashSet<Item>();
            int replaced = 0;
            for (int i = 0; i < lootEntries.size(); ++i) {
                Float ch;
                LootItemEntry le = lootEntries.get(i);
                Item it = le.itemStack().m_41720_();
                existingItems.add(it);
                if (!le.hasUnknownDropChance() || (ch = (Float)sampledChances.get(it)) == null) continue;
                lootEntries.set(i, new LootItemEntry(le.itemStack(), le.displayName(), ch.floatValue(), le.override()));
                ++replaced;
            }
            int added = 0;
            for (Map.Entry e : sampledChances.entrySet()) {
                if (existingItems.contains(e.getKey())) continue;
                ItemStack stack = new ItemStack((ItemLike)e.getKey());
                Component name = stack.m_41786_();
                lootEntries.add(new LootItemEntry(stack, name, ((Float)e.getValue()).floatValue(), false));
                ++added;
            }
            if (replaced > 0 || added > 0) {
                LOGGER.debug("Refined loot chances via sampling: replaced {} unknowns, added {} sampled entries", (Object)replaced, (Object)added);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to refine loot chances via sampling: {}", (Object)ex.getMessage());
        }
    }

    private static List<LootItemEntry> deduplicateAndNormalize(List<LootItemEntry> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        LinkedHashMap<Item, LootItemEntry> merged = new LinkedHashMap<Item, LootItemEntry>();
        for (LootItemEntry e : list) {
            float combined;
            Item item = e.itemStack().m_41720_();
            LootItemEntry existing = (LootItemEntry)merged.get(item);
            if (existing == null) {
                merged.put(item, e);
                continue;
            }
            float p1 = existing.dropChance();
            float p2 = e.dropChance();
            if (p1 == -1.0f && p2 != -1.0f) {
                combined = p2;
            } else if (p2 == -1.0f && p1 != -1.0f) {
                combined = p1;
            } else if (p1 == -1.0f && p2 == -1.0f) {
                combined = -1.0f;
            } else {
                double c = 1.0 - (1.0 - Math.max(0.0, Math.min(1.0, (double)p1))) * (1.0 - Math.max(0.0, Math.min(1.0, (double)p2)));
                combined = (float)Math.max(0.0, Math.min(1.0, c));
            }
            Component name = existing.displayName();
            if (name == null || name.getString().isEmpty()) {
                name = e.displayName();
            }
            boolean override = existing.override() || e.override();
            merged.put(item, new LootItemEntry(existing.itemStack(), name, combined, override));
        }
        return new ArrayList<LootItemEntry>(merged.values());
    }

    public static List<LootItemEntry> simulateAdditionalLootSamples(EntityType<?> entityType, ServerLevel serverLevel, int batches) {
        ArrayList<LootItemEntry> result = new ArrayList<LootItemEntry>();
        if (entityType == null || serverLevel == null || batches <= 0) {
            return result;
        }
        try {
            ResourceLocation lootTableId;
            ResourceLocation resolved = lootTableId = entityType.m_20677_();
            try {
                ResourceLocation entId;
                if ((resolved == null || resolved.equals((Object)BuiltInLootTables.f_78712_)) && (entId = ForgeRegistries.ENTITY_TYPES.getKey(entityType)) != null) {
                    ResourceLocation guess;
                    resolved = guess = ResourceLocation.m_135820_((String)(entId.m_135827_() + ":entities/" + entId.m_135815_()));
                    LOGGER.debug("simulateAdditionalLootSamples: default loot table for {} was null/empty; trying {}", (Object)entityType.m_20676_().getString(), (Object)resolved);
                }
            }
            catch (Throwable entId) {
                // empty catch block
            }
            if (resolved == null) {
                return result;
            }
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(resolved);
            if (lootTable == null) {
                return result;
            }
            Entity ctxEntity = null;
            try {
                ctxEntity = entityType.m_20615_((Level)serverLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ctxEntity == null) {
                try {
                    ctxEntity = EntityType.f_20501_.m_20615_((Level)serverLevel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (ctxEntity == null) {
                try {
                    ctxEntity = EntityType.f_20510_.m_20615_((Level)serverLevel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (ctxEntity == null) {
                return result;
            }
            LootParams.Builder paramsBuilder = new LootParams.Builder(serverLevel).m_287239_(0.0f).m_287286_(LootContextParams.f_81455_, (Object)ctxEntity);
            try {
                FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
                if (fakePlayer != null) {
                    paramsBuilder = paramsBuilder.m_287286_(LootContextParams.f_81458_, (Object)fakePlayer).m_287286_(LootContextParams.f_81459_, (Object)fakePlayer).m_287286_(LootContextParams.f_81456_, (Object)fakePlayer);
                    try {
                        DamageSource dmg = serverLevel.m_269111_().m_269075_((Player)fakePlayer);
                        paramsBuilder = paramsBuilder.m_287286_(LootContextParams.f_81457_, (Object)dmg);
                    }
                    catch (Throwable dmg) {}
                }
            }
            catch (Throwable fakePlayer) {
                // empty catch block
            }
            LootParams lootParams = paramsBuilder.m_287235_(LootContextParamSets.f_81415_);
            SampleAggregate aggr = SAMPLE_CACHE.computeIfAbsent(resolved, k -> new SampleAggregate());
            for (int i = 0; i < batches; ++i) {
                ObjectArrayList generated = lootTable.m_287195_(lootParams);
                for (ItemStack st : generated) {
                    Item it = st.m_41720_();
                    if (it == Items.f_41852_) continue;
                    aggr.counts.put(it, aggr.counts.getOrDefault(it, 0) + 1);
                }
                ++aggr.totalBatches;
            }
            for (Map.Entry<Item, Integer> e : aggr.counts.entrySet()) {
                Item item = e.getKey();
                int c = e.getValue();
                float p = Math.max(0.0f, Math.min(1.0f, (float)c / (float)Math.max(1, aggr.totalBatches)));
                ItemStack stack = new ItemStack((ItemLike)item);
                Component name = stack.m_41786_();
                result.add(new LootItemEntry(stack, name, p, false));
            }
            try {
                ctxEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception ex) {
            LOGGER.debug("simulateAdditionalLootSamples failed for {}: {}", (Object)(entityType != null ? entityType.m_20676_().getString() : "null"), (Object)ex.getMessage());
        }
        return result;
    }

    private static void supplementFromGlobalLootModifiers(ResourceLocation tableId, ServerLevel serverLevel, EntityType<?> entityType, List<LootItemEntry> out, Set<ResourceLocation> visited) {
        if (tableId == null || serverLevel == null) {
            return;
        }
        try {
            JsonObject root;
            ResourceManager rm = serverLevel.m_7654_().m_177941_();
            if (rm == null) {
                return;
            }
            ResourceLocation index = ResourceLocation.m_135820_((String)"forge:loot_modifiers/global_loot_modifiers.json");
            if (index == null) {
                return;
            }
            Optional idxRes = rm.m_213713_(index);
            if (idxRes.isEmpty()) {
                return;
            }
            try (InputStreamReader rdr = new InputStreamReader(((Resource)idxRes.get()).m_215507_(), StandardCharsets.UTF_8);){
                root = JsonParser.parseReader((Reader)rdr).getAsJsonObject();
            }
            if (root == null || !root.has("entries") || !root.get("entries").isJsonArray()) {
                return;
            }
            JsonArray arr = root.getAsJsonArray("entries");
            HashSet<Item> present = new HashSet<Item>();
            for (LootItemEntry e : out) {
                present.add(e.itemStack().m_41720_());
            }
            block22: for (JsonElement el : arr) {
                String simpleType;
                JsonObject modObj;
                Optional modRes;
                ResourceLocation modJsonPath;
                String entryStr;
                ResourceLocation entryId;
                if (!el.isJsonPrimitive() || (entryId = ResourceLocation.m_135820_((String)(entryStr = el.getAsString()))) == null || (modJsonPath = ResourceLocation.m_135820_((String)(entryId.m_135827_() + ":loot_modifiers/" + entryId.m_135815_() + ".json"))) == null || (modRes = rm.m_213713_(modJsonPath)).isEmpty()) continue;
                try (InputStreamReader mr = new InputStreamReader(((Resource)modRes.get()).m_215507_(), StandardCharsets.UTF_8);){
                    modObj = JsonParser.parseReader((Reader)mr).getAsJsonObject();
                }
                if (modObj == null) continue;
                boolean matches = false;
                if (modObj.has("conditions") && modObj.get("conditions").isJsonArray()) {
                    JsonArray conds = modObj.getAsJsonArray("conditions");
                    matches = EntityDataServerHelper.hasMatchingModifierTarget(conds, tableId, entityType);
                }
                if (!matches && modObj.has("filter")) {
                    if (modObj.get("filter").isJsonArray()) {
                        matches = EntityDataServerHelper.hasMatchingModifierTarget(modObj.getAsJsonArray("filter"), tableId, entityType);
                    } else if (modObj.get("filter").isJsonObject()) {
                        JsonArray arr1 = new JsonArray();
                        arr1.add((JsonElement)modObj.getAsJsonObject("filter"));
                        matches = EntityDataServerHelper.hasMatchingModifierTarget(arr1, tableId, entityType);
                    }
                }
                if (!matches) continue;
                String type = modObj.has("type") && modObj.get("type").isJsonPrimitive() ? modObj.get("type").getAsString() : "";
                switch (simpleType = type.contains(":") ? type.substring(type.indexOf(58) + 1) : type) {
                    case "add_items": {
                        if (modObj.has("items") && modObj.get("items").isJsonArray()) {
                            JsonArray items = modObj.getAsJsonArray("items");
                            for (JsonElement itEl : items) {
                                if (itEl.isJsonPrimitive()) {
                                    ResourceLocation itemRL = ResourceLocation.m_135820_((String)itEl.getAsString());
                                    EntityDataServerHelper.addItemIfMissing(itemRL, out, present);
                                    continue;
                                }
                                if (!itEl.isJsonObject()) continue;
                                JsonObject itObj = itEl.getAsJsonObject();
                                ResourceLocation itemRL = null;
                                if (itObj.has("item") && itObj.get("item").isJsonPrimitive()) {
                                    itemRL = ResourceLocation.m_135820_((String)itObj.get("item").getAsString());
                                } else if (itObj.has("name") && itObj.get("name").isJsonPrimitive()) {
                                    itemRL = ResourceLocation.m_135820_((String)itObj.get("name").getAsString());
                                }
                                EntityDataServerHelper.addItemIfMissing(itemRL, out, present);
                            }
                            continue block22;
                        }
                        if (!modObj.has("item") || !modObj.get("item").isJsonPrimitive()) break;
                        ResourceLocation itemRL = ResourceLocation.m_135820_((String)modObj.get("item").getAsString());
                        EntityDataServerHelper.addItemIfMissing(itemRL, out, present);
                        break;
                    }
                    case "append_loot": 
                    case "replace_loot": {
                        if (!modObj.has("loot_table") || !modObj.get("loot_table").isJsonPrimitive()) break;
                        ResourceLocation child = ResourceLocation.m_135820_((String)modObj.get("loot_table").getAsString());
                        if (child == null) continue block22;
                        int before = out.size();
                        EntityDataServerHelper.extractItemsFromLootTableJson(child, serverLevel, out, new HashSet<ResourceLocation>());
                        int added = out.size() - before;
                        if (added <= 0) continue block22;
                        for (int i = before; i < out.size(); ++i) {
                            present.add(out.get(i).itemStack().m_41720_());
                        }
                        continue block22;
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("GLM supplement failed for {}: {}", (Object)tableId, (Object)ex.getMessage());
        }
    }

    private static boolean hasMatchingLootTableCondition(JsonArray conditions, ResourceLocation tableId) {
        if (conditions == null || tableId == null) {
            return false;
        }
        try {
            for (JsonElement cEl : conditions) {
                if (!cEl.isJsonObject() || !EntityDataServerHelper.conditionMatchesLootTable(cEl.getAsJsonObject(), tableId)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean conditionMatchesLootTable(JsonObject cond, ResourceLocation tableId) {
        try {
            String simple;
            if (cond == null) {
                return false;
            }
            String condType = cond.has("condition") && cond.get("condition").isJsonPrimitive() ? cond.get("condition").getAsString() : "";
            String string = simple = condType.contains(":") ? condType.substring(condType.indexOf(58) + 1) : condType;
            if ("loot_table_id".equals(simple) && cond.has("loot_table_id") && cond.get("loot_table_id").isJsonPrimitive()) {
                String id = cond.get("loot_table_id").getAsString();
                return tableId.toString().equals(id);
            }
            if (cond.has("conditions") && cond.get("conditions").isJsonArray()) {
                for (JsonElement child : cond.getAsJsonArray("conditions")) {
                    if (!child.isJsonObject() || !EntityDataServerHelper.conditionMatchesLootTable(child.getAsJsonObject(), tableId)) continue;
                    return true;
                }
            }
            if (cond.has("terms") && cond.get("terms").isJsonArray()) {
                for (JsonElement child : cond.getAsJsonArray("terms")) {
                    if (!child.isJsonObject() || !EntityDataServerHelper.conditionMatchesLootTable(child.getAsJsonObject(), tableId)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean hasMatchingModifierTarget(JsonArray conditions, ResourceLocation tableId, EntityType<?> entityType) {
        if (conditions == null) {
            return false;
        }
        try {
            for (JsonElement cEl : conditions) {
                if (!cEl.isJsonObject() || !EntityDataServerHelper.conditionMatchesTarget(cEl.getAsJsonObject(), tableId, entityType)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean conditionMatchesTarget(JsonObject cond, ResourceLocation tableId, EntityType<?> entityType) {
        try {
            String simple;
            if (cond == null) {
                return false;
            }
            String condType = cond.has("condition") && cond.get("condition").isJsonPrimitive() ? cond.get("condition").getAsString() : "";
            String string = simple = condType.contains(":") ? condType.substring(condType.indexOf(58) + 1) : condType;
            if ("loot_table_id".equals(simple) && cond.has("loot_table_id") && cond.get("loot_table_id").isJsonPrimitive()) {
                String id = cond.get("loot_table_id").getAsString();
                if (tableId != null && tableId.toString().equals(id)) {
                    return true;
                }
            }
            if ("entity_properties".equals(simple) || "entity".equals(simple)) {
                JsonObject predicate;
                JsonObject jsonObject = predicate = cond.has("predicate") && cond.get("predicate").isJsonObject() ? cond.getAsJsonObject("predicate") : null;
                if (predicate != null && predicate.has("type")) {
                    String entIdStr = null;
                    try {
                        ResourceLocation entId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
                        entIdStr = entId != null ? entId.toString() : null;
                    }
                    catch (Throwable entId) {
                        // empty catch block
                    }
                    if (entIdStr != null) {
                        try {
                            String t2;
                            JsonObject to;
                            String t;
                            if (predicate.get("type").isJsonPrimitive() ? entIdStr.equals(t = predicate.get("type").getAsString()) : predicate.get("type").isJsonObject() && (to = predicate.getAsJsonObject("type")).has("type") && to.get("type").isJsonPrimitive() && entIdStr.equals(t2 = to.get("type").getAsString())) {
                                return true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (cond.has("conditions") && cond.get("conditions").isJsonArray()) {
                for (JsonElement child : cond.getAsJsonArray("conditions")) {
                    if (!child.isJsonObject() || !EntityDataServerHelper.conditionMatchesTarget(child.getAsJsonObject(), tableId, entityType)) continue;
                    return true;
                }
            }
            if (cond.has("terms") && cond.get("terms").isJsonArray()) {
                for (JsonElement child : cond.getAsJsonArray("terms")) {
                    if (!child.isJsonObject() || !EntityDataServerHelper.conditionMatchesTarget(child.getAsJsonObject(), tableId, entityType)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void addItemIfMissing(ResourceLocation itemRL, List<LootItemEntry> out, Set<Item> present) {
        if (itemRL == null) {
            return;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRL);
        if (item == null || item == Items.f_41852_) {
            return;
        }
        if (present.contains(item)) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        Component name = stack.m_41786_();
        out.add(new LootItemEntry(stack, name, -1.0f, false));
        present.add(item);
    }

    static {
        LOOT_TABLE_CACHE = new HashMap<ResourceLocation, List<LootItemEntry>>();
        SAMPLE_CACHE = new HashMap<ResourceLocation, SampleAggregate>();
        REFLECTION_TRIED = false;
        REFLECTION_INITIALIZED = false;
    }

    private static class SampleAggregate {
        final Map<Item, Integer> counts = new HashMap<Item, Integer>();
        int totalBatches = 0;

        private SampleAggregate() {
        }
    }
}

