/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public record LootItemEntry(ItemStack itemStack, Component displayName, float dropChance, boolean override) {
    public static final float UNKNOWN_DROP_CHANCE = -1.0f;

    public LootItemEntry {
        if (dropChance != -1.0f && (dropChance < 0.0f || dropChance > 1.0f)) {
            throw new IllegalArgumentException("Drop chance must be between 0.0 and 1.0, or UNKNOWN_DROP_CHANCE");
        }
    }

    public LootItemEntry(ItemStack itemStack, Component displayName, float dropChance) {
        this(itemStack, displayName, dropChance, false);
    }

    public static LootItemEntry createWithUnknownChance(ItemStack itemStack, Component displayName) {
        return new LootItemEntry(itemStack, displayName, -1.0f, false);
    }

    public String getDropChanceString() {
        if (this.dropChance == -1.0f) {
            return "?";
        }
        return String.format("%.1f%%", Float.valueOf(this.dropChance * 100.0f));
    }

    public boolean hasUnknownDropChance() {
        return this.dropChance == -1.0f;
    }
}

