/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EntityDataClientHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static SpawnLocationInfo getClientSideSpawnLocations(EntityType<?> entityType, MobCategory category) {
        ArrayList<ResourceLocation> spawnBiomes = new ArrayList<ResourceLocation>();
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            if (level != null && level.m_9598_() != null) {
                Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
                for (ResourceLocation biomeKey : biomeRegistry.m_6566_()) {
                    try {
                        Biome biome = (Biome)biomeRegistry.m_7745_(biomeKey);
                        if (biome == null || !EntityDataClientHelper.canEntitySpawnInBiome(entityType, biome, category)) continue;
                        spawnBiomes.add(biomeKey);
                        LOGGER.debug("Entity {} can spawn in biome {}", (Object)entityType.m_20676_().getString(), (Object)biomeKey);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error checking if entity can spawn in biome {}: {}", (Object)biomeKey, (Object)e.getMessage());
                    }
                }
                if (!spawnBiomes.isEmpty()) {
                    return SpawnLocationInfo.fromBiomeKeys(spawnBiomes, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting client-side spawn locations: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static boolean canEntitySpawnInBiome(EntityType<?> entityType, Biome biome, MobCategory category) {
        try {
            List spawners = biome.m_47518_().m_151798_(category).m_146338_();
            for (MobSpawnSettings.SpawnerData spawnerData : spawners) {
                if (spawnerData.f_48404_ != entityType) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Error checking spawn rule for {} in biome {}: {}", new Object[]{entityType.m_20675_(), biome.toString(), e.getMessage()});
            return false;
        }
    }
}

