/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client.gui;

import com.araxer.araxers_bestiary.client.ClientProgressionData;
import com.araxer.araxers_bestiary.client.PacketHandler;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryAttributeManager;
import com.araxer.araxers_bestiary.data.EntityAttributes;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.MonsterEntry;
import com.araxer.araxers_bestiary.data.RankUtils;
import com.araxer.araxers_bestiary.data.RankXConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BestiaryScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TEXTURE = new ResourceLocation("araxers_bestiary", "textures/gui/bestiary.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("araxers_bestiary", "textures/gui/bestiary_background.png");
    private static String currentGlobalRankBarType = null;
    private static final ResourceLocation VILLAGER_TRADER_TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/villager2.png");
    private static final int VILLAGER_TEX_WIDTH = 512;
    private static final int VILLAGER_TEX_HEIGHT = 256;
    private static final int VILLAGER_BAR_U = 0;
    private static final int VILLAGER_BAR_V_BG = 186;
    private static final int VILLAGER_BAR_V_FG = 191;
    private static final int VILLAGER_BAR_WIDTH = 102;
    private static final int VILLAGER_BAR_HEIGHT = 5;
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int PANEL_WIDTH = 170;
    private static final int PANEL_HEIGHT = 256;
    private static final int ENTITY_VIEW_SIZE = 150;
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_SPACING = 35;
    private int scaledItemSpacing;
    private List<MonsterEntry> monsters = new ArrayList<MonsterEntry>();
    private List<MonsterEntry> filteredMonsters = new ArrayList<MonsterEntry>();
    private Map<EntityType<?>, Integer> killCounts = new HashMap();
    private Button switchUiButton;
    private Button categoryToggleButton;
    private EditBox searchBox;
    private MonsterListWidget monsterList;
    private EntityViewWidget entityView;
    private InfoPanel infoPanel;
    private Button rankXToggleButton;
    private Button hideUnseenButton;
    private static boolean HIDE_UNSEEN_TOGGLED = false;
    private Button listTextModeButton;
    private static ListTextMode listTextMode = null;
    private static final String[] CATEGORY_TOKENS = new String[]{"new", "sighted", "discovered", "boss", "monster", "creature", "water_creature", "underground_water_creature", "ambient", "water_ambient", "axolotls", "misc"};
    private static final String[] CATEGORY_LABEL_KEYS = new String[]{"screen.araxers_bestiary.filter.display.new", "screen.araxers_bestiary.filter.display.sighted", "screen.araxers_bestiary.filter.display.discovered", "screen.araxers_bestiary.filter.display.boss", "screen.araxers_bestiary.filter.display.monster", "screen.araxers_bestiary.filter.display.creature", "screen.araxers_bestiary.filter.display.water_creature", "screen.araxers_bestiary.filter.display.underground_water_creature", "screen.araxers_bestiary.filter.display.ambient", "screen.araxers_bestiary.filter.display.water_ambient", "screen.araxers_bestiary.filter.display.axolotls", "screen.araxers_bestiary.filter.display.misc"};
    private static int activeCategoryIndex = -1;
    private boolean categoryMarqueeActive = false;
    private String categoryFullLabel = "";
    private String categoryMarqueeBase = "";
    private int categoryMarqueeIndex = 0;
    private long categoryMarqueeLastUpdate = 0L;
    private static final long CATEGORY_MARQUEE_INTERVAL_MS = 180L;
    private Button lootButton;
    private Button locationsButton;
    private Button attributesButton;
    private TabType currentTab = TabType.ATTRIBUTES;
    private MonsterEntry selectedMonster = null;
    private float newTextBounceOffset = 0.0f;
    private float newTextRotation = 0.0f;
    private long lastUpdateTime = 0L;

    private boolean isCategoryAllowed(int idx) {
        if (idx < 0 || idx >= CATEGORY_TOKENS.length) {
            return false;
        }
        if (Config.enableProgressionSystem) {
            return true;
        }
        String token = CATEGORY_TOKENS[idx];
        return !"new".equals(token) && !"sighted".equals(token) && !"discovered".equals(token);
    }

    private void ensureActiveCategoryValid() {
        if (activeCategoryIndex == -1) {
            return;
        }
        if (!this.isCategoryAllowed(activeCategoryIndex)) {
            activeCategoryIndex = -1;
        }
    }

    private Component getCategoryLabelForIndex(int idx) {
        if (idx < 0) {
            return Component.m_237115_((String)"screen.araxers_bestiary.filter.display.all");
        }
        if (idx >= 0 && idx < CATEGORY_LABEL_KEYS.length) {
            return Component.m_237115_((String)CATEGORY_LABEL_KEYS[idx]);
        }
        return Component.m_237115_((String)"screen.araxers_bestiary.filter.display.all");
    }

    private void updateCategoryButtonMessage() {
        if (this.categoryToggleButton == null) {
            return;
        }
        this.ensureActiveCategoryValid();
        Component comp = this.getCategoryLabelForIndex(activeCategoryIndex);
        String full = comp.getString();
        this.setupOrDisableCategoryMarquee(full);
    }

    private void setupOrDisableCategoryMarquee(String fullText) {
        if (this.categoryToggleButton == null || this.f_96547_ == null) {
            return;
        }
        this.categoryFullLabel = fullText == null ? "" : fullText;
        int available = this.getCategoryButtonTextWidth();
        if (this.f_96547_.m_92895_(this.categoryFullLabel) <= available || available <= 0) {
            this.categoryMarqueeActive = false;
            this.categoryMarqueeBase = "";
            this.categoryMarqueeIndex = 0;
            this.categoryMarqueeLastUpdate = 0L;
            this.categoryToggleButton.m_93666_((Component)Component.m_237113_((String)this.categoryFullLabel));
        } else {
            String spacer = "   ";
            this.categoryMarqueeBase = this.categoryFullLabel + spacer + this.categoryFullLabel;
            this.categoryMarqueeActive = true;
            this.categoryMarqueeIndex = 0;
            this.categoryMarqueeLastUpdate = System.currentTimeMillis();
            this.updateCategoryMarqueeText();
        }
    }

    private int getCategoryButtonTextWidth() {
        int padding = 10;
        return Math.max(0, this.categoryToggleButton.m_5711_() - padding);
    }

    private void updateCategoryMarqueeText() {
        if (!this.categoryMarqueeActive || this.categoryToggleButton == null || this.f_96547_ == null) {
            return;
        }
        int available = this.getCategoryButtonTextWidth();
        String window = this.sliceLoopByWidth(this.categoryMarqueeBase, this.categoryMarqueeIndex, available);
        this.categoryToggleButton.m_93666_((Component)Component.m_237113_((String)window));
    }

    private String sliceLoopByWidth(String base, int startIndex, int maxWidth) {
        int w;
        if (base == null || base.isEmpty()) {
            return "";
        }
        int n = base.length();
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int width = 0;
        int maxChars = n * 2;
        for (int i = 0; i < maxChars && width < maxWidth; width += w, ++i) {
            char ch = base.charAt((startIndex + i) % n);
            String s = String.valueOf(ch);
            w = this.f_96547_.m_92895_(s);
            if (sb.length() > 0 && width + w > maxWidth) break;
            sb.append(ch);
        }
        if (sb.length() == 0) {
            sb.append(base.charAt(startIndex % n));
        }
        return sb.toString();
    }

    private void setActiveCategoryIndex(int idx) {
        activeCategoryIndex = idx;
        this.updateCategoryButtonMessage();
        this.updateFilteredMonsters();
        if (this.monsterList != null) {
            this.monsterList.updateEntries(this.filteredMonsters);
        }
    }

    private void cycleCategory(int delta) {
        int count = CATEGORY_TOKENS.length;
        if (count == 0) {
            return;
        }
        if (activeCategoryIndex == -1) {
            if (delta > 0) {
                for (int i = 0; i < count; ++i) {
                    if (!this.isCategoryAllowed(i)) continue;
                    this.setActiveCategoryIndex(i);
                    return;
                }
                return;
            }
            for (int i = count - 1; i >= 0; --i) {
                if (!this.isCategoryAllowed(i)) continue;
                this.setActiveCategoryIndex(i);
                return;
            }
            return;
        }
        int next = activeCategoryIndex;
        for (int attempts = 0; attempts < count; ++attempts) {
            if ((next += delta > 0 ? 1 : -1) >= 0 && next < count) continue;
            this.setActiveCategoryIndex(-1);
            return;
        }
        this.setActiveCategoryIndex(-1);
    }

    public BestiaryScreen() {
        super((Component)Component.m_237115_((String)"screen.araxers_bestiary.bestiary"));
    }

    private float getScalingFactor() {
        int currentScale = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
        if (currentScale == 0) {
            int height;
            int width = Minecraft.m_91087_().m_91268_().m_85441_();
            int scaleFactor = Math.max(1, Math.min(width / 320, (height = Minecraft.m_91087_().m_91268_().m_85442_()) / 240));
            if (scaleFactor > 3) {
                return 3.0f / (float)scaleFactor;
            }
        } else if (currentScale > 3) {
            return 3.0f / (float)currentScale;
        }
        return 1.0f;
    }

    protected void m_7856_() {
        LOGGER.debug("Initializing Modern Bestiary Screen");
        currentGlobalRankBarType = Config.globalRankProgressBarType != null ? Config.globalRankProgressBarType : "S";
        int panelSpacing = 20;
        int totalWidth = 170 + panelSpacing + 150;
        this.scaledItemSpacing = 35;
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        int leftPanelX = Math.round(centerX - (float)totalWidth / 2.0f);
        int rightPanelX = leftPanelX + 170 + panelSpacing;
        int panelY = Math.round(centerY - 128.0f);
        int entityViewX = rightPanelX;
        int entityViewY = panelY;
        int infoPanelX = rightPanelX;
        int infoPanelY = panelY + 150 + 30;
        int infoPanelHeight = 76;
        this.searchBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, leftPanelX - 10, panelY - 10, 170, 20, (Component)Component.m_237115_((String)"screen.araxers_bestiary.search")));
        this.searchBox.m_94151_(this::updateSearch);
        int hideBtnWidth = 20;
        int hideBtnHeight = 16;
        int hideBtnX = leftPanelX - 10 + 170 - hideBtnWidth;
        int hideBtnY = panelY + 12;
        this.hideUnseenButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"H"), btn -> {
            HIDE_UNSEEN_TOGGLED = !HIDE_UNSEEN_TOGGLED;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.updateHideUnseenButtonLabel();
            this.updateFilteredMonsters();
            if (this.monsterList != null) {
                this.monsterList.updateEntries(this.filteredMonsters);
            }
        }).m_252794_(hideBtnX, hideBtnY).m_253046_(hideBtnWidth, hideBtnHeight).m_253136_());
        this.hideUnseenButton.f_93624_ = Config.enableProgressionSystem;
        this.updateHideUnseenButtonLabel();
        if (listTextMode == null) {
            listTextMode = "ranks".equals(Config.progressionSystemType) ? ListTextMode.RANK : ("kills".equals(Config.progressionSystemType) ? ListTextMode.KILLS : ListTextMode.HIDE);
        }
        if (!"ranks".equals(Config.progressionSystemType) && listTextMode == ListTextMode.RANK) {
            listTextMode = ListTextMode.KILLS;
        }
        int listBtnWidth = hideBtnWidth;
        int listBtnHeight = hideBtnHeight;
        int listBtnX = hideBtnX - listBtnWidth - 2;
        int listBtnY = hideBtnY;
        this.listTextModeButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder(this.getListTextModeLabel(), btn -> {
            boolean ranksEnabled = "ranks".equals(Config.progressionSystemType);
            if (ranksEnabled) {
                switch (listTextMode) {
                    case RANK: {
                        listTextMode = ListTextMode.KILLS;
                        break;
                    }
                    case KILLS: {
                        listTextMode = ListTextMode.HIDE;
                        break;
                    }
                    case HIDE: {
                        listTextMode = ListTextMode.RANK;
                        break;
                    }
                    default: {
                        listTextMode = ListTextMode.RANK;
                        break;
                    }
                }
            } else {
                listTextMode = listTextMode == ListTextMode.KILLS ? ListTextMode.HIDE : ListTextMode.KILLS;
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.updateListTextModeButtonLabel();
        }).m_252794_(listBtnX, listBtnY).m_253046_(listBtnWidth, listBtnHeight).m_253136_());
        this.listTextModeButton.f_93624_ = Config.enableProgressionSystem;
        this.updateListTextModeButtonLabel();
        this.categoryToggleButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder(this.getCategoryLabelForIndex(activeCategoryIndex), btn -> this.cycleCategory(1)).m_252794_(leftPanelX - 10, panelY - 34).m_253046_(90, 20).m_253136_());
        this.updateCategoryButtonMessage();
        this.loadMonsterData();
        this.monsterList = new MonsterListWidget(leftPanelX - 10, panelY + 30, 170, 256, this.filteredMonsters);
        this.m_142416_((GuiEventListener)this.monsterList);
        this.entityView = new EntityViewWidget(entityViewX, entityViewY, 150, 150);
        this.m_142416_((GuiEventListener)this.entityView);
        int buttonWidth = 56;
        int buttonY = entityViewY + 150 + 5;
        int buttonHeight = 20;
        this.attributesButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"screen.araxers_bestiary.tab.stats"), button -> {
            this.currentTab = TabType.ATTRIBUTES;
        }).m_252794_(entityViewX - 8, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.locationsButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"screen.araxers_bestiary.tab.spawn"), button -> {
            this.currentTab = TabType.LOCATIONS;
        }).m_252794_(entityViewX + buttonWidth - 8, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.lootButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"screen.araxers_bestiary.tab.loot"), button -> {
            this.currentTab = TabType.LOOT;
        }).m_252794_(entityViewX + buttonWidth * 2 - 8, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.infoPanel = new InfoPanel(infoPanelX - 8, infoPanelY, 170, infoPanelHeight);
        this.m_142416_((GuiEventListener)this.infoPanel);
        this.rankXToggleButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"X"), btn -> {
            if (this.infoPanel != null) {
                boolean bl = this.infoPanel.showRankXInsteadOfAttributes = !this.infoPanel.showRankXInsteadOfAttributes;
                if (this.infoPanel.showRankXInsteadOfAttributes) {
                    this.infoPanel.rankXScrollOffset = 0;
                }
            }
        }).m_252794_(infoPanelX - 8 + 170 - 22, infoPanelY + 12).m_253046_(16, 16).m_253136_());
        this.rankXToggleButton.f_93624_ = false;
    }

    private void loadMonsterData() {
        this.monsters.clear();
        this.filteredMonsters.clear();
        this.killCounts.clear();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level != null) {
            LOGGER.debug("Level is available, fetching monster entries dynamically");
            if (player != null) {
                LOGGER.debug("Using progressive monster entries for player: {}", (Object)player.m_7755_().getString());
                this.monsters = EntityDataProvider.getProgressiveMonsterEntries((Level)level, (Player)player);
                for (MonsterEntry monster : this.monsters) {
                    if (monster.entityType() == null) continue;
                    int killCount = ClientProgressionData.getKillCount(monster.entityType());
                    this.killCounts.put(monster.entityType(), killCount);
                    LOGGER.debug("Kill count for {}: {}", (Object)monster.name(), (Object)killCount);
                }
            } else {
                LOGGER.warn("Player is not available, using regular monster entries");
                this.monsters = EntityDataProvider.getMonsterEntries((Level)level);
            }
        }
        this.updateFilteredMonsters();
    }

    private void updateFilteredMonsters() {
        this.filteredMonsters.clear();
        String rawSearchText = this.searchBox != null ? this.searchBox.m_94155_().toLowerCase() : "";
        Object effectiveSearchText = rawSearchText;
        boolean startsWithSpecial = ((String)effectiveSearchText).startsWith("@") || ((String)effectiveSearchText).startsWith("#") || ((String)effectiveSearchText).startsWith("$") || ((String)effectiveSearchText).startsWith("%");
        boolean appliedCategoryViaToggle = false;
        this.ensureActiveCategoryValid();
        if (activeCategoryIndex != -1 && !startsWithSpecial && this.isCategoryAllowed(activeCategoryIndex)) {
            appliedCategoryViaToggle = true;
            effectiveSearchText = "#" + CATEGORY_TOKENS[activeCategoryIndex];
        }
        String nameFilterForCombine = rawSearchText;
        Object searchText = effectiveSearchText;
        if (((String)searchText).equals("@") || ((String)searchText).equals("#") || ((String)searchText).equals("$") || ((String)searchText).equals("%")) {
            for (MonsterEntry monster : this.monsters) {
                if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType())) continue;
                this.filteredMonsters.add(monster);
            }
            LOGGER.debug("Search text is '{}' - not filtering by name or mod ID", searchText);
            return;
        }
        if (((String)searchText).startsWith("$") && ((String)searchText).length() > 1) {
            String filterType = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by entity type: {}", (Object)filterType);
            boolean isEFilter = "e".equals(filterType);
            boolean isDFilter = "d".equals(filterType);
            boolean isCFilter = "c".equals(filterType);
            boolean isBFilter = "b".equals(filterType);
            boolean isAFilter = "a".equals(filterType);
            boolean isSFilter = "s".equals(filterType);
            if (!(isEFilter || isAFilter || isBFilter || isCFilter || isSFilter || isDFilter)) {
                return;
            }
            for (MonsterEntry monster : this.monsters) {
                ClientLevel level;
                if (Config.enableProgressionSystem && (Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType()) || monster.entityType() == null || (level = Minecraft.m_91087_().f_91073_) == null) continue;
                try {
                    Entity entity = monster.entityType().m_20615_((Level)level);
                    if (entity == null) continue;
                    boolean shouldAdd = false;
                    if (isEFilter && ClientProgressionData.getRank(monster.entityType()).equals("E")) {
                        shouldAdd = true;
                    }
                    if (isCFilter && ClientProgressionData.getRank(monster.entityType()).equals("C")) {
                        shouldAdd = true;
                    }
                    if (isDFilter && ClientProgressionData.getRank(monster.entityType()).equals("D")) {
                        shouldAdd = true;
                    }
                    if (isBFilter && ClientProgressionData.getRank(monster.entityType()).equals("B")) {
                        shouldAdd = true;
                    }
                    if (isAFilter && ClientProgressionData.getRank(monster.entityType()).equals("A")) {
                        shouldAdd = true;
                    }
                    if (isSFilter && ClientProgressionData.getRank(monster.entityType()).equals("S")) {
                        shouldAdd = true;
                    }
                    if (shouldAdd) {
                        this.filteredMonsters.add(monster);
                    }
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create entity for filter check: {}", (Object)e.getMessage());
                }
            }
            LOGGER.debug("Filtered by entity type '{}': {} entities shown", (Object)filterType, (Object)this.filteredMonsters.size());
            return;
        }
        if (((String)searchText).startsWith("%") && ((String)searchText).length() > 1) {
            String locationFilter = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by spawn location containing: {}", (Object)locationFilter);
            for (MonsterEntry monster : this.monsters) {
                if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType())) continue;
                boolean match = false;
                if (monster.spawnLocation() != null) {
                    List<Component> locations = monster.spawnLocation().getAllLocations();
                    for (Component loc : locations) {
                        String raw = loc.getString().toLowerCase();
                        if (raw.contains(locationFilter)) {
                            match = true;
                            break;
                        }
                        String processed = raw;
                        if (raw.contains("/")) {
                            String[] partsSlash = raw.split("/");
                            processed = partsSlash[partsSlash.length - 1];
                        } else if (raw.contains(".")) {
                            String[] partsDot = raw.split("\\.");
                            processed = partsDot[partsDot.length - 1];
                        }
                        if (!(processed = processed.replace('_', ' ')).contains(locationFilter)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match) continue;
                this.filteredMonsters.add(monster);
            }
            LOGGER.debug("Filtered by spawn location '{}': {} entities shown", (Object)locationFilter, (Object)this.filteredMonsters.size());
            return;
        }
        if (((String)searchText).startsWith("#") && ((String)searchText).length() > 1) {
            boolean isDiscoveredFilter;
            String filterType = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by entity type: {}", (Object)filterType);
            boolean isBossFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.boss").getString().toLowerCase().contains(filterType) || "boss".contains(filterType);
            boolean isMonsterFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.monster").getString().toLowerCase().contains(filterType) || "monster".contains(filterType);
            boolean isCreatureFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.creature").getString().toLowerCase().contains(filterType) || "creature".contains(filterType);
            boolean isWaterCreatureFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.water_creature").getString().toLowerCase().contains(filterType) || "water_creature".contains(filterType);
            boolean isUndergroundWaterCreatureFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.underground_water_creature").getString().toLowerCase().contains(filterType) || "underground_water_creature".contains(filterType);
            boolean isAmbientFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.ambient").getString().toLowerCase().contains(filterType) || "ambient".contains(filterType);
            boolean isWaterAmbientFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.water_ambient").getString().toLowerCase().contains(filterType) || "water_ambient".contains(filterType);
            boolean isAxolotlsFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.axolotls").getString().toLowerCase().contains(filterType) || "axolotls".contains(filterType);
            boolean isMiscFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.misc").getString().toLowerCase().contains(filterType) || "misc".contains(filterType);
            boolean isNewFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.new").getString().toLowerCase().contains(filterType) || "new".contains(filterType);
            boolean isPartiallyFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.sighted").getString().toLowerCase().contains(filterType) || "sighted".contains(filterType);
            boolean bl = isDiscoveredFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.discovered").getString().toLowerCase().contains(filterType) || "discovered".contains(filterType);
            if (!(isBossFilter || isMonsterFilter || isCreatureFilter || isWaterCreatureFilter || isUndergroundWaterCreatureFilter || isAmbientFilter || isWaterAmbientFilter || isAxolotlsFilter || isMiscFilter || isNewFilter || isPartiallyFilter || isDiscoveredFilter)) {
                LOGGER.debug("No matching filter type for: {}", (Object)filterType);
                return;
            }
            for (MonsterEntry monster : this.monsters) {
                ClientLevel level;
                if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || "sighting".equals(Config.progressionSystemType) && monster.entityType() != null && !ClientProgressionData.isFullyDiscovered(monster.entityType()) && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || monster.entityType() == null || (level = Minecraft.m_91087_().f_91073_) == null) continue;
                try {
                    Entity entity = monster.entityType().m_20615_((Level)level);
                    if (entity == null) continue;
                    boolean shouldAdd = false;
                    if (isBossFilter && (EntityViewWidget.hasBossBar(entity) || monster.boss())) {
                        shouldAdd = true;
                    }
                    if (isNewFilter && ClientProgressionData.isNewlyDiscovered(monster.entityType())) {
                        shouldAdd = true;
                    }
                    if (isPartiallyFilter && ClientProgressionData.isPartiallyDiscovered(monster.entityType())) {
                        shouldAdd = true;
                    }
                    if (isDiscoveredFilter && (!ClientProgressionData.getRank(monster.entityType()).equals("") && "ranks".equals(Config.progressionSystemType) || this.killCounts.getOrDefault(monster.entityType(), 0) > 0 && "kills".equals(Config.progressionSystemType) || ClientProgressionData.isFullyDiscovered(monster.entityType()) && "sighting".equals(Config.progressionSystemType))) {
                        shouldAdd = true;
                    }
                    if (shouldAdd && this.shouldHideByUnseen(monster.entityType()) && !isPartiallyFilter) {
                        shouldAdd = false;
                    }
                    MobCategory category = monster.entityType().m_20674_();
                    if (isMonsterFilter && category == MobCategory.MONSTER) {
                        shouldAdd = true;
                    }
                    if (isCreatureFilter && category == MobCategory.CREATURE) {
                        shouldAdd = true;
                    }
                    if (isWaterCreatureFilter && category == MobCategory.WATER_CREATURE) {
                        shouldAdd = true;
                    }
                    if (isUndergroundWaterCreatureFilter && category == MobCategory.UNDERGROUND_WATER_CREATURE) {
                        shouldAdd = true;
                    }
                    if (isAmbientFilter && category == MobCategory.AMBIENT) {
                        shouldAdd = true;
                    }
                    if (isWaterAmbientFilter && category == MobCategory.WATER_AMBIENT) {
                        shouldAdd = true;
                    }
                    if (isAxolotlsFilter && category == MobCategory.AXOLOTLS) {
                        shouldAdd = true;
                    }
                    if (isMiscFilter && category == MobCategory.MISC) {
                        shouldAdd = true;
                    }
                    if (shouldAdd && appliedCategoryViaToggle && nameFilterForCombine != null && !nameFilterForCombine.isEmpty() && !monster.name().getString().toLowerCase().contains(nameFilterForCombine)) {
                        shouldAdd = false;
                    }
                    if (shouldAdd) {
                        this.filteredMonsters.add(monster);
                    }
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create entity for filter check: {}", (Object)e.getMessage());
                }
            }
            LOGGER.debug("Filtered by entity type '{}': {} entities shown", (Object)filterType, (Object)this.filteredMonsters.size());
            return;
        }
        boolean isModSearch = false;
        String modIdFilter = "";
        if (((String)searchText).startsWith("@") && ((String)searchText).length() > 1) {
            isModSearch = true;
            modIdFilter = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by mod ID: {}", (Object)modIdFilter);
        }
        for (MonsterEntry monster : this.monsters) {
            ResourceLocation entityId;
            if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType()) || !((String)searchText).isEmpty() && (isModSearch ? monster.entityType() == null || (entityId = ForgeRegistries.ENTITY_TYPES.getKey(monster.entityType())) == null || !entityId.m_135827_().toLowerCase().contains(modIdFilter) : !monster.name().getString().toLowerCase().contains((CharSequence)searchText))) continue;
            this.filteredMonsters.add(monster);
        }
        LOGGER.debug("Filtered monsters list: {} of {} monsters shown", (Object)this.filteredMonsters.size(), (Object)this.monsters.size());
    }

    private void updateSearch(String searchText) {
        this.updateFilteredMonsters();
        if (this.monsterList != null) {
            this.monsterList.updateEntries(this.filteredMonsters);
        }
    }

    private boolean isEntityDiscovered(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if (entityType != null && (ClientProgressionData.isSpyglassObserved(entityType) || ClientProgressionData.isPartiallyDiscovered(entityType))) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return this.killCounts.getOrDefault(entityType, 0) > 0;
        }
        if ("ranks".equals(Config.progressionSystemType)) {
            return !ClientProgressionData.getRank(entityType).equals("");
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return ClientProgressionData.isFullyDiscovered(entityType) || ClientProgressionData.isSpyglassObserved(entityType);
        }
        return false;
    }

    private boolean shouldHideByUnseen(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return false;
        }
        return HIDE_UNSEEN_TOGGLED && entityType != null && (ClientProgressionData.isPartiallyDiscovered(entityType) || !this.isEntityDiscovered(entityType));
    }

    private void updateHideUnseenButtonLabel() {
        if (this.hideUnseenButton != null) {
            this.hideUnseenButton.m_93666_((Component)Component.m_237113_((String)(HIDE_UNSEEN_TOGGLED ? "H*" : "H")));
        }
    }

    private Component getListTextModeLabel() {
        ListTextMode mode = listTextMode;
        if (mode == null) {
            if ("ranks".equals(Config.progressionSystemType)) {
                return Component.m_237113_((String)"R");
            }
            if ("kills".equals(Config.progressionSystemType)) {
                return Component.m_237113_((String)"K");
            }
            return Component.m_237113_((String)"-");
        }
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ListTextMode.RANK -> Component.m_237113_((String)"R");
            case ListTextMode.KILLS -> Component.m_237113_((String)"K");
            case ListTextMode.HIDE -> Component.m_237113_((String)"-");
        };
    }

    private void updateListTextModeButtonLabel() {
        if (this.listTextModeButton != null) {
            this.listTextModeButton.m_93666_(this.getListTextModeLabel());
        }
    }

    public void selectMonster(MonsterEntry monster) {
        LOGGER.debug("selectMonster called for monster: {}", (Object)monster.name());
        this.selectedMonster = monster;
        this.currentTab = TabType.ATTRIBUTES;
        if (monster.entityType() != null && "ranks".equals(Config.progressionSystemType)) {
            String rank = ClientProgressionData.getRank(monster.entityType());
            LOGGER.debug("Selected monster {} with rank: {}", (Object)monster.name(), (Object)rank);
        }
        if (monster.entityType() == null) {
            LOGGER.warn("Monster {} has no entity type, cannot check if newly discovered", (Object)monster.name());
        } else {
            boolean isNewlyDiscovered = ClientProgressionData.isNewlyDiscovered(monster.entityType());
            LOGGER.debug("Entity {} is newly discovered: {}", (Object)monster.entityType().m_20675_(), (Object)isNewlyDiscovered);
            LOGGER.debug("Calling markAsViewed for entity {}", (Object)monster.entityType().m_20675_());
            ClientProgressionData.markAsViewed(monster.entityType());
            PacketHandler.sendEntityViewedPacket(monster.entityType());
            if (!isNewlyDiscovered) {
                LOGGER.debug("Entity {} was not newly discovered, but still marked as viewed", (Object)monster.entityType().m_20675_());
            }
        }
        if (this.entityView != null) {
            LOGGER.debug("Setting entity in entityView: {}", (Object)monster.name());
            this.entityView.setEntity(monster.entityType(), monster);
        } else {
            LOGGER.warn("entityView is null, cannot set entity");
        }
        if (this.infoPanel != null) {
            LOGGER.debug("Setting monster in infoPanel: {}", (Object)monster.name());
            this.infoPanel.setMonster(monster);
        } else {
            LOGGER.warn("infoPanel is null, cannot set monster");
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scalingFactor = this.getScalingFactor();
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        float timeDelta = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
        this.lastUpdateTime = currentTime;
        this.newTextBounceOffset = (float)Math.sin((double)currentTime / 200.0) * 2.0f;
        this.newTextRotation = (float)Math.sin((double)currentTime / 300.0) * 10.0f;
        guiGraphics.m_280168_().m_85836_();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        guiGraphics.m_280168_().m_252880_(centerX, centerY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scalingFactor, scalingFactor, 1.0f);
        guiGraphics.m_280168_().m_252880_(-centerX, -centerY, 0.0f);
        int scaledMouseX = Math.round(((float)mouseX - centerX) / scalingFactor + centerX);
        int scaledMouseY = Math.round(((float)mouseY - centerY) / scalingFactor + centerY);
        int originalWidth = 512;
        int originalHeight = 512;
        float backgroundScale = 0.8f;
        int scaledWidth = (int)((float)originalWidth * backgroundScale);
        int scaledHeight = (int)((float)originalHeight * backgroundScale);
        int x = (this.f_96543_ - scaledWidth) / 2;
        int y = (this.f_96544_ - scaledHeight) / 2;
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, scaledWidth, scaledHeight, scaledWidth, scaledHeight);
        String countText = Component.m_237110_((String)"screen.araxers_bestiary.monsters_count", (Object[])new Object[]{this.filteredMonsters.size()}).getString();
        guiGraphics.m_280056_(this.f_96547_, countText, this.monsterList.m_252754_(), this.monsterList.m_252907_() - 15, 0, false);
        this.updateTabButtonStyles();
        if (this.categoryMarqueeActive && this.categoryToggleButton != null) {
            long now = System.currentTimeMillis();
            if (this.categoryMarqueeLastUpdate == 0L) {
                this.categoryMarqueeLastUpdate = now;
            }
            if (now - this.categoryMarqueeLastUpdate >= 180L) {
                this.categoryMarqueeIndex = (this.categoryMarqueeIndex + 1) % Math.max(1, this.categoryMarqueeBase.length());
                this.categoryMarqueeLastUpdate = now;
                this.updateCategoryMarqueeText();
            }
        }
        super.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTick);
        if (this.hideUnseenButton != null && this.hideUnseenButton.f_93624_ && Config.enableProgressionSystem && this.hideUnseenButton.m_5953_((double)scaledMouseX, (double)scaledMouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.araxers_bestiary.tooltip.hide_undiscovered"), scaledMouseX, scaledMouseY);
        }
        if (this.listTextModeButton != null && this.listTextModeButton.f_93624_ && Config.enableProgressionSystem && this.listTextModeButton.m_5953_((double)scaledMouseX, (double)scaledMouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.araxers_bestiary.tooltip.list_text_mode"), scaledMouseX, scaledMouseY);
        }
        if (this.rankXToggleButton != null) {
            boolean showBtn = false;
            int newX = 0;
            int newY = 0;
            if (this.currentTab == TabType.ATTRIBUTES && this.selectedMonster != null && this.selectedMonster.entityType() != null && this.infoPanel != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.selectedMonster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                    String rnk = ClientProgressionData.getRank(this.selectedMonster.entityType());
                    boolean eligible = RankUtils.compareRanks(rnk, "S") >= 0;
                    boolean bl = showBtn = eligible && Config.showChallenges;
                    if (!showBtn) {
                        this.infoPanel.showRankXInsteadOfAttributes = false;
                    }
                }
                int btnW = this.rankXToggleButton.m_5711_();
                newX = this.infoPanel.x + this.infoPanel.width - btnW - 6;
                newY = this.infoPanel.y + 12;
            }
            this.rankXToggleButton.f_93624_ = showBtn;
            this.rankXToggleButton.f_93623_ = showBtn;
            if (showBtn) {
                this.rankXToggleButton.m_252865_(newX);
                this.rankXToggleButton.m_253211_(newY);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void drawVillagerProgressBarStretched(GuiGraphics guiGraphics, int barX, int barY, int totalWidth, float ratio, int fillColorRGB) {
        if (totalWidth <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float clamped = Math.max(0.0f, Math.min(1.0f, ratio));
        guiGraphics.m_280411_(VILLAGER_TRADER_TEXTURE, barX, barY, totalWidth, 5, 0.0f, 186.0f, 102, 5, 512, 256);
        int destFillWidth = (int)((float)totalWidth * clamped);
        if (clamped > 0.0f && destFillWidth == 0) {
            destFillWidth = 1;
        }
        if (destFillWidth > 0) {
            int srcFillWidth = Math.max(1, Math.min(102, Math.round(102.0f * clamped)));
            float r = (float)(fillColorRGB >> 16 & 0xFF) / 255.0f;
            float g = (float)(fillColorRGB >> 8 & 0xFF) / 255.0f;
            float b = (float)(fillColorRGB & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            guiGraphics.m_280411_(VILLAGER_TRADER_TEXTURE, barX, barY, destFillWidth, 5, 0.0f, 191.0f, srcFillWidth, 5, 512, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void updateTabButtonStyles() {
        boolean shouldShowTabs;
        boolean isDiscovered;
        if (this.selectedMonster == null) {
            this.attributesButton.f_93624_ = false;
            this.locationsButton.f_93624_ = false;
            this.lootButton.f_93624_ = false;
            return;
        }
        boolean isPartiallyDiscovered = false;
        if (this.selectedMonster.entityType() != null) {
            isPartiallyDiscovered = ClientProgressionData.isPartiallyDiscovered(this.selectedMonster.entityType());
        }
        if (!(isDiscovered = this.isEntityDiscovered(this.selectedMonster.entityType())) && Config.forceObfuscation) {
            shouldShowTabs = false;
        } else if ("sighting".equals(Config.progressionSystemType)) {
            shouldShowTabs = isDiscovered;
        } else {
            boolean bl = shouldShowTabs = !isPartiallyDiscovered || !Config.enableProgressionSystem || "kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities;
        }
        if (Config.enableProgressionSystem && !shouldShowTabs) {
            this.attributesButton.f_93624_ = false;
            this.locationsButton.f_93624_ = false;
            this.lootButton.f_93624_ = false;
            return;
        }
        this.attributesButton.f_93624_ = true;
        this.locationsButton.f_93624_ = true;
        this.lootButton.f_93624_ = true;
        this.attributesButton.f_93623_ = true;
        this.locationsButton.f_93623_ = true;
        this.lootButton.f_93623_ = true;
        switch (this.currentTab) {
            case ATTRIBUTES: {
                this.attributesButton.f_93623_ = false;
                break;
            }
            case LOCATIONS: {
                this.locationsButton.f_93623_ = false;
                break;
            }
            case LOOT: {
                this.lootButton.f_93623_ = false;
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        if (button == 1 && this.categoryToggleButton != null) {
            int bx = this.categoryToggleButton.m_252754_();
            int by = this.categoryToggleButton.m_252907_();
            int bw = this.categoryToggleButton.m_5711_();
            int bh = this.categoryToggleButton.m_93694_();
            if (scaledMouseX >= (double)bx && scaledMouseX <= (double)(bx + bw) && scaledMouseY >= (double)by && scaledMouseY <= (double)(by + bh)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.cycleCategory(-1);
                return true;
            }
        }
        return super.m_6375_(scaledMouseX, scaledMouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        return super.m_6348_(scaledMouseX, scaledMouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        double scaledDragX = dragX / (double)scalingFactor;
        double scaledDragY = dragY / (double)scalingFactor;
        return super.m_7979_(scaledMouseX, scaledMouseY, button, scaledDragX, scaledDragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        return super.m_6050_(scaledMouseX, scaledMouseY, delta);
    }

    static /* synthetic */ Font access$000(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$100(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$200(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$300(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$400(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$500(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$600(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$700(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$800(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$900(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1000(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1100(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1200(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1300(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1400(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1500(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1600(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1700(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1800(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8300(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8400(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8500(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8600(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8700(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    private class MonsterListWidget
    extends AbstractWidget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private List<MonsterEntry> entries;
        private int scrollOffset;
        private final int entryHeight;
        private boolean isDragging;

        public MonsterListWidget(int x, int y, int width, int height, List<MonsterEntry> entries) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.scrollOffset = 0;
            this.isDragging = false;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.entries = new ArrayList<MonsterEntry>(entries);
            this.entryHeight = 24;
        }

        public void updateEntries(List<MonsterEntry> newEntries) {
            this.entries = new ArrayList<MonsterEntry>(newEntries);
            this.scrollOffset = 0;
        }

        public static String getModNameFromModId(String modId) {
            if (ModList.get().isLoaded(modId)) {
                return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(modId);
            }
            return modId;
        }

        /*
         * Unable to fully structure code
         */
        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BestiaryScreen.TEXTURE);
            guiGraphics.m_280163_(BestiaryScreen.TEXTURE, this.x, this.y, 0.0f, 0.0f, this.width, this.height, 512, 512);
            visibleEntries = this.height / this.entryHeight;
            startIndex = this.scrollOffset;
            endIndex = Math.min(startIndex + visibleEntries, this.entries.size());
            for (i = startIndex; i < endIndex; ++i) {
                entry = this.entries.get(i);
                entryY = this.y + (i - startIndex) * this.entryHeight;
                isSelected = entry == BestiaryScreen.this.selectedMonster;
                isHovered = this.isMouseOverEntry(mouseX + 10, mouseY, entryY);
                if (isSelected) {
                    guiGraphics.m_280163_(BestiaryScreen.TEXTURE, this.x + 2, entryY + 2, 0.0f, 260.0f, this.width - 10, this.entryHeight, 512, 512);
                } else if (isHovered) {
                    guiGraphics.m_280163_(BestiaryScreen.TEXTURE, this.x + 2, entryY + 2, 0.0f, 290.0f, this.width - 10, this.entryHeight, 512, 512);
                }
                displayName = entry.name();
                nameColor = 0;
                shouldHideInfo = false;
                if (entry.entityType() != null) {
                    isDiscovered = BestiaryScreen.this.isEntityDiscovered(entry.entityType());
                    if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                        shouldHideInfo = true;
                    } else if (ClientProgressionData.isPartiallyDiscovered(entry.entityType()) && Config.enableProgressionSystem) {
                        shouldHideInfo = true;
                    } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                        shouldHideInfo = false;
                    }
                }
                if (shouldHideInfo) {
                    displayName = Component.m_237115_((String)"screen.araxers_bestiary.unknown");
                    nameColor = 0x888888;
                }
                if (!(!displayName.getString().contains(".") || displayName.getString().contains(")") && displayName.getString().contains("("))) {
                    parts = displayName.getString().split("\\.");
                    split = parts[parts.length - 1];
                    name = new StringBuilder();
                    nextUpper = true;
                    for (char c : split.toCharArray()) {
                        if (c == '_') {
                            name.append(' ');
                            nextUpper = true;
                            continue;
                        }
                        name.append(nextUpper != false ? Character.toUpperCase(c) : c);
                        nextUpper = false;
                    }
                    guiGraphics.m_280056_(BestiaryScreen.access$000(BestiaryScreen.this), name.toString(), this.x + 5, entryY + 10, nameColor, false);
                } else {
                    guiGraphics.m_280614_(BestiaryScreen.access$100(BestiaryScreen.this), displayName, this.x + 5, entryY + 10, nameColor, false);
                }
                if (entry.entityType() != null && ClientProgressionData.isNewlyDiscovered(entry.entityType())) {
                    nameWidth = BestiaryScreen.access$200(BestiaryScreen.this).m_92852_((FormattedText)entry.name());
                    guiGraphics.m_280168_().m_85836_();
                    textX = this.x + 2;
                    textY = entryY + 2;
                    guiGraphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
                    guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(BestiaryScreen.this.newTextRotation));
                    guiGraphics.m_280168_().m_252880_(0.0f, BestiaryScreen.this.newTextBounceOffset, 0.0f);
                    guiGraphics.m_280056_(BestiaryScreen.access$300(BestiaryScreen.this), Component.m_237115_((String)"screen.araxers_bestiary.new_indicator").getString(), 0, 0, 0xFFFF00, false);
                    guiGraphics.m_280168_().m_85849_();
                }
                if (entry.entityType() != null) {
                    nameWidth = BestiaryScreen.access$400(BestiaryScreen.this).m_92852_((FormattedText)entry.name());
                    nameX = this.x + 5;
                    nameY = entryY + 10;
                    Objects.requireNonNull(BestiaryScreen.access$500(BestiaryScreen.this));
                    nameHeight = 9;
                    v0 = isHoveringOverName = mouseX >= nameX && mouseX <= nameX + nameWidth && mouseY >= nameY && mouseY <= nameY + nameHeight;
                    if (isHoveringOverName && (entityId = ForgeRegistries.ENTITY_TYPES.getKey(entry.entityType())) != null) {
                        modName = MonsterListWidget.getModNameFromModId(entityId.m_135827_());
                        guiGraphics.m_280557_(BestiaryScreen.access$600(BestiaryScreen.this), (Component)Component.m_237113_((String)modName), mouseX, mouseY);
                    }
                }
                if ("sighting".equals(Config.progressionSystemType) && (BestiaryScreen.listTextMode == null || BestiaryScreen.listTextMode == ListTextMode.HIDE) || !Config.enableProgressionSystem || entry.entityType() == null || !BestiaryScreen.this.killCounts.containsKey(entry.entityType())) continue;
                killCount = BestiaryScreen.this.killCounts.getOrDefault(entry.entityType(), 0);
                if (BestiaryScreen.listTextMode == ListTextMode.HIDE) continue;
                isRankSystem = BestiaryScreen.listTextMode == null ? "ranks".equals(Config.progressionSystemType) : (BestiaryScreen.listTextMode == ListTextMode.HIDE ? "ranks".equals(Config.progressionSystemType) : BestiaryScreen.listTextMode == ListTextMode.RANK);
                shouldHideInfo = ClientProgressionData.isPartiallyDiscovered(entry.entityType()) != false && Config.enableProgressionSystem != false;
                isDiscovered = BestiaryScreen.this.isEntityDiscovered(entry.entityType());
                if (!isDiscovered && Config.forceObfuscation) {
                    shouldHideInfo = true;
                } else if (!Config.hideUndiscovered && !isDiscovered) {
                    shouldHideInfo = true;
                } else if (isRankSystem && !Config.hideNoRankEntities || !isRankSystem && !Config.hideZeroKillEntities) {
                    shouldHideInfo = false;
                }
                sighted = Component.m_237115_((String)"screen.araxers_bestiary.sighted").getString();
                if (isRankSystem) {
                    if (shouldHideInfo) {
                        displayText = ClientProgressionData.getRank(entry.entityType()).equals("") && !ClientProgressionData.isPartiallyDiscovered(entry.entityType()) ? Component.m_237115_((String)"screen.araxers_bestiary.unknown_short").getString() : sighted;
                    } else {
                        rank = ClientProgressionData.getRank(entry.entityType());
                        displayText = rank;
                        if (displayText == null || displayText.isEmpty()) {
                            displayText = ClientProgressionData.getRank(entry.entityType()).equals("") && !ClientProgressionData.isPartiallyDiscovered(entry.entityType()) ? Component.m_237115_((String)"screen.araxers_bestiary.unknown_short").getString() : sighted;
                        }
                    }
                } else {
                    displayText = shouldHideInfo != false ? Component.m_237115_((String)"screen.araxers_bestiary.defeats_unknown").getString() : Component.m_237110_((String)"screen.araxers_bestiary.defeats_count", (Object[])new Object[]{killCount}).getString();
                }
                setShadow = false;
                if (shouldHideInfo) {
                    textColor = 0x888888;
                } else if (isRankSystem) {
                    var24_62 = rank = ClientProgressionData.getRank(entry.entityType());
                    var25_63 = -1;
                    switch (var24_62.hashCode()) {
                        case 88: {
                            if (!var24_62.equals("X")) break;
                            var25_63 = 0;
                            break;
                        }
                        case 83: {
                            if (!var24_62.equals("S")) break;
                            var25_63 = 1;
                            break;
                        }
                        case 65: {
                            if (!var24_62.equals("A")) break;
                            var25_63 = 2;
                            break;
                        }
                        case 66: {
                            if (!var24_62.equals("B")) break;
                            var25_63 = 3;
                            break;
                        }
                        case 67: {
                            if (!var24_62.equals("C")) break;
                            var25_63 = 4;
                            break;
                        }
                        case 68: {
                            if (!var24_62.equals("D")) break;
                            var25_63 = 5;
                            break;
                        }
                        case 69: {
                            if (!var24_62.equals("E")) break;
                            var25_63 = 6;
                        }
                    }
                    switch (var25_63) {
                        case 0: {
                            v1 = 0xAA1111;
                            break;
                        }
                        case 1: {
                            v1 = 0xFFFF55;
                            break;
                        }
                        case 2: {
                            v1 = 16717267;
                            break;
                        }
                        case 3: {
                            v1 = 16716629;
                            break;
                        }
                        case 4: {
                            v1 = 305919;
                            break;
                        }
                        case 5: {
                            v1 = 0x55FF55;
                            break;
                        }
                        case 6: {
                            v1 = 0xEEEEEE;
                            break;
                        }
                        default: {
                            v1 = 0x888888;
                        }
                    }
                    textColor = v1;
                    setShadow = true;
                } else {
                    textColor = "kills".equals(Config.progressionSystemType) ? (killCount >= Config.lootChanceThreshold ? 43520 : (killCount >= Config.lootIconThreshold ? 0xFFFF00 : (killCount >= Config.spawnLocationThreshold ? 16753920 : 0xFF0000))) : 0;
                }
                textX = this.x + this.width - BestiaryScreen.access$700(BestiaryScreen.this).m_92895_(displayText) - 20;
                textY = entryY + 10;
                if ("kills".equals(Config.progressionSystemType) || displayText.equals(sighted) || displayText.equals("?")) {
                    guiGraphics.m_280056_(BestiaryScreen.access$800(BestiaryScreen.this), displayText, textX, textY, textColor, false);
                } else {
                    guiGraphics.m_280056_(BestiaryScreen.access$900(BestiaryScreen.this), displayText, textX, textY, textColor, setShadow);
                }
                if (!isRankSystem || mouseX < textX || mouseX > textX + BestiaryScreen.access$1000(BestiaryScreen.this).m_92895_(displayText) || mouseY < textY) ** GOTO lbl-1000
                Objects.requireNonNull(BestiaryScreen.access$1100(BestiaryScreen.this));
                if (mouseY <= textY + 9) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = isHovering = false;
                }
                if (isHovering && !displayText.equals(sighted)) {
                    guiGraphics.m_280557_(BestiaryScreen.access$1200(BestiaryScreen.this), (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.defeats", (Object[])new Object[]{killCount}), mouseX, mouseY);
                    continue;
                }
                if (!isHovering || !displayText.equals(sighted)) continue;
                guiGraphics.m_280557_(BestiaryScreen.access$1300(BestiaryScreen.this), (Component)Component.m_237115_((String)"screen.araxers_bestiary.tooltip.sighted"), mouseX, mouseY);
            }
            if (this.entries.size() > visibleEntries) {
                scrollbarWidth = 6;
                scrollbarX = this.x + this.width - scrollbarWidth - 2;
                scrollbarHeight = (int)((double)this.height * 0.9);
                scrollbarY = this.y + (this.height - scrollbarHeight) / 2;
                guiGraphics.m_280163_(BestiaryScreen.TEXTURE, scrollbarX, scrollbarY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                contentRatio = (float)visibleEntries / (float)this.entries.size();
                minThumbHeight = 20;
                thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                scrollRatio = (float)this.scrollOffset / (float)Math.max(1, this.entries.size() - visibleEntries);
                thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                thumbColor = this.isDragging != false || hoveringOverScrollbar != false ? -594735 : -1784461;
                guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
            if (Config.enableProgressionSystem && ("ranks".equals(Config.progressionSystemType) || "sighting".equals(Config.progressionSystemType))) {
                ranksMode = "ranks".equals(Config.progressionSystemType);
                sightingMode = "sighting".equals(Config.progressionSystemType);
                sCount = 0;
                xCount = 0;
                sightCount = 0;
                for (MonsterEntry m : BestiaryScreen.this.monsters) {
                    if (m.entityType() == null) continue;
                    r = ClientProgressionData.getRank(m.entityType());
                    if (RankUtils.compareRanks(r, "S") >= 0) {
                        ++sCount;
                    }
                    if ("X".equals(r)) {
                        ++xCount;
                    }
                    if (!ClientProgressionData.isSpyglassObserved(m.entityType()) && !ClientProgressionData.isFullyDiscovered(m.entityType())) continue;
                    ++sightCount;
                }
                desiredType = BestiaryScreen.currentGlobalRankBarType != null ? BestiaryScreen.currentGlobalRankBarType : Config.globalRankProgressBarType;
                showX = "X".equalsIgnoreCase(desiredType);
                count = showX != false ? xCount : sCount;
                countToUse = sightingMode != false ? sightCount : count;
                thresholds = Config.globalSRankThresholds != null && Config.globalSRankThresholds.isEmpty() == false ? Config.globalSRankThresholds : List.of(Integer.valueOf(50));
                prev = 0;
                next = thresholds.get(0);
                last = thresholds.get(thresholds.size() - 1);
                for (i = 0; i < thresholds.size(); ++i) {
                    t = thresholds.get(i);
                    if (countToUse < t) {
                        next = t;
                        break;
                    }
                    prev = t;
                    next = i + 1 < thresholds.size() ? thresholds.get(i + 1) : t;
                }
                if (countToUse >= last) {
                    ratio = 1.0f;
                    next = last;
                } else {
                    ratio = (float)countToUse / (float)Math.max(1, next);
                }
                barTotalWidth = this.width - 12;
                barX = this.x + 6;
                barY = this.y + this.height - 5 - 6;
                color = sightingMode != false ? 0x55FF55 : (showX != false ? 0xDD2222 : 0x55FF55);
                BestiaryScreen.this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, barTotalWidth, ratio, color);
                hoverBar = mouseX >= barX && mouseX <= barX + barTotalWidth && mouseY >= barY && mouseY <= barY + 5;
                percent = Math.round(ratio * 100.0f);
                if (!hoverBar) {
                    percentText = percent + "%";
                    textW = BestiaryScreen.access$1400(BestiaryScreen.this).m_92895_(percentText);
                    textX = barX + (barTotalWidth - textW) / 2;
                    Objects.requireNonNull(BestiaryScreen.access$1500(BestiaryScreen.this));
                    textY = barY + (5 - 9) / 2;
                    outlineColor = 0;
                    for (dx = -1; dx <= 1; ++dx) {
                        for (dy = -1; dy <= 1; ++dy) {
                            if (dx == 0 && dy == 0) continue;
                            guiGraphics.m_280056_(BestiaryScreen.access$1600(BestiaryScreen.this), percentText, textX + dx, textY + dy, outlineColor, false);
                        }
                    }
                    guiGraphics.m_280056_(BestiaryScreen.access$1700(BestiaryScreen.this), percentText, textX, textY, color, false);
                }
                if (hoverBar) {
                    if (sightingMode) {
                        tipComp = Component.m_237110_((String)"screen.araxers_bestiary.global_bar.tooltip.sighted", (Object[])new Object[]{countToUse, next});
                    } else {
                        key = showX != false ? "screen.araxers_bestiary.global_bar.tooltip.x_ranks" : "screen.araxers_bestiary.global_bar.tooltip.s_ranks";
                        tipComp = Component.m_237110_((String)key, (Object[])new Object[]{count, next});
                    }
                    guiGraphics.m_280557_(BestiaryScreen.access$1800(BestiaryScreen.this), (Component)tipComp, mouseX, mouseY);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }

        private boolean isMouseOverEntry(int mouseX, int mouseY, int entryY) {
            return mouseX >= this.x && mouseX < this.x + this.width && mouseY >= entryY && mouseY < entryY + this.entryHeight;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.entries.size() > this.height / this.entryHeight) {
                int scrollbarWidth = 6;
                int scrollbarX = this.x + this.width - scrollbarWidth - 2;
                int scrollbarHeight = (int)((double)this.height * 0.9);
                int scrollbarY = this.y + (this.height - scrollbarHeight) / 2;
                if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + scrollbarHeight)) {
                    this.isDragging = true;
                    return true;
                }
            }
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width - 10) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
                boolean inBar;
                int barTotalWidth = this.width - 12;
                int barX = this.x + 6;
                int barTop = this.y + this.height - 5 - 6;
                int barBottom = barTop + 5;
                boolean bl = inBar = mouseX >= (double)barX && mouseX <= (double)(barX + barTotalWidth) && mouseY >= (double)barTop && mouseY <= (double)barBottom;
                if (inBar) {
                    if ("ranks".equals(Config.progressionSystemType)) {
                        if (Config.enableGlobalRankProgressBarCycling) {
                            String after;
                            int xCount = 0;
                            for (MonsterEntry m : BestiaryScreen.this.monsters) {
                                String r;
                                if (m.entityType() == null || !"X".equals(r = ClientProgressionData.getRank(m.entityType()))) continue;
                                ++xCount;
                            }
                            String before = currentGlobalRankBarType != null ? currentGlobalRankBarType : Config.globalRankProgressBarType;
                            boolean defaultIsS = "S".equalsIgnoreCase(Config.globalRankProgressBarType);
                            if (defaultIsS && "S".equalsIgnoreCase(before) && xCount == 0) {
                                return true;
                            }
                            currentGlobalRankBarType = after = "S".equalsIgnoreCase(before) ? "X" : "S";
                            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                            return true;
                        }
                        return true;
                    }
                    return "sighting".equals(Config.progressionSystemType);
                }
                int visibleEntries = this.height / this.entryHeight;
                int clickedIndex = this.scrollOffset + (int)((mouseY - (double)this.y) / (double)this.entryHeight);
                if (clickedIndex >= 0 && clickedIndex < this.entries.size()) {
                    BestiaryScreen.this.selectMonster(this.entries.get(clickedIndex));
                    return true;
                }
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isDragging && this.entries.size() > this.height / this.entryHeight) {
                int scrollbarHeight = (int)((double)this.height * 0.9);
                int scrollbarY = this.y + (this.height - scrollbarHeight) / 2;
                float scrollRatio = mouseY < (double)scrollbarY ? 0.0f : (mouseY > (double)(scrollbarY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)scrollbarY) / (float)scrollbarHeight);
                this.scrollOffset = (int)(scrollRatio * (float)this.entries.size());
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.entries.size() - this.height / this.entryHeight));
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height) && this.entries.size() > this.height / this.entryHeight) {
                this.scrollOffset -= (int)delta;
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.entries.size() - this.height / this.entryHeight));
                return true;
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"narration.araxers_bestiary.monster_list"));
        }

        public int m_252754_() {
            return this.x;
        }

        public int m_252907_() {
            return this.y;
        }
    }

    private static enum TabType {
        LOOT,
        LOCATIONS,
        ATTRIBUTES;

    }

    private static enum ListTextMode {
        RANK,
        KILLS,
        HIDE;

    }

    private class EntityViewWidget
    extends AbstractWidget {
        private final int x;
        private final int y;
        private final int size;
        private Entity renderedEntity;
        private MonsterEntry displayedMonster;
        private float rotationYaw;
        private float rotationPitch;
        private float autoRotationSpeed;
        private boolean isDragging;
        private boolean isDraggingScrollbar;
        private int lastMouseX;
        private int lastMouseY;
        private boolean showDescription;
        private Button infoButton;
        private int descriptionScrollOffset;
        private List<String> descriptionLines;
        private Long lastGameTime;
        private float zoom;
        private static final float MIN_ZOOM = 0.5f;
        private static final float MAX_ZOOM = 2.0f;

        private boolean isEntityBoss() {
            if (this.renderedEntity == null) {
                LOGGER.debug("isEntityBoss check failed: renderedEntity is null");
                return false;
            }
            if (this.displayedMonster != null && this.displayedMonster.boss()) {
                return true;
            }
            boolean hasBossBar = EntityViewWidget.hasBossBar(this.renderedEntity);
            return hasBossBar;
        }

        public static boolean hasBossBar(Entity entity) {
            if (entity instanceof EnderDragon || entity instanceof WitherBoss || entity instanceof ElderGuardian || entity instanceof Warden) {
                return true;
            }
            try {
                for (Class<?> iface : entity.getClass().getInterfaces()) {
                    Class<?> enclosing = iface.getEnclosingClass();
                    if (enclosing != null && enclosing.getSimpleName().equals("BossEvent") && iface.getSimpleName().equals("Provider")) {
                        return true;
                    }
                    if (iface.getName().contains("boss")) {
                        return true;
                    }
                    if (enclosing == null || !enclosing.getSimpleName().contains("boss")) continue;
                    return true;
                }
                String className = entity.getClass().getSimpleName().toLowerCase();
                if (className.contains("boss")) {
                    return true;
                }
                EntityType type = entity.m_6095_();
                String id = EntityType.m_20613_((EntityType)type).m_135815_();
                if (id.contains("boss")) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        public EntityViewWidget(int x, int y, int size, int size1) {
            super(x, y, size, size1, (Component)Component.m_237119_());
            this.rotationYaw = 0.0f;
            this.rotationPitch = 0.0f;
            this.autoRotationSpeed = 1.0f;
            this.isDragging = false;
            this.isDraggingScrollbar = false;
            this.lastMouseX = 0;
            this.lastMouseY = 0;
            this.showDescription = false;
            this.descriptionScrollOffset = 0;
            this.descriptionLines = new ArrayList<String>();
            this.lastGameTime = null;
            this.zoom = 1.0f;
            this.x = x;
            this.y = y;
            this.size = size;
            this.infoButton = new Button.Builder((Component)Component.m_237113_((String)"i"), button -> {
                this.showDescription = !this.showDescription;
            }).m_252794_(0, 0).m_253046_(20, 20).m_253136_();
            this.infoButton.f_93624_ = false;
            BestiaryScreen.this.m_142416_((GuiEventListener)this.infoButton);
        }

        public void setEntity(EntityType<?> entityType, MonsterEntry monster) {
            this.disposeRenderedEntity();
            this.displayedMonster = monster;
            this.showDescription = false;
            this.descriptionScrollOffset = 0;
            this.descriptionLines.clear();
            this.lastGameTime = null;
            this.zoom = 1.0f;
            if (entityType != null) {
                try {
                    ClientLevel level = Minecraft.m_91087_().f_91073_;
                    if (level != null) {
                        this.renderedEntity = entityType.m_20615_((Level)level);
                        LOGGER.debug("Created entity for rendering: {}", (Object)entityType.m_20675_());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create entity for rendering: {}", (Object)e.getMessage());
                }
            }
        }

        private void disposeRenderedEntity() {
            if (this.renderedEntity != null) {
                try {
                    this.renderedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    LOGGER.debug("Disposed entity: {}", (Object)this.renderedEntity.m_7755_().getString());
                    this.renderedEntity = null;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to dispose entity: {}", (Object)e.getMessage());
                }
            }
        }

        private void renderDescription(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.displayedMonster == null || this.displayedMonster.description() == null || this.displayedMonster.description().isEmpty()) {
                String text = "No description available";
                guiGraphics.m_280137_(BestiaryScreen.this.f_96547_, text, this.x + this.size / 2, this.y + this.size / 2, 0);
                return;
            }
            int padding = 10;
            int textX = this.x + padding;
            int textY = this.y + padding;
            int textWidth = this.size - padding * 2;
            Objects.requireNonNull(BestiaryScreen.this.f_96547_);
            int lineHeight = 9 + 2;
            int visibleLines = (this.size - padding * 2) / lineHeight;
            if (this.descriptionLines.isEmpty() || !this.displayedMonster.description().equals(String.join((CharSequence)" ", this.descriptionLines))) {
                this.descriptionScrollOffset = 0;
                String description = this.displayedMonster.description();
                this.descriptionLines.clear();
                String[] words = description.split(" ");
                StringBuilder currentLine = new StringBuilder();
                for (String word : words) {
                    if (BestiaryScreen.this.f_96547_.m_92895_(String.valueOf(currentLine) + " " + word) < textWidth) {
                        if (currentLine.length() > 0) {
                            currentLine.append(" ");
                        }
                        currentLine.append(word);
                        continue;
                    }
                    if (currentLine.length() > 0) {
                        this.descriptionLines.add(currentLine.toString());
                        currentLine = new StringBuilder(word);
                        continue;
                    }
                    this.descriptionLines.add(word);
                }
                if (currentLine.length() > 0) {
                    this.descriptionLines.add(currentLine.toString());
                }
            }
            int maxScroll = Math.max(0, this.descriptionLines.size() - visibleLines);
            this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, maxScroll));
            for (int i = 0; i < visibleLines && i + this.descriptionScrollOffset < this.descriptionLines.size(); ++i) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, this.descriptionLines.get(i + this.descriptionScrollOffset), textX, textY + i * lineHeight, 0, false);
            }
            if (this.descriptionLines.size() > visibleLines) {
                int scrollbarWidth = 6;
                int scrollbarX = this.x + this.size - scrollbarWidth - 4;
                int scrollbarHeight = this.size - padding * 2;
                int scrollbarY = this.y + padding;
                guiGraphics.m_280163_(TEXTURE, scrollbarX, scrollbarY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                float contentRatio = (float)visibleLines / (float)this.descriptionLines.size();
                int thumbHeight = Math.max(20, (int)((float)scrollbarHeight * contentRatio));
                int thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * ((float)this.descriptionScrollOffset / (float)(this.descriptionLines.size() - visibleLines)));
                boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                int thumbColor = this.isDraggingScrollbar || hoveringOverScrollbar ? -594735 : -1784461;
                guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            guiGraphics.m_280163_(TEXTURE, this.x, this.y, 180.0f, 0.0f, this.size, this.size, 512, 512);
            if (this.displayedMonster != null) {
                boolean showInfoButton;
                int textColor;
                boolean isBoss;
                boolean isPartiallyDiscovered = false;
                if (this.displayedMonster.entityType() != null) {
                    boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(this.displayedMonster.entityType());
                    if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                        isPartiallyDiscovered = true;
                    } else if (ClientProgressionData.isPartiallyDiscovered(this.displayedMonster.entityType()) && Config.enableProgressionSystem) {
                        isPartiallyDiscovered = true;
                    } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                        isPartiallyDiscovered = false;
                    }
                }
                MutableComponent entityName = isPartiallyDiscovered ? Component.m_237113_((String)"???") : this.displayedMonster.name();
                boolean bl = isBoss = (!isPartiallyDiscovered || Config.enableProgressionSystem) && this.isEntityBoss();
                if (isBoss) {
                    entityName = Component.m_237115_((String)"screen.araxers_bestiary.boss_prefix").m_7220_((Component)entityName);
                    LOGGER.debug("Added [Boss] prefix to entity name: {}", (Object)entityName);
                } else {
                    LOGGER.debug("Entity is not a boss, no prefix added: {}", (Object)entityName);
                }
                int nameOffsetY = 15;
                int textWidth = BestiaryScreen.this.f_96547_.m_92852_((FormattedText)entityName);
                int centeredX = this.x + this.size / 2 - textWidth / 2;
                int n = textColor = isPartiallyDiscovered ? 0x888888 : 0;
                if (!(!entityName.getString().contains(".") || entityName.getString().contains(")") && entityName.getString().contains("("))) {
                    String[] parts = entityName.getString().split("\\.");
                    String split = parts[parts.length - 1];
                    StringBuilder displayName = new StringBuilder();
                    boolean nextUpper = true;
                    for (char c : split.toCharArray()) {
                        if (c == '_') {
                            displayName.append(' ');
                            nextUpper = true;
                            continue;
                        }
                        displayName.append(nextUpper ? Character.toUpperCase(c) : c);
                        nextUpper = false;
                    }
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, displayName.toString(), centeredX, this.y - nameOffsetY, textColor, false);
                } else {
                    guiGraphics.m_280614_(BestiaryScreen.this.f_96547_, (Component)entityName, centeredX, this.y - nameOffsetY, textColor, false);
                }
                boolean hasDescription = this.displayedMonster.description() != null && !this.displayedMonster.description().isEmpty();
                boolean hasReachedThreshold = !Config.enableProgressionSystem || ClientProgressionData.shouldShowDescription(this.displayedMonster.entityType());
                boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(this.displayedMonster.entityType());
                this.infoButton.f_93624_ = showInfoButton = hasDescription && hasReachedThreshold && isDiscovered;
                if (showInfoButton) {
                    int buttonSpacing = 5;
                    int buttonWidth = this.infoButton.m_5711_();
                    int buttonX = this.x + this.size - buttonWidth - buttonSpacing;
                    int buttonY = this.y - nameOffsetY - 20 - 2;
                    this.infoButton.m_252865_(buttonX);
                    this.infoButton.m_253211_(buttonY);
                }
            } else {
                this.infoButton.f_93624_ = false;
            }
            boolean hasReachedThreshold = !Config.enableProgressionSystem || this.displayedMonster != null && this.displayedMonster.entityType() != null && ClientProgressionData.shouldShowDescription(this.displayedMonster.entityType());
            guiGraphics.m_280588_(this.x - 15, this.y + 30, this.x + this.size - 35, this.y + this.size - 5);
            if (this.showDescription && this.displayedMonster != null && hasReachedThreshold) {
                this.renderDescription(guiGraphics, mouseX, mouseY);
            } else {
                if (!this.isDragging && this.renderedEntity != null) {
                    this.rotationYaw += this.autoRotationSpeed;
                    if (this.rotationYaw > 360.0f) {
                        this.rotationYaw -= 360.0f;
                    }
                }
                if (this.renderedEntity != null) {
                    int entityScale = Math.max(1, Math.round(30.0f * this.zoom));
                    this.renderEntity(guiGraphics, this.x + this.size / 2, this.y + Math.round((float)this.size / 1.5f), entityScale, this.rotationYaw, this.rotationPitch);
                } else if (BestiaryScreen.this.selectedMonster != null) {
                    String text = Component.m_237115_((String)"screen.araxers_bestiary.no_preview").getString();
                    guiGraphics.m_280137_(BestiaryScreen.this.f_96547_, text, this.x + this.size / 2, this.y + this.size / 2, 0xFFFFFF);
                }
            }
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderEntity(GuiGraphics guiGraphics, int posX, int posY, int scale, float yaw, float pitch) {
            boolean usePoseStackRotation;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)posX, (double)posY, 1050.0);
            guiGraphics.m_280168_().m_85841_(1.0f, 1.0f, -1.0f);
            float scaleFactor = this.getScaleFactorForEntity(this.renderedEntity);
            float entityScale = (float)scale * scaleFactor;
            if (!Float.isFinite(entityScale) || entityScale <= 0.0f) {
                entityScale = 30.0f;
            }
            if (entityScale < 5.0f) {
                entityScale = 5.0f;
            }
            if (entityScale > 120.0f) {
                entityScale = 120.0f;
            }
            guiGraphics.m_280168_().m_85841_(entityScale, entityScale, entityScale);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            boolean bl = usePoseStackRotation = !(this.renderedEntity instanceof LivingEntity) || this.isHugeOrSpecial(this.renderedEntity);
            if (usePoseStackRotation) {
                guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(yaw));
                guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(pitch));
            }
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            dispatcher.m_114468_(false);
            boolean isPartiallyDiscovered = false;
            if (BestiaryScreen.this.selectedMonster != null && BestiaryScreen.this.selectedMonster.entityType() != null) {
                boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(BestiaryScreen.this.selectedMonster.entityType());
                if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                    isPartiallyDiscovered = true;
                } else if (ClientProgressionData.isPartiallyDiscovered(BestiaryScreen.this.selectedMonster.entityType()) && Config.enableProgressionSystem) {
                    isPartiallyDiscovered = true;
                } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                    isPartiallyDiscovered = false;
                }
            }
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            if (isPartiallyDiscovered) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            float pt = Minecraft.m_91087_().m_91296_();
            ClientLevel lvl = Minecraft.m_91087_().f_91073_;
            if (lvl != null) {
                long dt;
                long now = lvl.m_46467_();
                if (this.lastGameTime == null) {
                    this.lastGameTime = now;
                }
                if ((dt = now - this.lastGameTime) != 0L) {
                    this.renderedEntity.f_19797_ += (int)dt;
                    this.lastGameTime = now;
                }
            }
            LivingEntity living = this.renderedEntity instanceof LivingEntity ? (LivingEntity)this.renderedEntity : null;
            float oldBody = 0.0f;
            float oldBodyO = 0.0f;
            float oldHead = 0.0f;
            float oldHeadO = 0.0f;
            float oldY = 0.0f;
            float oldYO = 0.0f;
            float oldX = 0.0f;
            float oldXO = 0.0f;
            double prevXO = this.renderedEntity.f_19854_;
            double prevYO = this.renderedEntity.f_19855_;
            double prevZO = this.renderedEntity.f_19856_;
            if (living != null && !usePoseStackRotation) {
                float yawAdj;
                oldBody = living.f_20883_;
                oldBodyO = living.f_20884_;
                oldHead = living.f_20885_;
                oldHeadO = living.f_20886_;
                oldY = living.m_146908_();
                oldYO = living.f_19859_;
                oldX = living.m_146909_();
                oldXO = living.f_19860_;
                living.f_20883_ = living.f_20884_ = (yawAdj = 180.0f + yaw);
                living.f_20885_ = living.f_20886_ = yawAdj;
                living.m_146922_(yawAdj);
                living.f_19859_ = yawAdj;
                living.m_146926_(-pitch);
                living.f_19860_ = -pitch;
                living.m_20334_(0.0, 0.0, 0.0);
                this.renderedEntity.f_19854_ = this.renderedEntity.m_20185_();
                this.renderedEntity.f_19855_ = this.renderedEntity.m_20186_();
                this.renderedEntity.f_19856_ = this.renderedEntity.m_20189_();
            }
            RenderSystem.runAsFancy(() -> dispatcher.m_114384_(this.renderedEntity, 0.0, 0.0, 0.0, 0.0f, pt, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0));
            bufferSource.m_109911_();
            if (isPartiallyDiscovered) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (living != null && !usePoseStackRotation) {
                living.f_20883_ = oldBody;
                living.f_20884_ = oldBodyO;
                living.f_20885_ = oldHead;
                living.f_20886_ = oldHeadO;
                living.m_146922_(oldY);
                living.f_19859_ = oldYO;
                living.m_146926_(oldX);
                living.f_19860_ = oldXO;
                this.renderedEntity.f_19854_ = prevXO;
                this.renderedEntity.f_19855_ = prevYO;
                this.renderedEntity.f_19856_ = prevZO;
            }
            guiGraphics.m_280168_().m_85849_();
            dispatcher.m_114468_(true);
        }

        private float getScaleFactorForEntity(Entity entity) {
            float baseFactor = 1.0f;
            try {
                float clampedScale;
                float width = entity.m_20205_();
                float height = entity.m_20206_();
                float referenceSize = Math.max(width, height);
                float scaleFactor = 1.0f / (referenceSize * referenceSize);
                float calibrationFactor = 2.0f;
                scaleFactor *= calibrationFactor;
                float minScale = 0.1f;
                float maxScale = 0.35f;
                if (referenceSize > 16.0f) {
                    float extraScaleFactor = 30.0f / referenceSize;
                    clampedScale = Math.min(Math.max(scaleFactor *= extraScaleFactor, minScale * extraScaleFactor), maxScale);
                } else {
                    clampedScale = Math.min(Math.max(scaleFactor, minScale), maxScale) * 3.5f;
                }
                return clampedScale;
            }
            catch (Exception e) {
                LOGGER.debug("Could not determine size for entity, using default scale. Error: {}", (Object)e.getMessage());
                return 0.35f;
            }
        }

        private boolean isHugeOrSpecial(Entity entity) {
            try {
                float height;
                if (entity instanceof EnderDragon) {
                    return true;
                }
                float width = entity.m_20205_();
                float reference = Math.max(width, height = entity.m_20206_());
                return reference >= 6.0f;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.size) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.size)) {
                if (this.showDescription) {
                    int padding = 10;
                    Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                    int lineHeight = 9 + 2;
                    int visibleLines = (this.size - padding * 2) / lineHeight;
                    if (this.descriptionLines.size() > visibleLines) {
                        boolean clickedOnTrack;
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.size - scrollbarWidth - 4;
                        int scrollbarHeight = this.size - padding * 2;
                        int scrollbarY = this.y + padding;
                        float contentRatio = (float)visibleLines / (float)this.descriptionLines.size();
                        int thumbHeight = Math.max(20, (int)((float)scrollbarHeight * contentRatio));
                        float scrollRatio = (float)this.descriptionScrollOffset / (float)Math.max(1, this.descriptionLines.size() - visibleLines);
                        int thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                        boolean clickedOnThumb = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight);
                        boolean bl = clickedOnTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight);
                        if (clickedOnThumb) {
                            this.isDraggingScrollbar = true;
                            return true;
                        }
                        if (clickedOnTrack) {
                            float newScrollRatio = (float)(mouseY - (double)scrollbarY) / (float)scrollbarHeight;
                            this.descriptionScrollOffset = (int)(newScrollRatio * (float)(this.descriptionLines.size() - visibleLines));
                            this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, this.descriptionLines.size() - visibleLines));
                            return true;
                        }
                    }
                    return true;
                }
                this.isDragging = true;
                this.lastMouseX = (int)mouseX;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            this.isDraggingScrollbar = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isDragging && this.renderedEntity != null) {
                this.rotationYaw = (float)((double)this.rotationYaw + (mouseX - (double)this.lastMouseX) * 1.0);
                this.rotationPitch = (float)((double)this.rotationPitch + (mouseY - (double)this.lastMouseY) * 0.5);
                if (this.rotationPitch > 30.0f) {
                    this.rotationPitch = 30.0f;
                }
                if (this.rotationPitch < -30.0f) {
                    this.rotationPitch = -30.0f;
                }
                this.lastMouseX = (int)mouseX;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (this.isDraggingScrollbar && this.showDescription) {
                int padding = 10;
                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                int lineHeight = 9 + 2;
                int visibleLines = (this.size - padding * 2) / lineHeight;
                if (this.descriptionLines.size() > visibleLines) {
                    int scrollbarHeight = this.size - padding * 2;
                    int scrollbarY = this.y + padding;
                    float scrollRatio = mouseY < (double)scrollbarY ? 0.0f : (mouseY > (double)(scrollbarY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)scrollbarY) / (float)scrollbarHeight);
                    this.descriptionScrollOffset = (int)(scrollRatio * (float)(this.descriptionLines.size() - visibleLines));
                    this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, this.descriptionLines.size() - visibleLines));
                    return true;
                }
            }
            return false;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            boolean inside;
            boolean bl = inside = mouseX >= (double)this.x && mouseX < (double)(this.x + this.size) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.size);
            if (!inside) {
                return false;
            }
            if (this.showDescription) {
                int padding = 10;
                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                int lineHeight = 9 + 2;
                int visibleLines = (this.size - padding * 2) / lineHeight;
                if (this.descriptionLines.size() > visibleLines) {
                    this.descriptionScrollOffset -= (int)delta;
                    int maxScroll = Math.max(0, this.descriptionLines.size() - visibleLines);
                    this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, maxScroll));
                    return true;
                }
                return false;
            }
            if (this.renderedEntity != null) {
                float step = 0.1f;
                float newZoom = this.zoom + (float)delta * step;
                if (newZoom < 0.5f) {
                    newZoom = 0.5f;
                }
                if (newZoom > 2.0f) {
                    newZoom = 2.0f;
                }
                if (newZoom != this.zoom) {
                    this.zoom = newZoom;
                    return true;
                }
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"narration.araxers_bestiary.entity_view"));
        }
    }

    private class InfoPanel
    extends AbstractWidget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private MonsterEntry monster;
        private int spawnLocationsScrollOffset;
        private int lootItemsScrollOffset;
        private boolean isDragging;
        private boolean isDraggingLoot;
        private int rankXScrollOffset;
        private boolean isDraggingRankX;
        private boolean showRankXInsteadOfAttributes;
        private int advAttrScrollOffset;
        private boolean isDraggingAdvAttr;
        private int rxTooltipScrollOffset;
        private int rxTTX;
        private int rxTTY;
        private int rxTTW;
        private int rxTTH;
        private int rxTTTotalLines;
        private int rxTTVisibleLines;

        public InfoPanel(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.spawnLocationsScrollOffset = 0;
            this.lootItemsScrollOffset = 0;
            this.isDragging = false;
            this.isDraggingLoot = false;
            this.rankXScrollOffset = 0;
            this.isDraggingRankX = false;
            this.showRankXInsteadOfAttributes = false;
            this.advAttrScrollOffset = 0;
            this.isDraggingAdvAttr = false;
            this.rxTooltipScrollOffset = 0;
            this.rxTTX = 0;
            this.rxTTY = 0;
            this.rxTTW = 0;
            this.rxTTH = 0;
            this.rxTTTotalLines = 0;
            this.rxTTVisibleLines = 0;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setMonster(MonsterEntry monster) {
            this.monster = monster;
            this.spawnLocationsScrollOffset = 0;
            this.lootItemsScrollOffset = 0;
            this.rankXScrollOffset = 0;
            this.isDraggingRankX = false;
            this.showRankXInsteadOfAttributes = false;
            this.advAttrScrollOffset = 0;
            this.isDraggingAdvAttr = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<AdvRowType> buildAdvancedRows(MonsterEntry m) {
            ArrayList<AdvRowType> rows = new ArrayList<AdvRowType>();
            if (m == null) {
                return rows;
            }
            rows.add(AdvRowType.KNOCKBACK);
            rows.add(AdvRowType.ARMOR);
            rows.add(AdvRowType.TOUGHNESS);
            rows.add(AdvRowType.MOVEMENT);
            rows.add(AdvRowType.EXPERIENCE);
            if (Minecraft.m_91087_().f_91073_ != null && m.entityType() != null) {
                ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                Entity temp = null;
                try {
                    temp = m.entityType().m_20615_((Level)lvl);
                    if (temp instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)temp;
                        if (le.m_21051_(Attributes.f_22277_) != null) {
                            rows.add(AdvRowType.FOLLOW_RANGE);
                        }
                        if (le.m_21051_(Attributes.f_22282_) != null) {
                            rows.add(AdvRowType.ATTACK_KNOCKBACK);
                        }
                        if (le.m_21051_(Attributes.f_22280_) != null) {
                            rows.add(AdvRowType.FLY_SPEED);
                        }
                        if (le.m_21051_(Attributes.f_22283_) != null) {
                            rows.add(AdvRowType.ATTACK_SPEED);
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (temp != null) {
                        temp.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
            return rows;
        }

        private void drawVillagerProgressBarStretched(GuiGraphics guiGraphics, int barX, int barY, int totalWidth, float ratio, int fillColorRGB) {
            if (totalWidth <= 0) {
                return;
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float clamped = Math.max(0.0f, Math.min(1.0f, ratio));
            guiGraphics.m_280411_(VILLAGER_TRADER_TEXTURE, barX, barY, totalWidth, 5, 0.0f, 186.0f, 102, 5, 512, 256);
            int destFillWidth = (int)((float)totalWidth * clamped);
            if (clamped > 0.0f && destFillWidth == 0) {
                destFillWidth = 1;
            }
            if (destFillWidth > 0) {
                int srcFillWidth = Math.max(1, Math.min(102, Math.round(102.0f * clamped)));
                float r = (float)(fillColorRGB >> 16 & 0xFF) / 255.0f;
                float g = (float)(fillColorRGB >> 8 & 0xFF) / 255.0f;
                float b = (float)(fillColorRGB & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                guiGraphics.m_280411_(VILLAGER_TRADER_TEXTURE, barX, barY, destFillWidth, 5, 0.0f, 191.0f, srcFillWidth, 5, 512, 256);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        private void drawVillagerProgressBarStretched(GuiGraphics guiGraphics, int barX, int barY, int totalWidth, float ratio) {
            this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio, 0xFFFFFF);
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            guiGraphics.m_280163_(TEXTURE, this.x, this.y, 340.0f, 0.0f, this.width, this.height, 512, 512);
            int statsX = this.x + 10;
            int statsY = this.y + 10;
            if (this.monster == null) {
                String text = "Select a monster to view details";
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, this.x, this.y + this.height / 2, 0, false);
                guiGraphics.m_280168_().m_85849_();
                return;
            }
            boolean shouldShowContent = true;
            boolean isPartiallyDiscovered = false;
            if (this.monster.entityType() != null) {
                boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(this.monster.entityType());
                if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                    shouldShowContent = false;
                    isPartiallyDiscovered = true;
                } else if (ClientProgressionData.isPartiallyDiscovered(this.monster.entityType()) && Config.enableProgressionSystem) {
                    shouldShowContent = false;
                    isPartiallyDiscovered = true;
                } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                    shouldShowContent = true;
                    isPartiallyDiscovered = false;
                }
            }
            if (Config.enableProgressionSystem && !shouldShowContent) {
                guiGraphics.m_280168_().m_85849_();
                return;
            }
            int killCount = 0;
            if (Config.enableProgressionSystem && this.monster.entityType() != null && BestiaryScreen.this.killCounts.containsKey(this.monster.entityType())) {
                killCount = BestiaryScreen.this.killCounts.getOrDefault(this.monster.entityType(), 0);
            }
            switch (BestiaryScreen.this.currentTab) {
                case ATTRIBUTES: {
                    this.renderAttributesTab(guiGraphics, mouseX, mouseY, this.x, statsY, killCount);
                    break;
                }
                case LOCATIONS: {
                    this.renderLocationsTab(guiGraphics, mouseX, mouseY, this.x, statsY, killCount);
                    break;
                }
                case LOOT: {
                    this.renderLootTab(guiGraphics, mouseX, mouseY, this.x, statsY, killCount);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderAttributesTab(GuiGraphics guiGraphics, int mouseX, int mouseY, int statsX, int statsY, int killCount) {
            boolean rxEligible = false;
            EntityAttributes attrsForToggle = null;
            RankXConfig rxForToggle = null;
            boolean canToggleRX = false;
            if (this.monster.entityType() != null) {
                attrsForToggle = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rxForToggle = attrsForToggle != null ? attrsForToggle.rankX() : null;
                if (rxForToggle != null && Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                    String rnk = ClientProgressionData.getRank(this.monster.entityType());
                    rxEligible = RankUtils.compareRanks(rnk, "S") >= 0;
                    canToggleRX = true;
                }
            }
            if (!rxEligible) {
                this.showRankXInsteadOfAttributes = false;
            }
            if (rxEligible && this.showRankXInsteadOfAttributes && rxForToggle != null && rxEligible) {
                boolean hoverRx;
                int sectionY = statsY;
                String header = Component.m_237115_((String)"screen.araxers_bestiary.rankx.header").getString();
                if (header.equals("screen.araxers_bestiary.rankx.header")) {
                    header = "Rank-X Progress";
                }
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, header, statsX, sectionY, 0, false);
                sectionY += 12;
                int pts = ClientProgressionData.getRankXPoints(this.monster.entityType());
                int target = Math.max(1, rxForToggle.getTarget());
                int barX = statsX;
                int barY = sectionY += 10;
                int totalWidth = Math.max(1, this.width - 20);
                float ratio = Math.min(1.0f, (float)pts / (float)target);
                int rxColor = 0xDD2222;
                this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio, rxColor);
                boolean bl = hoverRx = mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5;
                if (!hoverRx) {
                    int percent = Math.round(ratio * 100.0f);
                    String percentText = percent + "%";
                    int textW = BestiaryScreen.this.f_96547_.m_92895_(percentText);
                    int textX = barX + (totalWidth - textW) / 2;
                    Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                    int textY = barY + (5 - 9) / 2;
                    int outlineColor = 0;
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dy = -1; dy <= 1; ++dy) {
                            if (dx == 0 && dy == 0) continue;
                            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX + dx, textY + dy, outlineColor, false);
                        }
                    }
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX, textY, rxColor, false);
                }
                if (hoverRx) {
                    MutableComponent tipComp = Component.m_237110_((String)"screen.araxers_bestiary.rankx.points", (Object[])new Object[]{pts, target});
                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)tipComp, mouseX, mouseY);
                }
                sectionY += 17;
                List<RankXConfig.Challenge> challenges = rxForToggle.getChallenges();
                if (!challenges.isEmpty()) {
                    String chHeader = Component.m_237115_((String)"screen.araxers_bestiary.rankx.challenges").getString();
                    if (chHeader.contains("screen.araxers_bestiary.rankx.challenges")) {
                        chHeader = "Challenges:";
                    }
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, chHeader, statsX, sectionY, 0, false);
                    int listY = sectionY += 10;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(6, challenges.size()));
                    int maxOffset = Math.max(0, challenges.size() - visibleRows);
                    if (this.rankXScrollOffset > maxOffset) {
                        this.rankXScrollOffset = maxOffset;
                    }
                    if (this.rankXScrollOffset < 0) {
                        this.rankXScrollOffset = 0;
                    }
                    Map<String, Integer> awarded = ClientProgressionData.getRankXChallengeProgress(this.monster.entityType());
                    int startIndex = Math.min(this.rankXScrollOffset, Math.max(0, challenges.size() - visibleRows));
                    int endIndex = Math.min(startIndex + visibleRows, challenges.size());
                    int drawY = listY;
                    for (int i = startIndex; i < endIndex; ++i) {
                        Object localized;
                        int val;
                        RankXConfig.Challenge c;
                        block99: {
                            c = challenges.get(i);
                            val = awarded.getOrDefault(c.id(), 0);
                            String chId = c.id();
                            String keyCh = "screen.araxers_bestiary.rankx.challenge." + chId;
                            localized = Component.m_237115_((String)keyCh).getString();
                            if (((String)localized).equals(keyCh) || ((String)localized).contains(keyCh)) {
                                if (chId.startsWith("elite_streak_")) {
                                    try {
                                        int n = Integer.parseInt(chId.substring("elite_streak_".length()));
                                        String eliteKey = "screen.araxers_bestiary.rankx.challenge.elite_streak";
                                        String elite = Component.m_237110_((String)eliteKey, (Object[])new Object[]{n}).getString();
                                        if (!elite.equals(eliteKey) && !elite.contains(eliteKey)) {
                                            localized = elite;
                                            break block99;
                                        }
                                        localized = "Elite streak " + n;
                                    }
                                    catch (NumberFormatException ignored) {
                                        localized = chId.replace('_', ' ');
                                    }
                                } else {
                                    localized = chId.replace('_', ' ');
                                }
                            }
                        }
                        String line = "- " + (String)localized + ": " + val + "/" + c.cap() + " (" + c.points() + ")";
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, line, statsX, drawY, 0, false);
                        drawY += lineHeight;
                    }
                    if (challenges.size() > visibleRows) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                        int scrollbarHeight = visibleRows * lineHeight;
                        guiGraphics.m_280163_(TEXTURE, scrollbarX, listY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                        float contentRatio = (float)visibleRows / (float)challenges.size();
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                        float scrollRatio = (float)startIndex / (float)Math.max(1, challenges.size() - visibleRows);
                        int thumbY = listY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                        boolean hovering = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                        int thumbColor = this.isDraggingRankX || hovering ? -594735 : -1784461;
                        guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
                    }
                }
                return;
            }
            if (this.monster.entityType() != null) {
                int esThRaw;
                String rankStr;
                RankXConfig rxTopBar;
                EntityAttributes attrsTopBar = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rxTopBar = attrsTopBar != null ? attrsTopBar.rankX() : null;
                if (rxTopBar != null && Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType) && RankUtils.compareRanks(ClientProgressionData.getRank(this.monster.entityType()), "S") >= 0) {
                    String currentRankStr;
                    boolean isX;
                    boolean hoverRxTop;
                    int pts = ClientProgressionData.getRankXPoints(this.monster.entityType());
                    int target = Math.max(1, rxTopBar.getTarget());
                    int barX = this.x + 6;
                    int barY = this.y;
                    int totalWidth = Math.max(1, this.width - 12);
                    float ratio = Math.min(1.0f, (float)pts / (float)target);
                    int rxColorTop = 0xDD2222;
                    this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio, rxColorTop);
                    boolean bl = hoverRxTop = mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5;
                    if (!hoverRxTop) {
                        int percent = Math.round(ratio * 100.0f);
                        String percentText = percent + "%";
                        int textW = BestiaryScreen.this.f_96547_.m_92895_(percentText);
                        int textX = barX + (totalWidth - textW) / 2;
                        Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                        int textY = barY + (5 - 9) / 2;
                        int outlineColor = 0;
                        for (int dx = -1; dx <= 1; ++dx) {
                            for (int dy = -1; dy <= 1; ++dy) {
                                if (dx == 0 && dy == 0) continue;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX + dx, textY + dy, outlineColor, false);
                            }
                        }
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX, textY, rxColorTop, false);
                    }
                    boolean bl2 = isX = RankUtils.compareRanks(currentRankStr = ClientProgressionData.getRank(this.monster.entityType()), "X") >= 0;
                    if (mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5) {
                        int haveDays;
                        RankXConfig.GateConfig gates;
                        int needDays;
                        int remDays;
                        int percent = Math.round(ratio * 100.0f);
                        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
                        tooltipLines.add(Component.m_237110_((String)"screen.araxers_bestiary.rankx.points", (Object[])new Object[]{pts, target}));
                        if (ratio >= 1.0f && !isX && (remDays = Math.max(0, (needDays = (gates = rxTopBar.getGates()) != null ? gates.getMinDaysSinceS() : 0) - Math.max(0, haveDays = ClientProgressionData.getRankXDaysSinceS(this.monster.entityType())))) > 0) {
                            String key = remDays == 1 ? "screen.araxers_bestiary.rankx.locked_days_remaining.one" : "screen.araxers_bestiary.rankx.locked_days_remaining.other";
                            tooltipLines.add(Component.m_237110_((String)key, (Object[])new Object[]{remDays}));
                        }
                        guiGraphics.m_280677_(BestiaryScreen.this.f_96547_, tooltipLines, Optional.empty(), mouseX, mouseY);
                    }
                }
                if (Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType) && RankUtils.compareRanks(rankStr = ClientProgressionData.getRank(this.monster.entityType()), "S") < 0 && (esThRaw = ClientProgressionData.getESThreshold(this.monster.entityType())) > 0) {
                    boolean hoverES;
                    int esPts = ClientProgressionData.getESPoints(this.monster.entityType());
                    int esTh = esThRaw;
                    int barX = this.x + 6;
                    int barY = this.y;
                    int totalWidth = Math.max(1, this.width - 12);
                    float ratio = Math.min(1.0f, esTh > 0 ? (float)esPts / (float)esTh : 0.0f);
                    this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio);
                    boolean bl = hoverES = mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5;
                    if (!hoverES) {
                        int percent = Math.round(ratio * 100.0f);
                        String percentText = percent + "%";
                        int textW = BestiaryScreen.this.f_96547_.m_92895_(percentText);
                        int textX = barX + (totalWidth - textW) / 2;
                        Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                        int textY = barY + (5 - 9) / 2;
                        int outlineColor = 0;
                        for (int dx = -1; dx <= 1; ++dx) {
                            for (int dy = -1; dy <= 1; ++dy) {
                                if (dx == 0 && dy == 0) continue;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX + dx, textY + dy, outlineColor, false);
                            }
                        }
                        int esColor = 0x55FF55;
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX, textY, esColor, false);
                    }
                    if (mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5) {
                        String from;
                        String string = from = rankStr != null && !rankStr.isEmpty() ? rankStr : "E";
                        if (from.equals("") || from.equals("")) {
                            from = "E";
                        }
                        String to = RankUtils.getNextRank(from);
                        MutableComponent tipComp = Component.m_237113_((String)("Rank " + from + " -> " + to + ": " + esPts + "/" + esTh));
                        guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)tipComp, mouseX, mouseY);
                    }
                }
            }
            int health = this.monster.health();
            int yOffset = statsY;
            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.stats.health").getString(), statsX, yOffset, 0, false);
            int textWidth = BestiaryScreen.this.f_96547_.m_92895_(Component.m_237115_((String)"screen.araxers_bestiary.stats.health").getString());
            if (health <= 20) {
                int i;
                int heartWidth = 9;
                int heartHeight = 9;
                int heartSpacing = 1;
                ResourceLocation iconsTexture = new ResourceLocation("minecraft", "textures/gui/icons.png");
                int fullHearts = health / 2;
                boolean hasHalfHeart = health % 2 == 1;
                int heartsStartX = statsX + textWidth;
                int heartsEndX = heartsStartX + 10 * (heartWidth + heartSpacing);
                for (i = 0; i < 10; ++i) {
                    int heartX = statsX + textWidth + i * (heartWidth + heartSpacing);
                    guiGraphics.m_280163_(iconsTexture, heartX, yOffset, 16.0f, 0.0f, heartWidth, heartHeight, 256, 256);
                }
                for (i = 0; i < fullHearts; ++i) {
                    int heartX = statsX + textWidth + i * (heartWidth + heartSpacing);
                    guiGraphics.m_280163_(iconsTexture, heartX, yOffset, 52.0f, 0.0f, heartWidth, heartHeight, 256, 256);
                }
                if (hasHalfHeart) {
                    int heartX = statsX + textWidth + fullHearts * (heartWidth + heartSpacing);
                    guiGraphics.m_280163_(iconsTexture, heartX, yOffset, 61.0f, 0.0f, heartWidth, heartHeight, 256, 256);
                }
                if (mouseX >= heartsStartX && mouseX <= heartsEndX && mouseY >= yOffset && mouseY <= yOffset + heartHeight) {
                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.health", (Object[])new Object[]{health}), mouseX, mouseY);
                }
            } else {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.valueOf(health), statsX + textWidth, yOffset, 0, false);
            }
            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.stats.damage").getString() + this.monster.damage(), statsX, statsY + 15, 0, false);
            if (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowAdvancedAttributes(this.monster.entityType())) {
                if (!this.showRankXInsteadOfAttributes) {
                    ArrayList<Object> combinedAttrs = new ArrayList<Object>();
                    String knockbackText = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                    combinedAttrs.add(knockbackText);
                    int armor = this.monster.armor();
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + armor);
                    float armorToughness = this.monster.armorToughness();
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(armorToughness)));
                    float movementSpeed = this.monster.movementSpeed();
                    String speedCategory = movementSpeed == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (movementSpeed <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (movementSpeed <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (movementSpeed <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (movementSpeed <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                    String speedText = Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{speedCategory}).getString() + " (" + String.format("%.3f", Float.valueOf(movementSpeed)) + ")";
                    combinedAttrs.add(speedText);
                    int experience = this.monster.experience();
                    if (experience == 0) {
                        combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                    } else {
                        combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + experience + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                    }
                    if (Minecraft.m_91087_().f_91073_ != null && this.monster.entityType() != null) {
                        ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                        Entity temp = null;
                        try {
                            temp = this.monster.entityType().m_20615_((Level)lvl);
                            if (temp instanceof LivingEntity) {
                                LivingEntity le = (LivingEntity)temp;
                                AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                                if (inst != null) {
                                    combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                                if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                    combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                                if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                    float fs = (float)inst.m_22135_();
                                    String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                    combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                                }
                                if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                    combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                            }
                        }
                        catch (Exception le) {
                        }
                        finally {
                            if (temp != null) {
                                temp.m_142687_(Entity.RemovalReason.DISCARDED);
                            }
                        }
                    }
                    List<AdvRowType> rows = this.buildAdvancedRows(this.monster);
                    Double frVal = null;
                    Double akbVal = null;
                    Double flyVal = null;
                    Double asVal = null;
                    if (Minecraft.m_91087_().f_91073_ != null && this.monster.entityType() != null) {
                        ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                        Entity temp = null;
                        try {
                            temp = this.monster.entityType().m_20615_((Level)lvl);
                            if (temp instanceof LivingEntity) {
                                LivingEntity le = (LivingEntity)temp;
                                AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                                if (inst != null) {
                                    frVal = inst.m_22135_();
                                }
                                if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                    akbVal = inst.m_22135_();
                                }
                                if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                    flyVal = inst.m_22135_();
                                }
                                if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                    asVal = inst.m_22135_();
                                }
                            }
                        }
                        catch (Exception le) {
                        }
                        finally {
                            if (temp != null) {
                                temp.m_142687_(Entity.RemovalReason.DISCARDED);
                            }
                        }
                    }
                    int listY = statsY + 30;
                    int lineHeight = 15;
                    int visibleRows = 5;
                    int areaHeight = visibleRows * lineHeight;
                    int content = rows.size();
                    int maxOffset = Math.max(0, content - visibleRows);
                    if (this.advAttrScrollOffset > maxOffset) {
                        this.advAttrScrollOffset = maxOffset;
                    }
                    if (this.advAttrScrollOffset < 0) {
                        this.advAttrScrollOffset = 0;
                    }
                    int startIndex = Math.min(this.advAttrScrollOffset, Math.max(0, maxOffset));
                    int endIndex = Math.min(startIndex + visibleRows, content);
                    int drawY = listY;
                    ResourceLocation iconsTexture = new ResourceLocation("minecraft", "textures/gui/icons.png");
                    for (int i = startIndex; i < endIndex; ++i) {
                        AdvRowType type = rows.get(i);
                        switch (type) {
                            case KNOCKBACK: {
                                String knockText = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, knockText, statsX, drawY, 0, false);
                                break;
                            }
                            case ARMOR: {
                                int k;
                                int armorVal = this.monster.armor();
                                String lbl = Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, lbl, statsX, drawY, 0, false);
                                int textW = BestiaryScreen.this.f_96547_.m_92895_(lbl);
                                if (armorVal <= 20) {
                                    int ax;
                                    int armorWidth = 9;
                                    int armorHeight = 9;
                                    int armorSpacing = 1;
                                    int fullArmor = armorVal / 2;
                                    boolean half = armorVal % 2 == 1;
                                    int startX = statsX + textW;
                                    for (k = 0; k < 10; ++k) {
                                        ax = startX + k * (armorWidth + armorSpacing);
                                        guiGraphics.m_280163_(iconsTexture, ax, drawY, 16.0f, 9.0f, armorWidth, armorHeight, 256, 256);
                                    }
                                    for (k = 0; k < fullArmor; ++k) {
                                        ax = statsX + textW + k * (armorWidth + armorSpacing);
                                        guiGraphics.m_280163_(iconsTexture, ax, drawY, 34.0f, 9.0f, armorWidth, armorHeight, 256, 256);
                                    }
                                    if (half) {
                                        int ax2 = statsX + textW + fullArmor * (armorWidth + armorSpacing);
                                        guiGraphics.m_280163_(iconsTexture, ax2, drawY, 25.0f, 9.0f, armorWidth, armorHeight, 256, 256);
                                    }
                                    int start = statsX + textW;
                                    int end = start + 10 * (armorWidth + armorSpacing);
                                    if (mouseX < start || mouseX > end || mouseY < drawY || mouseY > drawY + armorHeight) break;
                                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.armor", (Object[])new Object[]{armorVal}), mouseX, mouseY);
                                    break;
                                }
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.valueOf(armorVal), statsX + textW, drawY, 0, false);
                                break;
                            }
                            case TOUGHNESS: {
                                float tough = this.monster.armorToughness();
                                int toughHalf = (int)(tough * 2.0f);
                                String lbl = Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, lbl, statsX, drawY, 0, false);
                                int textW = BestiaryScreen.this.f_96547_.m_92895_(lbl);
                                if (toughHalf <= 20) {
                                    int px;
                                    int k;
                                    int w = 9;
                                    int h = 9;
                                    int s = 1;
                                    int full = toughHalf / 2;
                                    boolean half = toughHalf % 2 == 1;
                                    int startX = statsX + textW;
                                    for (k = 0; k < 10; ++k) {
                                        px = startX + k * (w + s);
                                        guiGraphics.m_280163_(iconsTexture, px, drawY, 16.0f, 9.0f, w, h, 256, 256);
                                    }
                                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                    for (k = 0; k < full; ++k) {
                                        px = statsX + textW + k * (w + s);
                                        guiGraphics.m_280163_(iconsTexture, px, drawY, 34.0f, 9.0f, w, h, 256, 256);
                                    }
                                    if (half) {
                                        int px2 = statsX + textW + full * (w + s);
                                        guiGraphics.m_280163_(iconsTexture, px2, drawY, 25.0f, 9.0f, w, h, 256, 256);
                                    }
                                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                    int start = statsX + textW;
                                    int end = start + 10 * (w + s);
                                    if (mouseX < start || mouseX > end || mouseY < drawY || mouseY > drawY + h) break;
                                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.toughness", (Object[])new Object[]{Float.valueOf(tough)}), mouseX, mouseY);
                                    break;
                                }
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.format("%.1f", Float.valueOf(tough)), statsX + textW, drawY, 0, false);
                                break;
                            }
                            case MOVEMENT: {
                                float ms = this.monster.movementSpeed();
                                String spdCat = ms == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                String label = Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{spdCat}).getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, label, statsX, drawY, 0, false);
                                int widthLbl = BestiaryScreen.this.f_96547_.m_92895_(label);
                                if (mouseX < statsX || mouseX > statsX + widthLbl || mouseY < drawY) break;
                                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                                if (mouseY > drawY + 9) break;
                                guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.speed", (Object[])new Object[]{Float.valueOf(ms)}), mouseX, mouseY);
                                break;
                            }
                            case EXPERIENCE: {
                                int k;
                                int expVal = this.monster.experience();
                                String lbl = Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, lbl, statsX, drawY, 0, false);
                                int expTextWidth = BestiaryScreen.this.f_96547_.m_92895_(lbl);
                                if (expVal == 0) {
                                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString(), statsX + expTextWidth, drawY, 0, false);
                                    break;
                                }
                                if (expVal <= 10) {
                                    int orbWidth = 8;
                                    int orbHeight = 8;
                                    int orbSpacing = 1;
                                    ResourceLocation expOrbTexture = new ResourceLocation("minecraft", "textures/entity/experience_orb.png");
                                    int startX = statsX + expTextWidth;
                                    int endX = startX + expVal * (orbWidth + orbSpacing);
                                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                                    for (k = 0; k < expVal; ++k) {
                                        int ox = startX + k * (orbWidth + orbSpacing);
                                        guiGraphics.m_280163_(expOrbTexture, ox, drawY, 8.0f, 8.0f, orbWidth, orbHeight, 32, 32);
                                    }
                                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                    if (mouseX < startX || mouseX > endX || mouseY < drawY || mouseY > drawY + orbHeight) break;
                                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.experience", (Object[])new Object[]{expVal}), mouseX, mouseY);
                                    break;
                                }
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.valueOf(expVal) + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString(), statsX + expTextWidth, drawY, 0, false);
                                break;
                            }
                            case FOLLOW_RANGE: {
                                if (frVal == null) break;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", frVal)}).getString(), statsX, drawY, 0, false);
                                break;
                            }
                            case ATTACK_KNOCKBACK: {
                                if (akbVal == null) break;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", akbVal)}).getString(), statsX, drawY, 0, false);
                                break;
                            }
                            case FLY_SPEED: {
                                if (flyVal == null) break;
                                float fs = flyVal.floatValue();
                                String spdCat = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                String label = Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{spdCat}).getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, label, statsX, drawY, 0, false);
                                int widthLbl = BestiaryScreen.this.f_96547_.m_92895_(label);
                                if (mouseX < statsX || mouseX > statsX + widthLbl || mouseY < drawY) break;
                                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                                if (mouseY > drawY + 9) break;
                                guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.speed", (Object[])new Object[]{Float.valueOf(fs)}), mouseX, mouseY);
                                break;
                            }
                            case ATTACK_SPEED: {
                                if (asVal == null) break;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", asVal)}).getString(), statsX, drawY, 0, false);
                            }
                        }
                        drawY += lineHeight;
                    }
                    if (content > visibleRows) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 2;
                        guiGraphics.m_280163_(TEXTURE, scrollbarX, listY, 180.0f, 160.0f, scrollbarWidth, areaHeight, 512, 512);
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)areaHeight * ((float)visibleRows / (float)content)), minThumbHeight);
                        float scrollRatio = (float)this.advAttrScrollOffset / (float)Math.max(1, content - visibleRows);
                        int thumbY = listY + (int)((float)(areaHeight - thumbHeight) * scrollRatio);
                        boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                        int thumbColor = this.isDraggingAdvAttr || hoveringOverScrollbar ? -594735 : -1784461;
                        guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
                    }
                }
            } else {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.stats.advanced_locked").getString(), statsX, statsY + 30, 0xFF0000, false);
                if ("kills".equals(Config.progressionSystemType)) {
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.stats.need_defeats", (Object[])new Object[]{Config.advancedAttributesThreshold}).getString(), statsX, statsY + 45, 0xFF0000, false);
                } else {
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.stats.need_rank", (Object[])new Object[]{Config.advancedAttributesRank}).getString(), statsX, statsY + 45, 0xFF0000, false);
                }
            }
            if (this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx == null || !Config.enableProgressionSystem || !"ranks".equals(Config.progressionSystemType) || rxEligible) {
                    // empty if block
                }
            }
        }

        private void renderLocationsTab(GuiGraphics guiGraphics, int mouseX, int mouseY, int statsX, int statsY, int killCount) {
            if (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType())) {
                if (this.monster.spawnLocation().hasMultipleLocations()) {
                    List<Component> locations = this.monster.spawnLocation().getAllLocations();
                    int maxVisibleLocations = 8;
                    int locationHeight = 12;
                    int startIndex = Math.min(this.spawnLocationsScrollOffset, Math.max(0, locations.size() - maxVisibleLocations));
                    int endIndex = Math.min(startIndex + maxVisibleLocations, locations.size());
                    for (int i = startIndex; i < endIndex; ++i) {
                        int locationY = statsY + (i - startIndex) * locationHeight;
                        if (locations.get(i).getString().contains(".")) {
                            String split;
                            if (locations.get(i).getString().contains("/")) {
                                split = locations.get(i).getString().split("/")[1];
                            } else {
                                String[] parts = locations.get(i).getString().split("\\.");
                                split = parts[parts.length - 1];
                            }
                            StringBuilder displayName = new StringBuilder();
                            boolean nextUpper = true;
                            for (char c : split.toCharArray()) {
                                if (c == '_') {
                                    displayName.append(' ');
                                    nextUpper = true;
                                    continue;
                                }
                                displayName.append(nextUpper ? Character.toUpperCase(c) : c);
                                nextUpper = false;
                            }
                            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, displayName.toString(), statsX, locationY, 0, false);
                            continue;
                        }
                        guiGraphics.m_280614_(BestiaryScreen.this.f_96547_, locations.get(i), statsX, locationY, 0, false);
                    }
                    if (locations.size() > maxVisibleLocations) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 10;
                        int scrollbarHeight = maxVisibleLocations * locationHeight;
                        guiGraphics.m_280163_(TEXTURE, scrollbarX, statsY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                        float contentRatio = (float)maxVisibleLocations / (float)locations.size();
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                        float scrollRatio = (float)this.spawnLocationsScrollOffset / (float)Math.max(1, locations.size() - maxVisibleLocations);
                        int thumbY = statsY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                        boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                        int thumbColor = this.isDragging || hoveringOverScrollbar ? -594735 : -1784461;
                        guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
                    }
                } else {
                    guiGraphics.m_280614_(BestiaryScreen.this.f_96547_, this.monster.spawnLocation().getPrimaryLocation(), statsX, statsY + 20, 0, false);
                }
            } else {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.spawn.locked").getString(), statsX, statsY + 20, 0xFF0000, false);
                if ("kills".equals(Config.progressionSystemType)) {
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.spawn.need_defeats", (Object[])new Object[]{Config.spawnLocationThreshold}).getString(), statsX, statsY + 35, 0xFF0000, false);
                } else {
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.spawn.need_rank", (Object[])new Object[]{Config.spawnLocationRank}).getString(), statsX, statsY + 35, 0xFF0000, false);
                }
            }
        }

        private void renderLootTab(GuiGraphics guiGraphics, int mouseX, int mouseY, int statsX, int statsY, int killCount) {
            if ((!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType())) && !this.monster.loot().isEmpty()) {
                int itemX = statsX;
                int itemY = statsY;
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int maxVisibleItems = itemsPerRow * maxVisibleRows;
                boolean showDropChances = !Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootChances(this.monster.entityType());
                int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                int startIndex = Math.min(this.lootItemsScrollOffset * itemsPerRow, Math.max(0, this.monster.loot().size() - maxVisibleItems));
                int endIndex = Math.min(startIndex + maxVisibleItems, this.monster.loot().size());
                for (int i = startIndex; i < endIndex; ++i) {
                    LootItemEntry lootEntry = this.monster.loot().get(i);
                    int adjustedIndex = i - startIndex;
                    int row = adjustedIndex / itemsPerRow;
                    int col = adjustedIndex % itemsPerRow;
                    int itemPosX = itemX + col * BestiaryScreen.this.scaledItemSpacing;
                    int itemPosY = itemY + row * BestiaryScreen.this.scaledItemSpacing;
                    guiGraphics.m_280480_(lootEntry.itemStack(), itemPosX, itemPosY);
                    if (showDropChances) {
                        String dropChance = lootEntry.getDropChanceString();
                        int dropChanceWidth = BestiaryScreen.this.f_96547_.m_92895_(dropChance);
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, dropChance, itemPosX + (16 - dropChanceWidth) / 2, itemPosY + 16 + 2, 0, false);
                    }
                    if (mouseX < itemPosX || mouseX >= itemPosX + 16 || mouseY < itemPosY || mouseY >= itemPosY + 16) continue;
                    if (lootEntry.displayName().getString().isEmpty() || lootEntry.itemStack().m_41786_().getString().equals(lootEntry.displayName().getString())) {
                        guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, lootEntry.itemStack().m_41786_(), mouseX, mouseY);
                        continue;
                    }
                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)lootEntry.itemStack().m_41786_().m_6881_().m_130946_(" ").m_7220_(lootEntry.displayName()), mouseX, mouseY);
                }
                if (this.monster.loot().size() > maxVisibleItems) {
                    int scrollbarWidth = 6;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                    int scrollbarHeight = maxVisibleRows * BestiaryScreen.this.scaledItemSpacing;
                    guiGraphics.m_280163_(TEXTURE, scrollbarX, statsY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                    float contentRatio = (float)maxVisibleRows / (float)totalRows;
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                    float scrollRatio = (float)this.lootItemsScrollOffset / (float)Math.max(1, totalRows - maxVisibleRows);
                    int thumbY = statsY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                    boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                    int thumbColor = this.isDraggingLoot || hoveringOverScrollbar ? -594735 : -1784461;
                    guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
                }
                if (Config.enableProgressionSystem && (this.monster.entityType() == null || !ClientProgressionData.shouldShowLootChances(this.monster.entityType()))) {
                    int messageY = itemY + maxVisibleRows * BestiaryScreen.this.scaledItemSpacing + 10;
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.loot.drop_chances_locked").getString(), statsX, messageY - 23, 0xFF0000, false);
                    if ("kills".equals(Config.progressionSystemType)) {
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.loot.need_defeats", (Object[])new Object[]{Config.lootChanceThreshold}).getString(), statsX, messageY - 8, 0xFF0000, false);
                    } else {
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.loot.need_rank", (Object[])new Object[]{Config.lootChanceRank}).getString(), statsX, messageY - 8, 0xFF0000, false);
                    }
                }
            } else if (Config.enableProgressionSystem && (this.monster.entityType() == null || !ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.loot.locked").getString(), statsX, statsY + 20, 0xFF0000, false);
                if ("kills".equals(Config.progressionSystemType)) {
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.loot.need_defeats", (Object[])new Object[]{Config.lootIconThreshold}).getString(), statsX, statsY + 35, 0xFF0000, false);
                } else {
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237110_((String)"screen.araxers_bestiary.loot.need_rank", (Object[])new Object[]{Config.lootIconRank}).getString(), statsX, statsY + 35, 0xFF0000, false);
                }
            } else if (this.monster.loot().isEmpty()) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.loot.no_drops").getString(), statsX, statsY + 20, 0, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int statsY;
            if (BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && !rx.getChallenges().isEmpty() && this.showRankXInsteadOfAttributes) {
                    int statsY2 = this.y + 10;
                    int listY = statsY2 + 58;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(4, rx.getChallenges().size()));
                    if (rx.getChallenges().size() > visibleRows) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                        int scrollbarHeight = visibleRows * lineHeight;
                        if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + scrollbarHeight)) {
                            this.isDraggingRankX = true;
                            int minThumbHeight = 15;
                            int thumbHeight = Math.max((int)((float)scrollbarHeight * ((float)visibleRows / (float)rx.getChallenges().size())), minThumbHeight);
                            float ratio = (float)(mouseY - (double)listY) / (float)Math.max(1, scrollbarHeight - thumbHeight);
                            int maxOffset = Math.max(0, rx.getChallenges().size() - visibleRows);
                            this.rankXScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                            return true;
                        }
                    }
                }
            }
            if (!(BestiaryScreen.this.currentTab != TabType.ATTRIBUTES || this.monster == null || this.monster.entityType() == null || this.showRankXInsteadOfAttributes || Config.enableProgressionSystem && !ClientProgressionData.shouldShowAdvancedAttributes(this.monster.entityType()))) {
                ArrayList<Object> combinedAttrs = new ArrayList<Object>();
                String knockbackText = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                combinedAttrs.add(knockbackText);
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + this.monster.armor());
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(this.monster.armorToughness())));
                float ms = this.monster.movementSpeed();
                String sc = ms == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{sc}).getString() + " (" + String.format("%.3f", Float.valueOf(ms)) + ")");
                int xp = this.monster.experience();
                if (xp == 0) {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                } else {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + xp + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                }
                if (Minecraft.m_91087_().f_91073_ != null) {
                    ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                    Entity temp = null;
                    try {
                        temp = this.monster.entityType().m_20615_((Level)lvl);
                        if (temp instanceof LivingEntity) {
                            LivingEntity le = (LivingEntity)temp;
                            AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                            if (inst != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                float fs = (float)inst.m_22135_();
                                String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                            }
                            if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                        }
                    }
                    catch (Exception le) {
                    }
                    finally {
                        if (temp != null) {
                            temp.m_142687_(Entity.RemovalReason.DISCARDED);
                        }
                    }
                }
                statsY = this.y + 10;
                int listY = statsY + 30;
                int lineHeight = 15;
                int visibleRows = 5;
                int areaHeight = visibleRows * lineHeight;
                int scrollbarWidth = 6;
                int content = combinedAttrs.size();
                if (content > visibleRows) {
                    boolean withinTrack;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 2;
                    boolean bl = withinTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + areaHeight);
                    if (withinTrack) {
                        this.isDraggingAdvAttr = true;
                        int maxOffset = Math.max(0, content - visibleRows);
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)areaHeight * ((float)visibleRows / (float)content)), minThumbHeight);
                        float ratio = (float)(mouseY - (double)listY) / (float)Math.max(1, areaHeight - thumbHeight);
                        this.advAttrScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                        return true;
                    }
                }
            }
            if (BestiaryScreen.this.currentTab == TabType.LOCATIONS && this.monster != null && this.monster.spawnLocation().hasMultipleLocations() && (!Config.enableProgressionSystem || ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType()))) {
                List<Component> locations = this.monster.spawnLocation().getAllLocations();
                int maxVisibleLocations = 8;
                int locationHeight = 12;
                if (locations.size() > maxVisibleLocations) {
                    boolean clickedOnTrack;
                    int scrollbarWidth = 6;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 10;
                    statsY = this.y + 10;
                    scrollbarHeight = maxVisibleLocations * locationHeight;
                    float contentRatio = (float)maxVisibleLocations / (float)locations.size();
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                    float scrollRatio = (float)this.spawnLocationsScrollOffset / (float)Math.max(1, locations.size() - maxVisibleLocations);
                    int thumbY = statsY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                    boolean clickedOnThumb = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight);
                    boolean bl = clickedOnTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)statsY && mouseY <= (double)(statsY + scrollbarHeight);
                    if (clickedOnThumb) {
                        this.isDragging = true;
                        return true;
                    }
                    if (clickedOnTrack) {
                        float newScrollRatio = (float)(mouseY - (double)statsY) / (float)scrollbarHeight;
                        this.spawnLocationsScrollOffset = (int)(newScrollRatio * (float)(locations.size() - maxVisibleLocations));
                        this.spawnLocationsScrollOffset = Math.max(0, Math.min(this.spawnLocationsScrollOffset, locations.size() - maxVisibleLocations));
                        return true;
                    }
                }
            } else if (BestiaryScreen.this.currentTab == TabType.LOOT && this.monster != null && !this.monster.loot().isEmpty() && (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int maxVisibleItems = itemsPerRow * maxVisibleRows;
                int statsY3 = this.y + 10;
                if (this.monster.loot().size() > maxVisibleItems) {
                    boolean clickedOnTrack;
                    int scrollbarWidth = 6;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                    scrollbarHeight = maxVisibleRows * BestiaryScreen.this.scaledItemSpacing;
                    int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                    float contentRatio = (float)maxVisibleRows / (float)totalRows;
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                    float scrollRatio = (float)this.lootItemsScrollOffset / (float)Math.max(1, totalRows - maxVisibleRows);
                    int thumbY = statsY3 + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                    boolean clickedOnThumb = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight);
                    boolean bl = clickedOnTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)statsY3 && mouseY <= (double)(statsY3 + scrollbarHeight);
                    if (clickedOnThumb) {
                        this.isDraggingLoot = true;
                        return true;
                    }
                    if (clickedOnTrack) {
                        float newScrollRatio = (float)(mouseY - (double)statsY3) / (float)scrollbarHeight;
                        int totalVisibleRows = totalRows - maxVisibleRows;
                        this.lootItemsScrollOffset = (int)(newScrollRatio * (float)totalVisibleRows);
                        this.lootItemsScrollOffset = Math.max(0, Math.min(this.lootItemsScrollOffset, totalVisibleRows));
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            this.isDraggingLoot = false;
            this.isDraggingRankX = false;
            this.isDraggingAdvAttr = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isDragging && BestiaryScreen.this.currentTab == TabType.LOCATIONS && this.monster != null && this.monster.spawnLocation().hasMultipleLocations() && (!Config.enableProgressionSystem || ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType()))) {
                List<Component> locations = this.monster.spawnLocation().getAllLocations();
                int maxVisibleLocations = 8;
                int locationHeight = 12;
                int statsY = this.y + 10;
                int scrollbarHeight = maxVisibleLocations * locationHeight;
                float scrollRatio = mouseY < (double)statsY ? 0.0f : (mouseY > (double)(statsY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)statsY) / (float)scrollbarHeight);
                this.spawnLocationsScrollOffset = (int)(scrollRatio * (float)(locations.size() - maxVisibleLocations));
                this.spawnLocationsScrollOffset = Math.max(0, Math.min(this.spawnLocationsScrollOffset, locations.size() - maxVisibleLocations));
                return true;
            }
            if (this.isDraggingLoot && BestiaryScreen.this.currentTab == TabType.LOOT && this.monster != null && !this.monster.loot().isEmpty() && (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int statsY = this.y + 10;
                int scrollbarHeight = maxVisibleRows * BestiaryScreen.this.scaledItemSpacing;
                int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                float scrollRatio = mouseY < (double)statsY ? 0.0f : (mouseY > (double)(statsY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)statsY) / (float)scrollbarHeight);
                int totalVisibleRows = totalRows - maxVisibleRows;
                this.lootItemsScrollOffset = (int)(scrollRatio * (float)totalVisibleRows);
                this.lootItemsScrollOffset = Math.max(0, Math.min(this.lootItemsScrollOffset, totalVisibleRows));
                return true;
            }
            if (this.isDraggingRankX && BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && !rx.getChallenges().isEmpty() && this.showRankXInsteadOfAttributes) {
                    int statsY = this.y + 10;
                    int listY = statsY + 58;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(4, rx.getChallenges().size()));
                    int scrollbarHeight = visibleRows * lineHeight;
                    float ratio = mouseY < (double)listY ? 0.0f : (mouseY > (double)(listY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)listY) / (float)Math.max(1, scrollbarHeight));
                    int maxOffset = Math.max(0, rx.getChallenges().size() - visibleRows);
                    this.rankXScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                    return true;
                }
            } else if (this.isDraggingAdvAttr && BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null && !this.showRankXInsteadOfAttributes) {
                ArrayList<Object> combinedAttrs = new ArrayList<Object>();
                String knockbackText2 = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                combinedAttrs.add(knockbackText2);
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + this.monster.armor());
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(this.monster.armorToughness())));
                float ms2 = this.monster.movementSpeed();
                String sc2 = ms2 == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms2 <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms2 <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms2 <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms2 <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{sc2}).getString() + " (" + String.format("%.3f", Float.valueOf(ms2)) + ")");
                int xp2 = this.monster.experience();
                if (xp2 == 0) {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                } else {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + xp2 + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                }
                if (Minecraft.m_91087_().f_91073_ != null) {
                    ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                    Entity temp = null;
                    try {
                        temp = this.monster.entityType().m_20615_((Level)lvl);
                        if (temp instanceof LivingEntity) {
                            LivingEntity le = (LivingEntity)temp;
                            AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                            if (inst != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                float fs = (float)inst.m_22135_();
                                String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                            }
                            if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                        }
                    }
                    catch (Exception le) {
                    }
                    finally {
                        if (temp != null) {
                            temp.m_142687_(Entity.RemovalReason.DISCARDED);
                        }
                    }
                }
                int statsY = this.y + 10;
                int listY = statsY + 30;
                int lineHeight = 15;
                int visibleRows = 5;
                int areaHeight = visibleRows * lineHeight;
                int content = combinedAttrs.size();
                if (content > visibleRows) {
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)areaHeight * ((float)visibleRows / (float)content)), minThumbHeight);
                    float ratio = mouseY < (double)listY ? 0.0f : (mouseY > (double)(listY + areaHeight) ? 1.0f : (float)(mouseY - (double)listY) / (float)Math.max(1, areaHeight - thumbHeight));
                    int maxOffset = Math.max(0, content - visibleRows);
                    this.advAttrScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                    return true;
                }
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (BestiaryScreen.this.currentTab == TabType.LOCATIONS && this.monster != null && this.monster.spawnLocation().hasMultipleLocations() && (!Config.enableProgressionSystem || ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType()))) {
                List<Component> locations = this.monster.spawnLocation().getAllLocations();
                int maxVisibleLocations = 8;
                if (locations.size() > maxVisibleLocations) {
                    if (delta < 0.0 && this.spawnLocationsScrollOffset < locations.size() - maxVisibleLocations) {
                        ++this.spawnLocationsScrollOffset;
                        return true;
                    }
                    if (delta > 0.0 && this.spawnLocationsScrollOffset > 0) {
                        --this.spawnLocationsScrollOffset;
                        return true;
                    }
                }
            } else if (BestiaryScreen.this.currentTab == TabType.LOOT && this.monster != null && !this.monster.loot().isEmpty() && (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int maxVisibleItems = itemsPerRow * maxVisibleRows;
                int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                if (this.monster.loot().size() > maxVisibleItems) {
                    int totalVisibleRows = totalRows - maxVisibleRows;
                    if (delta < 0.0 && this.lootItemsScrollOffset < totalVisibleRows) {
                        ++this.lootItemsScrollOffset;
                        return true;
                    }
                    if (delta > 0.0 && this.lootItemsScrollOffset > 0) {
                        --this.lootItemsScrollOffset;
                        return true;
                    }
                }
            } else if (BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && !rx.getChallenges().isEmpty() && this.showRankXInsteadOfAttributes) {
                    int statsY = this.y + 10;
                    int listY = statsY + 58;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(4, rx.getChallenges().size()));
                    if (rx.getChallenges().size() > visibleRows && mouseY >= (double)listY && mouseY <= (double)(listY + visibleRows * lineHeight)) {
                        int maxOffset = rx.getChallenges().size() - visibleRows;
                        if (delta < 0.0 && this.rankXScrollOffset < maxOffset) {
                            ++this.rankXScrollOffset;
                            return true;
                        }
                        if (delta > 0.0 && this.rankXScrollOffset > 0) {
                            --this.rankXScrollOffset;
                            return true;
                        }
                    }
                } else if (!(this.showRankXInsteadOfAttributes || Config.enableProgressionSystem && !ClientProgressionData.shouldShowAdvancedAttributes(this.monster.entityType()))) {
                    ArrayList<Object> combinedAttrs2 = new ArrayList<Object>();
                    String knock2 = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                    combinedAttrs2.add(knock2);
                    combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + this.monster.armor());
                    combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(this.monster.armorToughness())));
                    float ms3 = this.monster.movementSpeed();
                    String sc3 = ms3 == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms3 <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms3 <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms3 <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms3 <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{sc3}).getString() + " (" + String.format("%.3f", Float.valueOf(ms3)) + ")");
                    int xp3 = this.monster.experience();
                    if (xp3 == 0) {
                        combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                    } else {
                        combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + xp3 + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                    }
                    if (Minecraft.m_91087_().f_91073_ != null) {
                        ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                        Entity temp = null;
                        try {
                            temp = this.monster.entityType().m_20615_((Level)lvl);
                            if (temp instanceof LivingEntity) {
                                LivingEntity le = (LivingEntity)temp;
                                AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                                if (inst != null) {
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                                if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                                if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                    float fs = (float)inst.m_22135_();
                                    String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                                }
                                if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                            }
                        }
                        catch (Exception le) {
                        }
                        finally {
                            if (temp != null) {
                                temp.m_142687_(Entity.RemovalReason.DISCARDED);
                            }
                        }
                    }
                    int statsY = this.y + 10;
                    int listY2 = statsY + 30;
                    int lineHeight2 = 15;
                    int visibleRows2 = 5;
                    int areaHeight2 = visibleRows2 * lineHeight2;
                    int content2 = combinedAttrs2.size();
                    if (content2 > visibleRows2) {
                        boolean overArea;
                        boolean bl = overArea = mouseX >= (double)(this.x + 6) && mouseX <= (double)(this.x + this.width - 8) && mouseY >= (double)listY2 && mouseY <= (double)(listY2 + areaHeight2);
                        if (overArea) {
                            int maxOffset2 = content2 - visibleRows2;
                            if (delta < 0.0 && this.advAttrScrollOffset < maxOffset2) {
                                ++this.advAttrScrollOffset;
                                return true;
                            }
                            if (delta > 0.0 && this.advAttrScrollOffset > 0) {
                                --this.advAttrScrollOffset;
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"narration.araxers_bestiary.info_panel"));
        }

        private static enum AdvRowType {
            KNOCKBACK,
            ARMOR,
            TOUGHNESS,
            MOVEMENT,
            EXPERIENCE,
            FOLLOW_RANGE,
            ATTACK_KNOCKBACK,
            FLY_SPEED,
            ATTACK_SPEED;

        }
    }
}

