/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.slf4j.Logger;

public class EntityDataServerHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Field lootTablePoolsField;
    private static Field lootPoolEntriesField;
    private static Field lootPoolRollsField;
    private static Field constantValueField;
    private static Field lootItemItemField;
    private static Field lootEntryWeightField;
    private static final Map<ResourceLocation, List<LootItemEntry>> LOOT_TABLE_CACHE;

    public static void clearLootTableCache() {
        LOGGER.info("Clearing loot table cache ({} entries)", (Object)LOOT_TABLE_CACHE.size());
        LOOT_TABLE_CACHE.clear();
    }

    public static List<LootItemEntry> generateLootEntriesFromTable(EntityType<?> entityType, ServerLevel serverLevel) {
        long startTime = System.nanoTime();
        String entityName = entityType.m_20676_().getString();
        try {
            ResourceLocation lootTableId = entityType.m_20677_();
            if (LOOT_TABLE_CACHE.containsKey(lootTableId)) {
                List<LootItemEntry> cachedEntries = LOOT_TABLE_CACHE.get(lootTableId);
                LOGGER.debug("Using cached loot entries for entity: {} (loot table: {})", (Object)entityName, (Object)lootTableId);
                return new ArrayList<LootItemEntry>(cachedEntries);
            }
            LOGGER.debug("Generating loot entries for entity: {} from loot table: {}", (Object)entityName, (Object)lootTableId);
            ArrayList<LootItemEntry> lootEntries = new ArrayList<LootItemEntry>();
            try {
                LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableId);
                if (lootTable != null) {
                    try {
                        block20: {
                            if (lootTablePoolsField != null) {
                                try {
                                    List pools = (List)lootTablePoolsField.get(lootTable);
                                    if (pools != null && !pools.isEmpty()) {
                                        int poolsProcessed = 0;
                                        for (LootPool pool : pools) {
                                            try {
                                                int entriesBefore = lootEntries.size();
                                                EntityDataServerHelper.processLootPool(pool, lootEntries);
                                                int entriesAfter = lootEntries.size();
                                                if (entriesAfter <= entriesBefore) continue;
                                                ++poolsProcessed;
                                            }
                                            catch (Exception e) {
                                                LOGGER.debug("Error processing loot pool for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                                            }
                                        }
                                        LOGGER.debug("Processed {}/{} loot pools for entity: {}", new Object[]{poolsProcessed, pools.size(), entityName});
                                        break block20;
                                    }
                                    LOGGER.debug("No loot pools found for entity: {}", (Object)entityName);
                                }
                                catch (IllegalAccessException e) {
                                    LOGGER.debug("Failed to access loot pools for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                                    EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                                }
                            } else {
                                LOGGER.debug("Reflection fields not initialized, using fallback method for entity: {}", (Object)entityName);
                                EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                            }
                        }
                        if (lootEntries.isEmpty()) {
                            LOGGER.debug("No loot entries extracted for entity {}, using fallback method", (Object)entityName);
                            EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing loot table for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                        EntityDataServerHelper.fallbackToCommonDrops(lootTable, serverLevel, lootEntries, entityType);
                    }
                } else {
                    LOGGER.debug("Loot table is null for entity: {}", (Object)entityName);
                    EntityDataServerHelper.fallbackToCommonDrops(null, serverLevel, lootEntries, entityType);
                }
                if (!lootEntries.isEmpty()) {
                    LOOT_TABLE_CACHE.put(lootTableId, new ArrayList<LootItemEntry>(lootEntries));
                    LOGGER.debug("Cached {} loot entries for entity {} (loot table: {})", new Object[]{lootEntries.size(), entityName, lootTableId});
                } else {
                    LOGGER.debug("No loot entries generated for entity: {}", (Object)entityName);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error accessing loot table for entity {}: {}", (Object)entityName, (Object)e.getMessage());
                EntityDataServerHelper.fallbackToCommonDrops(null, serverLevel, lootEntries, entityType);
            }
            long endTime = System.nanoTime();
            long processingTime = endTime - startTime;
            LOGGER.debug("Generated {} loot entries for entity {} in {} ms", new Object[]{lootEntries.size(), entityName, processingTime / 1000000L});
            return lootEntries;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error generating loot entries for entity {}: {}", new Object[]{entityName, e.getMessage(), e});
            return new ArrayList<LootItemEntry>();
        }
    }

    private static void processLootPool(LootPool pool, List<LootItemEntry> lootEntries) {
        try {
            if (lootPoolEntriesField == null || lootPoolRollsField == null || constantValueField == null || lootItemItemField == null || lootEntryWeightField == null) {
                LOGGER.warn("Reflection fields not initialized, cannot process loot pool");
                return;
            }
            LootPoolEntryContainer[] entries = (LootPoolEntryContainer[])lootPoolEntriesField.get(pool);
            if (entries == null || entries.length == 0) {
                LOGGER.debug("No entries found in loot pool");
                return;
            }
            NumberProvider rolls = (NumberProvider)lootPoolRollsField.get(pool);
            float baseChance = 1.0f;
            if (rolls instanceof ConstantValue) {
                float value = constantValueField.getFloat(rolls);
                baseChance = value > 0.0f ? 1.0f / value : 1.0f;
                LOGGER.debug("Base chance calculated from constant value: {}", (Object)Float.valueOf(baseChance));
            } else {
                LOGGER.debug("Using default base chance: {}", (Object)Float.valueOf(baseChance));
            }
            int entriesProcessed = 0;
            for (LootPoolEntryContainer entry : entries) {
                if (!(entry instanceof LootItem)) continue;
                LootItem lootItem = (LootItem)entry;
                try {
                    Item item = (Item)lootItemItemField.get(lootItem);
                    int weight = lootEntryWeightField.getInt(lootItem);
                    float dropChance = (float)weight * baseChance;
                    if (dropChance > 1.0f) {
                        dropChance = 1.0f;
                    }
                    if (dropChance < 0.0f) {
                        dropChance = 0.0f;
                    }
                    if (item != Items.f_41852_) {
                        ItemStack itemStack = new ItemStack((ItemLike)item);
                        Component displayName = itemStack.m_41786_();
                        lootEntries.add(new LootItemEntry(itemStack, displayName, dropChance, false));
                        LOGGER.debug("Added loot entry: {} with chance {}", (Object)displayName, (Object)Float.valueOf(dropChance));
                        ++entriesProcessed;
                        continue;
                    }
                    LOGGER.debug("Skipped air item");
                }
                catch (IllegalAccessException e) {
                    LOGGER.debug("Failed to process loot item: {}", (Object)e.getMessage());
                }
            }
            LOGGER.debug("Processed {} loot entries from pool", (Object)entriesProcessed);
        }
        catch (Exception e) {
            LOGGER.error("Error processing loot pool: {}", (Object)e.getMessage());
        }
    }

    private static void fallbackToCommonDrops(LootTable lootTable, ServerLevel serverLevel, List<LootItemEntry> lootEntries, EntityType<?> entityType) {
        LOGGER.debug("Using loot table fallback mechanism for entity: {}", (Object)entityType.m_20676_().getString());
        if (lootTable != null && serverLevel != null) {
            try {
                EntityDataServerHelper.fallbackToRandomLoot(lootTable, serverLevel, lootEntries);
                if (!lootEntries.isEmpty()) {
                    LOGGER.debug("Successfully generated {} loot entries from random loot generation", (Object)lootEntries.size());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to generate random loot: {}", (Object)e.getMessage());
            }
        }
    }

    private static void fallbackToRandomLoot(LootTable lootTable, ServerLevel serverLevel, List<LootItemEntry> lootEntries) {
        LOGGER.debug("Using legacy fallback random loot generation");
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel);
        LootParams lootParams = lootParamsBuilder.m_287235_(LootContextParamSets.f_81410_);
        HashMap<Item, Integer> dropCounts = new HashMap<Item, Integer>();
        int totalBatches = 100;
        for (int i = 0; i < totalBatches; ++i) {
            ObjectArrayList generatedLoot = lootTable.m_287195_(lootParams);
            for (ItemStack itemStack : generatedLoot) {
                Item item = itemStack.m_41720_();
                dropCounts.put(item, dropCounts.getOrDefault(item, 0) + 1);
            }
        }
        for (Map.Entry entry : dropCounts.entrySet()) {
            Item item = (Item)entry.getKey();
            if (item == Items.f_41852_) continue;
            float dropChance = (float)((Integer)entry.getValue()).intValue() / (float)totalBatches;
            if (dropChance > 1.0f) {
                dropChance = 1.0f;
            }
            if (dropChance < 0.0f) {
                dropChance = 0.0f;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            Component displayName = itemStack.m_41786_();
            lootEntries.add(new LootItemEntry(itemStack, displayName, dropChance, false));
            LOGGER.debug("Added estimated loot entry: {} with chance {}", (Object)displayName, (Object)Float.valueOf(dropChance));
        }
    }

    public static SpawnLocationInfo getServerSideSpawnLocations(EntityType<?> entityType, ServerLevel serverLevel, MobCategory category) {
        ArrayList<ResourceLocation> spawnBiomes = new ArrayList<ResourceLocation>();
        try {
            if (serverLevel != null && serverLevel.m_9598_() != null) {
                Registry biomeRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256952_);
                for (ResourceLocation biomeKey : biomeRegistry.m_6566_()) {
                    try {
                        Biome biome = (Biome)biomeRegistry.m_7745_(biomeKey);
                        if (biome == null || !EntityDataServerHelper.canEntitySpawnInBiome(entityType, biome, category)) continue;
                        spawnBiomes.add(biomeKey);
                        LOGGER.debug("Entity {} can spawn in biome {}", (Object)entityType.m_20676_().getString(), (Object)biomeKey);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error checking if entity can spawn in biome {}: {}", (Object)biomeKey, (Object)e.getMessage());
                    }
                }
                if (!spawnBiomes.isEmpty()) {
                    return SpawnLocationInfo.fromBiomeKeys(spawnBiomes, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting server-side spawn locations: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static boolean canEntitySpawnInBiome(EntityType<?> entityType, Biome biome, MobCategory category) {
        try {
            List spawners = biome.m_47518_().m_151798_(category).m_146338_();
            for (MobSpawnSettings.SpawnerData spawnerData : spawners) {
                if (spawnerData.f_48404_ != entityType) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Error checking spawn rule for {} in biome {}: {}", new Object[]{entityType.m_20675_(), biome.toString(), e.getMessage()});
            return false;
        }
    }

    static {
        LOOT_TABLE_CACHE = new HashMap<ResourceLocation, List<LootItemEntry>>();
        try {
            lootTablePoolsField = LootTable.class.getDeclaredField("pools");
            lootTablePoolsField.setAccessible(true);
            lootPoolEntriesField = LootPool.class.getDeclaredField("entries");
            lootPoolEntriesField.setAccessible(true);
            lootPoolRollsField = LootPool.class.getDeclaredField("rolls");
            lootPoolRollsField.setAccessible(true);
            constantValueField = ConstantValue.class.getDeclaredField("value");
            constantValueField.setAccessible(true);
            lootItemItemField = LootItem.class.getDeclaredField("item");
            lootItemItemField.setAccessible(true);
            lootEntryWeightField = LootPoolEntryContainer.class.getDeclaredField("weight");
            lootEntryWeightField.setAccessible(true);
            LOGGER.info("Successfully initialized reflection fields for loot generation");
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Failed to initialize reflection fields: {}", (Object)e.getMessage());
        }
    }
}

