/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class GlobalPlayerProgressionData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String GLOBAL_DATA_NAME = "araxers_bestiary_progression_global";
    private static final String LEGACY_DATA_NAME = "araxers_bestiary_progression";
    private PlayerProgressionData delegate;
    private boolean migratedFromPerDimension = false;

    public GlobalPlayerProgressionData() {
        this.delegate = new PlayerProgressionData();
        this.delegate.attachToGlobal(this);
    }

    private GlobalPlayerProgressionData(PlayerProgressionData delegate, boolean migrated) {
        this.delegate = delegate != null ? delegate : new PlayerProgressionData();
        this.migratedFromPerDimension = migrated;
        this.delegate.attachToGlobal(this);
    }

    public static GlobalPlayerProgressionData get(MinecraftServer server) {
        ServerLevel overworld = server.m_129783_();
        GlobalPlayerProgressionData data = (GlobalPlayerProgressionData)overworld.m_8895_().m_164861_(GlobalPlayerProgressionData::load, GlobalPlayerProgressionData::new, GLOBAL_DATA_NAME);
        if (!data.migratedFromPerDimension) {
            long start = System.nanoTime();
            int mergedDimensions = 0;
            for (ServerLevel level : server.m_129785_()) {
                PlayerProgressionData legacy = (PlayerProgressionData)level.m_8895_().m_164858_(PlayerProgressionData::load, LEGACY_DATA_NAME);
                if (legacy == null) continue;
                try {
                    data.delegate.mergeFrom(legacy, level);
                    ++mergedDimensions;
                }
                catch (Exception e) {
                    LOGGER.error("Failed merging legacy progression from dimension {}: {}", new Object[]{level.m_46472_().m_135782_(), e.getMessage(), e});
                }
            }
            data.migratedFromPerDimension = true;
            data.m_77762_();
            long elapsedMs = (System.nanoTime() - start) / 1000000L;
            LOGGER.info("Araxer's Bestiary: migrated legacy per-dimension progression into global store from {} dimension(s) in {} ms", (Object)mergedDimensions, (Object)elapsedMs);
        }
        return data;
    }

    public PlayerProgressionData data() {
        return this.delegate;
    }

    public void sendProgressionSyncPacket(ServerPlayer player) {
        this.delegate.sendProgressionSyncPacket(player);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag root = new CompoundTag();
        CompoundTag res = this.delegate.m_7176_(root);
        res.m_128379_("migratedFromPerDimension", this.migratedFromPerDimension);
        return res;
    }

    public static GlobalPlayerProgressionData load(CompoundTag tag) {
        try {
            PlayerProgressionData d = PlayerProgressionData.load(tag);
            boolean migrated = tag.m_128471_("migratedFromPerDimension");
            return new GlobalPlayerProgressionData(d, migrated);
        }
        catch (Throwable t) {
            LogUtils.getLogger().error("Error loading GlobalPlayerProgressionData: {}", (Object)t.getMessage(), (Object)t);
            return new GlobalPlayerProgressionData();
        }
    }
}

