/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.client.ClientProgressionData;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.MonsterEntry;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ProgressiveEntityData {
    private final MonsterEntry originalEntry;
    private final Player player;
    private final PlayerProgressionData progressionData;
    private final boolean isProgressionEnabled;
    private final boolean showSpawnLocations;
    private final boolean showLootIcons;
    private final boolean showLootChances;
    private final boolean showDescription;

    public ProgressiveEntityData(MonsterEntry originalEntry, Player player, PlayerProgressionData progressionData) {
        this.originalEntry = originalEntry;
        this.player = player;
        this.progressionData = progressionData;
        this.isProgressionEnabled = Config.enableProgressionSystem;
        if (!this.isProgressionEnabled) {
            this.showSpawnLocations = true;
            this.showLootIcons = true;
            this.showLootChances = true;
            this.showDescription = true;
        } else if (player != null && originalEntry.entityType() != null) {
            EntityType<?> entityType = originalEntry.entityType();
            if (player.m_9236_().m_5776_()) {
                this.showSpawnLocations = ClientProgressionData.shouldShowSpawnLocations(entityType);
                this.showLootIcons = ClientProgressionData.shouldShowLootIcons(entityType);
                this.showLootChances = ClientProgressionData.shouldShowLootChances(entityType);
                this.showDescription = ClientProgressionData.shouldShowDescription(entityType);
            } else if (progressionData != null) {
                UUID playerUUID = player.m_20148_();
                this.showSpawnLocations = progressionData.shouldShowSpawnLocations(playerUUID, entityType);
                this.showLootIcons = progressionData.shouldShowLootIcons(playerUUID, entityType);
                this.showLootChances = progressionData.shouldShowLootChances(playerUUID, entityType);
                this.showDescription = progressionData.hasReachedThreshold(playerUUID, entityType, Config.descriptionThreshold);
            } else {
                this.showSpawnLocations = false;
                this.showLootIcons = false;
                this.showLootChances = false;
                this.showDescription = false;
            }
        } else {
            this.showSpawnLocations = false;
            this.showLootIcons = false;
            this.showLootChances = false;
            this.showDescription = false;
        }
    }

    public Component getName() {
        return this.originalEntry.name();
    }

    public int getHealth() {
        return this.originalEntry.health();
    }

    public int getDamage() {
        return this.originalEntry.damage();
    }

    public SpawnLocationInfo getSpawnLocation() {
        if (!this.isProgressionEnabled || this.showSpawnLocations) {
            return this.originalEntry.spawnLocation();
        }
        return new SpawnLocationInfo((Component)Component.m_237113_((String)"Unknown"));
    }

    public List<LootItemEntry> getLoot() {
        List<LootItemEntry> originalLoot = this.originalEntry.loot();
        if (!this.isProgressionEnabled) {
            return originalLoot;
        }
        ArrayList<LootItemEntry> progressiveLoot = new ArrayList<LootItemEntry>();
        for (LootItemEntry originalItem : originalLoot) {
            if (!this.showLootIcons) {
                ItemStack unknownItem = new ItemStack((ItemLike)Items.f_42127_);
                progressiveLoot.add(new LootItemEntry(unknownItem, (Component)Component.m_237115_((String)"screen.araxers_bestiary.loot.unknown_drop"), 0.0f));
                continue;
            }
            if (!this.showLootChances) {
                progressiveLoot.add(new LootItemEntry(originalItem.itemStack(), originalItem.displayName(), 0.0f));
                continue;
            }
            progressiveLoot.add(originalItem);
        }
        return progressiveLoot;
    }

    public EntityType<?> getEntityType() {
        return this.originalEntry.entityType();
    }

    public float getKnockbackResistance() {
        if (!this.isProgressionEnabled || this.player != null && this.originalEntry.entityType() != null && this.player.m_9236_().m_5776_() && ClientProgressionData.shouldShowAdvancedAttributes(this.originalEntry.entityType())) {
            return this.originalEntry.knockbackResistance();
        }
        return 0.0f;
    }

    public int getArmor() {
        if (!this.isProgressionEnabled || this.player != null && this.originalEntry.entityType() != null && this.player.m_9236_().m_5776_() && ClientProgressionData.shouldShowAdvancedAttributes(this.originalEntry.entityType())) {
            return this.originalEntry.armor();
        }
        return 0;
    }

    public float getArmorToughness() {
        if (!this.isProgressionEnabled || this.player != null && this.originalEntry.entityType() != null && this.player.m_9236_().m_5776_() && ClientProgressionData.shouldShowAdvancedAttributes(this.originalEntry.entityType())) {
            return this.originalEntry.armorToughness();
        }
        return 0.0f;
    }

    public float getMovementSpeed() {
        if (!this.isProgressionEnabled || this.player != null && this.originalEntry.entityType() != null && this.player.m_9236_().m_5776_() && ClientProgressionData.shouldShowAdvancedAttributes(this.originalEntry.entityType())) {
            return this.originalEntry.movementSpeed();
        }
        return 0.3f;
    }

    public int getExperience() {
        if (!this.isProgressionEnabled || this.player != null && this.originalEntry.entityType() != null && this.player.m_9236_().m_5776_() && ClientProgressionData.shouldShowAdvancedAttributes(this.originalEntry.entityType())) {
            return this.originalEntry.experience();
        }
        return 0;
    }

    public String getDescription() {
        if (!this.isProgressionEnabled || this.showDescription) {
            return this.originalEntry.description() != null ? this.originalEntry.description() : "";
        }
        return "Kill more of this entity to unlock its description.";
    }

    public int getKillCount() {
        if (!this.isProgressionEnabled || this.player == null || this.originalEntry.entityType() == null) {
            return 0;
        }
        EntityType<?> entityType = this.originalEntry.entityType();
        if (this.player.m_9236_().m_5776_()) {
            return ClientProgressionData.getKillCount(entityType);
        }
        if (this.progressionData != null) {
            return this.progressionData.getKillCount(this.player.m_20148_(), entityType);
        }
        return 0;
    }

    public MonsterEntry toMonsterEntry() {
        return new MonsterEntry(this.getName(), this.getHealth(), this.getDamage(), this.getKnockbackResistance(), this.getArmor(), this.getArmorToughness(), this.getMovementSpeed(), this.getExperience(), this.getSpawnLocation(), this.getLoot(), this.getEntityType(), this.getDescription(), this.originalEntry.boss());
    }
}

