/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.config.Config;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.warden.Warden;

public class RankUtils {
    public static final List<String> RANKS = Arrays.asList("E", "D", "C", "B", "A", "S", "X");
    public static final String NO_RANK = "";
    public static final String DEFAULT_RANK = "";

    public static int getRankIndex(String rank) {
        return RANKS.indexOf(rank);
    }

    public static boolean isValidRank(String rank) {
        return RANKS.contains(rank) || rank.equals("");
    }

    public static String getNextRank(String currentRank) {
        int currentIndex = RankUtils.getRankIndex(currentRank);
        if (currentRank == null || currentRank.equals("") || currentIndex == -1) {
            return RANKS.get(0);
        }
        int maxNormalIndex = RankUtils.getRankIndex("S");
        if (currentIndex >= maxNormalIndex) {
            return currentRank;
        }
        return RANKS.get(currentIndex + 1);
    }

    public static int compareRanks(String rank1, String rank2) {
        int index1 = RankUtils.getRankIndex(rank1);
        int index2 = RankUtils.getRankIndex(rank2);
        if (index1 == -1) {
            index1 = -1;
        }
        if (index2 == -1) {
            index2 = -1;
        }
        return Integer.compare(index1, index2);
    }

    public static boolean meetsRankThreshold(String rank, String thresholdRank) {
        if (rank.equals("")) {
            return false;
        }
        return RankUtils.compareRanks(rank, thresholdRank) >= 0;
    }

    private static double[] calculateRankProbabilities() {
        return RankUtils.calculateRankProbabilities(false);
    }

    private static double[] calculateRankProbabilities(boolean isPartiallyDiscovered) {
        double[] cumulativeProbabilities;
        int totalWeight;
        int sWeight = Config.rankSWeight;
        int aWeight = Config.rankAWeight;
        int bWeight = Config.rankBWeight;
        int cWeight = Config.rankCWeight;
        int dWeight = Config.rankDWeight;
        int eWeight = Config.rankEWeight;
        if (isPartiallyDiscovered) {
            eWeight = eWeight > 1 ? Math.max(1, eWeight / 2) : 1;
        }
        if ((totalWeight = sWeight + aWeight + bWeight + cWeight + dWeight + eWeight) == 0) {
            sWeight = 1;
            aWeight = 4;
            bWeight = 10;
            cWeight = 15;
            dWeight = 20;
            if (isPartiallyDiscovered) {
                eWeight = 25;
                totalWeight = 75;
            } else {
                eWeight = 50;
                totalWeight = 100;
            }
        }
        cumulativeProbabilities = new double[]{(double)sWeight / (double)totalWeight, cumulativeProbabilities[0] + (double)aWeight / (double)totalWeight, cumulativeProbabilities[1] + (double)bWeight / (double)totalWeight, cumulativeProbabilities[2] + (double)cWeight / (double)totalWeight, cumulativeProbabilities[3] + (double)dWeight / (double)totalWeight, 1.0};
        String logPrefix = isPartiallyDiscovered ? "Partially discovered entity rank probabilities" : "Rank probabilities";
        LogUtils.getLogger().debug("{} calculated - S: {}, A: {}, B: {}, C: {}, D: {}, E: {}, Total: {}", new Object[]{logPrefix, sWeight, aWeight, bWeight, cWeight, dWeight, eWeight, totalWeight});
        LogUtils.getLogger().debug("{} cumulative - S: {}, A: {}, B: {}, C: {}, D: {}, E: {}", new Object[]{logPrefix, cumulativeProbabilities[0], cumulativeProbabilities[1], cumulativeProbabilities[2], cumulativeProbabilities[3], cumulativeProbabilities[4], cumulativeProbabilities[5]});
        return cumulativeProbabilities;
    }

    public static String tryIncreaseRank(String currentRank, double baseChance, Entity entity, boolean isPartiallyDiscovered, boolean rollAssignedRank) {
        int maxNormalIndex = RankUtils.getRankIndex("S");
        if (RankUtils.getRankIndex(currentRank) >= maxNormalIndex) {
            return currentRank;
        }
        double adjustedChance = baseChance;
        if (Config.enableProgressiveRankDifficulty && !currentRank.equals("")) {
            switch (currentRank) {
                case "E": {
                    break;
                }
                case "D": {
                    adjustedChance *= Config.rankDDifficultyMultiplier;
                    break;
                }
                case "C": {
                    adjustedChance *= Config.rankCDifficultyMultiplier;
                    break;
                }
                case "B": {
                    adjustedChance *= Config.rankBDifficultyMultiplier;
                    break;
                }
                case "A": {
                    adjustedChance *= Config.rankADifficultyMultiplier;
                    break;
                }
                case "S": {
                    adjustedChance *= Config.rankSDifficultyMultiplier;
                    break;
                }
            }
        }
        if (entity != null && RankUtils.isBossEntity(entity)) {
            double beforeBossMultiplier = adjustedChance;
            LogUtils.getLogger().debug("Boss multiplier applied - Before: {}, After: {}, Multiplier: {}", new Object[]{beforeBossMultiplier, adjustedChance *= Config.bossRankMultiplier, Config.bossRankMultiplier});
        }
        LogUtils.getLogger().debug("Final adjusted chance: {} (Base chance: {})", (Object)adjustedChance, (Object)baseChance);
        if (currentRank.equals("")) {
            double[] probabilities = RankUtils.calculateRankProbabilities(isPartiallyDiscovered);
            double rankRoll = Math.random();
            String assignedRank = rankRoll < probabilities[0] ? "S" : (rankRoll < probabilities[1] ? "A" : (rankRoll < probabilities[2] ? "B" : (rankRoll < probabilities[3] ? "C" : (rankRoll < probabilities[4] ? "D" : "E"))));
            String logPrefix = isPartiallyDiscovered ? "Partially discovered entity" : "First discovery";
            LogUtils.getLogger().debug("{} rank assignment - RankRoll: {}, Assigned Rank: {}", new Object[]{logPrefix, rankRoll, assignedRank});
            if (rollAssignedRank) {
                if (Math.random() < adjustedChance) {
                    return assignedRank;
                }
                return currentRank;
            }
            return assignedRank;
        }
        if (Math.random() < adjustedChance) {
            return RankUtils.getNextRank(currentRank);
        }
        return currentRank;
    }

    public static String tryIncreaseRank(String currentRank, double baseChance, Entity entity) {
        return RankUtils.tryIncreaseRank(currentRank, baseChance, entity, false, false);
    }

    public static String tryIncreaseRank(String currentRank, double baseChance) {
        return RankUtils.tryIncreaseRank(currentRank, baseChance, null, false, false);
    }

    public static boolean isBossEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EnderDragon || entity instanceof WitherBoss || entity instanceof ElderGuardian || entity instanceof Warden) {
            return true;
        }
        String className = entity.getClass().getSimpleName().toLowerCase();
        if (className.contains("boss")) {
            return true;
        }
        EntityType type = entity.m_6095_();
        String id = EntityType.m_20613_((EntityType)type).m_135815_();
        return id.contains("boss");
    }
}

