/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.network;

import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary")
public class ServerPacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        LOGGER.debug("Initializing server packet handler");
        try {
            if (CommonPacketHandler.VIEWED_CHANNEL == null) {
                LOGGER.warn("CommonPacketHandler channels are not initialized yet. Attempting to initialize them now.");
                CommonPacketHandler.init();
                if (CommonPacketHandler.VIEWED_CHANNEL == null) {
                    LOGGER.error("Failed to initialize CommonPacketHandler channels. Entity viewed packets may not work correctly.");
                    return;
                }
            }
            CommonPacketHandler.VIEWED_CHANNEL.addListener(ServerPacketHandler::handleEntityViewedPacket);
            LOGGER.debug("Successfully registered server-side listener for entity viewed packets");
        }
        catch (Exception e) {
            LOGGER.error("Error initializing server packet handler: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        LOGGER.debug("Server starting, initializing server packet handler");
        ServerPacketHandler.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEntityViewedPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            ServerPlayer player = context.getSender();
            if (player == null) {
                LOGGER.error("Cannot process entity viewed packet: player is null");
                return;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            if (level == null) {
                LOGGER.error("Cannot process entity viewed packet: level is null");
                return;
            }
            ResourceLocation entityTypeId = buf.m_130281_();
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
            if (entityType == null) {
                LOGGER.error("Cannot process entity viewed packet: unknown entity type {}", (Object)entityTypeId);
                return;
            }
            LOGGER.debug("Received entity viewed packet from player {} for entity {}", (Object)player.m_7755_().getString(), (Object)entityType.m_20675_());
            GlobalPlayerProgressionData.get(level.m_7654_()).data().markAsViewed(player.m_20148_(), entityType);
            LOGGER.debug("Successfully marked entity {} as viewed for player {} (global)", (Object)entityType.m_20675_(), (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            LOGGER.error("Error processing entity viewed packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing entity viewed packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }
}

