/*
 * Decompiled with CFR 0.152.
 */
package commoble.databuddy.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public class CodecJsonDataManager<T>
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private final Codec<T> codec;
    private final Logger logger;
    private final String folderName;
    protected BiMap<ResourceLocation, T> data = HashBiMap.create();

    public CodecJsonDataManager(String folderName, Codec<T> codec, Logger logger) {
        this(folderName, codec, logger, STANDARD_GSON);
    }

    public CodecJsonDataManager(String folderName, Codec<T> codec, Logger logger, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
        this.logger = logger;
    }

    @Deprecated(forRemoval=true)
    public T getData(ResourceLocation id) {
        return (T)this.data.get((Object)id);
    }

    public BiMap<ResourceLocation, T> getData() {
        return this.data;
    }

    public void setData(BiMap<ResourceLocation, T> data) {
        this.data = data;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        this.logger.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
    }

    private BiMap<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashBiMap newMap = HashBiMap.create();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(arg_0 -> CodecJsonDataManager.lambda$mapValues$0((BiMap)newMap, key, arg_0)).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key, (Object)partial.message()));
        }
        return newMap;
    }

    private static /* synthetic */ void lambda$mapValues$0(BiMap newMap, ResourceLocation key, Pair result) {
        newMap.put((Object)key, result.getFirst());
    }
}

